/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.util;

import com.aligo.tools.util.ConstantsPopulator;
import com.aligo.tools.xml.DefaultDOMXMLable;
import com.aligo.tools.xml.XMLUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConstantsList
extends DefaultDOMXMLable {
    public static final String CONSTANTS_LIST_TAG = "ConstantsList";
    public static final String CONSTANT_ITEM_TAG = "ConstantItem";
    private List constants;

    public ConstantsList() {
        this.initialize();
    }

    protected void initialize() {
        if (this.constants == null) {
            this.constants = new ArrayList();
        } else {
            this.constants.clear();
        }
    }

    public ConstantsList(Element element) {
        super(element);
    }

    public List getConstants() {
        return new ArrayList(this.constants);
    }

    public boolean contains(Object constant) {
        return this.constants.contains(constant);
    }

    public void addConstant(Object constant) {
        this.constants.add(constant);
    }

    public void setConstants(List constants) {
        if (constants == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " : You can not use NULL as a list of constants!");
        }
        this.constants = constants;
    }

    public void fromXMLElement(Element element) {
        this.initialize();
        if (element != null && CONSTANTS_LIST_TAG.equals(element.getTagName())) {
            Iterator elements = XMLUtilities.getMatchingChildren(element, CONSTANT_ITEM_TAG).iterator();
            while (elements.hasNext()) {
                Element nextElement = (Element)elements.next();
                String reflectString = XMLUtilities.getPCData(nextElement);
                Object constant = ConstantsPopulator.getObjectFromReflectString(reflectString);
                if (constant == null) continue;
                this.constants.add(constant);
            }
        }
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(CONSTANTS_LIST_TAG);
        Iterator constIt = this.constants.iterator();
        while (constIt.hasNext()) {
            String reflectString = ConstantsPopulator.getReflectString(constIt.next());
            if (reflectString == null) continue;
            Element constElement = document.createElement(CONSTANT_ITEM_TAG);
            XMLUtilities.setPCData(document, constElement, reflectString);
            element.appendChild(constElement);
        }
        return element;
    }
}

