/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.util;

import java.text.MessageFormat;

public class ClassName {
    private static MessageFormat WHOLE_CLASS = new MessageFormat("{0}.{1}");
    private static String DOT = ".";
    private String packageName;
    private String className;

    public ClassName(String wholeClassName) {
        if (wholeClassName.lastIndexOf(DOT) >= 0) {
            int index = wholeClassName.lastIndexOf(DOT);
            this.packageName = wholeClassName.substring(0, index);
            this.className = index < wholeClassName.length() ? wholeClassName.substring(index + 1) : "";
        } else {
            this.packageName = "";
            this.className = wholeClassName;
        }
    }

    public ClassName(String packageName, String className) {
        if (packageName.endsWith(DOT)) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        this.packageName = packageName;
        this.className = className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getWholeClassName() {
        return WHOLE_CLASS.format(new Object[]{this.packageName, this.className});
    }
}

