/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.image;

import com.aligo.tools.image.DPOImage;
import com.aligo.tools.interfaces.Named;
import com.aligo.tools.xml.DefaultDOMXMLable;
import com.aligo.tools.xml.XMLUtilities;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DPOImageMap
extends DefaultDOMXMLable
implements Named {
    public static final String DPO_IMAGE_MAP_TAG = "DPOImageMap";
    public static final String IMAGE_NAME_ATTR = "name";
    private String name;
    private ArrayList dpoImages;

    public DPOImageMap() {
        this.initialize();
    }

    public DPOImageMap(Element element) {
        super(element);
    }

    protected void initialize() {
        this.dpoImages = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DPOImage getFirstGIF() {
        DPOImage image = null;
        Iterator images = ((AbstractList)this.dpoImages).iterator();
        while (image == null && images.hasNext()) {
            DPOImage next = (DPOImage)images.next();
            if (next.getSourceFile() == null || !next.getSourceFile().toString().toLowerCase().endsWith(".gif")) continue;
            image = next;
        }
        return image;
    }

    public List getDPOImages() {
        return new ArrayList(this.dpoImages);
    }

    public Iterator getDPOImagesIterator() {
        return ((AbstractList)this.dpoImages).iterator();
    }

    public void addDPOImage(DPOImage image) {
        this.dpoImages.add(image);
    }

    public DPOImage getDPOImageByName(String dpoName) {
        DPOImage match = null;
        Iterator images = this.getDPOImagesIterator();
        while (images.hasNext() && match == null) {
            DPOImage next = (DPOImage)images.next();
            if (next.getDPOName() == null || !next.getDPOName().equals(dpoName)) continue;
            match = next;
        }
        return match;
    }

    public void removeDPOImage(DPOImage image) {
        ((AbstractCollection)this.dpoImages).remove(image);
    }

    public void fromXMLElement(Element element) {
        this.dpoImages = new ArrayList();
        if (element != null && DPO_IMAGE_MAP_TAG.equals(element.getTagName())) {
            this.name = element.getAttribute(IMAGE_NAME_ATTR);
            List imageElements = XMLUtilities.getMatchingChildren(element, "DPOImage");
            Iterator imageItems = imageElements.iterator();
            while (imageItems.hasNext()) {
                Element imageElement = (Element)imageItems.next();
                DPOImage toAdd = new DPOImage(imageElement);
                this.dpoImages.add(toAdd);
            }
        }
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(DPO_IMAGE_MAP_TAG);
        element.setAttribute(IMAGE_NAME_ATTR, this.getName());
        Iterator imageItems = ((AbstractList)this.dpoImages).iterator();
        while (imageItems.hasNext()) {
            DPOImage image = (DPOImage)imageItems.next();
            element.appendChild(image.toXMLElement(document));
        }
        return element;
    }

    public String toString() {
        return this.getName();
    }
}

