/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.image;

import com.aligo.tools.util.CrossAlignType;
import com.aligo.tools.xml.DefaultDOMXMLable;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DPOImage
extends DefaultDOMXMLable {
    public static final String DPO_IMAGE_TAG = "DPOImage";
    public static final String DPO_NAME_ATTR = "dpoName";
    public static final String SRC_ATTR = "src";
    public static final String SRC_FILE_ATTR = "srcFile";
    public static final String ALT_ATTR = "alt";
    public static final String ALIGN_ATTR = "align";
    public static final String HEIGHT_ATTR = "height";
    public static final String WIDTH_ATTR = "width";
    public static final String VSPACE_ATTR = "vspace";
    public static final String HSPACE_ATTR = "hspace";
    public static final String PERSIST_ATTR = "persist";
    private String dpoName;
    private String src;
    private File srcFile;
    private String alt;
    private CrossAlignType align;
    private int height;
    private int width;
    private int vspace;
    private int hspace;
    private boolean persist;
    private String srcString;

    public DPOImage() {
        this.initialize();
    }

    public DPOImage(Element element) {
        super(element);
    }

    protected void initialize() {
        this.align = CrossAlignType.BOTTOM;
        this.dpoName = "";
        this.src = "";
        this.alt = "";
    }

    public String getDPOName() {
        return this.dpoName;
    }

    public void setDPOName(String dpoName) {
        this.dpoName = dpoName;
    }

    public String getSource() {
        return this.src;
    }

    public void setSource(String src) {
        this.src = src;
    }

    public File getSourceFile() {
        return this.srcFile;
    }

    public void setSourceFile(File srcFile) {
        this.srcFile = srcFile;
    }

    public String getSourceString() {
        return this.srcString;
    }

    public void setSourceString(String srcString) {
        this.srcString = srcString;
    }

    public String getAlternate() {
        return this.alt;
    }

    public void setAlternate(String alt) {
        this.alt = alt;
    }

    public CrossAlignType getAlignment() {
        return this.align;
    }

    public void setAlignment(CrossAlignType align) {
        this.align = align;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getVSpace() {
        return this.vspace;
    }

    public void setVSpace(int vspace) {
        this.vspace = vspace;
    }

    public int getHSpace() {
        return this.hspace;
    }

    public void setHSpace(int hspace) {
        this.hspace = hspace;
    }

    public boolean isPersist() {
        return this.persist;
    }

    public void setPersist(boolean persist) {
        this.persist = persist;
    }

    public void fromXMLElement(Element element) {
        if (element != null && DPO_IMAGE_TAG.equals(element.getTagName())) {
            this.dpoName = element.getAttribute(DPO_NAME_ATTR);
            this.src = element.getAttribute(SRC_ATTR);
            String srcFileText = element.getAttribute(SRC_FILE_ATTR);
            if (srcFileText != null && srcFileText.length() > 0) {
                this.srcFile = new File(srcFileText);
                this.srcString = srcFileText;
            }
            this.alt = element.getAttribute(ALT_ATTR);
            this.align = CrossAlignType.getTypeFromAttributeValue(element.getAttribute(ALIGN_ATTR));
            String intString = element.getAttribute(HEIGHT_ATTR);
            try {
                this.height = Integer.parseInt(intString);
            }
            catch (Exception e) {
                // empty catch block
            }
            intString = element.getAttribute(WIDTH_ATTR);
            try {
                this.width = Integer.parseInt(intString);
            }
            catch (Exception e) {
                // empty catch block
            }
            intString = element.getAttribute(VSPACE_ATTR);
            try {
                this.vspace = Integer.parseInt(intString);
            }
            catch (Exception e) {
                // empty catch block
            }
            intString = element.getAttribute(HSPACE_ATTR);
            try {
                this.hspace = Integer.parseInt(intString);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.persist = Boolean.valueOf(element.getAttribute(PERSIST_ATTR));
        }
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(DPO_IMAGE_TAG);
        if (this.getDPOName() != null) {
            element.setAttribute(DPO_NAME_ATTR, this.getDPOName());
        }
        if (this.getSource() != null) {
            element.setAttribute(SRC_ATTR, this.getSource());
        }
        if (this.getSourceFile() != null) {
            element.setAttribute(SRC_FILE_ATTR, this.getSourceString());
        }
        if (this.getAlternate() != null) {
            element.setAttribute(ALT_ATTR, this.getAlternate());
        }
        if (this.getAlignment() != null) {
            element.setAttribute(ALIGN_ATTR, this.getAlignment().getAttributeValue());
        }
        if (this.height > 0) {
            element.setAttribute(HEIGHT_ATTR, String.valueOf(this.height));
        }
        if (this.width > 0) {
            element.setAttribute(WIDTH_ATTR, String.valueOf(this.width));
        }
        if (this.vspace > 0) {
            element.setAttribute(VSPACE_ATTR, String.valueOf(this.vspace));
        }
        if (this.hspace > 0) {
            element.setAttribute(HSPACE_ATTR, String.valueOf(this.hspace));
        }
        element.setAttribute(PERSIST_ATTR, String.valueOf(this.persist));
        return element;
    }
}

