/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.factory;

import com.aligo.tools.factory.FactoryObject;
import com.aligo.tools.xml.XMLUtilities;
import java.lang.reflect.Method;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SingletonFactoryObject
extends FactoryObject {
    private static final String TAG_NAME_TAG = "SingletonFactoryObject";
    private static final String METHOD_TAG = "Method";
    private String method;
    private Object factoryObject;

    public SingletonFactoryObject(String method, Class definingClass) {
        super(definingClass);
        this.method = method;
    }

    public SingletonFactoryObject(Element element) {
        super(element);
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Object getFactoryObject() {
        if (this.factoryObject == null) {
            try {
                Method m = this.getDefiningClass().getMethod(this.method, null);
                this.factoryObject = m.invoke(null, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.factoryObject;
    }

    public String getTagName() {
        return TAG_NAME_TAG;
    }

    public void fromXMLElement(Element element) {
        this.factoryObject = null;
        this.method = null;
        if (element != null) {
            if (!TAG_NAME_TAG.equals(element.getTagName())) {
                element = XMLUtilities.getFirstMatch(element, TAG_NAME_TAG);
            }
            if (element != null && TAG_NAME_TAG.equals(element.getTagName())) {
                super.fromXMLElement(element);
                this.method = XMLUtilities.getPCData(element, METHOD_TAG);
            }
        }
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(this.getTagName());
        if (this.getMethod() != null) {
            XMLUtilities.createPCData(document, element, METHOD_TAG, this.getMethod());
        }
        return element;
    }
}

