/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.factory;

import com.aligo.tools.ToolsUtilities;
import com.aligo.tools.xml.DefaultDOMXMLable;
import com.aligo.tools.xml.XMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class FactoryObject
extends DefaultDOMXMLable {
    private static final String CLASS_TAG = "Class";
    private Class definingClass;

    public FactoryObject(Class definingClass) {
        this.definingClass = definingClass;
    }

    public FactoryObject(Element element) {
        super(element);
    }

    public Class getDefiningClass() {
        return this.definingClass;
    }

    public void setDefiningClass(Class definingClass) {
        this.definingClass = definingClass;
    }

    public abstract String getTagName();

    public abstract Object getFactoryObject();

    public void fromXMLElement(Element element) {
        String className;
        super.fromXMLElement(element);
        this.definingClass = null;
        if (element != null && !ToolsUtilities.isNullOrEmpty(className = XMLUtilities.getPCData(element, CLASS_TAG))) {
            try {
                this.definingClass = Class.forName(className);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(this.getTagName());
        if (this.getDefiningClass() != null) {
            XMLUtilities.createPCData(document, element, CLASS_TAG, this.getDefiningClass().getName());
        }
        return element;
    }
}

