/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.parsing;

import com.aligo.parsing.XMLDOMItem;
import com.aligo.parsing.XMLElement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class XMLHDOM {
    public Hashtable htab = new Hashtable();
    public String rawXML;
    public XMLDOMItem defaultDI;
    public String defaultPath;
    public XMLDOMItem parentDefaultDI;
    private Vector children = null;

    public void setRawXML(String goo) {
        this.rawXML = goo;
    }

    public String getRawXML() {
        return this.rawXML;
    }

    public String getXML() {
        StringBuffer xml = new StringBuffer(2048);
        xml.append("");
        this.getXML(xml, this.htab);
        return xml.toString();
    }

    public String getXMLSubTree() {
        if (this.defaultDI != null && this.defaultDI.hdom != null) {
            return this.defaultDI.hdom.getXML();
        }
        return null;
    }

    private void getXML(StringBuffer xml, Hashtable ht) {
        Enumeration e1 = ht.keys();
        while (e1.hasMoreElements()) {
            Vector v = (Vector)ht.get(e1.nextElement());
            Enumeration e2 = v.elements();
            while (e2.hasMoreElements()) {
                XMLDOMItem xdi = (XMLDOMItem)e2.nextElement();
                xml.append(xdi.xel.toStringElementOpen());
                this.getXML(xml, xdi.hdom.htab);
                xml.append(xdi.xel.toStringElementClose());
            }
        }
    }

    public void dumpDom() {
        this.domDump(this.htab, 0);
    }

    private void domDump(Hashtable ht, int level) {
        Enumeration e1 = ht.keys();
        while (e1.hasMoreElements()) {
            Vector v = (Vector)ht.get(e1.nextElement());
            Enumeration e2 = v.elements();
            while (e2.hasMoreElements()) {
                XMLDOMItem xdi = (XMLDOMItem)e2.nextElement();
                String tab = "";
                int i = 0;
                while (i < level) {
                    tab = tab + " ";
                    ++i;
                }
                System.out.println(tab + xdi.xel.toStringElementOpen());
                this.domDump(xdi.hdom.htab, level + 1);
                System.out.println(tab + xdi.xel.toStringElementClose());
            }
        }
    }

    private boolean isLiteralNumber(String str) {
        int i = 0;
        while (i < str.length()) {
            if (!Character.isDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int evalXPath(String expr, String ename) {
        String texpr = expr.trim();
        if (texpr.charAt(0) == '@') {
            int eidx = texpr.indexOf(61);
            if (eidx == -1) {
                System.out.println("Invalid xpath expression - missing =");
                return 0;
            }
            String attname = texpr.substring(1, eidx);
            String attval = texpr.substring(eidx + 1, texpr.length());
            Vector v = (Vector)this.htab.get(ename);
            if (v == null) {
                System.out.println("Xpath error - no matching element - " + ename);
                return 0;
            }
            int i = 0;
            while (i < v.size()) {
                XMLDOMItem xdi = (XMLDOMItem)v.elementAt(i);
                if (xdi.xel.getAttribute(attname).equals(attval)) {
                    return i;
                }
                ++i;
            }
        } else {
            if (texpr.charAt(0) == '*') {
                return 0;
            }
            int eidx = texpr.indexOf(61);
            if (eidx == -1) {
                System.out.println("Invalid xpath expression - missing =");
                return 0;
            }
            String elname = texpr.substring(1, eidx);
            String elval = texpr.substring(eidx + 1, texpr.length());
            Vector v = (Vector)this.htab.get(ename);
            if (v == null) {
                System.out.println("Xpath error - no matching element - " + ename);
                return 0;
            }
            int i = 0;
            while (i < v.size()) {
                XMLDOMItem xdi = (XMLDOMItem)v.elementAt(i);
                Vector v2 = (Vector)xdi.hdom.htab.get(elname);
                if (v2 == null) {
                    System.out.println("Xpath error - no matching element(2) - " + ename + " - " + elname);
                    return -1;
                }
                int k = 0;
                while (k < v2.size()) {
                    XMLDOMItem xdi2 = (XMLDOMItem)v.elementAt(i);
                    if (xdi2.xel.getData().equals(elval)) {
                        return i;
                    }
                    ++k;
                }
                ++i;
            }
        }
        return -1;
    }

    public String getElementName(Object obj) {
        XMLDOMItem xdi = (XMLDOMItem)obj;
        return xdi.xel.getName();
    }

    private int getIndex(int s, String name, String ename) {
        int e = name.indexOf(93);
        if (e == -1) {
            System.out.println("Invalid xpath expression - missing ] - " + name);
            return 0;
        }
        String expr = name.substring(s + 1, e);
        if (this.isLiteralNumber(expr)) {
            return Integer.valueOf(expr);
        }
        return this.evalXPath(expr, ename);
    }

    public XMLHDOM addItem(XMLElement xel) {
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.addElement(xel);
        Vector<XMLDOMItem> v = (Vector<XMLDOMItem>)this.htab.get(xel.getName());
        if (v == null) {
            v = new Vector<XMLDOMItem>();
            this.htab.put(xel.getName(), v);
        }
        XMLDOMItem xdi = new XMLDOMItem(xel);
        v.addElement(xdi);
        return xdi.hdom;
    }

    public XMLHDOM updateItem(XMLElement xel) {
        Vector<XMLDOMItem> v = (Vector<XMLDOMItem>)this.htab.get(xel.getName());
        if (v == null) {
            v = new Vector<XMLDOMItem>();
            this.htab.put(xel.getName(), v);
        }
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            XMLDOMItem di = (XMLDOMItem)e.nextElement();
            if (!di.xel.equals(xel)) continue;
            di.xel = xel;
            return di.hdom;
        }
        XMLDOMItem xdi = new XMLDOMItem(xel);
        v.addElement(xdi);
        return xdi.hdom;
    }

    private XMLDOMItem find(StringTokenizer st, Vector prev) {
        if (st.hasMoreTokens()) {
            Vector v;
            XMLDOMItem xdi;
            int idx;
            String cname;
            String name = st.nextToken();
            int eon = name.indexOf(91);
            if (eon != -1) {
                cname = name.substring(0, eon);
                idx = this.getIndex(eon, name, cname);
            } else {
                cname = name;
                idx = 0;
            }
            if (idx == -1) {
                return null;
            }
            if (cname.charAt(0) == '*') {
                xdi = (XMLDOMItem)prev.elementAt(0);
                v = (Vector)this.htab.get(xdi.xel.name);
            } else {
                v = (Vector)this.htab.get(cname);
                if (v == null) {
                    return null;
                }
                try {
                    xdi = (XMLDOMItem)v.elementAt(idx);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return null;
                }
            }
            if (st.hasMoreTokens()) {
                return xdi.hdom.find(st, v);
            }
            return xdi;
        }
        return null;
    }

    private int findTrailingAttrSymbol(String path) {
        int s = path.length() - 1;
        while (path.charAt(s) != '/' && path.charAt(s) != ']' && s >= 0) {
            if (path.charAt(s) == '@') {
                return s;
            }
            --s;
        }
        return -1;
    }

    public String resolve(String path) {
        if (path.charAt(0) == '.') {
            this.defaultDI.hdom.parentDefaultDI = this.defaultDI;
            return this.defaultDI.hdom.resolve(path.substring(1, path.length()));
        }
        int idx = this.findTrailingAttrSymbol(path);
        if (idx != -1) {
            String npath = path.substring(0, idx);
            String atspec = path.substring(idx + 1, path.length());
            StringTokenizer st = new StringTokenizer(npath, "/");
            if (npath.equals("/")) {
                if (atspec != null && this.parentDefaultDI != null) {
                    return this.parentDefaultDI.xel.getAttribute(atspec);
                }
            } else {
                XMLDOMItem xdi = this.find(st, null);
                if (xdi != null && atspec != null) {
                    return xdi.xel.getAttribute(atspec);
                }
            }
        } else {
            StringTokenizer st = new StringTokenizer(path, "/");
            XMLDOMItem xdi = this.find(st, null);
            if (xdi != null) {
                return xdi.xel.getData();
            }
        }
        return null;
    }

    public String resolve(String path, String defaultValue) {
        String data = this.resolve(path);
        if (null == data) {
            return defaultValue;
        }
        return data.trim();
    }

    public String resolveEx(String path) {
        String data = this.resolve(path);
        if (null == data) {
            return "";
        }
        return data.trim();
    }

    public String setdefault(String path) {
        if (path.equals("/")) {
            this.defaultDI = null;
            this.defaultPath = null;
            this.parentDefaultDI = null;
            return path;
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        this.defaultDI = this.find(st, null);
        if (this.defaultDI != null) {
            this.defaultPath = path;
            return path;
        }
        return null;
    }

    public String getdefault() {
        return this.defaultPath;
    }

    private int count(StringTokenizer st) {
        if (st.hasMoreTokens()) {
            int idx;
            String cname;
            String name = st.nextToken();
            int eon = name.indexOf(91);
            if (eon != -1) {
                cname = name.substring(0, eon);
                idx = this.getIndex(eon, name, cname);
            } else {
                cname = name;
                idx = 0;
            }
            if (idx == -1) {
                return 0;
            }
            Vector v = (Vector)this.htab.get(cname);
            if (v == null) {
                return 0;
            }
            if (st.hasMoreTokens()) {
                XMLDOMItem xdi = (XMLDOMItem)v.elementAt(idx);
                return xdi.hdom.count(st);
            }
            return v.size();
        }
        return -1;
    }

    public int count(String path) {
        if (path.charAt(0) == '.') {
            return this.defaultDI.hdom.count(path.substring(1, path.length()));
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        return this.count(st);
    }

    private boolean deleteRelative(StringTokenizer st, Hashtable parent) {
        if (st.hasMoreTokens()) {
            boolean removeAll;
            int idx;
            String cname;
            String name = st.nextToken();
            int eon = name.indexOf(91);
            if (eon != -1) {
                cname = name.substring(0, eon);
                idx = this.getIndex(eon, name, cname);
                removeAll = false;
            } else {
                cname = name;
                idx = 0;
                removeAll = true;
            }
            if (idx == -1) {
                return false;
            }
            Vector v = (Vector)this.htab.get(cname);
            if (v == null) {
                return false;
            }
            if (st.hasMoreTokens()) {
                XMLDOMItem xdi = (XMLDOMItem)v.elementAt(idx);
                return xdi.hdom.deleteRelative(st, this.htab);
            }
            if (removeAll) {
                parent.remove(cname);
            } else {
                v.removeElementAt(idx);
            }
            return true;
        }
        return false;
    }

    private boolean deleteAbsolute(StringTokenizer st) {
        if (st.hasMoreTokens()) {
            boolean removeAll;
            int idx;
            String cname;
            String name = st.nextToken();
            int eon = name.indexOf(91);
            if (eon != -1) {
                cname = name.substring(0, eon);
                idx = this.getIndex(eon, name, cname);
                removeAll = false;
            } else {
                cname = name;
                idx = 0;
                removeAll = true;
            }
            if (idx == -1) {
                return false;
            }
            Vector v = (Vector)this.htab.get(cname);
            if (v == null) {
                return false;
            }
            if (st.hasMoreTokens()) {
                XMLDOMItem xdi = (XMLDOMItem)v.elementAt(idx);
                return xdi.hdom.deleteAbsolute(st);
            }
            if (removeAll) {
                this.htab.remove(cname);
            } else {
                v.removeElementAt(idx);
            }
            return true;
        }
        return false;
    }

    public boolean delete(String path) {
        if (path.charAt(0) == '.') {
            String rpath = path.substring(1, path.length());
            StringTokenizer st = new StringTokenizer(rpath, "/");
            return this.defaultDI.hdom.deleteRelative(st, this.htab);
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        return this.deleteAbsolute(st);
    }

    public Enumeration children(String path) {
        if (path.charAt(0) == '.') {
            return this.defaultDI.hdom.elements(path.substring(1, path.length()));
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        XMLDOMItem xdi = this.find(st, null);
        if (xdi != null && xdi.hdom.children != null) {
            return xdi.hdom.children.elements();
        }
        return null;
    }

    public Enumeration elements(String path) {
        if (path.charAt(0) == '.') {
            return this.defaultDI.hdom.elements(path.substring(1, path.length()));
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        XMLDOMItem xdi = this.find(st, null);
        if (xdi != null) {
            return xdi.hdom.htab.keys();
        }
        return null;
    }

    public Enumeration elements() {
        return this.htab.keys();
    }

    public String toString() {
        return this.htab.toString();
    }
}

