/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.morpher;

import com.aligo.aml.base.interfaces.AmlElement;
import com.aligo.morpher.TagProcessorAdapter;
import com.aligo.morpher.interfaces.TagHelperInterface;
import com.aligo.morpher.interfaces.TagManagerInterface;
import com.aligo.util.ClassUtils;
import com.aligo.util.URLUtils;
import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AmlURLTagProcessor
extends TagProcessorAdapter {
    private static String ACTION_ATTR = "action";
    private static String URL = "url";
    private static final String DEFAULT_ADD_ATTRIBUTE_METHOD_NAME = "setURL";
    private static String TYPE_ATTR = "type";
    private static Hashtable oTypeTable = new Hashtable();

    public void process(Node rootNode, AmlElement parentElement, TagHelperInterface helper, TagManagerInterface manager, boolean forgive) throws Exception {
        block7: {
            try {
                NamedNodeMap attributeNodeMap = rootNode.getAttributes();
                Node attribute = attributeNodeMap.getNamedItem(ACTION_ATTR);
                if (attribute != null) {
                    String actionName = attribute.getNodeValue();
                    String params = this.getParams(rootNode);
                    String url = actionName;
                    if (manager != null) {
                        url = manager.resolveAction(actionName);
                    }
                    url = URLUtils.composeURL(url, params);
                    String methodName = this.getMethodName(attributeNodeMap, helper);
                    Object[] args = new Object[]{url};
                    if (this.logger.debugEnabled()) {
                        this.logger.logDebug("Calling method " + methodName + " with url " + url + " on object " + parentElement);
                    }
                    ClassUtils.callMethod(parentElement, methodName, args);
                } else if (this.logger.debugEnabled()) {
                    this.logger.logDebug("action attribute is missing in AmlURL tag");
                }
            }
            catch (Exception ex) {
                if (forgive) break block7;
                throw ex;
            }
        }
    }

    private String getParams(Node inContextNode) {
        Node paramNode = null;
        StringBuffer paramsb = new StringBuffer("");
        NamedNodeMap nMap = null;
        Node nameAttNode = null;
        Node valueAttNode = null;
        String delim = "";
        if (inContextNode.getNodeType() == 1) {
            Element element = (Element)inContextNode;
            NodeList nl = element.getElementsByTagName("AmlParam");
            if (nl == null) {
                if (this.logger.debugEnabled()) {
                    this.logger.logDebug("nodelist is null - no parameters provided");
                }
            } else {
                int length = nl.getLength();
                if (length == 0) {
                    if (this.logger.debugEnabled()) {
                        this.logger.logDebug("nodelist is empty - no parameters provided");
                    }
                } else {
                    int i = 0;
                    while (i < length) {
                        paramNode = nl.item(i);
                        try {
                            nMap = null;
                            nMap = paramNode.getAttributes();
                            if (null != nMap) {
                                nameAttNode = nMap.getNamedItem("name");
                                valueAttNode = nMap.getNamedItem("value");
                                paramsb.append(delim + nameAttNode.getNodeValue() + "=" + valueAttNode.getNodeValue());
                                delim = "&";
                                if (this.logger.debugEnabled()) {
                                    this.logger.logDebug("nameAttNode :  " + nameAttNode.getNodeValue());
                                }
                                if (this.logger.debugEnabled()) {
                                    this.logger.logDebug("valueAttNode : " + valueAttNode.getNodeValue());
                                }
                            }
                        }
                        catch (NullPointerException n) {
                            this.logger.logError(n);
                        }
                        catch (Exception e) {
                            this.logger.logError(e);
                        }
                        ++i;
                    }
                }
            }
        }
        return paramsb.toString();
    }

    private String getMethodName(NamedNodeMap attributeNodeMap, TagHelperInterface helper) {
        String value;
        String methodName = DEFAULT_ADD_ATTRIBUTE_METHOD_NAME;
        Node attribute = attributeNodeMap.getNamedItem(TYPE_ATTR);
        if (attribute != null && (value = attribute.getNodeValue()) != null) {
            methodName = this.strMethodName(value, helper);
        }
        return methodName;
    }

    private String strMethodName(String name, TagHelperInterface helper) {
        String methodName = (String)oTypeTable.get(name);
        if (methodName == null) {
            methodName = helper.strMethodName(name);
        }
        return methodName;
    }
}

