/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.xhtml.amlhandlets;

import com.aligo.axml.AxmlDocument;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import com.aligo.modules.xhtml.handlets.XHtmlAmlStylePathHandlet;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlAddAttributeHandledHandletEvent;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlAddAttributeHandletEvent;
import com.aligo.modules.xhtml.util.XHtmlAmlElementUtils;
import com.aligo.modules.xhtml.util.XHtmlEventDescriptor;
import com.aligo.xhtml.XHtmlMeta;
import com.aligo.xhtml.exceptions.XHtmlAttributeCannotBeAddedException;
import com.aligo.xhtml.interfaces.XHtmlElement;
import java.util.Vector;

public class XHtmlAmlRefreshHandlet
extends XHtmlAmlStylePathHandlet {
    private static final String REFRESH = "Refresh";
    private static final String CONTENT_SEPARATOR = "; ";
    private static final String URL = "URL";
    private static final String EQUALS = "=";
    private AxmlElement oAmlElement;
    private String sRefresh;
    private XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;

    public Vector getEvents() {
        Vector<XHtmlEventDescriptor> events = new Vector<XHtmlEventDescriptor>();
        XHtmlEventDescriptor eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long xhtmlAmlStylePathRelevance() {
        XHtmlAmlAddAttributeHandletEvent addAttributeEvent;
        XmlAttributeInterface xmlAttribute;
        long currentXHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof XHtmlAmlAddAttributeHandletEvent && (xmlAttribute = (addAttributeEvent = (XHtmlAmlAddAttributeHandletEvent)this.oCurrentEvent).getXmlAttribute()) instanceof XmlAmlHandlerAttributeInterface) {
            String refresh;
            String attrName;
            XmlAmlHandlerAttributeInterface xmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)xmlAttribute;
            this.oCurrentAmlPath = addAttributeEvent.getAmlPath();
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
            if (amlElement instanceof AxmlDocument && (attrName = xmlAmlHandlerAttribute.getAmlAttributeName()).equals("refresh") && (refresh = amlElement.getAxmlAttributeValue(attrName)) != null) {
                this.oXmlAmlHandlerAttribute = xmlAmlHandlerAttribute;
                this.oAmlElement = amlElement;
                this.sRefresh = refresh;
                currentXHtmlAmlStylePathRelevance = 20L;
            }
        }
        return currentXHtmlAmlStylePathRelevance;
    }

    public void handleStylePathEvent() {
        if (this.oCurrentEvent instanceof XHtmlAmlAddAttributeHandletEvent) {
            try {
                XHtmlElement xhtmlElement = XHtmlAmlElementUtils.getXHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.oStyleXmlElement);
                try {
                    XHtmlMeta xhtmlMeta = new XHtmlMeta();
                    xhtmlMeta.addXHtmlAttribute("http-equiv", REFRESH);
                    int timeout = 0;
                    try {
                        String strTimeout = this.oAmlElement.getAxmlAttributeValue("refresh_timeout");
                        if (strTimeout != null) {
                            timeout = new Integer(strTimeout);
                        }
                    }
                    catch (NumberFormatException ne) {
                        this.oHandlerLogger.logError(ne);
                    }
                    String content = timeout + CONTENT_SEPARATOR + URL + EQUALS + this.sRefresh;
                    xhtmlMeta.addXHtmlAttribute("content", content);
                    XHtmlAmlElementUtils.addXHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, xhtmlElement, xhtmlMeta);
                }
                catch (XHtmlAttributeCannotBeAddedException ex) {
                    this.oHandlerLogger.logError(ex);
                }
            }
            catch (HandlerError he) {
                this.oHandlerLogger.logError(he);
            }
            XHtmlAmlAddAttributeHandledHandletEvent addAttributeHandledEvent = new XHtmlAmlAddAttributeHandledHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
            this.oHandlerManager.postEvent(addAttributeHandledEvent);
        }
    }
}

