/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.xhtml.amlhandlets;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.interfaces.AligoEventInterface;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import com.aligo.modules.xhtml.events.XHtmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.xhtml.exceptions.XHtmlAmlInsufficientMemoryException;
import com.aligo.modules.xhtml.handlets.XHtmlAmlStylePathHandlet;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlAddAttributeHandledHandletEvent;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlAddAttributeHandletEvent;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlXmlXHtmlElementHandletEvent;
import com.aligo.modules.xhtml.util.XHtmlAmlElementUtils;
import com.aligo.modules.xhtml.util.XHtmlEventDescriptor;
import com.aligo.xhtml.XHtmlInput;
import com.aligo.xhtml.XHtmlTextArea;
import com.aligo.xhtml.interfaces.XHtmlElement;
import java.util.Vector;

public class XHtmlAmlInputFormatHandlet
extends XHtmlAmlStylePathHandlet {
    protected XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;
    XmlAttributeInterface xmlAttribute;
    XHtmlElement xhtmlElement;
    private static final String JAPANESE_ENCODING = "SHIFT_JIS";
    private static final String FORMAT = "format";
    public static final String FORMAT_NUMERIC = "*N";
    public static final String FORMAT_JAPANESE_ALPHABETIC = "*M";
    public static final String FORMAT_ENGLISH_ALPHABETIC = "*m";
    public static final String FORMAT_ALPHA_NUMERIC_UPPER_CASE = "*X";
    public static final String FORMAT_ALPHA_NUMERIC_LOWER_CASE = "*x";
    public static final String FORMAT_ALPHA_ONLY_UPPER_CASE = "*A";
    public static final String FORMAT_ALPHA_ONLY_LOWER_CASE = "*a";
    private AmlPathInterface saCurrentAmlPath;

    public Vector getEvents() {
        Vector<XHtmlEventDescriptor> events = new Vector<XHtmlEventDescriptor>();
        XHtmlEventDescriptor eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long xhtmlAmlStylePathRelevance() {
        long currentXHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof XHtmlAmlAddAttributeHandletEvent) {
            XHtmlAmlAddAttributeHandletEvent addAttributeEvent = (XHtmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            this.xmlAttribute = addAttributeEvent.getXmlAttribute();
            try {
                AligoEventInterface event = this.oCurrentEvent;
                XHtmlAmlXmlXHtmlElementHandletEvent getXHtmlElementEvent = new XHtmlAmlXmlXHtmlElementHandletEvent("Get", addAttributeEvent.getAmlPath(), addAttributeEvent.getXmlElement());
                this.oHandlerManager.postEventNow(getXHtmlElementEvent);
                this.oCurrentEvent = event;
                this.xhtmlElement = getXHtmlElementEvent.getXHtmlElement();
                if (this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && (this.xhtmlElement instanceof XHtmlInput || this.xhtmlElement instanceof XHtmlTextArea)) {
                    this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                    if (this.oXmlAmlHandlerAttribute.getAmlAttributeName().toLowerCase().equals(FORMAT)) {
                        currentXHtmlAmlStylePathRelevance = 20L;
                    }
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        return currentXHtmlAmlStylePathRelevance;
    }

    public void handleStylePathEvent() {
        boolean memoryError = false;
        if (this.oCurrentEvent instanceof XHtmlAmlAddAttributeHandletEvent) {
            try {
                if (this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && (this.xhtmlElement instanceof XHtmlInput || this.xhtmlElement instanceof XHtmlTextArea)) {
                    AxmlElement axmlElement;
                    String amlAttributeValue;
                    this.saCurrentAmlPath = ((XHtmlAmlAddAttributeHandletEvent)this.oCurrentEvent).getAmlPath();
                    this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                    String amlAttributeName = this.oXmlAmlHandlerAttribute.getAmlAttributeName();
                    if (amlAttributeName.toLowerCase().equals(FORMAT) && (amlAttributeValue = (axmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.saCurrentAmlPath)).getAxmlAttributeValue(FORMAT)) != null) {
                        AxmlElement amlDocument = AmlPathUtils.getRootAmlElement(this.oHandlerManager);
                        String encoding = amlDocument.getAxmlAttributeValue("encoding");
                        if (amlAttributeValue.equals("numeric")) {
                            XHtmlAmlElementUtils.addXHtmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.xhtmlElement, FORMAT, FORMAT_NUMERIC);
                        } else if (amlAttributeValue.equals("localizedalphanumeric")) {
                            if (encoding != null && encoding.toUpperCase().indexOf(JAPANESE_ENCODING) != -1) {
                                XHtmlAmlElementUtils.addXHtmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.xhtmlElement, FORMAT, FORMAT_JAPANESE_ALPHABETIC);
                            } else {
                                XHtmlAmlElementUtils.addXHtmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.xhtmlElement, FORMAT, FORMAT_ENGLISH_ALPHABETIC);
                            }
                        } else if (amlAttributeValue.equals("alphanumeric")) {
                            XHtmlAmlElementUtils.addXHtmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.xhtmlElement, FORMAT, FORMAT_ENGLISH_ALPHABETIC);
                        } else if (amlAttributeValue.equals("alphanumericuppercase")) {
                            XHtmlAmlElementUtils.addXHtmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.xhtmlElement, FORMAT, FORMAT_ALPHA_NUMERIC_UPPER_CASE);
                        } else if (amlAttributeValue.equals("alphanumericlowercase")) {
                            XHtmlAmlElementUtils.addXHtmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.xhtmlElement, FORMAT, FORMAT_ALPHA_NUMERIC_LOWER_CASE);
                        } else if (amlAttributeValue.equals("alphaonlyuppercase")) {
                            XHtmlAmlElementUtils.addXHtmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.xhtmlElement, FORMAT, FORMAT_ALPHA_ONLY_UPPER_CASE);
                        } else if (amlAttributeValue.equals("alphaonlylowercase")) {
                            XHtmlAmlElementUtils.addXHtmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.xhtmlElement, FORMAT, FORMAT_ALPHA_ONLY_LOWER_CASE);
                        } else {
                            XHtmlAmlElementUtils.addXHtmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.xhtmlElement, FORMAT, amlAttributeValue);
                        }
                    }
                }
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (ex instanceof XHtmlAmlInsufficientMemoryException) {
                    memoryError = true;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
            if (memoryError) {
                XHtmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new XHtmlAmlInsufficientMemoryHandlerEvent(this.saCurrentAmlPath);
                this.oHandlerManager.postEvent(insufficientMemoryEvent);
            } else {
                XHtmlAmlAddAttributeHandledHandletEvent xhtmlAmlAddAttributeHandledHandletEvent = new XHtmlAmlAddAttributeHandledHandletEvent(this.saCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
                this.oHandlerManager.postEvent(xhtmlAmlAddAttributeHandledHandletEvent);
            }
        }
    }
}

