/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.wml.amlhandlets;

import com.aligo.axml.AxmlPage;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.EventDescriptor;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.modules.wml.errors.WmlAmlHandlerError;
import com.aligo.modules.wml.events.WmlAmlDetachFromTreeMemoryHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetPreviousChildIndexHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlSetCurrentPageHandlerEvent;
import com.aligo.modules.wml.exceptions.WmlAmlInsufficientMemoryException;
import com.aligo.modules.wml.handlets.WmlAmlStylePathHandlet;
import com.aligo.modules.wml.handlets.events.WmlAmlAddElementHandledHandletEvent;
import com.aligo.modules.wml.handlets.events.WmlAmlAddXmlAmlAddAttributeHandletEvent;
import com.aligo.modules.wml.interfaces.WmlEventHookPosition;
import com.aligo.modules.wml.util.WmlAmlElementUtils;
import com.aligo.modules.wml.util.WmlEventDescriptor;
import com.aligo.modules.wml.util.WmlEventHookDescriptor;
import com.aligo.util.wml.TextUtils;
import com.aligo.wml.WmlA;
import com.aligo.wml.WmlCard;
import com.aligo.wml.WmlDo;
import com.aligo.wml.WmlGo;
import com.aligo.wml.WmlOption;
import com.aligo.wml.exceptions.WmlAttributeCannotBeAddedException;
import com.aligo.wml.exceptions.WmlElementCannotBeAddedException;
import com.aligo.wml.exceptions.WmlElementIndexOutOfBoundsException;
import com.aligo.wml.interfaces.WmlElement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class WmlAmlLinkingHandlet
extends WmlAmlStylePathHandlet {
    private static final String TYPE = "type";
    private static final String OPTIONS = "options";
    private static final String LABEL = "label";
    private static final String PREVIOUS_PAGE = "Previous Page";
    private static final String SENDREFERER = "sendreferer";
    private static final String TRUE = "true";
    private static final String HREF = "href";
    private static final String NEXT_PAGE = "Next Page";
    private static final String ID = "id";
    private Hashtable oPageIDs = new Hashtable();
    private Hashtable oIDPages = new Hashtable();
    private Hashtable oNavigators = new Hashtable();
    private Hashtable oIDLinks = new Hashtable();
    private WmlElement oWmlElement;

    public Vector getEvents() {
        Vector<EventDescriptor> events = new Vector<EventDescriptor>();
        WmlEventHookDescriptor eventHookDescriptor = new WmlEventHookDescriptor("WmlAmlAddElementHandledHandletEvent", WmlEventHookPosition.POSITION_AFTER);
        events.addElement(eventHookDescriptor);
        eventHookDescriptor = new WmlEventHookDescriptor("WmlAmlDetachFromTreeMemoryHandlerEvent", WmlEventHookPosition.POSITION_AFTER);
        events.addElement(eventHookDescriptor);
        WmlEventDescriptor eventDescriptor = new WmlEventDescriptor("WmlAmlAddXmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long wmlAmlRelevance() {
        long currentWmlAmlRelevance = 0L;
        if (this.oCurrentEvent instanceof WmlAmlDetachFromTreeMemoryHandlerEvent) {
            if (this.oHandlerLogger.debugEnabled()) {
                this.oHandlerLogger.logDebug("01/29 Captured detach event");
            }
            this.oCurrentAmlPath = ((WmlAmlDetachFromTreeMemoryHandlerEvent)this.oCurrentEvent).getAmlPath();
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
            if (amlElement instanceof AxmlPage) {
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug("Handling for page detach" + this.oCurrentAmlPath);
                }
                currentWmlAmlRelevance = 20L;
            }
        } else {
            currentWmlAmlRelevance = super.wmlAmlRelevance();
        }
        return currentWmlAmlRelevance;
    }

    public long wmlAmlStylePathRelevance() {
        long currentWmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof WmlAmlAddElementHandledHandletEvent) {
            WmlAmlAddElementHandledHandletEvent addElementHandledEvent = (WmlAmlAddElementHandledHandletEvent)this.oCurrentEvent;
            this.oStyleXmlElement = addElementHandledEvent.getXmlElement();
            this.oCurrentAmlPath = addElementHandledEvent.getAmlPath();
            try {
                WmlElement wmlElement = WmlAmlElementUtils.getWmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.oStyleXmlElement);
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug(" %%%%% wmlElement is " + wmlElement);
                }
                if (wmlElement instanceof WmlCard) {
                    if (this.oHandlerLogger.debugEnabled()) {
                        this.oHandlerLogger.logDebug(" &&&&& wmlElement being set ");
                    }
                    this.oWmlElement = wmlElement;
                    currentWmlAmlStylePathRelevance = 20L;
                }
            }
            catch (HandlerError he) {
                this.oHandlerLogger.logError(he);
            }
        } else if (this.oCurrentEvent instanceof WmlAmlAddXmlAmlAddAttributeHandletEvent) {
            WmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (WmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            XmlElementInterface styleXmlElement = addAttributeEvent.getXmlElement();
            this.oCurrentAmlPath = addAttributeEvent.getAmlPath();
            try {
                WmlElement wmlElement = WmlAmlElementUtils.getWmlElement(this.oHandlerManager, this.oCurrentAmlPath, styleXmlElement);
                String wmlName = addAttributeEvent.getWmlName();
                if (wmlElement instanceof WmlCard) {
                    if (wmlName.equals(ID)) {
                        currentWmlAmlStylePathRelevance = 20L;
                    }
                } else if (this.isLinkAttr(wmlElement, wmlName)) {
                    currentWmlAmlStylePathRelevance = 20L;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return currentWmlAmlStylePathRelevance;
    }

    private boolean isLinkAttr(WmlElement wmlElement, String attrName) {
        boolean linkAttr = false;
        if (wmlElement instanceof WmlA) {
            if (attrName.equals(HREF)) {
                linkAttr = true;
            }
        } else if (wmlElement instanceof WmlOption) {
            if (attrName.equals("onpick")) {
                linkAttr = true;
            }
        } else if (wmlElement instanceof WmlGo && attrName.equals(HREF)) {
            linkAttr = true;
        }
        return linkAttr;
    }

    public void handleEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof WmlAmlDetachFromTreeMemoryHandlerEvent) {
            this.oCurrentAmlPath = ((WmlAmlDetachFromTreeMemoryHandlerEvent)this.oCurrentEvent).getAmlPath();
            this.removePage(this.oCurrentAmlPath);
        } else {
            super.handleEventNow();
        }
    }

    public void removePage(AmlPathInterface currentAmlPath) throws HandlerError {
        String strCurrentAmlPath = currentAmlPath.toString();
        String id = (String)this.oPageIDs.get(strCurrentAmlPath);
        if (id != null) {
            AmlPathInterface documentPath;
            AmlPathInterface previousPagePath;
            AxmlElement previousAxmlCard;
            Vector navDesc;
            Vector pages;
            if (this.oHandlerLogger.debugEnabled()) {
                this.oHandlerLogger.logDebug("Id... " + id);
            }
            if ((pages = (Vector)this.oIDPages.get(id)) != null) {
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug("Checking pages... " + pages.size());
                }
                Enumeration keys = pages.elements();
                boolean done = false;
                while (keys.hasMoreElements() && !done) {
                    AmlPathInterface path = (AmlPathInterface)keys.nextElement();
                    if (!strCurrentAmlPath.equals(path.toString())) continue;
                    if (this.oHandlerLogger.debugEnabled()) {
                        this.oHandlerLogger.logDebug("Found path...");
                    }
                    pages.remove(path);
                    done = true;
                }
            }
            if ((navDesc = (Vector)this.oNavigators.get(strCurrentAmlPath)) != null) {
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug("Remove nav... " + navDesc);
                }
                WmlAmlElementUtils.removeWmlElement(this.oHandlerManager, (AmlPathInterface)navDesc.elementAt(1), (WmlElement)navDesc.elementAt(2), (WmlElement)navDesc.elementAt(3));
                this.oNavigators.remove(strCurrentAmlPath);
            }
            int position = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
            WmlAmlGetPreviousChildIndexHandlerEvent previousIndexEvent = new WmlAmlGetPreviousChildIndexHandlerEvent(currentAmlPath, position);
            this.oHandlerManager.postEventNow(previousIndexEvent);
            int prevIndex = previousIndexEvent.getPreviousIndex();
            if (prevIndex >= 0 && (previousAxmlCard = AmlPathUtils.getAmlElement(this.oHandlerManager, previousPagePath = AmlPathUtils.getChildPath(this.oHandlerManager, documentPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath), prevIndex))) instanceof AxmlPage) {
                WmlAmlSetCurrentPageHandlerEvent setCurrentPageEvent = new WmlAmlSetCurrentPageHandlerEvent(previousPagePath);
                this.oHandlerManager.postEventNow(setCurrentPageEvent);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleStylePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof WmlAmlAddElementHandledHandletEvent) {
            try {
                this.addName(this.oWmlElement);
                return;
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
                if (ex instanceof HandlerError) return;
                throw new WmlAmlHandlerError(ex);
            }
        } else {
            if (!(this.oCurrentEvent instanceof WmlAmlAddXmlAmlAddAttributeHandletEvent)) return;
            WmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (WmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            XmlElementInterface styleXmlElement = addAttributeEvent.getXmlElement();
            WmlElement wmlElement = WmlAmlElementUtils.getWmlElement(this.oHandlerManager, this.oCurrentAmlPath, styleXmlElement);
            String wmlName = addAttributeEvent.getWmlName();
            if (wmlElement instanceof WmlCard) {
                String wmlValue;
                if (!wmlName.equals(ID) || (wmlValue = addAttributeEvent.getWmlValue()) == null) return;
                this.setCardId(wmlElement, wmlValue);
                String strPath = this.oCurrentAmlPath.toString();
                WmlElement navElement = null;
                Vector navDesc = (Vector)this.oNavigators.get(strPath);
                if (navDesc != null) {
                    navElement = (WmlElement)navDesc.elementAt(0);
                }
                if (navElement == null) return;
                try {
                    WmlAmlElementUtils.addWmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, navElement, HREF, "#" + wmlValue);
                    return;
                }
                catch (HandlerError he) {}
                return;
            } else {
                String wmlValue;
                if (!this.isLinkAttr(wmlElement, wmlName) || (wmlValue = addAttributeEvent.getWmlValue()) == null) return;
                String url = wmlValue;
                int refIndex = wmlValue.indexOf("#");
                if (refIndex != -1) {
                    Vector links;
                    String id = wmlValue.substring(refIndex + 1);
                    Vector paths = (Vector)this.oIDPages.get(id);
                    if (paths != null && paths.size() > 0) {
                        url = this.getUrl(this.oCurrentAmlPath, paths, id);
                    }
                    if ((links = (Vector)this.oIDLinks.get(id)) == null) {
                        links = new Vector();
                        this.oIDLinks.put(id, links);
                    }
                    Vector<Object> linkDesc = new Vector<Object>();
                    linkDesc.addElement(this.oCurrentAmlPath);
                    linkDesc.addElement(wmlElement);
                    linkDesc.addElement(wmlName);
                    links.addElement(linkDesc);
                } else {
                    url = TextUtils.transformAttr(wmlName, url);
                }
                WmlAmlElementUtils.addWmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, wmlElement, wmlName, url);
            }
        }
    }

    public String addName(WmlElement wmlElement) throws WmlAttributeCannotBeAddedException, WmlElementCannotBeAddedException, HandlerError {
        String name = null;
        if (this.oHandlerLogger.debugEnabled()) {
            this.oHandlerLogger.logDebug(" ------------ In addName: wmlElement = " + wmlElement);
        }
        try {
            if (wmlElement instanceof WmlCard) {
                PageAllocatorInterface pageAllocator = WmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug(" -- Allocating element -- ");
                }
                pageAllocator.allocateElement();
                name = pageAllocator.getCurrentElementID();
                this.setCardId(wmlElement, name);
                String strPath = this.oCurrentAmlPath.toString();
                int position = AmlPathUtils.getChildIndex(this.oHandlerManager, this.oCurrentAmlPath);
                WmlAmlGetPreviousChildIndexHandlerEvent previousIndexEvent = new WmlAmlGetPreviousChildIndexHandlerEvent(this.oCurrentAmlPath, position);
                this.oHandlerManager.postEventNow(previousIndexEvent);
                int prevIndex = previousIndexEvent.getPreviousIndex();
                if (prevIndex >= 0) {
                    AmlPathInterface documentPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
                    AxmlElement currentAxmlCard = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                    AmlPathInterface previousPagePath = AmlPathUtils.getChildPath(this.oHandlerManager, documentPath, prevIndex);
                    AxmlElement previousAxmlCard = AmlPathUtils.getAmlElement(this.oHandlerManager, previousPagePath);
                    if (previousAxmlCard instanceof AxmlPage) {
                        String prevStrPath = previousPagePath.toString();
                        String previousCardId = (String)this.oPageIDs.get(prevStrPath);
                        String currentCardId = name;
                        if (currentAxmlCard.getAxmlAttributeValue("prev_label") == null || currentAxmlCard.getAxmlAttributeValue("prev_label") != null && !currentAxmlCard.getAxmlAttributeValue("prev_label").equalsIgnoreCase("none")) {
                            WmlDo wmlDo = new WmlDo();
                            wmlDo.addWmlAttribute(TYPE, OPTIONS);
                            if (currentAxmlCard.getAxmlAttributeValue("prev_label") != null) {
                                wmlDo.addWmlAttribute(LABEL, currentAxmlCard.getAxmlAttributeValue("prev_label"));
                            } else {
                                wmlDo.addWmlAttribute(LABEL, PREVIOUS_PAGE);
                            }
                            WmlGo wmlGo = new WmlGo();
                            wmlGo.addWmlAttribute(SENDREFERER, TRUE);
                            wmlGo.addWmlAttribute(HREF, "#" + previousCardId);
                            wmlDo.addWmlElement(wmlGo);
                            WmlAmlElementUtils.addWmlElement(this.oHandlerManager, this.oCurrentAmlPath, wmlElement, wmlDo);
                        }
                        WmlElement previousPageContainer = WmlAmlElementUtils.getTopWmlElement(this.oHandlerManager, previousPagePath);
                        WmlElement previousCard = previousPageContainer.wmlElementAt(0);
                        if (previousAxmlCard.getAxmlAttributeValue("next_label") == null || previousAxmlCard.getAxmlAttributeValue("next_label") != null && !previousAxmlCard.getAxmlAttributeValue("next_label").equalsIgnoreCase("none")) {
                            WmlDo wmlDo = new WmlDo();
                            wmlDo.addWmlAttribute(TYPE, OPTIONS);
                            if (previousAxmlCard.getAxmlAttributeValue("next_label") != null) {
                                wmlDo.addWmlAttribute(LABEL, previousAxmlCard.getAxmlAttributeValue("next_label"));
                            } else {
                                wmlDo.addWmlAttribute(LABEL, NEXT_PAGE);
                            }
                            WmlGo wmlGo = new WmlGo();
                            wmlGo.addWmlAttribute(SENDREFERER, TRUE);
                            wmlGo.addWmlAttribute(HREF, "#" + currentCardId);
                            wmlDo.addWmlElement(wmlGo);
                            WmlAmlElementUtils.addWmlElement(this.oHandlerManager, previousPagePath, previousCard, wmlDo);
                            Vector<Object> navDesc = new Vector<Object>();
                            navDesc.addElement(wmlGo);
                            navDesc.addElement(previousPagePath);
                            navDesc.addElement(previousCard);
                            navDesc.addElement(wmlDo);
                            this.oNavigators.put(strPath, navDesc);
                        }
                    }
                }
            }
        }
        catch (HandlerError he) {
            this.oHandlerLogger.logError(he);
            Exception ex = he.getException();
            if (!(ex instanceof WmlAmlInsufficientMemoryException)) {
                throw he;
            }
        }
        catch (WmlElementIndexOutOfBoundsException ex) {
            this.oHandlerLogger.logError(ex);
        }
        return name;
    }

    private void setCardId(WmlElement wmlElement, String id) {
        try {
            WmlAmlElementUtils.addWmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, wmlElement, ID, id);
        }
        catch (HandlerError he) {
            // empty catch block
        }
        String strPath = this.oCurrentAmlPath.toString();
        String oldId = (String)this.oPageIDs.get(strPath);
        if (oldId != null) {
            this.oIDPages.remove(oldId);
            PageAllocatorInterface pageAllocator = WmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
            pageAllocator.changeElement(oldId, id);
        }
        this.oPageIDs.put(strPath, id);
        Vector<AmlPathInterface> pages = (Vector<AmlPathInterface>)this.oIDPages.get(id);
        if (pages == null) {
            pages = new Vector<AmlPathInterface>();
            this.oIDPages.put(id, pages);
        }
        pages.addElement(this.oCurrentAmlPath);
        Vector links = (Vector)this.oIDLinks.get(id);
        if (links != null) {
            int number = links.size();
            if (this.oHandlerLogger.debugEnabled()) {
                this.oHandlerLogger.logDebug("01/29:():Fixing links for Id " + id);
            }
            int i = 0;
            while (i < number) {
                Vector linkDesc = (Vector)links.elementAt(i);
                AmlPathInterface amlPath = (AmlPathInterface)linkDesc.elementAt(0);
                WmlElement linkElement = (WmlElement)linkDesc.elementAt(1);
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug("01/29:(): Fixing AmlPath(" + amlPath + ")+to(" + linkElement + ")");
                }
                try {
                    String url = this.getUrl(amlPath, pages, id);
                    String wmlName = (String)linkDesc.elementAt(2);
                    if (this.oHandlerLogger.debugEnabled()) {
                        this.oHandlerLogger.logDebug("01/29:(): url(" + url + ")+wmlName(" + wmlName + ")");
                    }
                    WmlAmlElementUtils.addWmlAttribute(this.oHandlerManager, amlPath, linkElement, wmlName, url);
                }
                catch (HandlerError he) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    private String getUrl(AmlPathInterface srcPath, Vector paths, String id) {
        if (this.oHandlerLogger.debugEnabled()) {
            this.oHandlerLogger.logDebug("01/29:()(getUrl): Find URL for " + srcPath + " while fixing " + id + ")");
        }
        String url = "#" + id;
        int srcRealm = srcPath.getRealm();
        Enumeration keys = paths.elements();
        boolean isSame = false;
        boolean first = true;
        AmlPathInterface firstPath = null;
        int firstRealm = -1;
        while (keys.hasMoreElements() && !isSame) {
            AmlPathInterface destPath = (AmlPathInterface)keys.nextElement();
            int destRealm = destPath.getRealm();
            if (srcRealm == destRealm) {
                isSame = true;
                if (!this.oHandlerLogger.debugEnabled()) continue;
                this.oHandlerLogger.logDebug("01/29:(): SrC realm = Dest realm for(" + srcRealm + "," + destRealm + ")+( " + srcPath + "pointing to" + destPath + " while fixing " + id + ")");
                continue;
            }
            if (first) {
                firstRealm = destRealm;
                firstPath = destPath;
                first = false;
                continue;
            }
            if (destRealm >= firstRealm) continue;
            firstRealm = destRealm;
            firstPath = destPath;
        }
        if (!isSame) {
            if (this.oHandlerLogger.debugEnabled()) {
                this.oHandlerLogger.logDebug("01/29:(): SrC realm != Dest realm for(" + firstRealm + ")+( " + srcPath + "pointing to" + firstPath + " while fixing " + id + ")");
            }
            if (firstPath != null) {
                url = this.getUrl(srcPath, firstPath, id);
            }
            if (this.oHandlerLogger.debugEnabled()) {
                this.oHandlerLogger.logDebug("01/29:(): And the URL is " + url);
            }
        }
        return url;
    }

    private String getUrl(AmlPathInterface srcPath, AmlPathInterface destPath, String id) {
        int destRealm;
        String url = "#" + id;
        int srcRealm = srcPath.getRealm();
        if (srcRealm != (destRealm = destPath.getRealm())) {
            PageAllocatorInterface pageAllocator = WmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
            url = pageAllocator.getElementURL(id);
        }
        return url;
    }
}

