/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.wml.amlhandlets;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.interfaces.AligoEventInterface;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import com.aligo.modules.wml.events.WmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.wml.exceptions.WmlAmlInsufficientMemoryException;
import com.aligo.modules.wml.handlets.WmlAmlStylePathHandlet;
import com.aligo.modules.wml.handlets.events.WmlAmlAddAttributeHandletEvent;
import com.aligo.modules.wml.handlets.events.WmlAmlAddNextAttributeHandletEvent;
import com.aligo.modules.wml.util.WmlAmlElementUtils;
import com.aligo.modules.wml.util.WmlEventDescriptor;
import com.aligo.wml.WmlSelect;
import com.aligo.wml.interfaces.WmlElement;
import java.util.Vector;

public class WmlAmlCheckBoxSelectedHandlet
extends WmlAmlStylePathHandlet {
    private static final String SELECTED_TRUE = "true";
    private static final String SELECT_NO = "no";
    private static final String SELECT_YES = "yes";
    protected XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;
    private XmlAttributeInterface xmlAttribute;
    private WmlElement wmlElement;

    public Vector getEvents() {
        Vector<WmlEventDescriptor> events = new Vector<WmlEventDescriptor>();
        WmlEventDescriptor eventDescriptor = new WmlEventDescriptor("WmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long wmlAmlStylePathRelevance() {
        long currentWmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof WmlAmlAddAttributeHandletEvent) {
            WmlAmlAddAttributeHandletEvent addAttributeEvent = (WmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            this.xmlAttribute = addAttributeEvent.getXmlAttribute();
            if (this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface) {
                this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                if (this.oXmlAmlHandlerAttribute.getAmlAttributeName().toLowerCase().equals("selected")) {
                    try {
                        AligoEventInterface event = this.oCurrentEvent;
                        this.wmlElement = WmlAmlElementUtils.getWmlElement(this.oHandlerManager, addAttributeEvent.getAmlPath(), addAttributeEvent.getXmlElement());
                        this.oCurrentEvent = event;
                        if (this.wmlElement instanceof WmlSelect) {
                            currentWmlAmlStylePathRelevance = 20L;
                        }
                    }
                    catch (Exception ex) {
                        this.oHandlerLogger.logError(ex);
                    }
                }
            }
        }
        return currentWmlAmlStylePathRelevance;
    }

    public void handleStylePathEvent() {
        boolean memoryError = false;
        if (this.oCurrentEvent instanceof WmlAmlAddAttributeHandletEvent) {
            WmlAmlAddAttributeHandletEvent addAttributeEvent = (WmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            try {
                if (this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && this.wmlElement instanceof WmlSelect) {
                    this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                    String amlAttributeName = this.oXmlAmlHandlerAttribute.getAmlAttributeName();
                    AxmlElement axmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                    String amlAttributeValue = axmlElement.getAxmlAttributeValue(amlAttributeName);
                    if (amlAttributeName.toLowerCase().equals("selected") && amlAttributeValue != null && !amlAttributeValue.equals("")) {
                        if (amlAttributeValue.equals(SELECTED_TRUE)) {
                            WmlAmlElementUtils.addWmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, this.wmlElement, "value", SELECT_YES);
                        } else {
                            WmlAmlElementUtils.addWmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, this.wmlElement, "value", SELECT_NO);
                        }
                    }
                }
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (ex instanceof WmlAmlInsufficientMemoryException) {
                    memoryError = true;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
            if (memoryError) {
                try {
                    WmlAmlElementUtils.removeWmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.wmlElement.getWmlParentElement(), this.wmlElement);
                }
                catch (HandlerError he) {
                    // empty catch block
                }
                WmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new WmlAmlInsufficientMemoryHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(insufficientMemoryEvent);
            } else {
                WmlAmlAddNextAttributeHandletEvent wmlAmlAddNextAttributeHandletEvent = new WmlAmlAddNextAttributeHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
                this.oHandlerManager.postEvent(wmlAmlAddNextAttributeHandletEvent);
            }
        }
    }
}

