/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.wml;

import com.aligo.axml.AxmlCheckBox;
import com.aligo.axml.AxmlChoice;
import com.aligo.axml.AxmlControlMenu;
import com.aligo.axml.AxmlForm;
import com.aligo.axml.AxmlInput;
import com.aligo.axml.AxmlListItem;
import com.aligo.axml.AxmlOption;
import com.aligo.axml.AxmlPage;
import com.aligo.axml.AxmlText;
import com.aligo.axml.AxmlTextArea;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.interfaces.AligoEventInterface;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.paths.AmlPath;
import com.aligo.modules.paths.interfaces.AmlPathComponentInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.modules.wml.WmlAmlHandler;
import com.aligo.modules.wml.amlhandlets.events.WmlAmlSetFormElementEvent;
import com.aligo.modules.wml.amlhandlets.events.WmlAmlSetFormInputNameEvent;
import com.aligo.modules.wml.errors.WmlAmlHandlerError;
import com.aligo.modules.wml.events.WmlAmlAddControlMenuElementHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlCheckLinkFormHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlCheckLinkPageHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlCombineTextHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlCreateElementHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlDetachFromTreeMemoryHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlEndRenderingHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetCreatedIndicesHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetCurrentPageIDHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetDynamicURLHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetFormRedirectionInfoHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetLastWorkingPathHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetPreviousChildIndexHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetPreviousPageIDHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetTopWmlElementStateHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlIsCachedChoiceFormHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlRemoveCreatedIndexHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlResetTextStateHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlSetCurrentPageHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlSetTopWmlElementStateHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlShouldDetachTextMemoryHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlStartNewRealmMemoryHandlerEvent;
import com.aligo.modules.wml.exceptions.WmlAmlInsufficientMemoryException;
import com.aligo.modules.wml.handlets.events.WmlAmlAddAttributeHandletEvent;
import com.aligo.modules.wml.handlets.events.WmlAmlAddNextAttributeHandletEvent;
import com.aligo.modules.wml.handlets.events.WmlAmlAddXmlWmlAttributeHandletEvent;
import com.aligo.modules.wml.handlets.events.WmlAmlFixInputValueHandletEvent;
import com.aligo.modules.wml.util.WmlAmlElementUtils;
import com.aligo.modules.wml.util.WmlAmlMemoryUtils;
import com.aligo.modules.wml.util.WmlEventDescriptor;
import com.aligo.util.FormRedirectionInfo;
import com.aligo.util.FormRedirector;
import com.aligo.util.wml.TextUtils;
import com.aligo.wml.WmlA;
import com.aligo.wml.WmlContainer;
import com.aligo.wml.WmlDo;
import com.aligo.wml.WmlGo;
import com.aligo.wml.WmlOption;
import com.aligo.wml.WmlP;
import com.aligo.wml.WmlPCData;
import com.aligo.wml.WmlPostfield;
import com.aligo.wml.exceptions.WmlElementIndexOutOfBoundsException;
import com.aligo.wml.exceptions.WmlElementNotFoundException;
import com.aligo.wml.interfaces.WmlElement;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class WmlAmlMemoryHandler
extends WmlAmlHandler {
    public static final String PERSIST = "persist";
    public static final String PERSIST_FALSE = "false";
    private static final String PAGE = "com.aligo.axml.AxmlPage";
    private static final String FORM = "com.aligo.axml.AxmlForm";
    private static final String CHOICE = "com.aligo.axml.AxmlChoice";
    private static final String FORM_NAME = "Go";
    private static final String FORM_DO = "Do";
    private static final String TEXT_NAME = "P";
    private static final String FORM_ACTION = "href";
    private static final String EQUALS = "=";
    private static final String AMPERSAND = "&amp;";
    private static final String LEFT_PAREN = "(";
    private static final String RIGHT_PAREN = ")";
    private int iRealm = 0;
    private AmlPathInterface oLastWorkingPath;
    private static final String MORE = "More";
    private static final String BACK = "Back";
    private static final String HREF = "href";
    private static final String TEXT = "text";
    private static final String TYPE = "type";
    private static final String OPTIONS = "options";
    private static final String LABEL = "label";
    private static final String SENDREFERER = "sendreferer";
    private static final String TRUE = "true";
    private static final String HALIGN = "halign";
    private static final String VALIGN = "valign";
    private static final String SUBMIT_IDENTIFIER = "s";
    private static final String FORMNUM_IDENTIFIER = "agf";
    private AmlPathInterface oLastPagePath = null;
    private AmlPathInterface oCurrentPagePath = null;
    private boolean bPageSet = false;
    private AmlPathInterface oLastFormPath = null;
    private AmlPathInterface oLastFormProcessedPath = null;
    private boolean bIsChoiceFormPresent = false;
    private Vector oLastFormRedirectors;
    private String oSecondLastChoiceFormURL = null;
    private boolean bClosingChoiceFormCall = false;
    private boolean bDisablePageBack = false;
    private boolean bDisablePageMore = false;
    private int iFormNumber = 0;
    private Hashtable formState = new Hashtable();
    private Vector currentFormPaths = new Vector();
    private static final String INPUTS = "inputs";
    private static final String LAST_ELEMENT = "lastelement";
    private static final String PATH_LAST_ELEMENT = "pathlastelement";
    private static final String URL = "url";
    private static final String NAME = "name";
    private static final String CACHE_VIEW_LINK = "cache-view-link";
    private XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;
    private AmlPathInterface oCurrentAmlPath;
    private XmlElementInterface oStyleXmlElement;
    private WmlElement oWmlElement;
    private Hashtable oCacheViews = new Hashtable();

    public WmlAmlMemoryHandler() {
        this.oLastFormRedirectors = new Vector();
    }

    public Vector getEvents() {
        Vector<WmlEventDescriptor> events = new Vector<WmlEventDescriptor>();
        WmlEventDescriptor eventDescriptor = new WmlEventDescriptor("WmlAmlInsufficientMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlStartNewRealmMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlDetachFromTreeMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlSetCurrentPageHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlCombineTextHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlCheckLinkPageHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlCheckLinkFormHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlIsCachedChoiceFormHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlSetFormInputNameEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlSetFormElementEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlGetLastWorkingPathHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long wmlAmlRelevance() {
        XmlAmlHandlerAttributeInterface xmlAmlHandlerAttribute;
        String amlAttributeName;
        WmlAmlAddAttributeHandletEvent addAttributeEvent;
        XmlAttributeInterface xmlAttribute;
        long currentWmlAmlRelevance = 0L;
        if (this.oCurrentEvent instanceof WmlAmlInsufficientMemoryHandlerEvent || this.oCurrentEvent instanceof WmlAmlStartNewRealmMemoryHandlerEvent || this.oCurrentEvent instanceof WmlAmlDetachFromTreeMemoryHandlerEvent) {
            currentWmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof WmlAmlSetCurrentPageHandlerEvent) {
            currentWmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof WmlAmlCombineTextHandlerEvent) {
            currentWmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof WmlAmlCheckLinkPageHandlerEvent) {
            currentWmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof WmlAmlCheckLinkFormHandlerEvent) {
            currentWmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof WmlAmlIsCachedChoiceFormHandlerEvent) {
            currentWmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof WmlAmlSetFormInputNameEvent) {
            currentWmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof WmlAmlSetFormElementEvent) {
            currentWmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof WmlAmlGetLastWorkingPathHandlerEvent) {
            currentWmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof WmlAmlAddAttributeHandletEvent && (xmlAttribute = (addAttributeEvent = (WmlAmlAddAttributeHandletEvent)this.oCurrentEvent).getXmlAttribute()) instanceof XmlAmlHandlerAttributeInterface && (amlAttributeName = (xmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)xmlAttribute).getAmlAttributeName()).equals(CACHE_VIEW_LINK)) {
            try {
                this.oCurrentAmlPath = addAttributeEvent.getAmlPath();
                AligoEventInterface event = this.oCurrentEvent;
                this.oStyleXmlElement = addAttributeEvent.getXmlElement();
                this.oWmlElement = WmlAmlElementUtils.getWmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.oStyleXmlElement);
                this.oCurrentEvent = event;
                this.oXmlAmlHandlerAttribute = xmlAmlHandlerAttribute;
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug("Cache view link posting high relevance");
                }
                currentWmlAmlRelevance = 20L;
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        return currentWmlAmlRelevance;
    }

    public void handleEvent() {
        block46: {
            if (this.oCurrentEvent instanceof WmlAmlInsufficientMemoryHandlerEvent) {
                AmlPathInterface workingPath = ((WmlAmlInsufficientMemoryHandlerEvent)this.oCurrentEvent).getAmlPath();
                boolean sane = false;
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug("InSufficient memory...");
                }
                try {
                    int numberCurrentPath;
                    int numberFormPath;
                    AmlPathInterface lastWorkingPath;
                    do {
                        AmlPathInterface parentPath;
                        block45: {
                            if (this.oHandlerLogger.debugEnabled()) {
                                this.oHandlerLogger.logDebug(" working path " + workingPath);
                            }
                            try {
                                AxmlElement amlElement;
                                if (workingPath != null && this.isTextElement(workingPath) && (parentPath = AmlPathUtils.getParentPath(this.oHandlerManager, workingPath)) != null && ((amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentPath)) instanceof AxmlTextArea || amlElement instanceof AxmlInput || amlElement instanceof AxmlCheckBox || amlElement instanceof AxmlOption || amlElement instanceof AxmlListItem)) {
                                    WmlAmlResetTextStateHandlerEvent resetTextStateEvent = new WmlAmlResetTextStateHandlerEvent(workingPath);
                                    this.oHandlerManager.postEventNow(resetTextStateEvent);
                                }
                            }
                            catch (HandlerError he) {
                                // empty catch block
                            }
                            try {
                                WmlAmlElementUtils.detachFromTree(this.oHandlerManager, workingPath);
                            }
                            catch (HandlerError he) {
                                this.oHandlerLogger.logError(he);
                                if (!this.oHandlerLogger.debugEnabled()) break block45;
                                this.oHandlerLogger.logDebug("Handler Error " + workingPath);
                            }
                        }
                        sane = WmlAmlElementUtils.isDeckSane(this.oHandlerManager);
                        if (sane && (parentPath = AmlPathUtils.getParentPath(this.oHandlerManager, workingPath)) != null && !WmlAmlMemoryUtils.isCacheable(this.oHandlerManager, parentPath)) {
                            sane = WmlAmlMemoryUtils.isCacheable(this.oHandlerManager, workingPath);
                            if (this.oHandlerLogger.debugEnabled()) {
                                this.oHandlerLogger.logDebug("Cache sanity: working path " + workingPath + " sanity " + sane);
                            }
                        }
                        lastWorkingPath = workingPath;
                        try {
                            workingPath = this.getPreviousPath(workingPath, -1);
                            if (workingPath == null) continue;
                            int currentNumberElements = workingPath.getNumberAmlPathComponents();
                            int lastNumberElements = lastWorkingPath.getNumberAmlPathComponents();
                            if (lastNumberElements == currentNumberElements) continue;
                            boolean detach = true;
                            if (this.isTextElement(lastWorkingPath)) {
                                WmlAmlShouldDetachTextMemoryHandlerEvent shouldDetachTextMemoryEvent = new WmlAmlShouldDetachTextMemoryHandlerEvent(lastWorkingPath);
                                this.oHandlerManager.postEventNow(shouldDetachTextMemoryEvent);
                                detach = shouldDetachTextMemoryEvent.isDetach();
                            }
                            if (this.oHandlerLogger.debugEnabled()) {
                                this.oHandlerLogger.logDebug("detach = " + detach);
                            }
                            if (!detach) continue;
                            sane = false;
                        }
                        catch (HandlerError he) {
                            sane = true;
                        }
                    } while (!sane && workingPath != null);
                    this.checkLinkForm(lastWorkingPath);
                    if (this.oHandlerLogger.debugEnabled()) {
                        this.oHandlerLogger.logDebug("Disable page more is..." + this.bDisablePageMore);
                    }
                    this.checkLinkPage();
                    boolean end = false;
                    AmlPathInterface formPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, lastWorkingPath, FORM);
                    if (formPath != null && (numberFormPath = formPath.getNumberAmlPathComponents()) < (numberCurrentPath = lastWorkingPath.getNumberAmlPathComponents())) {
                        AmlPathComponentInterface inputPathComponent = lastWorkingPath.getAmlPathComponentAt(numberFormPath);
                        int indexPos = inputPathComponent.getPathIndex();
                        if (this.oHandlerLogger.debugEnabled()) {
                            this.oHandlerLogger.logDebug("index : " + inputPathComponent.getPathIndex());
                        }
                        AmlPathInterface inputPath = AmlPathUtils.getChildPath(this.oHandlerManager, formPath, indexPos);
                        if (this.oHandlerLogger.debugEnabled()) {
                            this.oHandlerLogger.logDebug(inputPath);
                        }
                        AxmlElement axmlInput = AmlPathUtils.getAmlElement(this.oHandlerManager, inputPath);
                        if (this.oHandlerLogger.debugEnabled()) {
                            this.oHandlerLogger.logDebug("axml input " + axmlInput);
                        }
                        String axmlNameAttribute = axmlInput.getAxmlAttributeValue(NAME);
                        Hashtable formPathState = this.getFormPathState(formPath);
                        Hashtable inputs = (Hashtable)formPathState.get(INPUTS);
                        if (!(axmlInput instanceof AxmlChoice) && axmlNameAttribute != null) {
                            inputs.remove(axmlNameAttribute);
                        }
                    }
                    if (workingPath == null) {
                        end = true;
                    } else if (this.oLastWorkingPath != null) {
                        boolean insufficient = false;
                        try {
                            boolean ancestorPersistent = WmlAmlMemoryUtils.isAncestorPersistent(this.oHandlerManager, lastWorkingPath);
                            if (ancestorPersistent) {
                                insufficient = true;
                            }
                        }
                        catch (HandlerError he) {
                            // empty catch block
                        }
                        if (!this.isTextElement(lastWorkingPath)) {
                            String lastCanonicalPath = this.oLastWorkingPath.getCanonicalPath();
                            String currentLastCanonicalPath = lastWorkingPath.getCanonicalPath();
                            if (currentLastCanonicalPath.equals(lastCanonicalPath)) {
                                insufficient = true;
                            }
                        }
                        if (insufficient) {
                            if (this.oHandlerLogger.debugEnabled()) {
                                this.oHandlerLogger.logDebug("Page too big for device");
                            }
                            end = true;
                        }
                    }
                    if (this.oHandlerLogger.debugEnabled()) {
                        this.oHandlerLogger.logDebug("20040209 About to create New Page : Combine Elements " + lastWorkingPath + " != " + this.oCurrentPagePath);
                    }
                    if (this.oCurrentPagePath != null) {
                        this.combineTexts(this.oCurrentPagePath);
                    } else if (this.oHandlerLogger.debugEnabled()) {
                        this.oHandlerLogger.logDebug("20040209 Current page = null");
                    }
                    if (end) {
                        if (this.oHandlerLogger.debugEnabled()) {
                            this.oHandlerLogger.logDebug("Unable to fit page");
                        }
                        this.end();
                        break block46;
                    }
                    if (this.oHandlerLogger.debugEnabled()) {
                        this.oHandlerLogger.logDebug("Starting new realm...");
                    }
                    this.startNewRealm(lastWorkingPath);
                }
                catch (Exception ex) {
                    this.oHandlerLogger.logError(ex);
                    if (this.oHandlerLogger.debugEnabled()) {
                        this.oHandlerLogger.logDebug("Ending...");
                    }
                    this.end();
                }
            } else if (this.oCurrentEvent instanceof WmlAmlStartNewRealmMemoryHandlerEvent) {
                this.startNewRealm(((WmlAmlStartNewRealmMemoryHandlerEvent)this.oCurrentEvent).getAmlPath());
            } else if (this.oCurrentEvent instanceof WmlAmlAddAttributeHandletEvent) {
                this.oCacheViews.put(this.oCurrentAmlPath.toString(), this.oWmlElement);
                WmlAmlAddNextAttributeHandletEvent wmlAmlAddNextAttributeHandletEvent = new WmlAmlAddNextAttributeHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
                this.oHandlerManager.postEvent(wmlAmlAddNextAttributeHandletEvent);
            }
        }
    }

    public void handleEventNow() throws HandlerError {
        block25: {
            if (this.oCurrentEvent instanceof WmlAmlDetachFromTreeMemoryHandlerEvent) {
                this.detachFromTree(((WmlAmlDetachFromTreeMemoryHandlerEvent)this.oCurrentEvent).getAmlPath());
            } else if (this.oCurrentEvent instanceof WmlAmlSetCurrentPageHandlerEvent) {
                WmlAmlSetCurrentPageHandlerEvent setCurrentPageEvent = (WmlAmlSetCurrentPageHandlerEvent)this.oCurrentEvent;
                this.oCurrentPagePath = setCurrentPageEvent.getAmlPath();
                this.bPageSet = true;
            } else if (this.oCurrentEvent instanceof WmlAmlCombineTextHandlerEvent) {
                AmlPathInterface textPath = ((WmlAmlCombineTextHandlerEvent)this.oCurrentEvent).getAmlPath();
                this.combineTexts(textPath);
            } else if (this.oCurrentEvent instanceof WmlAmlCheckLinkPageHandlerEvent) {
                this.checkLinkPage();
            } else if (this.oCurrentEvent instanceof WmlAmlCheckLinkFormHandlerEvent) {
                AmlPathInterface formPath = ((WmlAmlCheckLinkFormHandlerEvent)this.oCurrentEvent).getAmlPath();
                this.checkLinkForm(formPath);
            } else if (this.oCurrentEvent instanceof WmlAmlIsCachedChoiceFormHandlerEvent) {
                WmlAmlIsCachedChoiceFormHandlerEvent isCachedChoiceFormEvent = (WmlAmlIsCachedChoiceFormHandlerEvent)this.oCurrentEvent;
                AmlPathInterface path = isCachedChoiceFormEvent.getAmlPath();
                boolean cached = this.isCachedChoiceForm(path);
                isCachedChoiceFormEvent.setCached(cached);
            } else if (this.oCurrentEvent instanceof WmlAmlSetFormElementEvent) {
                WmlAmlSetFormElementEvent wmlAmlSetFormElementEvent = (WmlAmlSetFormElementEvent)this.oCurrentEvent;
                AmlPathInterface formPath = wmlAmlSetFormElementEvent.getFormPath();
                AmlPathInterface elementPath = wmlAmlSetFormElementEvent.getElementPath();
                try {
                    WmlAmlGetTopWmlElementStateHandlerEvent getTopWmlElementStateEvent = new WmlAmlGetTopWmlElementStateHandlerEvent(elementPath);
                    this.oHandlerManager.postEventNow(getTopWmlElementStateEvent);
                    WmlElement wmlElement = getTopWmlElementStateEvent.getWmlElement();
                    if (wmlElement instanceof WmlContainer) {
                        wmlElement = this.getFirstChildWmlElement(wmlElement);
                    }
                    if (wmlElement != null) {
                        Hashtable formPathState = this.getFormPathState(formPath);
                        formPathState.put(LAST_ELEMENT, wmlElement);
                        formPathState.put(PATH_LAST_ELEMENT, formPath);
                    }
                }
                catch (Exception ex) {}
            } else if (this.oCurrentEvent instanceof WmlAmlSetFormInputNameEvent) {
                WmlAmlSetFormInputNameEvent wmlAmlSetFormInputNameEvent = (WmlAmlSetFormInputNameEvent)this.oCurrentEvent;
                try {
                    AmlPathInterface inputPath = wmlAmlSetFormInputNameEvent.getAmlPath();
                    AmlPathInterface formPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, inputPath, FORM);
                    Hashtable formPathState = this.getFormPathState(formPath);
                    Hashtable<String, String> inputs = (Hashtable<String, String>)formPathState.get(INPUTS);
                    if (inputs == null) {
                        inputs = new Hashtable<String, String>();
                        formPathState.put(INPUTS, inputs);
                    }
                    String inputName = wmlAmlSetFormInputNameEvent.getInputName();
                    String inputValue = wmlAmlSetFormInputNameEvent.getInputValue();
                    if (inputName == null || inputName.equals("")) break block25;
                    if (inputValue != null && !inputValue.equals("")) {
                        inputs.put(inputName, inputValue);
                        break block25;
                    }
                    inputs.put(inputName, inputName);
                }
                catch (Exception ex) {
                    this.oHandlerLogger.logError(ex);
                }
            } else if (this.oCurrentEvent instanceof WmlAmlGetLastWorkingPathHandlerEvent) {
                ((WmlAmlGetLastWorkingPathHandlerEvent)this.oCurrentEvent).setAmlPath(this.oLastWorkingPath);
            }
        }
    }

    private Hashtable getFormPathState(AmlPathInterface formPath) {
        Hashtable formPathState = (Hashtable)this.formState.get(formPath.toString());
        if (formPathState == null) {
            formPathState = new Hashtable();
            this.formState.put(formPath.toString(), formPathState);
            this.currentFormPaths.addElement(formPath);
        }
        return formPathState;
    }

    private void end() {
        WmlAmlEndRenderingHandlerEvent endRenderingEvent = new WmlAmlEndRenderingHandlerEvent();
        this.oHandlerManager.postEvent(endRenderingEvent);
    }

    private void startNewRealm(AmlPathInterface lastWorkingPath) {
        this.oLastWorkingPath = lastWorkingPath;
        ++this.iRealm;
        PageAllocatorInterface pageAllocator = WmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
        pageAllocator.allocatePage();
        AmlPath path = new AmlPath();
        path.setRealm(this.iRealm);
        if (this.oHandlerLogger.debugEnabled()) {
            this.oHandlerLogger.logDebug("New realm path..." + path.toString());
        }
        WmlAmlCreateElementHandlerEvent createElementEvent = new WmlAmlCreateElementHandlerEvent(path);
        this.oHandlerManager.postEvent(createElementEvent);
    }

    private boolean isTextElement(AmlPathInterface amlPath) {
        AxmlElement amlElement;
        boolean textElement = false;
        if (amlPath != null && (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath)) instanceof AxmlText) {
            textElement = true;
        }
        return textElement;
    }

    private AmlPathInterface getPreviousPath(AmlPathInterface currentAmlPath, int index) throws HandlerError {
        int previousChildIndex;
        AmlPathInterface previousPath = null;
        if (index == -1) {
            int currentChildIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
            WmlAmlGetPreviousChildIndexHandlerEvent getPreviousChildIndexEvent = new WmlAmlGetPreviousChildIndexHandlerEvent(currentAmlPath, currentChildIndex);
            this.oHandlerManager.postEventNow(getPreviousChildIndexEvent);
            previousChildIndex = getPreviousChildIndexEvent.getPreviousIndex();
        } else {
            previousChildIndex = index;
        }
        AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
        previousPath = previousChildIndex < 0 ? parentAmlPath : AmlPathUtils.getChildPath(this.oHandlerManager, parentAmlPath, previousChildIndex);
        return previousPath;
    }

    private void detachFromTree(AmlPathInterface currentAmlPath) throws HandlerError {
        WmlElement topElement = null;
        AmlPathInterface parentAmlPath = null;
        int originalIndex = 0;
        try {
            topElement = WmlAmlElementUtils.getTopWmlElement(this.oHandlerManager, currentAmlPath);
            if (topElement != null) {
                parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
                originalIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
                WmlAmlElementUtils.removeWmlElement(this.oHandlerManager, currentAmlPath, null, topElement);
            }
        }
        catch (HandlerError he) {
            Exception ex = he.getException();
            if (!(ex instanceof WmlElementNotFoundException) && !(ex instanceof WmlAmlInsufficientMemoryException)) {
                throw he;
            }
        }
        catch (Exception ex) {
            this.oHandlerLogger.logError(ex);
        }
        if (parentAmlPath != null) {
            WmlAmlRemoveCreatedIndexHandlerEvent removeCreatedIndexEvent = new WmlAmlRemoveCreatedIndexHandlerEvent(parentAmlPath, originalIndex);
            this.oHandlerManager.postEventNow(removeCreatedIndexEvent);
        }
    }

    private boolean isPersistentElement(AxmlElement amlElement) {
        boolean persistentElement = false;
        if (amlElement instanceof AxmlControlMenu) {
            persistentElement = true;
        } else {
            String value = amlElement.getAxmlAttributeValue(PERSIST);
            if (value != null && !value.equals(PERSIST_FALSE)) {
                persistentElement = true;
            }
        }
        return persistentElement;
    }

    private void checkLinkPage() {
        if (this.bPageSet) {
            this.linkPage();
            this.bPageSet = false;
        }
    }

    private boolean isValidLabel(String label) {
        boolean valid = true;
        if (label == null || label != null && label.equalsIgnoreCase("none")) {
            valid = false;
        }
        return valid;
    }

    private String getNextLabel(AmlPathInterface path) {
        String nextLabel = MORE;
        try {
            AxmlElement page = AmlPathUtils.getAmlElement(this.oHandlerManager, path);
            String tNextLabel = page.getAxmlAttributeValue("next_label");
            if (this.isValidLabel(tNextLabel)) {
                nextLabel = tNextLabel;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nextLabel;
    }

    private String getPrevLabel(AmlPathInterface path) {
        String prevLabel = BACK;
        try {
            AxmlElement page = AmlPathUtils.getAmlElement(this.oHandlerManager, path);
            String tPrevLabel = page.getAxmlAttributeValue("prev_label");
            if (this.isValidLabel(tPrevLabel)) {
                prevLabel = tPrevLabel;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return prevLabel;
    }

    private void checkThrow(HandlerError he) throws HandlerError {
        Exception ex = he.getException();
        if (!(ex instanceof WmlAmlInsufficientMemoryException)) {
            throw he;
        }
    }

    private boolean addCacheLinkLabel(String label, String url, AmlPathInterface pagePath) throws Exception {
        boolean added = false;
        WmlElement wmlElement = (WmlElement)this.oCacheViews.get(pagePath.toString());
        if (wmlElement != null) {
            WmlA wmlA = new WmlA();
            wmlA.addWmlAttribute("href", url);
            WmlPCData wmlPCData = new WmlPCData();
            wmlPCData.addWmlAttribute(TEXT, label);
            wmlA.addWmlElement(wmlPCData);
            WmlElement wmlAddElement = wmlElement;
            boolean nop = false;
            if (!(wmlElement instanceof WmlP)) {
                wmlAddElement = new WmlP();
                nop = true;
            }
            try {
                WmlAmlElementUtils.addWmlElement(this.oHandlerManager, pagePath, wmlAddElement, wmlA);
            }
            catch (HandlerError he) {
                this.checkThrow(he);
            }
            if (nop) {
                try {
                    WmlAmlElementUtils.addWmlElement(this.oHandlerManager, pagePath, wmlElement, wmlAddElement);
                }
                catch (HandlerError he) {
                    this.checkThrow(he);
                }
                this.oCacheViews.put(pagePath.toString(), wmlAddElement);
            }
            added = true;
        }
        return added;
    }

    private void addCacheMenuLabel(String label, String url, AmlPathInterface pagePath) throws Exception {
        WmlDo wmlDo = new WmlDo();
        wmlDo.addWmlAttribute(TYPE, OPTIONS);
        String nameLabel = label.replace(' ', '_');
        wmlDo.addWmlAttribute(NAME, nameLabel);
        wmlDo.addWmlAttribute(LABEL, label);
        WmlGo wmlGo = new WmlGo();
        wmlGo.addWmlAttribute(SENDREFERER, TRUE);
        wmlGo.addWmlAttribute("href", url);
        wmlDo.addWmlElement(wmlGo);
        WmlAmlAddControlMenuElementHandlerEvent addControlMenuElementEvent = new WmlAmlAddControlMenuElementHandlerEvent(pagePath, wmlDo);
        this.oHandlerManager.postEventNow(addControlMenuElementEvent);
    }

    private void addCacheLabel(String label, String url, AmlPathInterface pagePath, AxmlElement pageElement) {
        boolean added = false;
        String view = pageElement.getAxmlAttributeValue("cache_view");
        if (view != null && view.equals("link")) {
            try {
                added = this.addCacheLinkLabel(label, url, pagePath);
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        if (!added) {
            try {
                this.addCacheMenuLabel(label, url, pagePath);
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
    }

    private void linkPage() {
        try {
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentPagePath);
            if (amlElement instanceof AxmlPage) {
                if (this.oLastPagePath != null) {
                    String prevLabel;
                    AxmlElement amlPage = amlElement;
                    AxmlElement lastPage = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oLastPagePath);
                    PageAllocatorInterface pageAllocator = WmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
                    String prevURL = pageAllocator.getPreviousPageURL();
                    String currURL = pageAllocator.getCurrentPageURL();
                    if (!this.bDisablePageBack && this.isValidLabel(prevLabel = amlPage.getAxmlAttributeValue("prev_label"))) {
                        this.addCacheLabel(prevLabel, prevURL, this.oCurrentPagePath, amlPage);
                    }
                    if (!this.bDisablePageMore) {
                        String nextLabel = this.getNextLabel(this.oLastPagePath);
                        this.addCacheLabel(nextLabel, currURL, this.oLastPagePath, lastPage);
                    } else if (this.oHandlerLogger.debugEnabled()) {
                        this.oHandlerLogger.logDebug("Page more is disabled ####### ");
                    }
                }
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug("+++++oLastPagePath = " + this.oLastPagePath);
                }
                this.oLastPagePath = this.oCurrentPagePath;
            }
        }
        catch (Exception ex) {
            this.oHandlerLogger.logError(ex);
        }
    }

    private boolean isCachedChoiceForm(AmlPathInterface amlPath) {
        boolean cached = false;
        if (amlPath != null && this.oLastWorkingPath != null) {
            try {
                AmlPathInterface lastChoiceFormPath;
                AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oLastWorkingPath);
                if (!(amlElement instanceof AxmlChoice) && (lastChoiceFormPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, this.oLastWorkingPath, CHOICE)) != null && amlPath.getCanonicalPath().equals(lastChoiceFormPath.getCanonicalPath())) {
                    cached = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cached;
    }

    private void checkLinkForm(AmlPathInterface currentAmlPath) {
        this.bDisablePageBack = false;
        this.bDisablePageMore = false;
        int formNumber = this.iFormNumber;
        try {
            String methodType = "";
            int numberPaths = this.currentFormPaths.size();
            int i = 0;
            while (i < numberPaths) {
                String formUrl;
                AmlPathInterface currentFormPath = (AmlPathInterface)this.currentFormPaths.elementAt(i);
                if (currentFormPath != null && (formUrl = this.getFormStateURL(currentFormPath)) != null) {
                    this.setFormURL(currentFormPath, formUrl, formNumber, true);
                }
                ++i;
            }
            this.currentFormPaths.clear();
            PageAllocatorInterface pageAllocator = WmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
            WmlAmlGetFormRedirectionInfoHandlerEvent getFormRedirectionInfoEvent = new WmlAmlGetFormRedirectionInfoHandlerEvent();
            this.oHandlerManager.postEventNow(getFormRedirectionInfoEvent);
            FormRedirectionInfo formRedirectionInfo = getFormRedirectionInfoEvent.getInfo();
            AmlPathInterface currentFormPath = null;
            if (currentAmlPath != null) {
                currentFormPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, currentAmlPath, FORM);
            }
            if (this.bClosingChoiceFormCall && this.oLastFormPath != null) {
                this.oLastFormPath = AmlPathUtils.getNextRealmPath(this.oHandlerManager, this.oLastFormPath);
            }
            boolean lastFormPathSet = false;
            if (this.oHandlerLogger.debugEnabled()) {
                this.oHandlerLogger.logDebug("*****oLastFormPath = " + this.oLastFormPath + " currentAmlPath = " + currentAmlPath);
            }
            if (this.oLastFormPath != null) {
                String sCurrURL;
                String currURL;
                boolean isLastChoiceFormPresent;
                AmlPathInterface lastChoiceFormPath;
                block66: {
                    this.bDisablePageMore = true;
                    lastChoiceFormPath = null;
                    if (this.oLastWorkingPath != null) {
                        try {
                            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oLastWorkingPath);
                            if (!(amlElement instanceof AxmlChoice)) {
                                lastChoiceFormPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, this.oLastWorkingPath, CHOICE);
                                if (this.bClosingChoiceFormCall) {
                                    lastChoiceFormPath = AmlPathUtils.getNextRealmPath(this.oHandlerManager, lastChoiceFormPath);
                                }
                            }
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (this.oHandlerLogger.debugEnabled()) {
                        this.oHandlerLogger.logDebug("lastChoiceFormPath = " + lastChoiceFormPath);
                    }
                    isLastChoiceFormPresent = false;
                    String choiceName = null;
                    String choiceSelectLabel = null;
                    String choiceForwardValue = null;
                    String choiceBackwardValue = null;
                    boolean isSecondLastChoiceFormPresent = false;
                    if (lastChoiceFormPath != null) {
                        isLastChoiceFormPresent = true;
                        try {
                            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, lastChoiceFormPath);
                            choiceName = amlElement.getAxmlAttributeValue(NAME);
                            choiceSelectLabel = amlElement.getAxmlAttributeValue("wml_select_label");
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (isLastChoiceFormPresent && this.oSecondLastChoiceFormURL != null) {
                        isSecondLastChoiceFormPresent = true;
                    }
                    if (isLastChoiceFormPresent) {
                        WmlElement choiceElement;
                        WmlPCData wmlPCData;
                        WmlOption wmlOption;
                        this.bDisablePageBack = true;
                        this.bDisablePageMore = true;
                        if (isSecondLastChoiceFormPresent) {
                            try {
                                wmlOption = new WmlOption();
                                wmlPCData = new WmlPCData();
                                choiceBackwardValue = this.getPrevLabel(this.oLastPagePath);
                                wmlPCData.addWmlAttribute(TEXT, choiceBackwardValue);
                                wmlOption.addWmlAttribute("value", choiceBackwardValue);
                                if (choiceSelectLabel != null) {
                                    wmlOption.addWmlAttribute("title", choiceSelectLabel);
                                }
                                wmlOption.addWmlElement(wmlPCData);
                                choiceElement = WmlAmlElementUtils.getChildContainerWmlElement(this.oHandlerManager, lastChoiceFormPath);
                                try {
                                    WmlAmlElementUtils.addWmlElement(this.oHandlerManager, lastChoiceFormPath, choiceElement, wmlOption, 0);
                                }
                                catch (HandlerError he) {
                                }
                            }
                            catch (Exception ex) {}
                        } else {
                            this.bDisablePageBack = false;
                        }
                        if (!this.bClosingChoiceFormCall) {
                            try {
                                wmlOption = new WmlOption();
                                wmlPCData = new WmlPCData();
                                choiceForwardValue = this.getNextLabel(this.oLastPagePath);
                                wmlPCData.addWmlAttribute(TEXT, choiceForwardValue);
                                wmlOption.addWmlAttribute("value", choiceForwardValue);
                                if (choiceSelectLabel != null) {
                                    wmlOption.addWmlAttribute("title", choiceSelectLabel);
                                }
                                wmlOption.addWmlElement(wmlPCData);
                                choiceElement = WmlAmlElementUtils.getChildContainerWmlElement(this.oHandlerManager, lastChoiceFormPath);
                                try {
                                    WmlAmlElementUtils.addWmlElement(this.oHandlerManager, lastChoiceFormPath, choiceElement, wmlOption);
                                }
                                catch (HandlerError he) {}
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                    }
                    currURL = null;
                    if (!this.bClosingChoiceFormCall) {
                        currURL = pageAllocator.getCurrentPageURL();
                    } else if (this.isDiffCanonicalPaths(currentFormPath, this.oLastFormPath)) {
                        currURL = this.getFormCanonicalURL(this.oLastFormPath);
                        ++this.iFormNumber;
                    } else {
                        currURL = pageAllocator.getNextPageURL();
                    }
                    sCurrURL = null;
                    if (isLastChoiceFormPresent) {
                        String modifier;
                        WmlAmlGetDynamicURLHandlerEvent getDynamicURLEvent = new WmlAmlGetDynamicURLHandlerEvent();
                        this.oHandlerManager.postEventNow(getDynamicURLEvent);
                        String dynamicURL = getDynamicURLEvent.getURL();
                        String dCurrURL = null;
                        String id = null;
                        if (!this.bClosingChoiceFormCall) {
                            WmlAmlGetPreviousPageIDHandlerEvent getPreviousPageIDEvent = new WmlAmlGetPreviousPageIDHandlerEvent();
                            this.oHandlerManager.postEventNow(getPreviousPageIDEvent);
                            id = getPreviousPageIDEvent.getID();
                        } else {
                            WmlAmlGetCurrentPageIDHandlerEvent getCurrentPageIDEvent = new WmlAmlGetCurrentPageIDHandlerEvent();
                            this.oHandlerManager.postEventNow(getCurrentPageIDEvent);
                            id = getCurrentPageIDEvent.getID();
                        }
                        dCurrURL = dynamicURL + id;
                        if (this.oHandlerLogger.debugEnabled()) {
                            this.oHandlerLogger.logDebug("******* dynamic url = " + dCurrURL);
                        }
                        FormRedirector formRedirector = new FormRedirector();
                        formRedirector.setDynamicURL(dCurrURL);
                        if (isSecondLastChoiceFormPresent) {
                            modifier = choiceName + EQUALS + choiceBackwardValue;
                            formRedirector.addModifier(modifier, this.oSecondLastChoiceFormURL);
                        }
                        if (!this.bClosingChoiceFormCall) {
                            modifier = choiceName + EQUALS + choiceForwardValue;
                            formRedirector.addModifier(modifier, currURL);
                        }
                        this.oLastFormRedirectors.addElement(formRedirector);
                        sCurrURL = currURL;
                        currURL = dCurrURL;
                    }
                    this.setFormURL(this.oLastFormPath, currURL, formNumber);
                    XmlElementInterface topStyleElement = WmlAmlElementUtils.getTopStyleElement(this.oHandlerManager, this.oLastFormPath);
                    XmlElementInterface formElementInterface = WmlAmlElementUtils.getFirstMatchingChild(this.oHandlerManager, topStyleElement, FORM_DO);
                    AxmlElement formElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oLastFormPath);
                    WmlElement wmlElement = WmlAmlElementUtils.getWmlElement(this.oHandlerManager, this.oLastFormPath, formElementInterface);
                    if (!this.bClosingChoiceFormCall) {
                        try {
                            WmlAmlAddXmlWmlAttributeHandletEvent addXmlWmlAttributeEvent;
                            String doLabel;
                            block67: {
                                String submitLabel = formElement.getAxmlAttributeValue("submit_label");
                                if (submitLabel == null || submitLabel.equals("")) {
                                    submitLabel = "submit";
                                }
                                if (!(wmlElement instanceof WmlDo)) break block66;
                                String label = wmlElement.getWmlAttributeValue(LABEL);
                                if (this.oHandlerLogger.debugEnabled()) {
                                    this.oHandlerLogger.logDebug("$$$$$$ label = " + label);
                                }
                                if (label == null || !label.equals(submitLabel)) break block66;
                                doLabel = this.getNextLabel(this.oLastPagePath);
                                if (this.oHandlerLogger.debugEnabled()) {
                                    this.oHandlerLogger.logDebug("$$$$$$ Setting label .... current path " + currentFormPath + " last path " + this.oLastFormPath + " label = " + doLabel);
                                }
                                String nameLabel = doLabel.replace(' ', '_');
                                try {
                                    addXmlWmlAttributeEvent = new WmlAmlAddXmlWmlAttributeHandletEvent(this.oLastFormPath, wmlElement, NAME, nameLabel);
                                    this.oHandlerManager.postEventNow(addXmlWmlAttributeEvent);
                                }
                                catch (HandlerError he) {
                                    if (!this.oHandlerLogger.debugEnabled()) break block67;
                                    this.oHandlerLogger.logDebug("Ignore error..");
                                }
                            }
                            try {
                                addXmlWmlAttributeEvent = new WmlAmlAddXmlWmlAttributeHandletEvent(this.oLastFormPath, wmlElement, LABEL, doLabel);
                                this.oHandlerManager.postEventNow(addXmlWmlAttributeEvent);
                            }
                            catch (HandlerError he) {
                                if (this.oHandlerLogger.debugEnabled()) {
                                    this.oHandlerLogger.logDebug("Ignore error..");
                                }
                            }
                        }
                        catch (Exception ex) {
                            this.oHandlerLogger.logError(ex);
                        }
                    }
                }
                if (isLastChoiceFormPresent) {
                    this.oSecondLastChoiceFormURL = pageAllocator.getPreviousPageURL();
                    currURL = sCurrURL;
                }
                if (isLastChoiceFormPresent) {
                    boolean closeRedirection;
                    AmlPathInterface currentChoiceFormPath = null;
                    if (currentAmlPath != null) {
                        currentChoiceFormPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, currentAmlPath, CHOICE);
                    }
                    if (closeRedirection = this.isDiffCanonicalPaths(currentChoiceFormPath, lastChoiceFormPath)) {
                        if (!this.bClosingChoiceFormCall) {
                            this.bClosingChoiceFormCall = true;
                            this.checkLinkForm(currentAmlPath);
                            this.oLastFormPath = null;
                            lastFormPathSet = true;
                            this.bClosingChoiceFormCall = false;
                        }
                        if (this.bClosingChoiceFormCall) {
                            int numberElements = this.oLastFormRedirectors.size();
                            int i2 = 0;
                            while (i2 < numberElements) {
                                FormRedirector formRedirector = (FormRedirector)this.oLastFormRedirectors.elementAt(i2);
                                formRedirector.setOriginalURL(currURL);
                                formRedirectionInfo.addFormRedirector(formRedirector);
                                if (this.oHandlerLogger.debugEnabled()) {
                                    this.oHandlerLogger.logDebug("formRedirector = " + formRedirector.toString());
                                }
                                ++i2;
                            }
                            this.oLastFormRedirectors.clear();
                            this.oSecondLastChoiceFormURL = null;
                        }
                    }
                }
            }
            if (!this.bClosingChoiceFormCall && this.isDiffCanonicalPaths(currentFormPath, this.oLastFormProcessedPath)) {
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug("*******closing current form");
                }
                AmlPathInterface destPath = AmlPathUtils.getNextRealmPath(this.oHandlerManager, this.oLastFormProcessedPath);
                String destURL = this.getFormCanonicalURL(destPath);
                WmlAmlGetDynamicURLHandlerEvent getDynamicURLEvent = new WmlAmlGetDynamicURLHandlerEvent();
                this.oHandlerManager.postEventNow(getDynamicURLEvent);
                String dynamicURL = getDynamicURLEvent.getURL();
                WmlAmlGetCurrentPageIDHandlerEvent getCurrentPageIDEvent = new WmlAmlGetCurrentPageIDHandlerEvent();
                this.oHandlerManager.postEventNow(getCurrentPageIDEvent);
                String id = getCurrentPageIDEvent.getID();
                String dDestURL = dynamicURL + id + SUBMIT_IDENTIFIER;
                FormRedirector formRedirector = new FormRedirector();
                formRedirector.setDynamicURL(dDestURL);
                formRedirector.setOriginalURL(destURL);
                formRedirectionInfo.addFormRedirector(formRedirector);
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug("formRedirector = " + formRedirector.toString());
                }
                this.setFormURL(destPath, dDestURL, formNumber);
                ++this.iFormNumber;
            }
            if (!lastFormPathSet) {
                this.oLastFormPath = currentFormPath;
            }
            this.oLastFormProcessedPath = currentFormPath;
        }
        catch (Exception ex) {
            this.oHandlerLogger.logError(ex);
        }
    }

    private String getFormStateURL(AmlPathInterface formPath) throws HandlerError {
        String formStateUrl = null;
        Hashtable formPathState = (Hashtable)this.formState.get(formPath.toString());
        String formStateURL = (String)formPathState.get(URL);
        if (this.emptyURL(formStateURL)) {
            try {
                AxmlElement formElement = AmlPathUtils.getAmlElement(this.oHandlerManager, formPath);
                formStateUrl = ((AxmlForm)formElement).getAxmlAttributeValue(URL);
                formStateUrl = TextUtils.transformAttr("href", formStateUrl);
            }
            catch (Exception ex) {
                this.conditionalError(ex);
            }
        }
        if (formStateUrl == null) {
            formStateUrl = "";
        }
        return formStateUrl;
    }

    private boolean emptyURL(String url) {
        boolean empty = false;
        if (url == null || url != null && url.equals("")) {
            empty = true;
        }
        return empty;
    }

    private String createParamURL(Hashtable inputs, AxmlForm axmlForm) {
        StringBuffer paramUrl = new StringBuffer();
        boolean first = true;
        if (inputs != null) {
            Enumeration keys = inputs.keys();
            while (keys.hasMoreElements()) {
                String inputName = (String)keys.nextElement();
                String inputValue = (String)inputs.get(inputName);
                if (inputName == null) continue;
                if (inputName.equals(inputValue)) {
                    StringBuffer tmpSB = new StringBuffer("$");
                    tmpSB.append(LEFT_PAREN);
                    String value = inputName;
                    try {
                        value = this.fixValue(inputName);
                    }
                    catch (HandlerError he) {
                        this.oHandlerLogger.logError(he);
                    }
                    tmpSB.append(value);
                    tmpSB.append(RIGHT_PAREN);
                    inputValue = tmpSB.toString();
                }
                if (first) {
                    first = false;
                } else {
                    paramUrl.append(AMPERSAND);
                }
                paramUrl.append(inputName);
                paramUrl.append(EQUALS);
                paramUrl.append(inputValue);
            }
            return paramUrl.toString();
        }
        return null;
    }

    private void addFormPostElement(AmlPathInterface formPath, WmlElement postWmlElement) throws HandlerError {
        XmlElementInterface formElement = this.getFormXmlElement(formPath);
        WmlElement wmlElement = this.getFormElement(formPath);
        try {
            WmlAmlElementUtils.addWmlElement(this.oHandlerManager, formPath, wmlElement, postWmlElement);
        }
        catch (HandlerError he) {
            // empty catch block
        }
    }

    private void setFormNativeURL(AmlPathInterface formPath, String formURL) throws HandlerError {
        XmlElementInterface formElement = this.getFormXmlElement(formPath);
        WmlElement wmlElement = this.getFormElement(formPath);
        try {
            WmlAmlElementUtils.addWmlAttribute(this.oHandlerManager, formPath, wmlElement, "href", formURL);
        }
        catch (HandlerError he) {
            // empty catch block
        }
    }

    private void setFormURL(AmlPathInterface formPath, String formURL, int formNumber) throws HandlerError {
        this.setFormURL(formPath, formURL, formNumber, false);
    }

    private void setFormURL(AmlPathInterface formPath, String formURL, int formNumber, boolean boot) throws HandlerError {
        if (this.oHandlerLogger.debugEnabled()) {
            this.oHandlerLogger.logDebug("Setting form url... path = " + formPath + " url = " + formURL + " boot = " + boot);
        }
        try {
            AxmlElement formAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, formPath);
            if (formAmlElement instanceof AxmlForm) {
                String methodType = formAmlElement.getAxmlAttributeValue("method");
                if (methodType.equals("get")) {
                    formURL = this.composeURL(formURL, formPath);
                } else if (methodType.equals("post") && boot) {
                    this.setFormInputsURL(formPath);
                }
                if (!boot) {
                    String numURL = "agf=" + formNumber;
                    formURL = this.composeURL(formURL, numURL);
                }
                this.setFormNativeURL(formPath, formURL);
            }
        }
        catch (Exception ex) {
            this.conditionalError(ex);
        }
    }

    private String composeURL(String currURL, AmlPathInterface amlPath) {
        String paramURL = this.getFormParamsURL(amlPath);
        return this.composeURL(currURL, paramURL);
    }

    private String getFormParamsURL(AmlPathInterface formPath) {
        String paramURL = null;
        try {
            AxmlElement formElement = AmlPathUtils.getAmlElement(this.oHandlerManager, formPath);
            Hashtable formPathState = (Hashtable)this.formState.get(formPath.toString());
            Hashtable inputs = (Hashtable)formPathState.get(INPUTS);
            if (formElement instanceof AxmlForm) {
                paramURL = this.createParamURL(inputs, (AxmlForm)formElement);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return paramURL;
    }

    private String composeURL(String currURL, String paramURL) {
        if (paramURL != null) {
            currURL = currURL.indexOf("?") == -1 ? currURL + "?" : currURL + AMPERSAND;
            currURL = currURL + paramURL;
        }
        return currURL;
    }

    private void setFormInputsURL(AmlPathInterface formPath) {
        block6: {
            try {
                AxmlElement formElement = AmlPathUtils.getAmlElement(this.oHandlerManager, formPath);
                Hashtable formPathState = (Hashtable)this.formState.get(formPath.toString());
                Hashtable inputs = (Hashtable)formPathState.get(INPUTS);
                if (!(formElement instanceof AxmlForm)) break block6;
                Enumeration keys = inputs.keys();
                while (keys.hasMoreElements()) {
                    WmlPostfield wmlPostfield = new WmlPostfield();
                    String inputName = (String)keys.nextElement();
                    String inputValue = (String)inputs.get(inputName);
                    if (inputName == null) continue;
                    if (inputName.equals(inputValue)) {
                        StringBuffer tmpSB = new StringBuffer("$");
                        tmpSB.append(LEFT_PAREN);
                        String value = inputName;
                        try {
                            value = this.fixValue(inputName);
                        }
                        catch (HandlerError he) {
                            this.oHandlerLogger.logError(he);
                        }
                        tmpSB.append(value);
                        tmpSB.append(RIGHT_PAREN);
                        inputValue = tmpSB.toString();
                    }
                    wmlPostfield.addWmlAttribute(NAME, inputName);
                    wmlPostfield.addWmlAttribute("value", inputValue);
                    this.addFormPostElement(formPath, wmlPostfield);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String fixValue(String value) throws HandlerError {
        WmlAmlFixInputValueHandletEvent fixInputValueEvent = new WmlAmlFixInputValueHandletEvent(value);
        this.oHandlerManager.postEventNow(fixInputValueEvent);
        return fixInputValueEvent.getNewValue();
    }

    private String getFormURL(AmlPathInterface formPath) throws HandlerError {
        WmlElement wmlElement = this.getFormElement(formPath);
        String URL2 = wmlElement.getWmlAttributeValue("href");
        return URL2;
    }

    private String getFormCanonicalURL(AmlPathInterface formPath) throws HandlerError {
        String formUrl = "";
        try {
            AxmlElement formElement = AmlPathUtils.getAmlElement(this.oHandlerManager, formPath);
            Hashtable formPathState = (Hashtable)this.formState.get(formPath.toString());
            Hashtable inputs = (Hashtable)formPathState.get(INPUTS);
            if (formElement instanceof AxmlForm) {
                String methodType = formElement.getAxmlAttributeValue("method");
                String urlStr = (String)formPathState.get(URL);
                formUrl = urlStr != null && !urlStr.equals("") ? urlStr : ((AxmlForm)formElement).getAxmlAttributeValue(URL);
            }
        }
        catch (Exception ex) {
            this.oHandlerLogger.logError(ex);
        }
        return formUrl;
    }

    private WmlElement getFormElement(AmlPathInterface formPath) throws HandlerError {
        XmlElementInterface formElement = this.getFormXmlElement(formPath);
        WmlElement wmlElement = WmlAmlElementUtils.getWmlElement(this.oHandlerManager, formPath, formElement);
        return wmlElement;
    }

    private XmlElementInterface getFormXmlElement(AmlPathInterface formPath) throws HandlerError {
        XmlElementInterface topStyleElement = WmlAmlElementUtils.getTopStyleElement(this.oHandlerManager, formPath);
        XmlElementInterface formElement = WmlAmlElementUtils.getFirstMatchingChild(this.oHandlerManager, topStyleElement, FORM_NAME);
        return formElement;
    }

    private WmlElement getFirstChildWmlElement(WmlElement parent) {
        WmlElement element = null;
        if (parent.getNumberElements() > 0) {
            try {
                element = parent.wmlElementAt(0);
                if (element instanceof WmlContainer) {
                    element = this.getFirstChildWmlElement(element);
                }
            }
            catch (WmlElementIndexOutOfBoundsException wmlElementIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return element;
    }

    private void combineTexts(AmlPathInterface currentPath) {
        try {
            AxmlElement currentAxmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentPath);
            if (this.oHandlerLogger.debugEnabled()) {
                this.oHandlerLogger.logDebug("20040213 CombineText(" + currentPath + ") ");
            }
            WmlAmlGetCreatedIndicesHandlerEvent WmlAmlGetCreatedIndicesHandlerEvent2 = new WmlAmlGetCreatedIndicesHandlerEvent(currentPath);
            this.oHandlerManager.postEventNow(WmlAmlGetCreatedIndicesHandlerEvent2);
            Vector elementsVector = WmlAmlGetCreatedIndicesHandlerEvent2.getIndices();
            Object[] sortedVector = elementsVector.toArray();
            Arrays.sort(sortedVector);
            int size = sortedVector.length;
            Vector brContainer = new Vector();
            AmlPathInterface previousAmlPath = null;
            WmlElement previousCombineParent = null;
            WmlElement previousTopElement = null;
            int i = 0;
            while (i < size) {
                int elementIndex = (Integer)sortedVector[i];
                AmlPathInterface amlPath = AmlPathUtils.getChildPath(this.oHandlerManager, currentPath, elementIndex);
                AxmlElement axmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath);
                WmlElement currentTopElement = WmlAmlElementUtils.getTopWmlElement(this.oHandlerManager, amlPath);
                WmlElement currentElement = currentTopElement.wmlElementAt(0);
                if (currentElement instanceof WmlP) {
                    if (this.areElementsSimilar(previousCombineParent, currentElement)) {
                        try {
                            if (this.oHandlerLogger.debugEnabled()) {
                                this.oHandlerLogger.logDebug("20040210 Attempting to combine");
                                this.oHandlerLogger.logDebug("20040210 currentElement: " + currentElement);
                                this.oHandlerLogger.logDebug("20040210 previousCombineParent: " + previousCombineParent);
                                this.oHandlerLogger.logDebug("20040210 previousAmlPath: " + previousAmlPath);
                                this.oHandlerLogger.logDebug("20040210 amlPath: " + amlPath);
                                this.oHandlerLogger.logDebug("20040210 previousTopElement: " + previousTopElement);
                                this.oHandlerLogger.logDebug("20040210 currentTopElement: " + currentTopElement);
                                this.oHandlerLogger.logDebug("20040210 brContainer: " + brContainer.size());
                            }
                            this.combineElements(previousAmlPath, previousTopElement, previousCombineParent, amlPath, currentTopElement, currentElement, brContainer);
                        }
                        catch (HandlerError he) {
                            this.oHandlerLogger.logDebug("20040210 Combining failed..." + he.toString());
                            this.oHandlerLogger.logError(he);
                        }
                    } else {
                        previousAmlPath = amlPath;
                        previousTopElement = currentTopElement;
                        previousCombineParent = currentElement;
                    }
                } else {
                    previousAmlPath = null;
                    previousTopElement = null;
                    previousCombineParent = null;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean areElementsSimilar(WmlElement wmlElementa, WmlElement wmlElementb) {
        boolean similar = false;
        if (wmlElementa != null && wmlElementb != null) {
            similar = wmlElementa.getHead().equals(wmlElementb.getHead());
        }
        return similar;
    }

    private void removeFirstBr(Vector brContainer) throws HandlerError {
        try {
            if (brContainer != null && brContainer.size() > 0) {
                AmlPathInterface amlPath = (AmlPathInterface)brContainer.elementAt(0);
                WmlElement currentTopElement = WmlAmlElementUtils.getTopWmlElement(this.oHandlerManager, amlPath);
                WmlElement currentElementP = currentTopElement.wmlElementAt(0);
                WmlAmlElementUtils.removeWmlElement(this.oHandlerManager, amlPath, currentTopElement, currentElementP);
            }
        }
        catch (Exception ex) {
            this.conditionalError(ex);
        }
    }

    private void combineElements(AmlPathInterface previousAmlPath, WmlElement previousTopElement, WmlElement previousCombineElement, AmlPathInterface currentAmlPath, WmlElement currentTopElement, WmlElement currentElement, Vector brContainer) throws HandlerError {
        try {
            int numberElements = currentElement.getNumberElements();
            try {
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug("20040210 NON <BR> removing " + currentElement + " from " + currentTopElement + " : " + currentTopElement.getContents());
                }
                WmlAmlElementUtils.removeWmlElement(this.oHandlerManager, currentAmlPath, currentTopElement, currentElement);
            }
            catch (HandlerError he) {
                this.checkThrow(he);
            }
            WmlContainer wmlContainer = new WmlContainer();
            int i = 0;
            while (i < numberElements) {
                WmlElement wmlElement = currentElement.wmlElementAt(i);
                wmlContainer.addWmlElement(wmlElement);
                ++i;
            }
            try {
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug("20040210 NON <BR> addingng " + wmlContainer.getContents() + " to " + previousCombineElement + previousCombineElement.getContents());
                }
                WmlAmlElementUtils.addWmlElement(this.oHandlerManager, previousAmlPath, previousCombineElement, wmlContainer);
            }
            catch (HandlerError he) {
                this.checkThrow(he);
            }
            WmlAmlSetTopWmlElementStateHandlerEvent setTopWmlElementStateEvent = new WmlAmlSetTopWmlElementStateHandlerEvent(currentAmlPath, previousTopElement);
            this.oHandlerManager.postEventNow(setTopWmlElementStateEvent);
        }
        catch (Exception ex) {
            this.conditionalError(ex);
        }
    }

    private void conditionalError(Exception ex) throws HandlerError {
        if (ex instanceof HandlerError) {
            throw (HandlerError)ex;
        }
        throw new WmlAmlHandlerError(ex);
    }

    private boolean isDiffCanonicalPaths(AmlPathInterface currPath, AmlPathInterface prevPath) {
        boolean different = false;
        if (prevPath != null) {
            if (currPath == null) {
                different = true;
            } else if (!currPath.getCanonicalPath().equals(prevPath.getCanonicalPath())) {
                different = true;
            }
        }
        return different;
    }
}

