/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.util.ihtml;

import com.aligo.ihtml.exceptions.IHtmlElementNotFoundException;
import com.aligo.ihtml.interfaces.IHtmlElement;
import com.aligo.modules.Path;
import com.aligo.modules.PathComponent;
import com.aligo.modules.exceptions.PathIndexOutOfBoundsException;
import com.aligo.modules.exceptions.PathInvalidException;
import com.aligo.modules.exceptions.PathNotFoundException;
import com.aligo.modules.interfaces.PathComponentInterface;
import com.aligo.modules.interfaces.PathInterface;

public class IHtmlTreeUtils {
    public static IHtmlElement getIHtmlElement(IHtmlElement ihtmlElement, PathInterface path) throws PathInvalidException {
        IHtmlElement currentElement = ihtmlElement;
        try {
            while (path.hasMoreComponents()) {
                PathComponentInterface component = path.getFirstPathComponent();
                int index = component.getPathIndex();
                currentElement = index < 0 ? currentElement.getIHtmlParentElement() : currentElement.ihtmlElementAt(index);
                path = path.getNextPath();
            }
        }
        catch (Exception ex) {
            throw new PathInvalidException(ex.toString());
        }
        return currentElement;
    }

    public static PathInterface getIHtmlPath(IHtmlElement topElement, IHtmlElement ihtmlElement) throws PathNotFoundException {
        Path path = new Path();
        boolean foundPath = false;
        boolean done = false;
        while (!done) {
            IHtmlElement ihtmlParentElement = ihtmlElement.getIHtmlParentElement();
            if (ihtmlParentElement != null) {
                int ihtmlIndex = 0;
                try {
                    ihtmlIndex = ihtmlParentElement.ihtmlElementIndex(ihtmlElement);
                }
                catch (IHtmlElementNotFoundException we) {
                    // empty catch block
                }
                PathComponent pathComponent = new PathComponent(ihtmlIndex);
                try {
                    path.addPathComponentAt(pathComponent, 0);
                }
                catch (PathIndexOutOfBoundsException pe) {
                    // empty catch block
                }
                if (ihtmlParentElement.equals(topElement)) {
                    foundPath = true;
                    done = true;
                }
                ihtmlElement = ihtmlParentElement;
                continue;
            }
            done = true;
        }
        if (foundPath) {
            return path;
        }
        throw new PathNotFoundException();
    }
}

