/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.util.hdml;

import com.aligo.hdml.exceptions.HdmlElementNotFoundException;
import com.aligo.hdml.interfaces.HdmlElement;
import com.aligo.modules.Path;
import com.aligo.modules.PathComponent;
import com.aligo.modules.exceptions.PathIndexOutOfBoundsException;
import com.aligo.modules.exceptions.PathInvalidException;
import com.aligo.modules.exceptions.PathNotFoundException;
import com.aligo.modules.interfaces.PathComponentInterface;
import com.aligo.modules.interfaces.PathInterface;

public class HdmlTreeUtils {
    public static HdmlElement getHdmlElement(HdmlElement hdmlElement, PathInterface path) throws PathInvalidException {
        HdmlElement currentElement = hdmlElement;
        try {
            while (path.hasMoreComponents()) {
                PathComponentInterface component = path.getFirstPathComponent();
                int index = component.getPathIndex();
                currentElement = index < 0 ? currentElement.getHdmlParentElement() : currentElement.hdmlElementAt(index);
                path = path.getNextPath();
            }
        }
        catch (Exception ex) {
            throw new PathInvalidException(ex.toString());
        }
        return currentElement;
    }

    public static PathInterface getHdmlPath(HdmlElement topElement, HdmlElement hdmlElement) throws PathNotFoundException {
        Path path = new Path();
        boolean foundPath = false;
        boolean done = false;
        while (!done) {
            HdmlElement hdmlParentElement = hdmlElement.getHdmlParentElement();
            if (hdmlParentElement != null) {
                int hdmlIndex = 0;
                try {
                    hdmlIndex = hdmlParentElement.hdmlElementIndex(hdmlElement);
                }
                catch (HdmlElementNotFoundException we) {
                    // empty catch block
                }
                PathComponent pathComponent = new PathComponent(hdmlIndex);
                try {
                    path.addPathComponentAt(pathComponent, 0);
                }
                catch (PathIndexOutOfBoundsException pe) {
                    // empty catch block
                }
                if (hdmlParentElement.equals(topElement)) {
                    foundPath = true;
                    done = true;
                }
                hdmlElement = hdmlParentElement;
                continue;
            }
            done = true;
        }
        if (foundPath) {
            return path;
        }
        throw new PathNotFoundException();
    }
}

