/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.util.chtml;

import com.aligo.chtml.exceptions.CHtmlElementNotFoundException;
import com.aligo.chtml.interfaces.CHtmlElement;
import com.aligo.modules.Path;
import com.aligo.modules.PathComponent;
import com.aligo.modules.exceptions.PathIndexOutOfBoundsException;
import com.aligo.modules.exceptions.PathInvalidException;
import com.aligo.modules.exceptions.PathNotFoundException;
import com.aligo.modules.interfaces.PathComponentInterface;
import com.aligo.modules.interfaces.PathInterface;

public class CHtmlTreeUtils {
    public static CHtmlElement getCHtmlElement(CHtmlElement chtmlElement, PathInterface path) throws PathInvalidException {
        CHtmlElement currentElement = chtmlElement;
        try {
            while (path.hasMoreComponents()) {
                PathComponentInterface component = path.getFirstPathComponent();
                int index = component.getPathIndex();
                currentElement = index < 0 ? currentElement.getCHtmlParentElement() : currentElement.chtmlElementAt(index);
                path = path.getNextPath();
            }
        }
        catch (Exception ex) {
            throw new PathInvalidException(ex.toString());
        }
        return currentElement;
    }

    public static PathInterface getCHtmlPath(CHtmlElement topElement, CHtmlElement chtmlElement) throws PathNotFoundException {
        Path path = new Path();
        boolean foundPath = false;
        boolean done = false;
        while (!done) {
            CHtmlElement chtmlParentElement = chtmlElement.getCHtmlParentElement();
            if (chtmlParentElement != null) {
                int chtmlIndex = 0;
                try {
                    chtmlIndex = chtmlParentElement.chtmlElementIndex(chtmlElement);
                }
                catch (CHtmlElementNotFoundException we) {
                    // empty catch block
                }
                PathComponent pathComponent = new PathComponent(chtmlIndex);
                try {
                    path.addPathComponentAt(pathComponent, 0);
                }
                catch (PathIndexOutOfBoundsException pe) {
                    // empty catch block
                }
                if (chtmlParentElement.equals(topElement)) {
                    foundPath = true;
                    done = true;
                }
                chtmlElement = chtmlParentElement;
                continue;
            }
            done = true;
        }
        if (foundPath) {
            return path;
        }
        throw new PathNotFoundException();
    }
}

