/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.paths;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.paths.exceptions.AmlPathIndexOutOfBoundsException;
import com.aligo.modules.paths.interfaces.AmlPathComponentInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import java.util.ArrayList;

public class AmlPath
implements AmlPathInterface,
Cloneable {
    ArrayList oAmlPathContainer;
    int iRealm;
    String oPathIndexString;
    String oCanonicalPathString;
    AxmlElement oAmlElement;

    public AmlPath() {
        this.oAmlPathContainer = new ArrayList();
        this.setRealm(0);
    }

    public AmlPath(ArrayList pathContainer) {
        this.setAmlPathContainer(pathContainer);
    }

    private void dirty() {
        this.oPathIndexString = null;
        this.oCanonicalPathString = null;
    }

    public void setAmlPathContainer(ArrayList pathContainer) {
        this.oAmlPathContainer = pathContainer;
        this.dirty();
    }

    public void addAmlPathComponent(AmlPathComponentInterface component) {
        this.oAmlPathContainer.add(component);
        this.dirty();
    }

    public void addAmlPathComponentAt(AmlPathComponentInterface component, int index) throws AmlPathIndexOutOfBoundsException {
        try {
            this.oAmlPathContainer.add(index, component);
            this.dirty();
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new AmlPathIndexOutOfBoundsException(ae.toString());
        }
    }

    public int getNumberAmlPathComponents() {
        return this.oAmlPathContainer.size();
    }

    public AmlPathComponentInterface getAmlPathComponentAt(int i) throws AmlPathIndexOutOfBoundsException {
        try {
            return (AmlPathComponentInterface)this.oAmlPathContainer.get(i);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new AmlPathIndexOutOfBoundsException(ae.toString());
        }
    }

    public AmlPathComponentInterface getFirstAmlPathComponent() throws AmlPathIndexOutOfBoundsException {
        return this.getAmlPathComponentAt(0);
    }

    public AmlPathInterface getNextAmlPath() {
        AmlPath remainingAmlPath = new AmlPath();
        int numberElements = this.getNumberAmlPathComponents();
        int i = 1;
        while (i < numberElements) {
            AmlPathComponentInterface component = (AmlPathComponentInterface)this.oAmlPathContainer.get(i);
            remainingAmlPath.addAmlPathComponent(component);
            ++i;
        }
        return remainingAmlPath;
    }

    public boolean hasMoreAmlPathComponents() {
        boolean moreComponents = false;
        int numberElements = this.oAmlPathContainer.size();
        if (numberElements > 0) {
            moreComponents = true;
        }
        return moreComponents;
    }

    public AmlPathInterface newPath() {
        return new AmlPath();
    }

    public AmlPathInterface duplicate() {
        AmlPathInterface amlPath = null;
        try {
            amlPath = (AmlPathInterface)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return amlPath;
    }

    public boolean equals(AmlPathInterface amlPath) {
        boolean isEqual = false;
        try {
            int numberGPathComponents = amlPath.getNumberAmlPathComponents();
            int numberPathComponents = this.getNumberAmlPathComponents();
            if (numberPathComponents == numberGPathComponents) {
                boolean noMatch = false;
                int i = 0;
                while (i < numberPathComponents && !noMatch) {
                    AmlPathComponentInterface amlGPathComponent;
                    AmlPathComponentInterface amlPathComponent = this.getAmlPathComponentAt(i);
                    if (!amlPathComponent.equals(amlGPathComponent = amlPath.getAmlPathComponentAt(i))) {
                        noMatch = true;
                    }
                    ++i;
                }
                if (!noMatch) {
                    isEqual = true;
                }
            }
        }
        catch (AmlPathIndexOutOfBoundsException amlPathIndexOutOfBoundsException) {
            // empty catch block
        }
        return isEqual;
    }

    public String toString() {
        if (this.oPathIndexString == null) {
            StringBuffer string = new StringBuffer(this.getCanonicalPath());
            string.append("@");
            string.append(this.iRealm);
            this.oPathIndexString = string.toString();
        }
        return this.oPathIndexString;
    }

    public void setRealm(int realm) {
        this.iRealm = realm;
        this.dirty();
    }

    public int getRealm() {
        return this.iRealm;
    }

    public String getCanonicalPath() {
        if (this.oCanonicalPathString == null) {
            StringBuffer canonicalPath = new StringBuffer("");
            try {
                int numberPathComponents = this.getNumberAmlPathComponents();
                int i = 0;
                while (i < numberPathComponents) {
                    AmlPathComponentInterface amlPathComponent = this.getAmlPathComponentAt(i);
                    canonicalPath.append("/");
                    canonicalPath.append(amlPathComponent.toString());
                    ++i;
                }
            }
            catch (AmlPathIndexOutOfBoundsException amlPathIndexOutOfBoundsException) {
                // empty catch block
            }
            this.oCanonicalPathString = canonicalPath.toString();
        }
        return this.oCanonicalPathString;
    }

    public void setAmlElement(AxmlElement amlElement) {
        this.oAmlElement = amlElement;
    }

    public AxmlElement getAmlElement() {
        return this.oAmlElement;
    }
}

