/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.maps;

import com.aligo.modules.maps.exceptions.MetricTypesDoNotMatchException;
import com.aligo.modules.maps.interfaces.MapPathMetricInterface;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapPathMetric
implements MapPathMetricInterface {
    public static final long DEFAULT_METRIC = 0L;
    private long lMetric;

    public MapPathMetric() {
        this.resetMetric();
    }

    public MapPathMetric(long metric) {
        this.setMetric(metric);
    }

    public void setMetric(long metric) {
        this.lMetric = metric;
    }

    public long getMetric() {
        return this.lMetric;
    }

    public void addMetric(MapPathMetricInterface mapPathMetricInterface) throws MetricTypesDoNotMatchException {
        if (mapPathMetricInterface instanceof MapPathMetric) {
            MapPathMetric mapPathMetric = (MapPathMetric)mapPathMetricInterface;
            long additionalMetric = mapPathMetric.getMetric();
            this.lMetric += additionalMetric;
        } else {
            throw new MetricTypesDoNotMatchException();
        }
    }

    public void resetMetric() {
        this.lMetric = 0L;
    }

    public boolean isResetMetric() {
        boolean reset = false;
        if (this.lMetric == 0L) {
            reset = true;
        }
        return reset;
    }

    public MapPathMetricInterface getNewMetric() {
        return new MapPathMetric();
    }

    public void fillMetric(MapPathMetricInterface mapPathMetricInterface) {
        if (mapPathMetricInterface instanceof MapPathMetric) {
            MapPathMetric mapPathMetric = (MapPathMetric)mapPathMetricInterface;
            long metric = mapPathMetric.getMetric();
            this.setMetric(metric);
        }
    }

    public boolean isMetricGreater(MapPathMetricInterface mapPathMetricInterface) throws MetricTypesDoNotMatchException {
        boolean metricGreater = false;
        if (mapPathMetricInterface instanceof MapPathMetric) {
            MapPathMetric mapPathMetric = (MapPathMetric)mapPathMetricInterface;
            long compareMetric = mapPathMetric.getMetric();
            if (this.lMetric > compareMetric) {
                metricGreater = true;
            }
        } else {
            throw new MetricTypesDoNotMatchException();
        }
        return metricGreater;
    }

    public void fromXml(Node mapPathMetric) {
        if (mapPathMetric.getNodeType() == 1) {
            Element mapPathMetricElement = (Element)mapPathMetric;
            NodeList list = mapPathMetricElement.getChildNodes();
            if (list.item(0).getNodeValue() != null) {
                String metricString = list.item(0).getNodeValue();
                this.setMetric(Long.parseLong(metricString));
            }
        } else {
            System.out.println("A parser caanot handle this type");
        }
    }

    public String toXml() {
        return this.getMetric() + "";
    }
}

