/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.maps;

import com.aligo.modules.maps.MapPath;
import com.aligo.modules.maps.exceptions.MapPathIndexOutOfBoundsException;
import com.aligo.modules.maps.exceptions.MetricTypesDoNotMatchException;
import com.aligo.modules.maps.interfaces.MapPathInterface;
import com.aligo.modules.maps.interfaces.MapPathMetricInterface;
import com.aligo.parsing.XMLTextUtils;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapPathContainer
implements MapPathInterface {
    Vector oMapPaths;
    private final String MAP_PATH = "MapPath";
    private final String MAP_PATH_CONTAINER = "MapPathContainer";

    public MapPathContainer() {
        this.oMapPaths = new Vector();
    }

    public MapPathContainer(Vector paths) {
        this.setMapPathContainer(paths);
    }

    public void setMapPathContainer(Vector paths) {
        this.oMapPaths = paths;
    }

    public void addMapPath(MapPathInterface path) {
        this.oMapPaths.addElement(path);
    }

    public Enumeration getMapPaths() {
        return this.oMapPaths.elements();
    }

    public int getNumberMapPaths() {
        return this.oMapPaths.size();
    }

    public MapPathInterface getMapPathAt(int i) throws MapPathIndexOutOfBoundsException {
        try {
            return (MapPathInterface)this.oMapPaths.elementAt(i);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new MapPathIndexOutOfBoundsException(ae.toString());
        }
    }

    public void getEqualMetric(MapPathInterface mapPath, MapPathMetricInterface mapPathMetric) {
        int numberElements = this.getNumberMapPaths();
        int i = 0;
        while (i < numberElements) {
            MapPathInterface itMapPath = (MapPathInterface)this.oMapPaths.elementAt(i);
            MapPathMetricInterface currentPathMetric = mapPathMetric.getNewMetric();
            itMapPath.getEqualMetric(mapPath, currentPathMetric);
            try {
                if (currentPathMetric.isMetricGreater(mapPathMetric)) {
                    mapPathMetric.fillMetric(currentPathMetric);
                }
            }
            catch (MetricTypesDoNotMatchException me) {
                // empty catch block
            }
            ++i;
        }
    }

    public void fromXml(Node mapPathContainer) {
        if (mapPathContainer.getNodeType() == 1) {
            Element mapPathContainerElement = (Element)mapPathContainer;
            NodeList list = mapPathContainerElement.getElementsByTagName("MapPath");
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                MapPath mapPath = new MapPath();
                mapPath.fromXml(node);
                this.addMapPath(mapPath);
                ++i;
            }
        }
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append(XMLTextUtils.startElement("MapPathContainer"));
        int totalMapPaths = this.getNumberMapPaths();
        int i = 0;
        while (i < totalMapPaths) {
            MapPathInterface mapPathInterface = null;
            try {
                mapPathInterface = this.getMapPathAt(i);
            }
            catch (MapPathIndexOutOfBoundsException me) {
                me.printStackTrace();
            }
            if (mapPathInterface != null) {
                xml.append(mapPathInterface.toXml());
            }
            ++i;
        }
        xml.append(XMLTextUtils.endElement("MapPathContainer"));
        return xml.toString();
    }
}

