/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.maps;

import com.aligo.engine.logging.LoggerContainer;
import com.aligo.modules.maps.interfaces.MapMatcherInterface;
import com.aligo.parsing.XMLTextUtils;
import com.aligo.profile.interfaces.UAProfile;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapMatcher
implements MapMatcherInterface {
    private String sXmlID;
    private String sAmlID;
    private static final String MATCHER = "Matcher";
    private static final String AML_ID = "AmlID";
    private static final String XML_ID = "XmlID";
    private static final int EXACT_METRIC = 10;
    private static final int UNIVERSAL_METRIC = 1;
    private static final int NO_METRIC = -10;

    public MapMatcher() {
    }

    public MapMatcher(String xmlID, String amlID) {
        this.setXmlID(xmlID);
        this.setAmlID(amlID);
    }

    public void setXmlID(String xmlID) {
        this.sXmlID = xmlID;
    }

    public void setAmlID(String amlID) {
        this.sAmlID = amlID;
    }

    public String getXmlID() {
        return this.sXmlID;
    }

    public String getAmlID() {
        return this.sAmlID;
    }

    public boolean doesMatch(UAProfile uaProfile) {
        boolean matches = false;
        String tXmlID = uaProfile.getXmlID();
        String tAmlID = uaProfile.getAmlID();
        String amlID = this.getAmlID();
        String xmlID = this.getXmlID();
        if (amlID == null) {
            matches = true;
        } else if (xmlID == null) {
            matches = true;
        } else if (tXmlID.equals(xmlID) && tAmlID.equals(amlID)) {
            matches = true;
        }
        return matches;
    }

    private int getEqualMetric(String id, String tID) {
        int metric = 0;
        metric = id == null ? ++metric : (id.equals(tID) ? (metric += 10) : (metric -= 10));
        return metric;
    }

    public int getEqualMetric(UAProfile uaProfile) {
        int metric = 0;
        String tXmlID = uaProfile.getXmlID();
        String tAmlID = uaProfile.getAmlID();
        String amlID = this.getAmlID();
        String xmlID = this.getXmlID();
        metric += this.getEqualMetric(amlID, tAmlID);
        if (LoggerContainer.getDefaultLogger().debugEnabled()) {
            LoggerContainer.getDefaultLogger().logDebug("Matcher metric = " + metric);
        }
        return metric;
    }

    public void fromXml(Node mapMatcher) {
        if (mapMatcher.getNodeType() == 1) {
            Element xmlId;
            NodeList list;
            NodeList xmlIds;
            Element amlId;
            NodeList list2;
            Element mapMatcherElement = (Element)mapMatcher;
            NodeList amlIds = mapMatcherElement.getElementsByTagName(AML_ID);
            if (amlIds.getLength() > 0 && amlIds.item(0).getNodeType() == 1 && (list2 = (amlId = (Element)amlIds.item(0)).getChildNodes()).item(0).getNodeValue() != null) {
                this.setAmlID(list2.item(0).getNodeValue());
            }
            if ((xmlIds = mapMatcherElement.getElementsByTagName(XML_ID)).getLength() > 0 && xmlIds.item(0).getNodeType() == 1 && (list = (xmlId = (Element)xmlIds.item(0)).getChildNodes()).item(0).getNodeValue() != null) {
                this.setXmlID(list.item(0).getNodeValue());
            }
        } else {
            System.out.println("A parser cannot handle this type");
        }
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append(XMLTextUtils.startElement(MATCHER));
        if (this.getXmlID() != null) {
            xml.append(XMLTextUtils.startElement(XML_ID));
            xml.append(this.getXmlID());
            xml.append(XMLTextUtils.endElement(XML_ID));
        }
        if (this.getAmlID() != null) {
            xml.append(XMLTextUtils.startElement(AML_ID));
            xml.append(this.getAmlID());
            xml.append(XMLTextUtils.endElement(AML_ID));
        }
        xml.append(XMLTextUtils.endElement(MATCHER));
        return xml.toString();
    }
}

