/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.jhtml.util;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.jhtml.interfaces.JHtmlElement;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.interfaces.HandlerManagerInterface;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.jhtml.events.JHtmlAmlDetachFromTreeMemoryHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlGetJHtmlChildContainerStateHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlGetPageAllocatorMemoryHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlGetPresentationElementsHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlGetRootElementHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlGetTopJHtmlElementStateHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlGetTopStyleElementStateHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlIsDeckSaneMemoryHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlIsPersistentHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlIsSufficientMemoryHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlSetRootElementHandlerEvent;
import com.aligo.modules.jhtml.handlets.events.JHtmlAmlAddXmlJHtmlAttributeHandletEvent;
import com.aligo.modules.jhtml.handlets.events.JHtmlAmlAddXmlJHtmlElementHandletEvent;
import com.aligo.modules.jhtml.handlets.events.JHtmlAmlCreateXmlJHtmlElementHandletEvent;
import com.aligo.modules.jhtml.handlets.events.JHtmlAmlRemoveXmlJHtmlAttributeHandletEvent;
import com.aligo.modules.jhtml.handlets.events.JHtmlAmlRemoveXmlJHtmlElementHandletEvent;
import com.aligo.modules.jhtml.handlets.events.JHtmlAmlResetXmlJHtmlTextHandletEvent;
import com.aligo.modules.jhtml.handlets.events.JHtmlAmlSetXmlJHtmlTextHandletEvent;
import com.aligo.modules.jhtml.handlets.events.JHtmlAmlXmlJHtmlElementHandletEvent;
import com.aligo.modules.jhtml.util.exceptions.JHtmlAmlGetRootElementFailedException;
import com.aligo.modules.jhtml.util.exceptions.JHtmlAmlSetRootElementFailedException;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.exceptions.XmlElementIndexOutOfBoundsException;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import java.util.Hashtable;

public class JHtmlAmlElementUtils {
    public static PageAllocatorInterface getPageAllocator(HandlerManagerInterface handlerManager) {
        PageAllocatorInterface pageAllocator = null;
        try {
            JHtmlAmlGetPageAllocatorMemoryHandlerEvent getPageAllocatorEvent = new JHtmlAmlGetPageAllocatorMemoryHandlerEvent();
            handlerManager.postEventNow(getPageAllocatorEvent);
            pageAllocator = getPageAllocatorEvent.getPageAllocator();
        }
        catch (HandlerError handlerError) {
            // empty catch block
        }
        return pageAllocator;
    }

    public static AxmlElement getRootAmlElement(HandlerManagerInterface handlerManager) throws JHtmlAmlGetRootElementFailedException {
        try {
            JHtmlAmlGetRootElementHandlerEvent getRootElementHandlerEvent = new JHtmlAmlGetRootElementHandlerEvent();
            handlerManager.postEventNow(getRootElementHandlerEvent);
            return getRootElementHandlerEvent.getAmlElement();
        }
        catch (HandlerError handlerError) {
            throw new JHtmlAmlGetRootElementFailedException(handlerError.toString());
        }
    }

    public static void setRootAmlElement(HandlerManagerInterface handlerManager, AxmlElement rootAmlElement) throws JHtmlAmlSetRootElementFailedException {
        try {
            JHtmlAmlSetRootElementHandlerEvent setRootElementHandlerEvent = new JHtmlAmlSetRootElementHandlerEvent(rootAmlElement);
            handlerManager.postEventNow(setRootElementHandlerEvent);
        }
        catch (HandlerError handlerError) {
            throw new JHtmlAmlSetRootElementFailedException(handlerError.toString());
        }
    }

    public static boolean isSufficientMemory(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        JHtmlAmlIsSufficientMemoryHandlerEvent isSufficientMemoryEvent = new JHtmlAmlIsSufficientMemoryHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(isSufficientMemoryEvent);
        return isSufficientMemoryEvent.isSufficient();
    }

    public static JHtmlElement getTopJHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        JHtmlAmlGetTopJHtmlElementStateHandlerEvent getTopJHtmlElementStateEvent = new JHtmlAmlGetTopJHtmlElementStateHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(getTopJHtmlElementStateEvent);
        return getTopJHtmlElementStateEvent.getJHtmlElement();
    }

    public static void detachFromTree(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        JHtmlAmlDetachFromTreeMemoryHandlerEvent detachFromTreeEvent = new JHtmlAmlDetachFromTreeMemoryHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(detachFromTreeEvent);
    }

    public static boolean isDeckSane(HandlerManagerInterface handlerManager) throws HandlerError {
        JHtmlAmlIsDeckSaneMemoryHandlerEvent isDeckSaneEvent = new JHtmlAmlIsDeckSaneMemoryHandlerEvent();
        handlerManager.postEventNow(isDeckSaneEvent);
        return isDeckSaneEvent.isSane();
    }

    public static JHtmlElement getChildContainerJHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        JHtmlAmlGetJHtmlChildContainerStateHandlerEvent getJHtmlChildContainerStateEvent = new JHtmlAmlGetJHtmlChildContainerStateHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(getJHtmlChildContainerStateEvent);
        return getJHtmlChildContainerStateEvent.getJHtmlElement();
    }

    public static XmlElementInterface getTopStyleElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        JHtmlAmlGetTopStyleElementStateHandlerEvent getTopStyleElementStateEvent = new JHtmlAmlGetTopStyleElementStateHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(getTopStyleElementStateEvent);
        return getTopStyleElementStateEvent.getXmlElement();
    }

    public static XmlElementInterface getFirstMatchingChild(HandlerManagerInterface handlerManager, XmlElementInterface topElement, String name) {
        XmlElementInterface matchedElement = null;
        String itName = topElement.getXmlElementName();
        if (name.equals(itName)) {
            matchedElement = topElement;
        } else {
            int numberElements = topElement.getNumberXmlElements();
            boolean done = false;
            int i = 0;
            while (i < numberElements && !done) {
                try {
                    XmlElementInterface xmlElement = topElement.getXmlElement(i);
                    XmlElementInterface childMatchElement = JHtmlAmlElementUtils.getFirstMatchingChild(handlerManager, xmlElement, name);
                    if (childMatchElement != null) {
                        matchedElement = childMatchElement;
                        done = true;
                    }
                }
                catch (XmlElementIndexOutOfBoundsException xe) {
                    // empty catch block
                }
                ++i;
            }
        }
        return matchedElement;
    }

    public static JHtmlElement getJHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, XmlElementInterface xmlElement) throws HandlerError {
        JHtmlAmlXmlJHtmlElementHandletEvent xmlJHtmlElementEvent = new JHtmlAmlXmlJHtmlElementHandletEvent("Get", currentAmlPath, xmlElement);
        handlerManager.postEventNow(xmlJHtmlElementEvent);
        return xmlJHtmlElementEvent.getJHtmlElement();
    }

    public static JHtmlElement createJHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, String name) throws HandlerError {
        JHtmlAmlCreateXmlJHtmlElementHandletEvent createXmlJHtmlEvent = new JHtmlAmlCreateXmlJHtmlElementHandletEvent(currentAmlPath, name);
        handlerManager.postEventNow(createXmlJHtmlEvent);
        return createXmlJHtmlEvent.getJHtmlElement();
    }

    public static void addJHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, JHtmlElement jhtmlElement, JHtmlElement childJHtmlElement) throws HandlerError {
        JHtmlAmlElementUtils.addJHtmlElement(handlerManager, currentAmlPath, jhtmlElement, childJHtmlElement, -1);
    }

    public static void addJHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, JHtmlElement jhtmlElement, JHtmlElement childJHtmlElement, int childIndex) throws HandlerError {
        JHtmlAmlAddXmlJHtmlElementHandletEvent addXmlJHtmlElementEvent = new JHtmlAmlAddXmlJHtmlElementHandletEvent(currentAmlPath, jhtmlElement, childJHtmlElement, childIndex);
        handlerManager.postEventNow(addXmlJHtmlElementEvent);
    }

    public static void addJHtmlAttribute(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, JHtmlElement jhtmlElement, String name, String value) throws HandlerError {
        JHtmlAmlAddXmlJHtmlAttributeHandletEvent addXmlJHtmlAttributeEvent = new JHtmlAmlAddXmlJHtmlAttributeHandletEvent(currentAmlPath, jhtmlElement, name, value);
        handlerManager.postEventNow(addXmlJHtmlAttributeEvent);
    }

    public static void setJHtmlText(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, JHtmlElement jhtmlElement, String text) throws HandlerError {
        JHtmlAmlSetXmlJHtmlTextHandletEvent setXmlJHtmlTextEvent = new JHtmlAmlSetXmlJHtmlTextHandletEvent(currentAmlPath, jhtmlElement, text);
        handlerManager.postEventNow(setXmlJHtmlTextEvent);
    }

    public static void removeJHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, JHtmlElement jhtmlElement, JHtmlElement childJHtmlElement) throws HandlerError {
        JHtmlAmlRemoveXmlJHtmlElementHandletEvent removeXmlJHtmlElementEvent = new JHtmlAmlRemoveXmlJHtmlElementHandletEvent(currentAmlPath, jhtmlElement, childJHtmlElement);
        handlerManager.postEventNow(removeXmlJHtmlElementEvent);
    }

    public static void removeJHtmlAttribute(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, JHtmlElement jhtmlElement, String name) throws HandlerError {
        JHtmlAmlRemoveXmlJHtmlAttributeHandletEvent removeXmlJHtmlAttributeEvent = new JHtmlAmlRemoveXmlJHtmlAttributeHandletEvent(currentAmlPath, jhtmlElement, name);
        handlerManager.postEventNow(removeXmlJHtmlAttributeEvent);
    }

    public static void resetJHtmlText(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, JHtmlElement jhtmlElement) throws HandlerError {
        JHtmlAmlResetXmlJHtmlTextHandletEvent resetXmlJHtmlTextEvent = new JHtmlAmlResetXmlJHtmlTextHandletEvent(currentAmlPath, jhtmlElement);
        handlerManager.postEventNow(resetXmlJHtmlTextEvent);
    }

    public static Hashtable getPresentationElements(HandlerManagerInterface handlerManager) throws HandlerError {
        JHtmlAmlGetPresentationElementsHandlerEvent getPresentationElementsEvent = new JHtmlAmlGetPresentationElementsHandlerEvent();
        handlerManager.postEventNow(getPresentationElementsEvent);
        return getPresentationElementsEvent.getJHtmlElements();
    }

    public static boolean isPresentationElement(HandlerManagerInterface handlerManager, JHtmlElement jhtmlElement) throws HandlerError {
        boolean present = false;
        Hashtable jhtmlElements = JHtmlAmlElementUtils.getPresentationElements(handlerManager);
        if (jhtmlElements.get(jhtmlElement) != null) {
            present = true;
        }
        return present;
    }

    public static void addPresentationElement(HandlerManagerInterface handlerManager, JHtmlElement jhtmlElement) throws HandlerError {
        Hashtable jhtmlElements = JHtmlAmlElementUtils.getPresentationElements(handlerManager);
        JHtmlAmlElementUtils.addPresentationElement(jhtmlElements, jhtmlElement);
    }

    public static void removePresentationElement(HandlerManagerInterface handlerManager, JHtmlElement jhtmlElement) throws HandlerError {
        Hashtable jhtmlElements = JHtmlAmlElementUtils.getPresentationElements(handlerManager);
        JHtmlAmlElementUtils.removePresentationElement(jhtmlElements, jhtmlElement);
    }

    public static void addPresentationElement(Hashtable jhtmlElements, JHtmlElement jhtmlElement) {
        jhtmlElements.put(jhtmlElement, jhtmlElement);
    }

    public static void removePresentationElement(Hashtable jhtmlElements, JHtmlElement jhtmlElement) {
        jhtmlElements.remove(jhtmlElement);
    }

    public static boolean isPersistent(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        JHtmlAmlIsPersistentHandlerEvent isPersistentEvent = new JHtmlAmlIsPersistentHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(isPersistentEvent);
        return isPersistentEvent.isPersistent();
    }
}

