/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.jhtml.amlhandlets;

import com.aligo.axml.AxmlDocument;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.jhtml.JHtmlMeta;
import com.aligo.jhtml.exceptions.JHtmlAttributeCannotBeAddedException;
import com.aligo.jhtml.interfaces.JHtmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.jhtml.handlets.JHtmlAmlStylePathHandlet;
import com.aligo.modules.jhtml.handlets.events.JHtmlAmlAddAttributeHandledHandletEvent;
import com.aligo.modules.jhtml.handlets.events.JHtmlAmlAddAttributeHandletEvent;
import com.aligo.modules.jhtml.util.JHtmlAmlElementUtils;
import com.aligo.modules.jhtml.util.JHtmlEventDescriptor;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import java.util.Vector;

public class JHtmlAmlRefreshHandlet
extends JHtmlAmlStylePathHandlet {
    private static final String REFRESH = "Refresh";
    private static final String CONTENT_SEPARATOR = "; ";
    private static final String URL = "URL";
    private static final String EQUALS = "=";
    private AxmlElement oAmlElement;
    private String sRefresh;
    private XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;

    public Vector getEvents() {
        Vector<JHtmlEventDescriptor> events = new Vector<JHtmlEventDescriptor>();
        JHtmlEventDescriptor eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long jhtmlAmlStylePathRelevance() {
        JHtmlAmlAddAttributeHandletEvent addAttributeEvent;
        XmlAttributeInterface xmlAttribute;
        long currentJHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof JHtmlAmlAddAttributeHandletEvent && (xmlAttribute = (addAttributeEvent = (JHtmlAmlAddAttributeHandletEvent)this.oCurrentEvent).getXmlAttribute()) instanceof XmlAmlHandlerAttributeInterface) {
            String refresh;
            String attrName;
            XmlAmlHandlerAttributeInterface xmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)xmlAttribute;
            this.oCurrentAmlPath = addAttributeEvent.getAmlPath();
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
            if (amlElement instanceof AxmlDocument && (attrName = xmlAmlHandlerAttribute.getAmlAttributeName()).equals("refresh") && (refresh = amlElement.getAxmlAttributeValue(attrName)) != null) {
                this.oXmlAmlHandlerAttribute = xmlAmlHandlerAttribute;
                this.oAmlElement = amlElement;
                this.sRefresh = refresh;
                currentJHtmlAmlStylePathRelevance = 20L;
            }
        }
        return currentJHtmlAmlStylePathRelevance;
    }

    public void handleStylePathEvent() {
        if (this.oCurrentEvent instanceof JHtmlAmlAddAttributeHandletEvent) {
            try {
                JHtmlElement jhtmlElement = JHtmlAmlElementUtils.getJHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.oStyleXmlElement);
                try {
                    JHtmlMeta jhtmlMeta = new JHtmlMeta();
                    jhtmlMeta.addJHtmlAttribute("http-equiv", "refresh");
                    int timeout = 0;
                    try {
                        String strTimeout = this.oAmlElement.getAxmlAttributeValue("refresh_timeout");
                        if (strTimeout != null) {
                            timeout = new Integer(strTimeout);
                        }
                    }
                    catch (NumberFormatException ne) {
                        this.oHandlerLogger.logError(ne);
                    }
                    String content = timeout + CONTENT_SEPARATOR + URL + EQUALS + this.sRefresh;
                    jhtmlMeta.addJHtmlAttribute("content", content);
                    JHtmlAmlElementUtils.addJHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, jhtmlElement, jhtmlMeta);
                }
                catch (JHtmlAttributeCannotBeAddedException ex) {
                    this.oHandlerLogger.logError(ex);
                }
            }
            catch (HandlerError he) {
                this.oHandlerLogger.logError(he);
            }
            JHtmlAmlAddAttributeHandledHandletEvent addAttributeHandledEvent = new JHtmlAmlAddAttributeHandledHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
            this.oHandlerManager.postEvent(addAttributeHandledEvent);
        }
    }
}

