/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.jhtml;

import com.aligo.jhtml.JHtmlElementCollection;
import com.aligo.jhtml.exceptions.JHtmlElementIndexOutOfBoundsException;
import com.aligo.jhtml.interfaces.JHtmlElement;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.jhtml.JHtmlAmlHandler;
import com.aligo.modules.jhtml.events.JHtmlAmlAddCurrentMemoryHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlCacheContentsHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlGetCurrentPageIDHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlGetJHtmlChildContainerStateHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlGetPageAllocatorMemoryHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlGetPresentationElementsHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlGetPreviousPageIDHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlGetRemainingMemoryHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlIsDeckSaneMemoryHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlIsSufficientMemoryHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlRemoveCurrentMemoryHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlResetCurrentMemoryHandlerEvent;
import com.aligo.modules.jhtml.util.JHtmlAmlElementUtils;
import com.aligo.modules.jhtml.util.JHtmlEventDescriptor;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.profile.interfaces.UAProfile;
import com.aligo.util.PageCache;
import com.aligo.util.URLUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class JHtmlAmlPresentationContainerHandler
extends JHtmlAmlHandler
implements PageAllocatorInterface {
    public static final long HIGH_RELEVANCE = 10L;
    public static final long RESERVE_MEM = 50L;
    private static final String ELEMENT_PREFIX = "agp";
    private static final String ELEMENT_REFERENCE = "#";
    private static final long DEFAULT_HIGHMEM = 1000L;
    private static final String EXISTS = "true";
    protected JHtmlElementCollection oJHtmlDecks = new JHtmlElementCollection();
    protected boolean bIsTransactionEvent;
    private Map oPageURLMap = Collections.synchronizedMap(new HashMap());
    private Map oPageIDMap = Collections.synchronizedMap(new HashMap());
    private Map oElementURLs = Collections.synchronizedMap(new HashMap());
    private Map oElementLinks = Collections.synchronizedMap(new HashMap());
    private int iCurrentElementNumber;
    private String sCurrentElementID;
    private String sPreviousElementID;
    private PageCache oPageCache;
    private String sCacheURL;
    private boolean bNavigatePrevious = false;
    private String sPreviousLabel = "Back";
    private String sNextLabel = "More";
    private long lMemory;
    private int iActiveIndex = 0;
    private int iBaseIndex = 0;
    private Hashtable oPresentationElements = new Hashtable();
    private Hashtable oCurrentMemories = new Hashtable();
    private int iCurrentRealm;

    public void init() {
        UAProfile uaProfile = this.getUAProfile();
        this.lMemory = (long)uaProfile.getPDUSize() - 50L;
        if (this.lMemory <= 0L) {
            this.defaultMemory();
        }
        if (this.oHandlerLogger.debugEnabled()) {
            this.oHandlerLogger.logDebug("lMemory = " + this.lMemory);
        }
        JHtmlAmlElementUtils.addPresentationElement(this.oPresentationElements, (JHtmlElement)this.oJHtmlDecks);
    }

    private void defaultMemory() {
        this.lMemory = 1000L;
    }

    public JHtmlElement getJHtmlDecks() {
        JHtmlElement jhtmlElement = null;
        try {
            jhtmlElement = this.oJHtmlDecks.jhtmlElementAt(0);
        }
        catch (JHtmlElementIndexOutOfBoundsException jHtmlElementIndexOutOfBoundsException) {
            // empty catch block
        }
        if (this.oHandlerLogger.debugEnabled()) {
            this.oHandlerLogger.logDebug("jhtmlElement = " + this.oJHtmlDecks.getContents());
        }
        return jhtmlElement;
    }

    public void allocatePage() {
        int index = this.iBaseIndex + this.iActiveIndex;
        StringBuffer pageURL = new StringBuffer(this.sCacheURL);
        pageURL.append(index);
        this.oPageURLMap.put(new Integer(index), pageURL.toString());
        ++this.iActiveIndex;
    }

    private int getMIndex() {
        return this.iBaseIndex + this.iActiveIndex;
    }

    public void changeElement(String oldId, String newId) {
        String linkId;
        String url;
        String linkedId = this.getElementLink(oldId);
        if (linkedId != null) {
            this.oElementLinks.put(newId, linkedId);
            this.oElementLinks.remove(oldId);
        }
        if ((url = (String)this.oElementURLs.get(oldId)) != null) {
            url = URLUtils.composeAnchorURL(url, newId).toString();
            this.oElementURLs.put(newId, url);
            this.oElementURLs.remove(oldId);
        }
        if ((linkId = this.getElementIDLinkingTo(oldId)) != null) {
            this.oElementLinks.put(linkId, newId);
        }
        if (this.sCurrentElementID != null && this.sCurrentElementID.equals(oldId)) {
            this.sCurrentElementID = newId;
        }
        if (this.sPreviousElementID != null && this.sPreviousElementID.equals(oldId)) {
            this.sPreviousElementID = newId;
        }
    }

    public void allocateElement() {
        this.sPreviousElementID = this.sCurrentElementID;
        StringBuffer elementID = new StringBuffer(ELEMENT_PREFIX);
        elementID.append(this.iCurrentElementNumber);
        this.sCurrentElementID = elementID.toString();
        StringBuffer url = new StringBuffer(this.sCacheURL);
        url.append(this.getMIndex());
        url = URLUtils.composeAnchorURL(url.toString(), ELEMENT_PREFIX + this.iCurrentElementNumber);
        String currElementURL = url.toString();
        this.oElementURLs.put(this.sCurrentElementID, currElementURL);
        if (this.sPreviousElementID != null) {
            String prevElementURLPrefix;
            String currElementURLPrefix = currElementURL.substring(0, currElementURL.indexOf(this.sCurrentElementID));
            String prevElementURL = this.getElementURL(this.sPreviousElementID);
            if (prevElementURL != null && (prevElementURLPrefix = prevElementURL.substring(0, prevElementURL.indexOf(this.sPreviousElementID))).equals(currElementURLPrefix)) {
                this.oElementLinks.put(this.sPreviousElementID, this.sCurrentElementID);
            }
        }
        ++this.iCurrentElementNumber;
    }

    public String getElementLink(String elementID) {
        return (String)this.oElementLinks.get(elementID);
    }

    private String getElementIDLinkingTo(String elementID) {
        String result = null;
        Iterator keys = this.oElementLinks.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String tmpElementID = (String)this.oElementLinks.get(key);
            if (tmpElementID == null || !tmpElementID.equals(elementID)) continue;
            result = key;
        }
        return result;
    }

    public void deallocateElement(String elementID) {
        String elementLinkFrom = this.getElementIDLinkingTo(elementID);
        String elementLinkTo = (String)this.oElementLinks.get(elementID);
        if (elementLinkFrom != null && elementLinkTo != null) {
            this.oElementLinks.put(elementLinkFrom, elementLinkTo);
            if (this.sPreviousElementID != null && this.sPreviousElementID.equals(elementID) && this.sCurrentElementID.equals(elementLinkTo)) {
                this.sPreviousElementID = elementLinkFrom;
            }
        } else if (elementLinkFrom != null && elementLinkTo == null) {
            if (this.sPreviousElementID != null && this.sPreviousElementID.equals(elementLinkFrom) && this.sCurrentElementID.equals(elementID)) {
                this.sPreviousElementID = this.getElementIDLinkingTo(elementLinkFrom);
                this.sCurrentElementID = elementLinkFrom;
            }
        } else if (elementLinkFrom == null && elementLinkTo != null && this.sPreviousElementID != null && this.sPreviousElementID.equals(elementID) && this.sCurrentElementID.equals(elementLinkTo)) {
            this.sPreviousElementID = null;
            this.sCurrentElementID = elementLinkTo;
        }
        this.oElementLinks.remove(elementID);
        this.oElementURLs.remove(elementID);
    }

    private String createPageURL(int index) {
        StringBuffer pageURL = new StringBuffer(this.sCacheURL);
        pageURL.append(index);
        return pageURL.toString();
    }

    public boolean navigatePrevious() {
        return this.bNavigatePrevious;
    }

    public String getPreviousLabel() {
        return this.sPreviousLabel;
    }

    public void setPreviousLabel(String label) {
        this.sPreviousLabel = label;
    }

    public String getNextLabel() {
        return this.sNextLabel;
    }

    public void setNextLabel(String label) {
        this.sNextLabel = label;
    }

    public void assignPageID(String pageID) {
        int mIndex = this.iBaseIndex + this.iActiveIndex;
        this.oPageIDMap.put(pageID, new Integer(mIndex));
    }

    public String getPageURL(String pageID) {
        return (String)this.oPageURLMap.get((Integer)this.oPageIDMap.get(pageID));
    }

    public String getCurrentPageURL() {
        int mIndex = this.iBaseIndex + this.iActiveIndex;
        return this.createPageURL(mIndex);
    }

    public String getPreviousPageURL() {
        String prevURL = null;
        if (this.iActiveIndex > 0) {
            int mIndex = this.iBaseIndex + this.iActiveIndex - 1;
            prevURL = this.createPageURL(mIndex);
        }
        return prevURL;
    }

    public String getNextPageURL() {
        String prevURL = null;
        if (this.iActiveIndex > 0) {
            int mIndex = this.iBaseIndex + this.iActiveIndex + 1;
            prevURL = this.createPageURL(mIndex);
        }
        return prevURL;
    }

    public String getPreviousElementURL() {
        return this.getElementURL(this.sPreviousElementID);
    }

    public String getElementURL(String elementID) {
        String result = null;
        if (elementID != null && !elementID.equals("")) {
            result = (String)this.oElementURLs.get(elementID);
        }
        return result;
    }

    public String getCurrentElementURL() {
        return this.getElementURL(this.sCurrentElementID);
    }

    public boolean isElementLinkValid(String linkFromElementID, String linkToElementID) {
        String tmpElementID = this.getElementIDLinkingTo(linkToElementID);
        return linkFromElementID.equals(tmpElementID);
    }

    public String getCurrentElementID() {
        return this.sCurrentElementID;
    }

    public String getPreviousElementID() {
        return this.sPreviousElementID;
    }

    public String getCacheURL() {
        return this.sCacheURL;
    }

    public void setCacheURL(String cacheURL) {
        this.sCacheURL = cacheURL;
    }

    public PageCache getPageCache() {
        return this.oPageCache;
    }

    public void setPageCache(PageCache pageCache) {
        this.oPageCache = pageCache;
    }

    private int getCurrentPageID() {
        return this.iActiveIndex + this.iBaseIndex;
    }

    private int getPreviousPageID() {
        int prevId = -1;
        if (this.iActiveIndex > 0) {
            prevId = this.iActiveIndex + this.iBaseIndex - 1;
        }
        return prevId;
    }

    public Vector getEvents() {
        Vector<JHtmlEventDescriptor> events = new Vector<JHtmlEventDescriptor>();
        JHtmlEventDescriptor eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlGetJHtmlChildContainerStateHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlIsSufficientMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlIsDeckSaneMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlGetRemainingMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlCacheContentsHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlGetCurrentPageIDHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlGetPreviousPageIDHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlGetPageAllocatorMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlResetCurrentMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlAddCurrentMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlRemoveCurrentMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlGetPresentationElementsHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long jhtmlAmlRelevance() {
        long currentJHtmlAmlRelevance = 0L;
        if (this.oCurrentEvent instanceof JHtmlAmlGetJHtmlChildContainerStateHandlerEvent) {
            JHtmlAmlGetJHtmlChildContainerStateHandlerEvent getJHtmlChildContainerStateHandlerEvent = (JHtmlAmlGetJHtmlChildContainerStateHandlerEvent)this.oCurrentEvent;
            AmlPathInterface amlPath = getJHtmlChildContainerStateHandlerEvent.getAmlPath();
            if (amlPath == null) {
                currentJHtmlAmlRelevance = 10L;
            }
        } else if (this.oCurrentEvent instanceof JHtmlAmlIsSufficientMemoryHandlerEvent) {
            currentJHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof JHtmlAmlIsDeckSaneMemoryHandlerEvent) {
            currentJHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof JHtmlAmlGetRemainingMemoryHandlerEvent) {
            currentJHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof JHtmlAmlCacheContentsHandlerEvent) {
            currentJHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof JHtmlAmlGetCurrentPageIDHandlerEvent) {
            currentJHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof JHtmlAmlGetPreviousPageIDHandlerEvent) {
            currentJHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof JHtmlAmlGetPageAllocatorMemoryHandlerEvent) {
            currentJHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof JHtmlAmlResetCurrentMemoryHandlerEvent) {
            currentJHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof JHtmlAmlAddCurrentMemoryHandlerEvent) {
            currentJHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof JHtmlAmlRemoveCurrentMemoryHandlerEvent) {
            currentJHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof JHtmlAmlGetPresentationElementsHandlerEvent) {
            currentJHtmlAmlRelevance = 10L;
        }
        return currentJHtmlAmlRelevance;
    }

    public void handleEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof JHtmlAmlGetJHtmlChildContainerStateHandlerEvent) {
            JHtmlAmlGetJHtmlChildContainerStateHandlerEvent jhtmlAmlJHtmlChildContainerStateHandlerEvent = (JHtmlAmlGetJHtmlChildContainerStateHandlerEvent)this.oCurrentEvent;
            jhtmlAmlJHtmlChildContainerStateHandlerEvent.setJHtmlElement(this.oJHtmlDecks);
        } else if (this.oCurrentEvent instanceof JHtmlAmlIsSufficientMemoryHandlerEvent) {
            JHtmlAmlIsSufficientMemoryHandlerEvent isSufficientMemoryEvent = (JHtmlAmlIsSufficientMemoryHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = isSufficientMemoryEvent.getAmlPath();
            boolean memorySufficient = this.isMemorySufficient(currentAmlPath);
            isSufficientMemoryEvent.setSufficient(memorySufficient);
        } else if (this.oCurrentEvent instanceof JHtmlAmlIsDeckSaneMemoryHandlerEvent) {
            JHtmlAmlIsDeckSaneMemoryHandlerEvent isDeckSaneEvent = (JHtmlAmlIsDeckSaneMemoryHandlerEvent)this.oCurrentEvent;
            boolean deckSane = this.isDeckSane();
            isDeckSaneEvent.setSane(deckSane);
        } else if (this.oCurrentEvent instanceof JHtmlAmlGetRemainingMemoryHandlerEvent) {
            JHtmlAmlGetRemainingMemoryHandlerEvent remainingMemoryEvent = (JHtmlAmlGetRemainingMemoryHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = remainingMemoryEvent.getAmlPath();
            long remainingMemory = 0L;
            try {
                long bytes = this.getCurrentNumberBytes(currentAmlPath);
                if (this.lMemory > bytes) {
                    remainingMemory = this.lMemory - bytes;
                }
            }
            catch (JHtmlElementIndexOutOfBoundsException ie) {
                // empty catch block
            }
            remainingMemoryEvent.setNumberBytes(remainingMemory);
        } else if (this.oCurrentEvent instanceof JHtmlAmlCacheContentsHandlerEvent) {
            this.allocatePage();
            int i = 0;
            while (i < this.iActiveIndex) {
                int index = this.iBaseIndex + i;
                try {
                    this.oPageCache.putIndexedPage(Integer.toString(index), this.oJHtmlDecks.jhtmlElementAt(i).getContents());
                }
                catch (JHtmlElementIndexOutOfBoundsException ie) {
                    // empty catch block
                }
                ++i;
            }
        } else if (this.oCurrentEvent instanceof JHtmlAmlGetCurrentPageIDHandlerEvent) {
            JHtmlAmlGetCurrentPageIDHandlerEvent currentPageIDEvent = (JHtmlAmlGetCurrentPageIDHandlerEvent)this.oCurrentEvent;
            currentPageIDEvent.setID(new Integer(this.getCurrentPageID()).toString());
        } else if (this.oCurrentEvent instanceof JHtmlAmlGetPreviousPageIDHandlerEvent) {
            JHtmlAmlGetPreviousPageIDHandlerEvent previousPageIDEvent = (JHtmlAmlGetPreviousPageIDHandlerEvent)this.oCurrentEvent;
            previousPageIDEvent.setID(new Integer(this.getPreviousPageID()).toString());
        } else if (this.oCurrentEvent instanceof JHtmlAmlGetPageAllocatorMemoryHandlerEvent) {
            JHtmlAmlGetPageAllocatorMemoryHandlerEvent getPageAllocatorEvent = (JHtmlAmlGetPageAllocatorMemoryHandlerEvent)this.oCurrentEvent;
            getPageAllocatorEvent.setPageAllocator(this);
        } else if (this.oCurrentEvent instanceof JHtmlAmlResetCurrentMemoryHandlerEvent) {
            AmlPathInterface currentAmlPath = ((JHtmlAmlResetCurrentMemoryHandlerEvent)this.oCurrentEvent).getAmlPath();
            this.resetCurrentMemory(currentAmlPath);
        } else if (this.oCurrentEvent instanceof JHtmlAmlAddCurrentMemoryHandlerEvent) {
            JHtmlAmlAddCurrentMemoryHandlerEvent addCurrentMemoryEvent = (JHtmlAmlAddCurrentMemoryHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = addCurrentMemoryEvent.getAmlPath();
            long addMemory = addCurrentMemoryEvent.getMemory();
            long currentMemory = this.getCurrentMemory(currentAmlPath);
            this.setCurrentMemory(currentAmlPath, currentMemory += addMemory);
        } else if (this.oCurrentEvent instanceof JHtmlAmlRemoveCurrentMemoryHandlerEvent) {
            JHtmlAmlRemoveCurrentMemoryHandlerEvent removeCurrentMemoryEvent = (JHtmlAmlRemoveCurrentMemoryHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = removeCurrentMemoryEvent.getAmlPath();
            long removeMemory = removeCurrentMemoryEvent.getMemory();
            long currentMemory = this.getCurrentMemory(currentAmlPath);
            this.setCurrentMemory(currentAmlPath, currentMemory -= removeMemory);
        } else if (this.oCurrentEvent instanceof JHtmlAmlGetPresentationElementsHandlerEvent) {
            JHtmlAmlGetPresentationElementsHandlerEvent getPresentationElementsEvent = (JHtmlAmlGetPresentationElementsHandlerEvent)this.oCurrentEvent;
            getPresentationElementsEvent.setJHtmlElements(this.oPresentationElements);
        }
    }

    private boolean isMemorySufficient(AmlPathInterface currentAmlPath) {
        boolean memorySufficient = true;
        try {
            long bytes = this.getCurrentNumberBytes(currentAmlPath);
            if (bytes > this.lMemory) {
                memorySufficient = false;
            }
        }
        catch (JHtmlElementIndexOutOfBoundsException ie) {
            memorySufficient = false;
        }
        return memorySufficient;
    }

    private long getCurrentNumberBytes(AmlPathInterface currentAmlPath) throws JHtmlElementIndexOutOfBoundsException {
        long bytes = this.getCurrentMemory(currentAmlPath);
        return bytes;
    }

    private boolean isElementSane(JHtmlElement jhtmlElement) {
        boolean elementSane = true;
        if (jhtmlElement == null) {
            elementSane = false;
        } else {
            elementSane = jhtmlElement.areJHtmlChildrenSane();
            if (elementSane && (elementSane = jhtmlElement.areJHtmlAttributesSane())) {
                int numberChildren = jhtmlElement.getNumberElements();
                int i = 0;
                while (i < numberChildren && elementSane) {
                    try {
                        JHtmlElement childJHtmlElement = jhtmlElement.jhtmlElementAt(i);
                        elementSane = this.isElementSane(childJHtmlElement);
                    }
                    catch (JHtmlElementIndexOutOfBoundsException ie) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }
        return elementSane;
    }

    private boolean isDeckSane() {
        boolean deckSane = true;
        try {
            JHtmlElement jhtmlElement = this.oJHtmlDecks.jhtmlElementAt(this.iActiveIndex);
            deckSane = this.isElementSane(jhtmlElement);
        }
        catch (JHtmlElementIndexOutOfBoundsException ie) {
            deckSane = false;
        }
        return deckSane;
    }

    private long getDefaultMemory() {
        return 0L;
    }

    private void resetCurrentMemory(AmlPathInterface currentAmlPath) {
        this.setCurrentMemory(currentAmlPath, this.getDefaultMemory());
    }

    private long getCurrentMemory(AmlPathInterface currentAmlPath) {
        int realm = currentAmlPath.getRealm();
        Long objMemory = (Long)this.oCurrentMemories.get(new Integer(realm));
        long memory = this.getDefaultMemory();
        if (objMemory != null) {
            memory = objMemory;
        }
        return memory;
    }

    private void setCurrentMemory(AmlPathInterface currentAmlPath, long memory) {
        int realm = currentAmlPath.getRealm();
        this.oCurrentMemories.put(new Integer(realm), new Long(memory));
    }
}

