/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.ihtml.amlhandlets;

import com.aligo.axml.AxmlForm;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.ihtml.IHtmlContainer;
import com.aligo.ihtml.IHtmlInput;
import com.aligo.ihtml.interfaces.IHtmlElement;
import com.aligo.interfaces.AligoEventInterface;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.ihtml.events.IHtmlAmlGetStyleIDStateHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.ihtml.exceptions.IHtmlAmlInsufficientMemoryException;
import com.aligo.modules.ihtml.handlets.IHtmlAmlStylePathHandlet;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlAddAttributeHandledHandletEvent;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlAddAttributeHandletEvent;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlXmlIHtmlElementHandletEvent;
import com.aligo.modules.ihtml.util.IHtmlAmlElementUtils;
import com.aligo.modules.ihtml.util.IHtmlEventDescriptor;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.XmlStyleID;
import com.aligo.modules.styles.interfaces.StyleIDInterface;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import java.util.Vector;

public class IHtmlAmlSeparatePidFromFormsUrlHandlet
extends IHtmlAmlStylePathHandlet {
    protected XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;
    XmlAttributeInterface xmlAttribute;
    IHtmlElement ihtmlElement;
    boolean style_id = false;
    private static final String HIDDEN = "hidden";
    private static final String URL = "url";
    private static final String QUESTION_MARK = "?";
    private static final String EQUAL_TO = "=";
    private static final String ACTION = "action";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String VALUE = "value";

    public Vector getEvents() {
        Vector<IHtmlEventDescriptor> events = new Vector<IHtmlEventDescriptor>();
        IHtmlEventDescriptor eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long ihtmlAmlStylePathRelevance() {
        long currentIHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof IHtmlAmlAddAttributeHandletEvent) {
            IHtmlAmlAddAttributeHandletEvent addAttributeEvent = (IHtmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            this.xmlAttribute = addAttributeEvent.getXmlAttribute();
            try {
                XmlStyleID xmlStyleID;
                String name;
                AligoEventInterface event = this.oCurrentEvent;
                IHtmlAmlXmlIHtmlElementHandletEvent getIHtmlElementEvent = new IHtmlAmlXmlIHtmlElementHandletEvent("Get", addAttributeEvent.getAmlPath(), addAttributeEvent.getXmlElement());
                this.oHandlerManager.postEventNow(getIHtmlElementEvent);
                this.oCurrentEvent = event;
                this.ihtmlElement = getIHtmlElementEvent.getIHtmlElement();
                IHtmlAmlGetStyleIDStateHandlerEvent getStyleIDStateEvent = new IHtmlAmlGetStyleIDStateHandlerEvent(addAttributeEvent.getAmlPath());
                this.oHandlerManager.postEventNow(getStyleIDStateEvent);
                StyleIDInterface styleID = getStyleIDStateEvent.getStyleID();
                if (styleID instanceof XmlStyleID && (name = (xmlStyleID = (XmlStyleID)styleID).getName()) != null && name.equals("IHtml_2")) {
                    this.style_id = true;
                }
                if (this.style_id && this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && this.ihtmlElement instanceof IHtmlContainer) {
                    this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                    if (this.oXmlAmlHandlerAttribute.getAmlAttributeName().toLowerCase().equals(HIDDEN)) {
                        currentIHtmlAmlStylePathRelevance = 20L;
                    }
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        return currentIHtmlAmlStylePathRelevance;
    }

    public void handleStylePathEvent() {
        if (this.oCurrentEvent instanceof IHtmlAmlAddAttributeHandletEvent) {
            boolean memoryError = false;
            try {
                if (this.style_id && this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && this.ihtmlElement instanceof IHtmlContainer) {
                    this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                    String amlAttributeName = this.oXmlAmlHandlerAttribute.getAmlAttributeName();
                    Object previousIHtmlElement = null;
                    AxmlElement axmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                    String amlAttributeValue = axmlElement.getAxmlAttributeValue(URL);
                    if (amlAttributeName.toLowerCase().equals(HIDDEN) && amlAttributeValue.indexOf(QUESTION_MARK) != -1) {
                        int position = amlAttributeValue.indexOf(QUESTION_MARK);
                        String formUrl = amlAttributeValue.substring(0, position);
                        String sessionIdInfo = amlAttributeValue.substring(position + 1);
                        if (sessionIdInfo.indexOf(EQUAL_TO) != -1) {
                            int eqPosition = sessionIdInfo.indexOf(EQUAL_TO);
                            IHtmlElement topElement = IHtmlAmlElementUtils.getTopIHtmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                            IHtmlElement containerElement = topElement.ihtmlElementAt(0);
                            IHtmlElement formElement = containerElement.ihtmlElementAt(0);
                            IHtmlAmlElementUtils.addIHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, formElement, ACTION, formUrl);
                            IHtmlInput input = new IHtmlInput();
                            input.addIHtmlAttribute(TYPE, HIDDEN);
                            input.addIHtmlAttribute(NAME, sessionIdInfo.substring(0, eqPosition));
                            input.addIHtmlAttribute(VALUE, sessionIdInfo.substring(eqPosition + 1));
                            IHtmlAmlElementUtils.addIHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, formElement, input);
                        }
                    }
                }
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (ex instanceof IHtmlAmlInsufficientMemoryException) {
                    AxmlElement amlElement;
                    memoryError = true;
                    AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
                    if (parentAmlPath != null && (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath)) instanceof AxmlForm) {
                        memoryError = false;
                    }
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
            if (memoryError) {
                try {
                    IHtmlAmlElementUtils.removeIHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.ihtmlElement.getIHtmlParentElement(), this.ihtmlElement);
                }
                catch (HandlerError he) {
                    // empty catch block
                }
                IHtmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new IHtmlAmlInsufficientMemoryHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(insufficientMemoryEvent);
            } else {
                IHtmlAmlAddAttributeHandledHandletEvent ihtmlAmlAddAttributeHandledHandletEvent = new IHtmlAmlAddAttributeHandledHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
                this.oHandlerManager.postEvent(ihtmlAmlAddAttributeHandledHandletEvent);
            }
        }
    }
}

