/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.ihtml.amlhandlets;

import com.aligo.axml.AxmlContainer;
import com.aligo.axml.AxmlTable;
import com.aligo.axml.AxmlTableCol;
import com.aligo.axml.AxmlTableRow;
import com.aligo.axml.AxmlText;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.ihtml.amlhandlets.events.IHtmlAmlCreateTableHandledHandletEvent;
import com.aligo.modules.ihtml.amlhandlets.events.IHtmlAmlCreateTableHandletEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlCreateNextChildHandledHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlCreateNextChildHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlCreateNextChildNoneHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlPathHandlerEvent;
import com.aligo.modules.ihtml.handlets.IHtmlAmlPathHandlet;
import com.aligo.modules.ihtml.util.IHtmlEventDescriptor;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class IHtmlAmlCreateTableHandlet
extends IHtmlAmlPathHandlet {
    private static final String REGULAR_ROWS = "regular";
    private static final String PERMANENT_ROWS = "permanent";
    private static final String REGULAR_ROW_INDEX = "rindex";
    private static final String PERMANENT_ROW_INDEX = "pindex";
    Hashtable tableState = new Hashtable();

    public Vector getEvents() {
        Vector<IHtmlEventDescriptor> events = new Vector<IHtmlEventDescriptor>();
        IHtmlEventDescriptor eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlCreateTableHandletEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlCreateNextChildHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long ihtmlAmlPathRelevance() {
        long currentIHtmlAmlPathRelevance = 0L;
        if (this.oCurrentEvent instanceof IHtmlAmlCreateTableHandletEvent) {
            currentIHtmlAmlPathRelevance = 20L;
        } else if (this.oCurrentEvent instanceof IHtmlAmlCreateNextChildHandlerEvent) {
            try {
                IHtmlAmlPathHandlerEvent pathHandlerEvent = (IHtmlAmlPathHandlerEvent)this.oCurrentEvent;
                this.oCurrentAmlPath = pathHandlerEvent.getAmlPath();
                AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
                int childPathIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, this.oCurrentAmlPath);
                AxmlElement parentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath);
                boolean postHighRelevance = false;
                if (parentAmlElement instanceof AxmlTable) {
                    if (childPathIndex == -1) {
                        postHighRelevance = true;
                    } else {
                        AxmlElement childAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                        if (childAmlElement instanceof AxmlTableRow) {
                            postHighRelevance = true;
                        }
                    }
                }
                if (postHighRelevance) {
                    currentIHtmlAmlPathRelevance = 30L;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        return currentIHtmlAmlPathRelevance;
    }

    public void handlePathEvent() {
        if (this.oCurrentEvent instanceof IHtmlAmlCreateTableHandletEvent) {
            try {
                AxmlElement axmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                if (axmlElement instanceof AxmlTable) {
                    if (this.oCurrentAmlPath == null) {
                        this.oHandlerLogger.logDebug("!!!CurrentAmlPath is null....");
                    }
                    String max = axmlElement.getAxmlAttributeValue("maxcolwidth");
                    AxmlContainer axmlContainer = new AxmlContainer();
                    axmlContainer.addAxmlAttribute("text", "&nbsp;");
                    int numElements = axmlElement.getNumberElements();
                    Hashtable<String, Serializable> tablePathState = new Hashtable<String, Serializable>();
                    Vector<Integer> permanentRows = new Vector<Integer>();
                    Vector<Integer> regularRows = new Vector<Integer>();
                    int i = 0;
                    while (i < numElements) {
                        AxmlElement child = axmlElement.axmlElementAt(i);
                        if (child instanceof AxmlTableRow) {
                            int numCols = child.getNumberElements();
                            int j = 0;
                            while (j < numCols) {
                                AxmlElement colChild;
                                int numColChilds;
                                AxmlElement col = child.axmlElementAt(j);
                                if (col instanceof AxmlTableCol && (numColChilds = col.getNumberElements()) > 0 && (colChild = col.axmlElementAt(0)) instanceof AxmlText) {
                                    String text = colChild.getAxmlAttributeValue("text");
                                    int textLength = text.length();
                                    int balenceLength = Integer.parseInt(max) - textLength;
                                    if (balenceLength > 0 && !(col.axmlElementAt(numColChilds - 1) instanceof AxmlContainer)) {
                                        int k = 0;
                                        while (k < balenceLength) {
                                            col.addAxmlElement(axmlContainer);
                                            ++k;
                                        }
                                    }
                                }
                                ++j;
                            }
                            String headerAttr = child.getAxmlAttributeValue("header");
                            if (headerAttr != null && headerAttr.equals("true")) {
                                permanentRows.add(0, new Integer(i));
                            } else {
                                String persistAttr = child.getAxmlAttributeValue("persist");
                                if (persistAttr != null && persistAttr.equals("true")) {
                                    permanentRows.add(new Integer(i));
                                } else {
                                    regularRows.add(new Integer(i));
                                }
                            }
                        }
                        ++i;
                    }
                    tablePathState.put(PERMANENT_ROWS, permanentRows);
                    tablePathState.put(REGULAR_ROWS, regularRows);
                    tablePathState.put(REGULAR_ROW_INDEX, new Integer(0));
                    tablePathState.put(PERMANENT_ROW_INDEX, new Integer(0));
                    this.tableState.put(this.oCurrentAmlPath.toString(), tablePathState);
                }
                IHtmlAmlCreateTableHandledHandletEvent event = new IHtmlAmlCreateTableHandledHandletEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(event);
            }
            catch (Exception ex) {
                this.oHandlerLogger.logDebug("Exception....." + ex.getMessage());
            }
        } else if (this.oCurrentEvent instanceof IHtmlAmlCreateNextChildHandlerEvent) {
            AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
            Hashtable tablePathState = (Hashtable)this.tableState.get(parentAmlPath.toString());
            Vector permanentRows = (Vector)tablePathState.get(PERMANENT_ROWS);
            Vector regularRows = (Vector)tablePathState.get(REGULAR_ROWS);
            int permIndex = (Integer)tablePathState.get(PERMANENT_ROW_INDEX);
            int regIndex = (Integer)tablePathState.get(REGULAR_ROW_INDEX);
            if (regIndex == 0 && permIndex < permanentRows.size()) {
                AmlPathInterface childAmlPath = AmlPathUtils.getChildPath(this.oHandlerManager, parentAmlPath, (Integer)permanentRows.elementAt(permIndex));
                tablePathState.put(PERMANENT_ROW_INDEX, new Integer(++permIndex));
                IHtmlAmlCreateNextChildHandledHandlerEvent createNextChildHandledEvent = new IHtmlAmlCreateNextChildHandledHandlerEvent(childAmlPath);
                this.oHandlerManager.postEvent(createNextChildHandledEvent);
            } else if (regIndex < regularRows.size()) {
                AmlPathInterface childAmlPath = AmlPathUtils.getChildPath(this.oHandlerManager, parentAmlPath, (Integer)regularRows.elementAt(regIndex));
                tablePathState.put(REGULAR_ROW_INDEX, new Integer(++regIndex));
                IHtmlAmlCreateNextChildHandledHandlerEvent createNextChildHandledEvent = new IHtmlAmlCreateNextChildHandledHandlerEvent(childAmlPath);
                this.oHandlerManager.postEvent(createNextChildHandledEvent);
            } else {
                IHtmlAmlCreateNextChildNoneHandlerEvent createNextChildNoneEvent = new IHtmlAmlCreateNextChildNoneHandlerEvent(parentAmlPath);
                this.oHandlerManager.postEvent(createNextChildNoneEvent);
            }
        }
    }
}

