/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.ihtml;

import com.aligo.ihtml.IHtmlElementCollection;
import com.aligo.ihtml.exceptions.IHtmlElementIndexOutOfBoundsException;
import com.aligo.ihtml.interfaces.IHtmlElement;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.ihtml.IHtmlAmlHandler;
import com.aligo.modules.ihtml.events.IHtmlAmlAddCurrentMemoryHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlCacheContentsHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlGetCurrentPageIDHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlGetIHtmlChildContainerStateHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlGetPageAllocatorMemoryHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlGetPresentationElementsHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlGetPreviousPageIDHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlGetRemainingMemoryHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlIsDeckSaneMemoryHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlIsSufficientMemoryHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlRemoveCurrentMemoryHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlResetCurrentMemoryHandlerEvent;
import com.aligo.modules.ihtml.util.IHtmlAmlElementUtils;
import com.aligo.modules.ihtml.util.IHtmlEventDescriptor;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.profile.interfaces.UAProfile;
import com.aligo.util.PageCache;
import com.aligo.util.URLUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class IHtmlAmlPresentationContainerHandler
extends IHtmlAmlHandler
implements PageAllocatorInterface {
    public static final long HIGH_RELEVANCE = 10L;
    public static final long RESERVE_MEM = 50L;
    private static final String ELEMENT_PREFIX = "agp";
    private static final String ELEMENT_REFERENCE = "#";
    private static final long DEFAULT_HIGHMEM = 1000L;
    private static final String EXISTS = "true";
    protected IHtmlElementCollection oIHtmlDecks = new IHtmlElementCollection();
    protected boolean bIsTransactionEvent;
    private Map oPageURLMap = Collections.synchronizedMap(new HashMap());
    private Map oPageIDMap = Collections.synchronizedMap(new HashMap());
    private Map oElementURLs = Collections.synchronizedMap(new HashMap());
    private Map oElementLinks = Collections.synchronizedMap(new HashMap());
    private int iCurrentElementNumber;
    private String sCurrentElementID;
    private String sPreviousElementID;
    private PageCache oPageCache;
    private String sCacheURL;
    private boolean bNavigatePrevious = false;
    private String sPreviousLabel = "Back";
    private String sNextLabel = "More";
    private long lMemory;
    private int iActiveIndex = 0;
    private int iBaseIndex = 0;
    private Hashtable oPresentationElements = new Hashtable();
    private Hashtable oCurrentMemories = new Hashtable();
    private int iCurrentRealm;

    public void init() {
        UAProfile uaProfile = this.getUAProfile();
        this.lMemory = (long)uaProfile.getPDUSize() - 50L;
        if (this.lMemory <= 0L) {
            this.defaultMemory();
        }
        if (this.oHandlerLogger.debugEnabled()) {
            this.oHandlerLogger.logDebug("lMemory = " + this.lMemory);
        }
        IHtmlAmlElementUtils.addPresentationElement(this.oPresentationElements, (IHtmlElement)this.oIHtmlDecks);
    }

    private void defaultMemory() {
        this.lMemory = 1000L;
    }

    public IHtmlElement getIHtmlDecks() {
        IHtmlElement ihtmlElement = null;
        try {
            ihtmlElement = this.oIHtmlDecks.ihtmlElementAt(0);
        }
        catch (IHtmlElementIndexOutOfBoundsException iHtmlElementIndexOutOfBoundsException) {
            // empty catch block
        }
        if (this.oHandlerLogger.debugEnabled()) {
            this.oHandlerLogger.logDebug("ihtmlElement =  " + this.oIHtmlDecks.getContents());
        }
        return ihtmlElement;
    }

    public void allocatePage() {
        int index = this.iBaseIndex + this.iActiveIndex;
        StringBuffer pageURL = new StringBuffer(this.sCacheURL);
        pageURL.append(index);
        this.oPageURLMap.put(new Integer(index), pageURL.toString());
        ++this.iActiveIndex;
    }

    private int getMIndex() {
        return this.iBaseIndex + this.iActiveIndex;
    }

    public void changeElement(String oldId, String newId) {
        String linkId;
        String url;
        String linkedId = this.getElementLink(oldId);
        if (linkedId != null) {
            this.oElementLinks.put(newId, linkedId);
            this.oElementLinks.remove(oldId);
        }
        if ((url = (String)this.oElementURLs.get(oldId)) != null) {
            url = URLUtils.composeAnchorURL(url, newId).toString();
            this.oElementURLs.put(newId, url);
            this.oElementURLs.remove(oldId);
        }
        if ((linkId = this.getElementIDLinkingTo(oldId)) != null) {
            this.oElementLinks.put(linkId, newId);
        }
        if (this.sCurrentElementID != null && this.sCurrentElementID.equals(oldId)) {
            this.sCurrentElementID = newId;
        }
        if (this.sPreviousElementID != null && this.sPreviousElementID.equals(oldId)) {
            this.sPreviousElementID = newId;
        }
    }

    public void allocateElement() {
        this.sPreviousElementID = this.sCurrentElementID;
        StringBuffer elementID = new StringBuffer(ELEMENT_PREFIX);
        elementID.append(this.iCurrentElementNumber);
        this.sCurrentElementID = elementID.toString();
        StringBuffer url = new StringBuffer(this.sCacheURL);
        url.append(this.getMIndex());
        url = URLUtils.composeAnchorURL(url.toString(), ELEMENT_PREFIX + this.iCurrentElementNumber);
        String currElementURL = url.toString();
        this.oElementURLs.put(this.sCurrentElementID, currElementURL);
        if (this.sPreviousElementID != null) {
            String prevElementURLPrefix;
            String currElementURLPrefix = currElementURL.substring(0, currElementURL.indexOf(this.sCurrentElementID));
            String prevElementURL = this.getElementURL(this.sPreviousElementID);
            if (prevElementURL != null && (prevElementURLPrefix = prevElementURL.substring(0, prevElementURL.indexOf(this.sPreviousElementID))).equals(currElementURLPrefix)) {
                this.oElementLinks.put(this.sPreviousElementID, this.sCurrentElementID);
            }
        }
        ++this.iCurrentElementNumber;
    }

    public String getElementLink(String elementID) {
        return (String)this.oElementLinks.get(elementID);
    }

    private String getElementIDLinkingTo(String elementID) {
        String result = null;
        Iterator keys = this.oElementLinks.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String tmpElementID = (String)this.oElementLinks.get(key);
            if (tmpElementID == null || !tmpElementID.equals(elementID)) continue;
            result = key;
        }
        return result;
    }

    public void deallocateElement(String elementID) {
        String elementLinkFrom = this.getElementIDLinkingTo(elementID);
        String elementLinkTo = (String)this.oElementLinks.get(elementID);
        if (elementLinkFrom != null && elementLinkTo != null) {
            this.oElementLinks.put(elementLinkFrom, elementLinkTo);
            if (this.sPreviousElementID != null && this.sPreviousElementID.equals(elementID) && this.sCurrentElementID.equals(elementLinkTo)) {
                this.sPreviousElementID = elementLinkFrom;
            }
        } else if (elementLinkFrom != null && elementLinkTo == null) {
            if (this.sPreviousElementID != null && this.sPreviousElementID.equals(elementLinkFrom) && this.sCurrentElementID.equals(elementID)) {
                this.sPreviousElementID = this.getElementIDLinkingTo(elementLinkFrom);
                this.sCurrentElementID = elementLinkFrom;
            }
        } else if (elementLinkFrom == null && elementLinkTo != null && this.sPreviousElementID != null && this.sPreviousElementID.equals(elementID) && this.sCurrentElementID.equals(elementLinkTo)) {
            this.sPreviousElementID = null;
            this.sCurrentElementID = elementLinkTo;
        }
        this.oElementLinks.remove(elementID);
        this.oElementURLs.remove(elementID);
    }

    private String createPageURL(int index) {
        StringBuffer pageURL = new StringBuffer(this.sCacheURL);
        pageURL.append(index);
        return pageURL.toString();
    }

    public boolean navigatePrevious() {
        return this.bNavigatePrevious;
    }

    public String getPreviousLabel() {
        return this.sPreviousLabel;
    }

    public void setPreviousLabel(String label) {
        this.sPreviousLabel = label;
    }

    public String getNextLabel() {
        return this.sNextLabel;
    }

    public void setNextLabel(String label) {
        this.sNextLabel = label;
    }

    public void assignPageID(String pageID) {
        int mIndex = this.iBaseIndex + this.iActiveIndex;
        this.oPageIDMap.put(pageID, new Integer(mIndex));
    }

    public String getPageURL(String pageID) {
        return (String)this.oPageURLMap.get((Integer)this.oPageIDMap.get(pageID));
    }

    public String getCurrentPageURL() {
        int mIndex = this.iBaseIndex + this.iActiveIndex;
        return this.createPageURL(mIndex);
    }

    public String getPreviousPageURL() {
        String prevURL = null;
        if (this.iActiveIndex > 0) {
            int mIndex = this.iBaseIndex + this.iActiveIndex - 1;
            prevURL = this.createPageURL(mIndex);
        }
        return prevURL;
    }

    public String getNextPageURL() {
        String prevURL = null;
        if (this.iActiveIndex > 0) {
            int mIndex = this.iBaseIndex + this.iActiveIndex + 1;
            prevURL = this.createPageURL(mIndex);
        }
        return prevURL;
    }

    public String getPreviousElementURL() {
        return this.getElementURL(this.sPreviousElementID);
    }

    public String getElementURL(String elementID) {
        String result = null;
        if (elementID != null && !elementID.equals("")) {
            result = (String)this.oElementURLs.get(elementID);
        }
        return result;
    }

    public String getCurrentElementURL() {
        return this.getElementURL(this.sCurrentElementID);
    }

    public boolean isElementLinkValid(String linkFromElementID, String linkToElementID) {
        String tmpElementID = this.getElementIDLinkingTo(linkToElementID);
        return linkFromElementID.equals(tmpElementID);
    }

    public String getCurrentElementID() {
        return this.sCurrentElementID;
    }

    public String getPreviousElementID() {
        return this.sPreviousElementID;
    }

    public String getCacheURL() {
        return this.sCacheURL;
    }

    public void setCacheURL(String cacheURL) {
        this.sCacheURL = cacheURL;
    }

    public PageCache getPageCache() {
        return this.oPageCache;
    }

    public void setPageCache(PageCache pageCache) {
        this.oPageCache = pageCache;
    }

    private int getCurrentPageID() {
        return this.iActiveIndex + this.iBaseIndex;
    }

    private int getPreviousPageID() {
        int prevId = -1;
        if (this.iActiveIndex > 0) {
            prevId = this.iActiveIndex + this.iBaseIndex - 1;
        }
        return prevId;
    }

    public Vector getEvents() {
        Vector<IHtmlEventDescriptor> events = new Vector<IHtmlEventDescriptor>();
        IHtmlEventDescriptor eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlGetIHtmlChildContainerStateHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlIsSufficientMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlIsDeckSaneMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlGetRemainingMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlCacheContentsHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlGetCurrentPageIDHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlGetPreviousPageIDHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlGetPageAllocatorMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlResetCurrentMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlAddCurrentMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlRemoveCurrentMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlGetPresentationElementsHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long ihtmlAmlRelevance() {
        long currentIHtmlAmlRelevance = 0L;
        if (this.oCurrentEvent instanceof IHtmlAmlGetIHtmlChildContainerStateHandlerEvent) {
            IHtmlAmlGetIHtmlChildContainerStateHandlerEvent getIHtmlChildContainerStateHandlerEvent = (IHtmlAmlGetIHtmlChildContainerStateHandlerEvent)this.oCurrentEvent;
            AmlPathInterface amlPath = getIHtmlChildContainerStateHandlerEvent.getAmlPath();
            if (amlPath == null) {
                currentIHtmlAmlRelevance = 10L;
            }
        } else if (this.oCurrentEvent instanceof IHtmlAmlIsSufficientMemoryHandlerEvent) {
            currentIHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof IHtmlAmlIsDeckSaneMemoryHandlerEvent) {
            currentIHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof IHtmlAmlGetRemainingMemoryHandlerEvent) {
            currentIHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof IHtmlAmlCacheContentsHandlerEvent) {
            currentIHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof IHtmlAmlGetCurrentPageIDHandlerEvent) {
            currentIHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof IHtmlAmlGetPreviousPageIDHandlerEvent) {
            currentIHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof IHtmlAmlGetPageAllocatorMemoryHandlerEvent) {
            currentIHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof IHtmlAmlResetCurrentMemoryHandlerEvent) {
            currentIHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof IHtmlAmlAddCurrentMemoryHandlerEvent) {
            currentIHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof IHtmlAmlRemoveCurrentMemoryHandlerEvent) {
            currentIHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof IHtmlAmlGetPresentationElementsHandlerEvent) {
            currentIHtmlAmlRelevance = 10L;
        }
        return currentIHtmlAmlRelevance;
    }

    public void handleEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof IHtmlAmlGetIHtmlChildContainerStateHandlerEvent) {
            IHtmlAmlGetIHtmlChildContainerStateHandlerEvent ihtmlAmlIHtmlChildContainerStateHandlerEvent = (IHtmlAmlGetIHtmlChildContainerStateHandlerEvent)this.oCurrentEvent;
            ihtmlAmlIHtmlChildContainerStateHandlerEvent.setIHtmlElement(this.oIHtmlDecks);
        } else if (this.oCurrentEvent instanceof IHtmlAmlIsSufficientMemoryHandlerEvent) {
            IHtmlAmlIsSufficientMemoryHandlerEvent isSufficientMemoryEvent = (IHtmlAmlIsSufficientMemoryHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = isSufficientMemoryEvent.getAmlPath();
            boolean memorySufficient = this.isMemorySufficient(currentAmlPath);
            isSufficientMemoryEvent.setSufficient(memorySufficient);
        } else if (this.oCurrentEvent instanceof IHtmlAmlIsDeckSaneMemoryHandlerEvent) {
            IHtmlAmlIsDeckSaneMemoryHandlerEvent isDeckSaneEvent = (IHtmlAmlIsDeckSaneMemoryHandlerEvent)this.oCurrentEvent;
            boolean deckSane = this.isDeckSane();
            isDeckSaneEvent.setSane(deckSane);
        } else if (this.oCurrentEvent instanceof IHtmlAmlGetRemainingMemoryHandlerEvent) {
            IHtmlAmlGetRemainingMemoryHandlerEvent remainingMemoryEvent = (IHtmlAmlGetRemainingMemoryHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = remainingMemoryEvent.getAmlPath();
            long remainingMemory = 0L;
            try {
                long bytes = this.getCurrentNumberBytes(currentAmlPath);
                if (this.lMemory > bytes) {
                    remainingMemory = this.lMemory - bytes;
                }
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug("20040213.1 Number bytes remaining = " + remainingMemory);
                }
            }
            catch (IHtmlElementIndexOutOfBoundsException ie) {
                // empty catch block
            }
            remainingMemoryEvent.setNumberBytes(remainingMemory);
        } else if (this.oCurrentEvent instanceof IHtmlAmlCacheContentsHandlerEvent) {
            this.allocatePage();
            int i = 0;
            while (i < this.iActiveIndex) {
                int index = this.iBaseIndex + i;
                try {
                    this.oPageCache.putIndexedPage(Integer.toString(index), this.oIHtmlDecks.ihtmlElementAt(i).getContents());
                }
                catch (IHtmlElementIndexOutOfBoundsException ie) {
                    // empty catch block
                }
                ++i;
            }
        } else if (this.oCurrentEvent instanceof IHtmlAmlGetCurrentPageIDHandlerEvent) {
            IHtmlAmlGetCurrentPageIDHandlerEvent currentPageIDEvent = (IHtmlAmlGetCurrentPageIDHandlerEvent)this.oCurrentEvent;
            currentPageIDEvent.setID(new Integer(this.getCurrentPageID()).toString());
        } else if (this.oCurrentEvent instanceof IHtmlAmlGetPreviousPageIDHandlerEvent) {
            IHtmlAmlGetPreviousPageIDHandlerEvent previousPageIDEvent = (IHtmlAmlGetPreviousPageIDHandlerEvent)this.oCurrentEvent;
            previousPageIDEvent.setID(new Integer(this.getPreviousPageID()).toString());
        } else if (this.oCurrentEvent instanceof IHtmlAmlGetPageAllocatorMemoryHandlerEvent) {
            IHtmlAmlGetPageAllocatorMemoryHandlerEvent getPageAllocatorEvent = (IHtmlAmlGetPageAllocatorMemoryHandlerEvent)this.oCurrentEvent;
            getPageAllocatorEvent.setPageAllocator(this);
        } else if (this.oCurrentEvent instanceof IHtmlAmlResetCurrentMemoryHandlerEvent) {
            AmlPathInterface currentAmlPath = ((IHtmlAmlResetCurrentMemoryHandlerEvent)this.oCurrentEvent).getAmlPath();
            this.resetCurrentMemory(currentAmlPath);
        } else if (this.oCurrentEvent instanceof IHtmlAmlAddCurrentMemoryHandlerEvent) {
            IHtmlAmlAddCurrentMemoryHandlerEvent addCurrentMemoryEvent = (IHtmlAmlAddCurrentMemoryHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = addCurrentMemoryEvent.getAmlPath();
            long addMemory = addCurrentMemoryEvent.getMemory();
            long currentMemory = this.getCurrentMemory(currentAmlPath);
            this.setCurrentMemory(currentAmlPath, currentMemory += addMemory);
        } else if (this.oCurrentEvent instanceof IHtmlAmlRemoveCurrentMemoryHandlerEvent) {
            IHtmlAmlRemoveCurrentMemoryHandlerEvent removeCurrentMemoryEvent = (IHtmlAmlRemoveCurrentMemoryHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = removeCurrentMemoryEvent.getAmlPath();
            long removeMemory = removeCurrentMemoryEvent.getMemory();
            long currentMemory = this.getCurrentMemory(currentAmlPath);
            this.setCurrentMemory(currentAmlPath, currentMemory -= removeMemory);
        } else if (this.oCurrentEvent instanceof IHtmlAmlGetPresentationElementsHandlerEvent) {
            IHtmlAmlGetPresentationElementsHandlerEvent getPresentationElementsEvent = (IHtmlAmlGetPresentationElementsHandlerEvent)this.oCurrentEvent;
            getPresentationElementsEvent.setIHtmlElements(this.oPresentationElements);
        }
    }

    private boolean isMemorySufficient(AmlPathInterface currentAmlPath) {
        boolean memorySufficient = true;
        try {
            long bytes = this.getCurrentNumberBytes(currentAmlPath);
            if (bytes > this.lMemory) {
                memorySufficient = false;
            }
        }
        catch (IHtmlElementIndexOutOfBoundsException ie) {
            memorySufficient = false;
        }
        return memorySufficient;
    }

    private long getCurrentNumberBytes(AmlPathInterface currentAmlPath) throws IHtmlElementIndexOutOfBoundsException {
        long bytes = this.getCurrentMemory(currentAmlPath);
        return bytes;
    }

    private boolean isElementSane(IHtmlElement ihtmlElement) {
        boolean elementSane = true;
        if (ihtmlElement == null) {
            elementSane = false;
        } else {
            elementSane = ihtmlElement.areIHtmlChildrenSane();
            if (elementSane && (elementSane = ihtmlElement.areIHtmlAttributesSane())) {
                int numberChildren = ihtmlElement.getNumberElements();
                int i = 0;
                while (i < numberChildren && elementSane) {
                    try {
                        IHtmlElement childIHtmlElement = ihtmlElement.ihtmlElementAt(i);
                        elementSane = this.isElementSane(childIHtmlElement);
                    }
                    catch (IHtmlElementIndexOutOfBoundsException ie) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }
        return elementSane;
    }

    private boolean isDeckSane() {
        boolean deckSane = true;
        try {
            IHtmlElement ihtmlElement = this.oIHtmlDecks.ihtmlElementAt(this.iActiveIndex);
            deckSane = this.isElementSane(ihtmlElement);
        }
        catch (IHtmlElementIndexOutOfBoundsException ie) {
            deckSane = false;
        }
        return deckSane;
    }

    private long getDefaultMemory() {
        return 0L;
    }

    private void resetCurrentMemory(AmlPathInterface currentAmlPath) {
        this.setCurrentMemory(currentAmlPath, this.getDefaultMemory());
    }

    private long getCurrentMemory(AmlPathInterface currentAmlPath) {
        int realm = currentAmlPath.getRealm();
        Long objMemory = (Long)this.oCurrentMemories.get(new Integer(realm));
        long memory = this.getDefaultMemory();
        if (objMemory != null) {
            memory = objMemory;
        }
        return memory;
    }

    private void setCurrentMemory(AmlPathInterface currentAmlPath, long memory) {
        int realm = currentAmlPath.getRealm();
        this.oCurrentMemories.put(new Integer(realm), new Long(memory));
    }
}

