/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.ihtml;

import com.aligo.axml.AxmlChoice;
import com.aligo.axml.AxmlOption;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.axml.interfaces.AxmlExtensionCollectionInterface;
import com.aligo.axml.interfaces.AxmlExtensionInterface;
import com.aligo.extensions.style.StyleExtension;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.ihtml.IHtmlAmlPathHandler;
import com.aligo.modules.ihtml.events.IHtmlAmlGetStyleComponentHandledHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlGetStyleComponentHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlSetStyleIDStateHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlSetTopStyleElementStateHandlerEvent;
import com.aligo.modules.ihtml.util.IHtmlEventDescriptor;
import com.aligo.modules.ihtml.util.exceptions.IHtmlAmlGetRootElementFailedException;
import com.aligo.modules.maps.MapPath;
import com.aligo.modules.maps.MapPathComponent;
import com.aligo.modules.maps.MapSourceComponent;
import com.aligo.modules.maps.interfaces.MapContainerInterface;
import com.aligo.modules.maps.interfaces.MapInterface;
import com.aligo.modules.maps.interfaces.MapPathInterface;
import com.aligo.modules.maps.interfaces.MapSourceComponentInterface;
import com.aligo.modules.paths.exceptions.AmlPathIndexOutOfBoundsException;
import com.aligo.modules.paths.interfaces.AmlPathComponentInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.StyleComponent;
import com.aligo.modules.styles.XmlStyleID;
import com.aligo.modules.styles.interfaces.StyleComponentInterface;
import com.aligo.modules.styles.interfaces.StyleIDInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.parsing.DOMParser;
import com.aligo.profile.interfaces.UAProfile;
import com.aligo.profile.interfaces.UAQueryInterface;
import java.util.Enumeration;
import java.util.Vector;

public class IHtmlAmlGetStyleComponentHandler
extends IHtmlAmlPathHandler {
    private static final String UNKNOWN_STYLE_ID = "UNKNOWN";
    private static final String CHOICE = "com.aligo.axml.AxmlChoice";
    private static final String IHTML = "IHtml";
    private static final String IHTML_1 = "IHtml-1";
    private MapContainerInterface oMapContainer;

    public Vector getEvents() {
        Vector<IHtmlEventDescriptor> events = new Vector<IHtmlEventDescriptor>();
        IHtmlEventDescriptor eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlGetStyleComponentHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long ihtmlAmlPathRelevance() {
        long currentIHtmlAmlPathRelevance = 0L;
        if (this.oCurrentEvent instanceof IHtmlAmlGetStyleComponentHandlerEvent) {
            currentIHtmlAmlPathRelevance = 20L;
        }
        return currentIHtmlAmlPathRelevance;
    }

    public void setMapContainer(MapContainerInterface mapContainer) {
        this.oMapContainer = mapContainer;
    }

    public MapContainerInterface getMapContainer() {
        return this.oMapContainer;
    }

    private MapPathInterface getMapPath(AxmlElement amlElement, AmlPathInterface amlPath) throws AmlPathIndexOutOfBoundsException {
        AxmlElement currentAmlElement = amlElement;
        int indexComponent = 0;
        int numberComponents = amlPath.getNumberAmlPathComponents();
        MapPath mapPath = new MapPath();
        String name = amlElement.getName();
        MapPathComponent mapPathComponent = new MapPathComponent(name);
        mapPath.addMapPathComponent(mapPathComponent);
        while (indexComponent < numberComponents) {
            AmlPathComponentInterface amlPathComponent = amlPath.getAmlPathComponentAt(indexComponent);
            int pathIndex = amlPathComponent.getPathIndex();
            currentAmlElement = currentAmlElement.axmlElementAt(pathIndex);
            name = currentAmlElement.getName();
            mapPathComponent = new MapPathComponent(name);
            mapPath.addMapPathComponent(mapPathComponent);
            ++indexComponent;
        }
        return mapPath;
    }

    private Vector getStyleExtensions(AxmlExtensionCollectionInterface extensions) {
        Vector<StyleExtension> styleExtensions = new Vector<StyleExtension>();
        if (extensions != null) {
            int numberExtensions = extensions.getNumberExtensions();
            int i = 0;
            while (i < numberExtensions) {
                try {
                    AxmlExtensionInterface extension = extensions.extensionAt(i);
                    if (extension instanceof StyleExtension) {
                        styleExtensions.add((StyleExtension)extension);
                    }
                }
                catch (ArrayIndexOutOfBoundsException ae) {
                    // empty catch block
                }
                ++i;
            }
        }
        return styleExtensions;
    }

    private StyleComponentInterface getStyleFromElement(AxmlElement amlElement, MapSourceComponentInterface mapSourceComponent) {
        StyleComponentInterface styleComponent = null;
        AxmlExtensionCollectionInterface extensions = amlElement.getExtensions();
        Vector styleExtensions = this.getStyleExtensions(extensions);
        StyleExtension styleExtension = null;
        boolean match = false;
        int i = 0;
        while (i < styleExtensions.size()) {
            styleExtension = (StyleExtension)styleExtensions.elementAt(i);
            UAQueryInterface uaQuery = styleExtension.getUAQuery();
            UAProfile uaProfile = this.getUAProfile();
            if (uaQuery != null) {
                if (uaQuery.match(uaProfile)) {
                    match = true;
                    break;
                }
            } else {
                String device = styleExtension.getDevice();
                if (device != null) {
                    String amlID = uaProfile.getAmlID();
                    if (amlID.equals(device)) {
                        match = true;
                        break;
                    }
                } else {
                    String xmlID;
                    String protocol = styleExtension.getProtocol();
                    if (protocol != null && (xmlID = uaProfile.getXmlID()).equals(protocol)) {
                        match = true;
                        break;
                    }
                }
            }
            ++i;
        }
        if (match) {
            String styleId = styleExtension.getStyleId();
            if (styleId != null) {
                boolean foundMap = false;
                Enumeration maps = this.oMapContainer.getMaps();
                while (maps.hasMoreElements() && !foundMap) {
                    XmlStyleID itXmlStyleID;
                    String itId;
                    StyleComponentInterface itStyleComponent;
                    StyleIDInterface itStyleID;
                    MapInterface map = (MapInterface)maps.nextElement();
                    MapSourceComponentInterface itMapSourceComponent = map.getMapSourceComponent();
                    if (!itMapSourceComponent.isEqual(mapSourceComponent) || !((itStyleID = (itStyleComponent = map.getStyleComponentInterface()).getStyleID()) instanceof XmlStyleID) || !(itId = (itXmlStyleID = (XmlStyleID)itStyleID).getName()).equals(styleId)) continue;
                    styleComponent = itStyleComponent;
                    foundMap = true;
                }
            } else {
                String inlineStyle = styleExtension.getInlineStyle();
                if (inlineStyle != null) {
                    styleComponent = this.getStyleComponentInterface(inlineStyle);
                }
            }
        }
        return styleComponent;
    }

    private StyleComponentInterface getStyleComponentInterface(String style) {
        StyleComponent styleComponent = null;
        String completeStyle = "<Style><StyleID>UNKNOWN</StyleID><Representation>" + style + "</Representation></Style>";
        try {
            DOMParser parser = new DOMParser();
            StyleComponent itStyleComponent = new StyleComponent();
            itStyleComponent.fromXml(parser.parse(completeStyle.toCharArray()).getDocumentElement());
            styleComponent = itStyleComponent;
        }
        catch (Exception ex) {
            this.oHandlerLogger.logError(ex);
        }
        return styleComponent;
    }

    private boolean isChoiceMultiple(AxmlElement amlElement) {
        boolean multiple = false;
        String mode = amlElement.getAxmlAttributeValue("mode");
        if (mode != null && mode.equals("multiple")) {
            multiple = true;
        }
        return multiple;
    }

    private boolean isIHtml1() {
        boolean ihtml1 = false;
        String amlId = this.oUAProfile.getAmlID();
        if (amlId == null || amlId.equals(IHTML_1) || amlId.equals(IHTML)) {
            ihtml1 = true;
        }
        return ihtml1;
    }

    private StyleComponentInterface getStyleFromContainer(AmlPathInterface currentAmlPath, AxmlElement currentAmlElement, MapSourceComponentInterface mapSourceComponent) throws IHtmlAmlGetRootElementFailedException, AmlPathIndexOutOfBoundsException {
        StyleComponentInterface styleComponent = null;
        if (this.isIHtml1()) {
            AxmlElement parentAmlElement;
            AmlPathInterface parentAmlPath;
            if (currentAmlElement instanceof AxmlChoice) {
                if (this.isChoiceMultiple(currentAmlElement)) {
                    styleComponent = this.getStyleComponentInterface("<Container cache=\"aml:handler\" persist=\"aml:handler\" child-container=\"aml:child\"/>");
                }
            } else if (currentAmlElement instanceof AxmlOption && (parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath)) != null && (parentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath)) != null && parentAmlElement instanceof AxmlChoice && this.isChoiceMultiple(parentAmlElement)) {
                styleComponent = this.getStyleComponentInterface("<Input type=\"checkbox\" name=\"..:name\" value=\".:value\" selected=\"aml:handler\"/> <Container child-container=\"aml:child\"/> <Br/>");
            }
        }
        if (styleComponent == null) {
            AxmlElement rootAmlElement = AmlPathUtils.getRootAmlElement(this.oHandlerManager);
            MapPathInterface mapPath = this.getMapPath(rootAmlElement, currentAmlPath);
            styleComponent = this.oMapContainer.getStyleComponent(mapPath, mapSourceComponent, this.oUAProfile);
        }
        return styleComponent;
    }

    public void handlePathEvent() {
        if (this.oCurrentEvent instanceof IHtmlAmlGetStyleComponentHandlerEvent) {
            try {
                AxmlElement currentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                String name = currentAmlElement.getName();
                MapSourceComponent mapSourceComponent = new MapSourceComponent(name);
                StyleComponentInterface styleComponent = this.getStyleFromElement(currentAmlElement, mapSourceComponent);
                if (styleComponent == null) {
                    styleComponent = this.getStyleFromContainer(this.oCurrentAmlPath, currentAmlElement, mapSourceComponent);
                }
                StyleIDInterface styleID = styleComponent.getStyleID();
                IHtmlAmlSetStyleIDStateHandlerEvent setStyleIDStateEvent = new IHtmlAmlSetStyleIDStateHandlerEvent(this.oCurrentAmlPath, styleID);
                this.oHandlerManager.postEventNow(setStyleIDStateEvent);
                XmlElementInterface styleXmlElement = styleComponent.getXmlElement();
                IHtmlAmlSetTopStyleElementStateHandlerEvent setTopStyleElementStateEvent = new IHtmlAmlSetTopStyleElementStateHandlerEvent(this.oCurrentAmlPath, styleXmlElement);
                this.oHandlerManager.postEventNow(setTopStyleElementStateEvent);
                IHtmlAmlGetStyleComponentHandledHandlerEvent getStyleComponentHandledHandlerEvent = new IHtmlAmlGetStyleComponentHandledHandlerEvent(this.oCurrentAmlPath, styleXmlElement);
                this.oHandlerManager.postEvent(getStyleComponentHandledHandlerEvent);
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
    }
}

