/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.html.state;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.html.HtmlElementCollection;
import com.aligo.html.exceptions.HtmlElementCannotBeAddedException;
import com.aligo.html.exceptions.HtmlElementNotFoundException;
import com.aligo.html.interfaces.HtmlElement;
import com.aligo.modules.html.state.exceptions.HtmlAmlStateKeeperAttributeNotFoundException;
import com.aligo.modules.html.state.exceptions.HtmlAmlStateKeeperElementNotFoundException;
import com.aligo.modules.html.state.interfaces.HtmlAmlStateKeeperInterface;
import com.aligo.modules.styles.interfaces.StyleIDInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HtmlAmlStateKeeper
implements HtmlAmlStateKeeperInterface {
    private AxmlElement oAmlElement;
    private HtmlElement oHtmlChildContainerElement;
    private HtmlElement oHtmlElements = new HtmlElementCollection();
    private HtmlElement oHtmlTopElement;
    private HtmlElement oHtmlEndElements = new HtmlElementCollection();
    private int iHtmlChildPosition = -1;
    private Hashtable oHtmlAttrTable = new Hashtable();
    private HtmlElement oHtmlTextElements = new HtmlElementCollection();
    private XmlElementInterface oTopStyleElement;
    private StyleIDInterface oStyleID;

    public void setAmlElement(AxmlElement amlElement) {
        this.oAmlElement = amlElement;
    }

    public AxmlElement getAmlElement() {
        return this.oAmlElement;
    }

    public void setHtmlChildContainerElement(HtmlElement htmlChildContainerElement) {
        this.oHtmlChildContainerElement = htmlChildContainerElement;
    }

    public HtmlElement getHtmlChildContainerElement() {
        return this.oHtmlChildContainerElement;
    }

    public void setHtmlChildPosition(int htmlChildPosition) {
        this.iHtmlChildPosition = htmlChildPosition;
    }

    public int getHtmlChildPosition() {
        return this.iHtmlChildPosition;
    }

    public void setTopHtmlElement(HtmlElement htmlTopElement) {
        this.oHtmlTopElement = htmlTopElement;
    }

    public HtmlElement getTopHtmlElement() {
        return this.oHtmlTopElement;
    }

    public void addEndHtmlElement(HtmlElement htmlEndElement) {
        try {
            this.oHtmlEndElements.addHtmlElement(htmlEndElement);
        }
        catch (HtmlElementCannotBeAddedException htmlElementCannotBeAddedException) {
            // empty catch block
        }
    }

    public HtmlElement getEndHtmlElements() {
        return this.oHtmlEndElements;
    }

    public void removeAllEndHtmlElements() {
        this.oHtmlEndElements.removeAll();
    }

    public void removeEndHtmlElement(HtmlElement htmlElement) throws HtmlAmlStateKeeperElementNotFoundException {
        try {
            this.oHtmlEndElements.removeHtmlElement(htmlElement);
        }
        catch (HtmlElementNotFoundException we) {
            throw new HtmlAmlStateKeeperElementNotFoundException();
        }
    }

    public void addHtmlElement(HtmlElement htmlElement) {
        try {
            this.oHtmlElements.addHtmlElement(htmlElement);
        }
        catch (HtmlElementCannotBeAddedException htmlElementCannotBeAddedException) {
            // empty catch block
        }
    }

    public HtmlElement getHtmlElements() {
        return this.oHtmlElements;
    }

    public void removeAllHtmlElements() {
        this.oHtmlElements.removeAll();
    }

    public void removeHtmlElement(HtmlElement htmlElement) throws HtmlAmlStateKeeperElementNotFoundException {
        try {
            this.oHtmlElements.removeHtmlElement(htmlElement);
        }
        catch (HtmlElementNotFoundException we) {
            throw new HtmlAmlStateKeeperElementNotFoundException();
        }
    }

    private Vector createHtmlAttributeVector(HtmlElement htmlElement) {
        Vector attributeVector = new Vector();
        this.oHtmlAttrTable.put(htmlElement, attributeVector);
        return attributeVector;
    }

    public void addHtmlAttribute(HtmlElement htmlElement, String attrName) {
        Vector attributeVector = (Vector)this.oHtmlAttrTable.get(htmlElement);
        if (attributeVector == null) {
            attributeVector = this.createHtmlAttributeVector(htmlElement);
        }
        attributeVector.addElement(attrName);
    }

    public HtmlElement getHtmlAttributeElements() {
        HtmlElementCollection attributeElements = new HtmlElementCollection();
        Enumeration keys = this.oHtmlAttrTable.keys();
        while (keys.hasMoreElements()) {
            try {
                HtmlElement htmlElement = (HtmlElement)keys.nextElement();
                attributeElements.addHtmlElement(htmlElement);
            }
            catch (HtmlElementCannotBeAddedException htmlElementCannotBeAddedException) {
                // empty catch block
            }
        }
        return attributeElements;
    }

    public Enumeration getHtmlAttributes(HtmlElement htmlElement) throws HtmlAmlStateKeeperElementNotFoundException {
        Vector attributeVector = (Vector)this.oHtmlAttrTable.get(htmlElement);
        if (attributeVector == null) {
            throw new HtmlAmlStateKeeperElementNotFoundException();
        }
        return attributeVector.elements();
    }

    public void removeAllHtmlAttributes() {
        this.oHtmlAttrTable.clear();
    }

    public void removeHtmlAttributes(HtmlElement htmlElement) throws HtmlAmlStateKeeperElementNotFoundException {
        Vector attributeVector = (Vector)this.oHtmlAttrTable.get(htmlElement);
        if (attributeVector == null) {
            throw new HtmlAmlStateKeeperElementNotFoundException();
        }
        this.oHtmlAttrTable.remove(htmlElement);
    }

    public void removeHtmlAttribute(HtmlElement htmlElement, String htmlAttrName) throws HtmlAmlStateKeeperElementNotFoundException, HtmlAmlStateKeeperAttributeNotFoundException {
        Vector attributeVector = (Vector)this.oHtmlAttrTable.get(htmlElement);
        if (attributeVector == null) {
            throw new HtmlAmlStateKeeperElementNotFoundException();
        }
        boolean present = attributeVector.remove(htmlAttrName);
        if (!present) {
            throw new HtmlAmlStateKeeperAttributeNotFoundException();
        }
    }

    public void addHtmlText(HtmlElement htmlElement) {
        try {
            this.oHtmlTextElements.addHtmlElement(htmlElement);
        }
        catch (HtmlElementCannotBeAddedException htmlElementCannotBeAddedException) {
            // empty catch block
        }
    }

    public HtmlElement getHtmlTextElements() {
        return this.oHtmlTextElements;
    }

    public void removeAllHtmlTextElements() {
        this.oHtmlTextElements.removeAll();
    }

    public void removeHtmlText(HtmlElement htmlElement) throws HtmlAmlStateKeeperElementNotFoundException {
        try {
            this.oHtmlTextElements.removeHtmlElement(htmlElement);
        }
        catch (HtmlElementNotFoundException we) {
            throw new HtmlAmlStateKeeperElementNotFoundException();
        }
    }

    public void setTopStyleElement(XmlElementInterface topStyleElement) {
        this.oTopStyleElement = topStyleElement;
    }

    public XmlElementInterface getTopStyleElement() {
        return this.oTopStyleElement;
    }

    public void setStyleID(StyleIDInterface styleID) {
        this.oStyleID = styleID;
    }

    public StyleIDInterface getStyleID() {
        return this.oStyleID;
    }
}

