/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.html.amlhandlets;

import com.aligo.axml.AxmlForm;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.html.HtmlFont;
import com.aligo.html.HtmlSelect;
import com.aligo.html.interfaces.HtmlElement;
import com.aligo.interfaces.AligoEventInterface;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.html.events.HtmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.html.exceptions.HtmlAmlInsufficientMemoryException;
import com.aligo.modules.html.handlets.HtmlAmlStylePathHandlet;
import com.aligo.modules.html.handlets.events.HtmlAmlAddAttributeHandledHandletEvent;
import com.aligo.modules.html.handlets.events.HtmlAmlAddAttributeHandletEvent;
import com.aligo.modules.html.handlets.events.HtmlAmlXmlHtmlElementHandletEvent;
import com.aligo.modules.html.util.HtmlAmlElementUtils;
import com.aligo.modules.html.util.HtmlEventDescriptor;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import java.util.Vector;

public class HtmlAmlChoiceModeHandlet
extends HtmlAmlStylePathHandlet {
    private static final String MULTIPLE = "multiple";
    private static final String SINGLE = "single";
    private static final String MODE = "mode";
    protected XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;
    XmlAttributeInterface xmlAttribute;
    HtmlElement htmlElement;

    public Vector getEvents() {
        Vector<HtmlEventDescriptor> events = new Vector<HtmlEventDescriptor>();
        HtmlEventDescriptor eventDescriptor = new HtmlEventDescriptor("HtmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long htmlAmlStylePathRelevance() {
        long currentHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof HtmlAmlAddAttributeHandletEvent) {
            HtmlAmlAddAttributeHandletEvent addAttributeEvent = (HtmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            this.xmlAttribute = addAttributeEvent.getXmlAttribute();
            try {
                AligoEventInterface event = this.oCurrentEvent;
                HtmlAmlXmlHtmlElementHandletEvent getHtmlElementEvent = new HtmlAmlXmlHtmlElementHandletEvent("Get", addAttributeEvent.getAmlPath(), addAttributeEvent.getXmlElement());
                this.oHandlerManager.postEventNow(getHtmlElementEvent);
                this.oCurrentEvent = event;
                this.htmlElement = getHtmlElementEvent.getHtmlElement();
                if (this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && this.htmlElement instanceof HtmlSelect) {
                    currentHtmlAmlStylePathRelevance = 20L;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        return currentHtmlAmlStylePathRelevance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleStylePathEvent() {
        boolean memoryError;
        block10: {
            if (!(this.oCurrentEvent instanceof HtmlAmlAddAttributeHandletEvent)) return;
            memoryError = false;
            try {
                if (!(this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface) || !(this.htmlElement instanceof HtmlSelect)) break block10;
                this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                String amlAttributeName = this.oXmlAmlHandlerAttribute.getAmlAttributeName();
                HtmlElement htmlParentElement = this.htmlElement.getHtmlParentElement();
                int position = -1;
                if (!amlAttributeName.toLowerCase().equals(MODE)) break block10;
                AxmlElement axmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                String amlAttributeValue = axmlElement.getAxmlAttributeValue(amlAttributeName);
                if (amlAttributeValue.toLowerCase().indexOf(MULTIPLE) != -1) {
                    HtmlAmlElementUtils.addHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, this.htmlElement, MULTIPLE, "true");
                } else if (amlAttributeValue.toLowerCase().indexOf(SINGLE) == -1) {
                    // empty if block
                }
            }
            catch (HandlerError he) {
                AxmlElement amlElement;
                Exception ex = he.getException();
                if (!(ex instanceof HtmlAmlInsufficientMemoryException)) break block10;
                memoryError = true;
                AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
                if (parentAmlPath != null && (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath)) instanceof AxmlForm) {
                    memoryError = false;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        if (!memoryError) {
            HtmlAmlAddAttributeHandledHandletEvent htmlAmlAddAttributeHandledHandletEvent = new HtmlAmlAddAttributeHandledHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
            this.oHandlerManager.postEvent(htmlAmlAddAttributeHandledHandletEvent);
            return;
        }
        try {
            HtmlAmlElementUtils.removeHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.htmlElement.getHtmlParentElement(), this.htmlElement);
        }
        catch (HandlerError he) {
            // empty catch block
        }
        HtmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new HtmlAmlInsufficientMemoryHandlerEvent(this.oCurrentAmlPath);
        this.oHandlerManager.postEvent(insufficientMemoryEvent);
    }

    public HtmlElement getHtmlFontFromParentList(HtmlElement currentElement) {
        while (currentElement != null) {
            HtmlElement parentElement = currentElement.getHtmlParentElement();
            if (parentElement instanceof HtmlFont) {
                return parentElement;
            }
            currentElement = parentElement;
        }
        return null;
    }
}

