/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.html;

import com.aligo.axml.AxmlChoice;
import com.aligo.axml.AxmlDocument;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.html.HtmlAmlPathHandler;
import com.aligo.modules.html.events.HtmlAmlCreateNextChildHandledHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlCreateNextChildHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlCreateNextChildNoneHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlGetNextChildIndexHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlIsCachedChoiceFormHandlerEvent;
import com.aligo.modules.html.util.HtmlEventDescriptor;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import java.util.Vector;

public class HtmlAmlCreateNextChildHandler
extends HtmlAmlPathHandler {
    private boolean bPendingMemoryEvent = false;

    public Vector getEvents() {
        Vector<HtmlEventDescriptor> events = new Vector<HtmlEventDescriptor>();
        HtmlEventDescriptor eventDescriptor = new HtmlEventDescriptor("HtmlAmlCreateNextChildHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long htmlAmlPathRelevance() {
        long currentHtmlAmlPathRelevance = 0L;
        if (this.oCurrentEvent instanceof HtmlAmlCreateNextChildHandlerEvent) {
            currentHtmlAmlPathRelevance = 20L;
        }
        return currentHtmlAmlPathRelevance;
    }

    public void handlePathEvent() {
        if (this.oCurrentEvent instanceof HtmlAmlCreateNextChildHandlerEvent) {
            boolean none = false;
            AmlPathInterface parentAmlPath = null;
            try {
                parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
                AxmlElement currentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath);
                int childIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, this.oCurrentAmlPath);
                HtmlAmlGetNextChildIndexHandlerEvent getNextChildIndexEvent = new HtmlAmlGetNextChildIndexHandlerEvent(this.oCurrentAmlPath, childIndex);
                this.oHandlerManager.postEventNow(getNextChildIndexEvent);
                int nextIndex = getNextChildIndexEvent.getNextIndex();
                int numberChildren = currentAmlElement.getNumberElements();
                if (nextIndex < numberChildren) {
                    AmlPathInterface childAmlPath = AmlPathUtils.getChildPath(this.oHandlerManager, parentAmlPath, nextIndex);
                    if (this.bPendingMemoryEvent) {
                        this.bPendingMemoryEvent = false;
                        HtmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new HtmlAmlInsufficientMemoryHandlerEvent(childAmlPath);
                        this.oHandlerManager.postEvent(insufficientMemoryEvent);
                    } else {
                        HtmlAmlCreateNextChildHandledHandlerEvent createNextChildHandledEvent = new HtmlAmlCreateNextChildHandledHandlerEvent(childAmlPath);
                        this.oHandlerManager.postEvent(createNextChildHandledEvent);
                    }
                } else {
                    none = true;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
                none = true;
            }
            if (none) {
                boolean memoryEvent = false;
                Object memoryPath = null;
                try {
                    AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath);
                    if (amlElement instanceof AxmlChoice) {
                        HtmlAmlIsCachedChoiceFormHandlerEvent isCachedChoiceFormEvent = new HtmlAmlIsCachedChoiceFormHandlerEvent(parentAmlPath);
                        this.oHandlerManager.postEventNow(isCachedChoiceFormEvent);
                        if (isCachedChoiceFormEvent.isCached()) {
                            this.bPendingMemoryEvent = true;
                        }
                    } else if (amlElement instanceof AxmlDocument) {
                        this.bPendingMemoryEvent = false;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                HtmlAmlCreateNextChildNoneHandlerEvent createNextChildNoneEvent = new HtmlAmlCreateNextChildNoneHandlerEvent(parentAmlPath);
                this.oHandlerManager.postEvent(createNextChildNoneEvent);
            }
        }
    }
}

