/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.hdml.handlets;

import com.aligo.hdml.exceptions.HdmlElementIndexOutOfBoundsException;
import com.aligo.hdml.interfaces.HdmlElement;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.hdml.events.HdmlAmlRemoveChildContainerHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlRemoveCurrentMemoryHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlRemoveHdmlElementStateHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlResetTopHdmlElementStateHandlerEvent;
import com.aligo.modules.hdml.exceptions.HdmlAmlInsufficientMemoryException;
import com.aligo.modules.hdml.handlets.HdmlAmlElementPathHandlet;
import com.aligo.modules.hdml.handlets.events.HdmlAmlRemoveHdmlElementHandletEvent;
import com.aligo.modules.hdml.handlets.events.HdmlAmlRemoveXmlHdmlElementHandletEvent;
import com.aligo.modules.hdml.util.HdmlAmlElementUtils;
import com.aligo.modules.hdml.util.HdmlEventDescriptor;
import java.util.Hashtable;
import java.util.Vector;

public class HdmlAmlRemoveXmlHdmlElementHandlet
extends HdmlAmlElementPathHandlet {
    protected HdmlElement oChildHdmlElement;

    public Vector getEvents() {
        Vector<HdmlEventDescriptor> events = new Vector<HdmlEventDescriptor>();
        HdmlEventDescriptor eventDescriptor = new HdmlEventDescriptor("HdmlAmlRemoveXmlHdmlElementHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long hdmlAmlElementPathRelevance() {
        long currentHdmlAmlRelevance = 0L;
        if (this.oCurrentEvent instanceof HdmlAmlRemoveXmlHdmlElementHandletEvent) {
            HdmlAmlRemoveXmlHdmlElementHandletEvent addChildEvent = (HdmlAmlRemoveXmlHdmlElementHandletEvent)this.oCurrentEvent;
            this.oChildHdmlElement = addChildEvent.getChildHdmlElement();
            currentHdmlAmlRelevance = 20L;
        }
        return currentHdmlAmlRelevance;
    }

    public void handleElementPathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof HdmlAmlRemoveXmlHdmlElementHandletEvent) {
            if (this.oHdmlElement == null) {
                HdmlAmlResetTopHdmlElementStateHandlerEvent resetTopHdmlElementEvent = new HdmlAmlResetTopHdmlElementStateHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEventNow(resetTopHdmlElementEvent);
                HdmlAmlRemoveChildContainerHandlerEvent removeChildContainerEvent = new HdmlAmlRemoveChildContainerHandlerEvent(this.oCurrentAmlPath, this.oChildHdmlElement);
                this.oHandlerManager.postEventNow(removeChildContainerEvent);
            } else {
                long removeMemory = 0L;
                if (HdmlAmlElementUtils.isPresentationElement(this.oHandlerManager, this.oHdmlElement)) {
                    String contents = this.oChildHdmlElement.getContents();
                    removeMemory += (long)contents.getBytes().length;
                }
                HdmlAmlRemoveHdmlElementHandletEvent removeHdmlElementEvent = new HdmlAmlRemoveHdmlElementHandletEvent(this.oHdmlElement, this.oChildHdmlElement);
                this.oHandlerManager.postEventNow(removeHdmlElementEvent);
                HdmlAmlRemoveHdmlElementStateHandlerEvent removeHdmlElementStateEvent = new HdmlAmlRemoveHdmlElementStateHandlerEvent(this.oCurrentAmlPath, this.oChildHdmlElement);
                this.oHandlerManager.postEventNow(removeHdmlElementStateEvent);
                if (removeMemory != 0L) {
                    HdmlAmlRemoveCurrentMemoryHandlerEvent removeCurrentMemoryEvent = new HdmlAmlRemoveCurrentMemoryHandlerEvent(this.oCurrentAmlPath, removeMemory);
                    this.oHandlerManager.postEventNow(removeCurrentMemoryEvent);
                }
                if (this.oChildHdmlElement.getNumberElements() == 0) {
                    HdmlAmlElementUtils.removePresentationElement(this.oHandlerManager, this.oChildHdmlElement);
                } else {
                    Hashtable hdmlElements = HdmlAmlElementUtils.getPresentationElements(this.oHandlerManager);
                    this.removePresentationElements(hdmlElements, this.oChildHdmlElement);
                }
                if (!HdmlAmlElementUtils.isSufficientMemory(this.oHandlerManager, this.oCurrentAmlPath)) {
                    throw new HandlerError(new HdmlAmlInsufficientMemoryException());
                }
            }
        }
    }

    void removePresentationElements(Hashtable hdmlElements, HdmlElement hdmlElement) {
        if (hdmlElement != null) {
            HdmlAmlElementUtils.removePresentationElement(hdmlElements, hdmlElement);
            int numberElements = hdmlElement.getNumberElements();
            int i = 0;
            while (i < numberElements) {
                try {
                    HdmlElement childHdmlElement = hdmlElement.hdmlElementAt(i);
                    this.removePresentationElements(hdmlElements, childHdmlElement);
                }
                catch (HdmlElementIndexOutOfBoundsException je) {
                    // empty catch block
                }
                ++i;
            }
        }
    }
}

