/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.hdml.handlets;

import com.aligo.hdml.HdmlChoice;
import com.aligo.hdml.HdmlContainer;
import com.aligo.hdml.HdmlDisplay;
import com.aligo.hdml.HdmlEntry;
import com.aligo.hdml.HdmlNodisplay;
import com.aligo.hdml.exceptions.HdmlElementIndexOutOfBoundsException;
import com.aligo.hdml.interfaces.HdmlElement;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.hdml.handlets.HdmlAmlHandlet;
import com.aligo.modules.hdml.handlets.events.HdmlAmlRemoveHdmlElementHandletEvent;
import com.aligo.modules.hdml.util.HdmlAmlElementUtils;
import com.aligo.modules.hdml.util.HdmlEventDescriptor;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import java.util.Vector;

public class HdmlAmlRemoveHdmlElementHandlet
extends HdmlAmlHandlet {
    protected HdmlElement oHdmlElement;
    protected HdmlElement oChildHdmlElement;

    public Vector getEvents() {
        Vector<HdmlEventDescriptor> events = new Vector<HdmlEventDescriptor>();
        HdmlEventDescriptor eventDescriptor = new HdmlEventDescriptor("HdmlAmlRemoveHdmlElementHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long hdmlAmlRelevance() {
        long currentHdmlAmlRelevance = 0L;
        if (this.oCurrentEvent instanceof HdmlAmlRemoveHdmlElementHandletEvent) {
            HdmlAmlRemoveHdmlElementHandletEvent removeChildEvent = (HdmlAmlRemoveHdmlElementHandletEvent)this.oCurrentEvent;
            this.oHdmlElement = removeChildEvent.getHdmlElement();
            this.oChildHdmlElement = removeChildEvent.getChildHdmlElement();
            currentHdmlAmlRelevance = 20L;
        }
        return currentHdmlAmlRelevance;
    }

    public void handleEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof HdmlAmlRemoveHdmlElementHandletEvent) {
            try {
                this.oHdmlElement.removeHdmlElement(this.oChildHdmlElement);
                this.deallocateElement(this.oChildHdmlElement);
            }
            catch (Exception we) {
                throw new HandlerError(we);
            }
        }
    }

    private void deallocateElement(HdmlElement hdmlElement) throws HdmlElementIndexOutOfBoundsException {
        if (hdmlElement instanceof HdmlContainer) {
            if (hdmlElement.getNumberElements() > 0) {
                this.deallocateElement(hdmlElement.hdmlElementAt(0));
            }
        } else if (hdmlElement instanceof HdmlNodisplay || hdmlElement instanceof HdmlDisplay || hdmlElement instanceof HdmlEntry || hdmlElement instanceof HdmlChoice) {
            PageAllocatorInterface pageAllocator = HdmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
            String elementID = hdmlElement.getHdmlAttributeValue("name");
            if (elementID != null) {
                pageAllocator.deallocateElement(elementID);
            }
        }
    }
}

