/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.hdml.handlets;

import com.aligo.axml.AxmlText;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.hdml.HdmlPCData;
import com.aligo.hdml.interfaces.HdmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.hdml.errors.HdmlAmlHandlerError;
import com.aligo.modules.hdml.events.HdmlAmlDetachFromTreeMemoryHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetRemainingMemoryHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlResetTextStateHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlShouldDetachTextMemoryHandlerEvent;
import com.aligo.modules.hdml.exceptions.HdmlAmlInsufficientMemoryException;
import com.aligo.modules.hdml.handlets.HdmlAmlStylePathHandlet;
import com.aligo.modules.hdml.handlets.events.HdmlAmlAddAttributeHandledHandletEvent;
import com.aligo.modules.hdml.handlets.events.HdmlAmlAddAttributeHandletEvent;
import com.aligo.modules.hdml.handlets.events.HdmlAmlXmlHdmlElementHandletEvent;
import com.aligo.modules.hdml.util.HdmlAmlElementUtils;
import com.aligo.modules.hdml.util.HdmlEventDescriptor;
import com.aligo.modules.hdml.util.exceptions.HdmlAmlGetRootElementFailedException;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlAmlAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import com.aligo.modules.styles.paths.interfaces.AmlAttributePathComponentInterface;
import com.aligo.modules.styles.paths.interfaces.AmlAttributePathInterface;
import com.aligo.util.hdml.TextUtils;
import java.util.Hashtable;
import java.util.Vector;

public class HdmlAmlAddXmlAmlAttributeHandlet
extends HdmlAmlStylePathHandlet {
    public static final String PREV_COMPONENT_NAME = "..";
    public static final String CURRENT_COMPONENT_NAME = ".";
    public static final String ENCODE = "encode";
    public static final String ENCODE_FALSE = "false";
    private XmlAmlAttributeInterface oXmlAmlAttribute;
    private Hashtable oTextIndices = new Hashtable();
    private Hashtable oOutputContainers = new Hashtable();
    private Hashtable oDetachFlags = new Hashtable();

    public Vector getEvents() {
        Vector<HdmlEventDescriptor> events = new Vector<HdmlEventDescriptor>();
        HdmlEventDescriptor eventDescriptor = new HdmlEventDescriptor("HdmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlDetachFromTreeMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlShouldDetachTextMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlResetTextStateHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long hdmlAmlStylePathRelevance() {
        HdmlAmlAddAttributeHandletEvent addNextAttributeHandledEvent;
        XmlAttributeInterface xmlAttribute;
        long currentHdmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof HdmlAmlAddAttributeHandletEvent && (xmlAttribute = (addNextAttributeHandledEvent = (HdmlAmlAddAttributeHandletEvent)this.oCurrentEvent).getXmlAttribute()) instanceof XmlAmlAttributeInterface) {
            currentHdmlAmlStylePathRelevance = 20L;
        }
        return currentHdmlAmlStylePathRelevance;
    }

    public long hdmlAmlRelevance() {
        long currentHdmlAmlRelevance = 0L;
        if (this.oCurrentEvent instanceof HdmlAmlDetachFromTreeMemoryHandlerEvent) {
            if (this.doesTextPathExist(this.oCurrentAmlPath) && !this.shouldDetach(this.oCurrentAmlPath)) {
                currentHdmlAmlRelevance = 30L;
            }
        } else {
            currentHdmlAmlRelevance = this.oCurrentEvent instanceof HdmlAmlShouldDetachTextMemoryHandlerEvent ? 30L : (this.oCurrentEvent instanceof HdmlAmlResetTextStateHandlerEvent ? 20L : super.hdmlAmlRelevance());
        }
        return currentHdmlAmlRelevance;
    }

    private boolean doesTextPathExist(AmlPathInterface amlPath) {
        boolean textPathExist = false;
        Integer iLastIndex = (Integer)this.oTextIndices.get(amlPath.getCanonicalPath());
        if (iLastIndex != null) {
            textPathExist = true;
        }
        return textPathExist;
    }

    private boolean shouldDetach(AmlPathInterface amlPath) {
        boolean detach = true;
        Boolean bDetach = (Boolean)this.oDetachFlags.get(amlPath.getCanonicalPath());
        if (bDetach != null) {
            detach = bDetach;
        }
        return detach;
    }

    private AxmlElement getRelativeAmlElement(AmlPathInterface oCurrentAmlPath, AmlAttributePathInterface amlRelativePath) throws HdmlAmlGetRootElementFailedException {
        int numberComponents = amlRelativePath.getNumberAmlAttributePathComponents();
        AxmlElement amlElement = null;
        AmlPathInterface amlPath = oCurrentAmlPath;
        try {
            int i = 0;
            while (i < numberComponents) {
                AmlAttributePathComponentInterface component = amlRelativePath.getAmlAttributePathComponentAt(i);
                String pathName = component.getPathName();
                if (pathName.equals(PREV_COMPONENT_NAME)) {
                    amlPath = AmlPathUtils.getParentPath(this.oHandlerManager, amlPath);
                } else if (pathName.equals(CURRENT_COMPONENT_NAME)) {
                    // empty if block
                }
                ++i;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath);
        return amlElement;
    }

    public void handleStylePathEvent() {
        if (this.oCurrentEvent instanceof HdmlAmlAddAttributeHandletEvent) {
            HdmlAmlAddAttributeHandletEvent addNextAttributeHandledEvent = (HdmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            XmlAttributeInterface xmlAttribute = addNextAttributeHandledEvent.getXmlAttribute();
            boolean memoryError = false;
            HdmlElement hdmlElement = null;
            String hdmlName = null;
            String hdmlValue = null;
            if (xmlAttribute instanceof XmlAmlAttributeInterface) {
                try {
                    this.oXmlAmlAttribute = (XmlAmlAttributeInterface)xmlAttribute;
                    HdmlAmlXmlHdmlElementHandletEvent getHdmlElementEvent = new HdmlAmlXmlHdmlElementHandletEvent("Get", this.oCurrentAmlPath, this.oStyleXmlElement);
                    this.oHandlerManager.postEventNow(getHdmlElementEvent);
                    hdmlElement = getHdmlElementEvent.getHdmlElement();
                    hdmlName = this.oXmlAmlAttribute.getXmlAttributeName();
                    String amlName = this.oXmlAmlAttribute.getAmlAttributeName();
                    AmlAttributePathInterface amlRelativePath = this.oXmlAmlAttribute.getAmlAttributePath();
                    AxmlElement amlElement = this.getRelativeAmlElement(this.oCurrentAmlPath, amlRelativePath);
                    hdmlValue = amlElement.getAxmlAttributeValue(amlName);
                    if (hdmlValue != null) {
                        String value = "";
                        AxmlElement currentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                        if (currentAmlElement instanceof AxmlText && hdmlElement instanceof HdmlPCData) {
                            if (hdmlName.equals("text")) {
                                int lastIndex;
                                Integer iLastIndex;
                                String pathString = this.oCurrentAmlPath.getCanonicalPath();
                                Vector strContainer = (Vector)this.oOutputContainers.get(pathString);
                                if (strContainer == null) {
                                    strContainer = new Vector();
                                    String encodeValue = currentAmlElement.getAxmlAttributeValue(ENCODE);
                                    boolean encode = true;
                                    if (encodeValue != null && encodeValue.equals(ENCODE_FALSE)) {
                                        encode = false;
                                    }
                                    TextUtils.prepareOutput(hdmlValue, this.oUAProfile.getScreenWidthChar(), strContainer, encode);
                                    this.oOutputContainers.put(pathString, strContainer);
                                }
                                if ((iLastIndex = (Integer)this.oTextIndices.get(pathString)) == null) {
                                    lastIndex = 0;
                                    iLastIndex = new Integer(lastIndex);
                                    this.oTextIndices.put(pathString, iLastIndex);
                                } else {
                                    lastIndex = iLastIndex;
                                }
                                HdmlAmlGetRemainingMemoryHandlerEvent getRemainingMemoryEvent = new HdmlAmlGetRemainingMemoryHandlerEvent(this.oCurrentAmlPath);
                                this.oHandlerManager.postEventNow(getRemainingMemoryEvent);
                                long remainingMemory = getRemainingMemoryEvent.getNumberBytes();
                                int numberElements = strContainer.size();
                                long memory = 0L;
                                boolean done = false;
                                boolean detach = false;
                                int i = lastIndex;
                                while (i < numberElements && !done) {
                                    String element = (String)strContainer.elementAt(i);
                                    long elementMemory = element.getBytes().length;
                                    if ((memory += elementMemory) > remainingMemory) {
                                        done = true;
                                        if (i == lastIndex) {
                                            detach = true;
                                        }
                                        lastIndex = i;
                                    } else {
                                        value = value + element;
                                    }
                                    ++i;
                                }
                                this.oDetachFlags.put(pathString, new Boolean(detach));
                                if (done) {
                                    this.oTextIndices.put(pathString, new Integer(lastIndex));
                                    memoryError = true;
                                } else {
                                    this.clearState(this.oCurrentAmlPath);
                                }
                            }
                        } else {
                            value = TextUtils.transformAttr(hdmlName, hdmlValue);
                        }
                        HdmlAmlElementUtils.addHdmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, hdmlElement, hdmlName, value);
                    }
                }
                catch (HandlerError he) {
                    Exception ex = he.getException();
                    if (ex instanceof HdmlAmlInsufficientMemoryException) {
                        memoryError = true;
                    }
                }
                catch (Exception ex) {
                    this.oHandlerLogger.logError(ex);
                }
                if (memoryError) {
                    HdmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new HdmlAmlInsufficientMemoryHandlerEvent(this.oCurrentAmlPath);
                    this.oHandlerManager.postEvent(insufficientMemoryEvent);
                } else {
                    HdmlAmlAddAttributeHandledHandletEvent addAttributeHandledHandletEvent = new HdmlAmlAddAttributeHandledHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlAttribute);
                    this.oHandlerManager.postEvent(addAttributeHandledHandletEvent);
                }
            }
        }
    }

    public void clearState(AmlPathInterface amlPath) {
        String pathString = amlPath.getCanonicalPath();
        this.oTextIndices.remove(pathString);
        this.oOutputContainers.remove(pathString);
        this.oDetachFlags.remove(pathString);
    }

    public void handleEventNow() throws HandlerError {
        if (!(this.oCurrentEvent instanceof HdmlAmlDetachFromTreeMemoryHandlerEvent)) {
            if (this.oCurrentEvent instanceof HdmlAmlShouldDetachTextMemoryHandlerEvent) {
                HdmlAmlShouldDetachTextMemoryHandlerEvent shouldDetachTextMemoryEvent = (HdmlAmlShouldDetachTextMemoryHandlerEvent)this.oCurrentEvent;
                AmlPathInterface currentAmlPath = shouldDetachTextMemoryEvent.getAmlPath();
                boolean detach = true;
                if (currentAmlPath != null) {
                    detach = this.shouldDetach(currentAmlPath);
                }
                shouldDetachTextMemoryEvent.setDetach(detach);
            } else if (this.oCurrentEvent instanceof HdmlAmlResetTextStateHandlerEvent) {
                try {
                    AmlPathInterface currentAmlPath = ((HdmlAmlResetTextStateHandlerEvent)this.oCurrentEvent).getAmlPath();
                    this.clearState(currentAmlPath);
                }
                catch (Exception ex) {
                    throw new HdmlAmlHandlerError(ex);
                }
            } else {
                super.handleEventNow();
            }
        }
    }
}

