/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.hdml.amlhandlets;

import com.aligo.axml.AxmlLink;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.hdml.HdmlA;
import com.aligo.hdml.HdmlCe;
import com.aligo.hdml.interfaces.HdmlElement;
import com.aligo.interfaces.AligoEventInterface;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.hdml.amlhandlets.events.HdmlAmlCreateLinkHandletEvent;
import com.aligo.modules.hdml.events.HdmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.hdml.exceptions.HdmlAmlInsufficientMemoryException;
import com.aligo.modules.hdml.handlets.HdmlAmlStylePathHandlet;
import com.aligo.modules.hdml.handlets.events.HdmlAmlAddAttributeHandledHandletEvent;
import com.aligo.modules.hdml.handlets.events.HdmlAmlAddAttributeHandletEvent;
import com.aligo.modules.hdml.handlets.events.HdmlAmlXmlHdmlElementHandletEvent;
import com.aligo.modules.hdml.util.HdmlAmlElementUtils;
import com.aligo.modules.hdml.util.HdmlEventDescriptor;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import com.aligo.util.hdml.TextUtils;
import java.util.Vector;

public class HdmlAmlLinkUrlHandlet
extends HdmlAmlStylePathHandlet {
    protected XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;
    XmlAttributeInterface xmlAttribute;
    HdmlElement hdmlElement;
    private static final String WTAI_PREFIX = "wtai://wp/mc;";
    private static final String MAIL_SERVICE_PREFIX = "device:home/goto?svc=Email&SUB=sendMsg";
    private static final String AMPERSAND = "&";
    private AmlPathInterface saCurrentAmlPath;

    public Vector getEvents() {
        Vector<HdmlEventDescriptor> events = new Vector<HdmlEventDescriptor>();
        HdmlEventDescriptor eventDescriptor = new HdmlEventDescriptor("HdmlAmlCreateLinkHandletEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long hdmlAmlRelevance() {
        long currentHdmlAmlRelevance = 0L;
        currentHdmlAmlRelevance = this.oCurrentEvent instanceof HdmlAmlCreateLinkHandletEvent ? 20L : super.hdmlAmlRelevance();
        return currentHdmlAmlRelevance;
    }

    public long hdmlAmlStylePathRelevance() {
        long currentHdmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof HdmlAmlAddAttributeHandletEvent) {
            HdmlAmlAddAttributeHandletEvent addAttributeEvent = (HdmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            this.xmlAttribute = addAttributeEvent.getXmlAttribute();
            try {
                AligoEventInterface event = this.oCurrentEvent;
                HdmlAmlXmlHdmlElementHandletEvent getHdmlElementEvent = new HdmlAmlXmlHdmlElementHandletEvent("Get", addAttributeEvent.getAmlPath(), addAttributeEvent.getXmlElement());
                this.oHandlerManager.postEventNow(getHdmlElementEvent);
                this.oCurrentEvent = event;
                this.hdmlElement = getHdmlElementEvent.getHdmlElement();
                if (this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && (this.hdmlElement instanceof HdmlA || this.hdmlElement instanceof HdmlCe)) {
                    this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                    if (this.oXmlAmlHandlerAttribute.getAmlAttributeName().toLowerCase().equals("dest")) {
                        currentHdmlAmlStylePathRelevance = 20L;
                    }
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        return currentHdmlAmlStylePathRelevance;
    }

    public void handleEventNow() throws HandlerError {
        this.oCurrentEvent = this.oEvent;
        if (this.oCurrentEvent instanceof HdmlAmlCreateLinkHandletEvent) {
            HdmlAmlCreateLinkHandletEvent createLinkEvent = (HdmlAmlCreateLinkHandletEvent)this.oCurrentEvent;
            try {
                AxmlLink axmlLink = createLinkEvent.getAxmlLink();
                if (axmlLink != null) {
                    HdmlElement hdmlLink = this.createLink(axmlLink);
                    createLinkEvent.setHdmlElement(hdmlLink);
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        } else {
            super.handleEventNow();
        }
    }

    public void handleStylePathEvent() {
        boolean memoryError = false;
        if (this.oCurrentEvent instanceof HdmlAmlAddAttributeHandletEvent) {
            block19: {
                try {
                    block23: {
                        if (!(this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface) || !(this.hdmlElement instanceof HdmlA) && !(this.hdmlElement instanceof HdmlCe)) break block19;
                        this.saCurrentAmlPath = ((HdmlAmlAddAttributeHandletEvent)this.oCurrentEvent).getAmlPath();
                        this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                        String amlAttributeName = this.oXmlAmlHandlerAttribute.getAmlAttributeName();
                        Object previousHdmlElement = null;
                        AxmlElement axmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.saCurrentAmlPath);
                        String amlAttributeValue = axmlElement.getAxmlAttributeValue("url");
                        if (!amlAttributeName.toLowerCase().equals("dest")) break block19;
                        if (amlAttributeValue != null && amlAttributeValue.startsWith(WTAI_PREFIX)) {
                            block20: {
                                String number = amlAttributeValue.substring(WTAI_PREFIX.length());
                                if (number == null || number.equals("")) break block19;
                                try {
                                    HdmlAmlElementUtils.addHdmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.hdmlElement, "number", number);
                                }
                                catch (HandlerError he) {
                                    Exception ex = he.getException();
                                    if (!(ex instanceof HdmlAmlInsufficientMemoryException)) break block20;
                                    memoryError = true;
                                }
                            }
                            HdmlAmlElementUtils.addHdmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.hdmlElement, "task", "call");
                            break block19;
                        }
                        if (amlAttributeValue != null && amlAttributeValue.startsWith(MAIL_SERVICE_PREFIX)) {
                            block22: {
                                Exception ex;
                                String vars;
                                block21: {
                                    vars = amlAttributeValue.substring(MAIL_SERVICE_PREFIX.length());
                                    if (vars.startsWith(AMPERSAND)) {
                                        vars = vars.substring(AMPERSAND.length());
                                    }
                                    try {
                                        HdmlAmlElementUtils.addHdmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.hdmlElement, "dest", MAIL_SERVICE_PREFIX);
                                    }
                                    catch (HandlerError he) {
                                        ex = he.getException();
                                        if (!(ex instanceof HdmlAmlInsufficientMemoryException)) break block21;
                                        memoryError = true;
                                    }
                                }
                                if (vars != null && !vars.equals("")) {
                                    try {
                                        HdmlAmlElementUtils.addHdmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.hdmlElement, "vars", vars);
                                    }
                                    catch (HandlerError he) {
                                        ex = he.getException();
                                        if (!(ex instanceof HdmlAmlInsufficientMemoryException)) break block22;
                                        memoryError = true;
                                    }
                                }
                            }
                            HdmlAmlElementUtils.addHdmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.hdmlElement, "task", "gosub");
                            break block19;
                        }
                        if (amlAttributeValue == null) break block19;
                        try {
                            HdmlAmlElementUtils.addHdmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.hdmlElement, "dest", TextUtils.transformAttr("dest", amlAttributeValue));
                        }
                        catch (HandlerError he) {
                            Exception ex = he.getException();
                            if (!(ex instanceof HdmlAmlInsufficientMemoryException)) break block23;
                            memoryError = true;
                        }
                    }
                    HdmlAmlElementUtils.addHdmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.hdmlElement, "task", "go");
                }
                catch (HandlerError he) {
                    Exception ex = he.getException();
                    if (ex instanceof HdmlAmlInsufficientMemoryException) {
                        memoryError = true;
                    }
                }
                catch (Exception ex) {
                    this.oHandlerLogger.logError(ex);
                }
            }
            if (memoryError) {
                HdmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new HdmlAmlInsufficientMemoryHandlerEvent(this.saCurrentAmlPath);
                this.oHandlerManager.postEvent(insufficientMemoryEvent);
            } else {
                HdmlAmlAddAttributeHandledHandletEvent hdmlAmlAddAttributeHandledHandletEvent = new HdmlAmlAddAttributeHandledHandletEvent(this.saCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
                this.oHandlerManager.postEvent(hdmlAmlAddAttributeHandledHandletEvent);
            }
        }
    }

    private HdmlElement createLink(AxmlLink axmlLink) {
        HdmlA hdmlLink = null;
        try {
            String url = axmlLink.getAxmlAttributeValue("url");
            if (url != null) {
                hdmlLink = new HdmlA();
                if (url.startsWith(WTAI_PREFIX)) {
                    String number = url.substring(WTAI_PREFIX.length());
                    if (number != null && !number.equals("")) {
                        hdmlLink.addHdmlAttribute("number", number);
                        hdmlLink.addHdmlAttribute("task", "call");
                    }
                } else if (url.startsWith(MAIL_SERVICE_PREFIX)) {
                    String vars = url.substring(MAIL_SERVICE_PREFIX.length());
                    if (vars.startsWith(AMPERSAND)) {
                        vars = vars.substring(AMPERSAND.length());
                    }
                    hdmlLink.addHdmlAttribute("dest", MAIL_SERVICE_PREFIX);
                    if (vars != null && !vars.equals("")) {
                        hdmlLink.addHdmlAttribute("vars", vars);
                    }
                    hdmlLink.addHdmlAttribute("task", "gosub");
                } else {
                    hdmlLink.addHdmlAttribute("dest", url);
                    hdmlLink.addHdmlAttribute("task", "go");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hdmlLink;
    }
}

