/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.chtml.state;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.chtml.CHtmlElementCollection;
import com.aligo.chtml.exceptions.CHtmlElementCannotBeAddedException;
import com.aligo.chtml.exceptions.CHtmlElementNotFoundException;
import com.aligo.chtml.interfaces.CHtmlElement;
import com.aligo.modules.chtml.state.exceptions.CHtmlAmlStateKeeperAttributeNotFoundException;
import com.aligo.modules.chtml.state.exceptions.CHtmlAmlStateKeeperElementNotFoundException;
import com.aligo.modules.chtml.state.interfaces.CHtmlAmlStateKeeperInterface;
import com.aligo.modules.styles.interfaces.StyleIDInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CHtmlAmlStateKeeper
implements CHtmlAmlStateKeeperInterface {
    private AxmlElement oAmlElement;
    private CHtmlElement oCHtmlChildContainerElement;
    private CHtmlElement oCHtmlElements = new CHtmlElementCollection();
    private CHtmlElement oCHtmlTopElement;
    private CHtmlElement oCHtmlEndElements = new CHtmlElementCollection();
    private int iCHtmlChildPosition = -1;
    private Hashtable oCHtmlAttrTable = new Hashtable();
    private CHtmlElement oCHtmlTextElements = new CHtmlElementCollection();
    private XmlElementInterface oTopStyleElement;
    private StyleIDInterface oStyleID;

    public void setAmlElement(AxmlElement amlElement) {
        this.oAmlElement = amlElement;
    }

    public AxmlElement getAmlElement() {
        return this.oAmlElement;
    }

    public void setCHtmlChildContainerElement(CHtmlElement chtmlChildContainerElement) {
        this.oCHtmlChildContainerElement = chtmlChildContainerElement;
    }

    public CHtmlElement getCHtmlChildContainerElement() {
        return this.oCHtmlChildContainerElement;
    }

    public void setCHtmlChildPosition(int chtmlChildPosition) {
        this.iCHtmlChildPosition = chtmlChildPosition;
    }

    public int getCHtmlChildPosition() {
        return this.iCHtmlChildPosition;
    }

    public void setTopCHtmlElement(CHtmlElement chtmlTopElement) {
        this.oCHtmlTopElement = chtmlTopElement;
    }

    public CHtmlElement getTopCHtmlElement() {
        return this.oCHtmlTopElement;
    }

    public void addEndCHtmlElement(CHtmlElement chtmlEndElement) {
        try {
            this.oCHtmlEndElements.addCHtmlElement(chtmlEndElement);
        }
        catch (CHtmlElementCannotBeAddedException cHtmlElementCannotBeAddedException) {
            // empty catch block
        }
    }

    public CHtmlElement getEndCHtmlElements() {
        return this.oCHtmlEndElements;
    }

    public void removeAllEndCHtmlElements() {
        this.oCHtmlEndElements.removeAll();
    }

    public void removeEndCHtmlElement(CHtmlElement chtmlElement) throws CHtmlAmlStateKeeperElementNotFoundException {
        try {
            this.oCHtmlEndElements.removeCHtmlElement(chtmlElement);
        }
        catch (CHtmlElementNotFoundException we) {
            throw new CHtmlAmlStateKeeperElementNotFoundException();
        }
    }

    public void addCHtmlElement(CHtmlElement chtmlElement) {
        try {
            this.oCHtmlElements.addCHtmlElement(chtmlElement);
        }
        catch (CHtmlElementCannotBeAddedException cHtmlElementCannotBeAddedException) {
            // empty catch block
        }
    }

    public CHtmlElement getCHtmlElements() {
        return this.oCHtmlElements;
    }

    public void removeAllCHtmlElements() {
        this.oCHtmlElements.removeAll();
    }

    public void removeCHtmlElement(CHtmlElement chtmlElement) throws CHtmlAmlStateKeeperElementNotFoundException {
        try {
            this.oCHtmlElements.removeCHtmlElement(chtmlElement);
        }
        catch (CHtmlElementNotFoundException we) {
            throw new CHtmlAmlStateKeeperElementNotFoundException();
        }
    }

    private Vector createCHtmlAttributeVector(CHtmlElement chtmlElement) {
        Vector attributeVector = new Vector();
        this.oCHtmlAttrTable.put(chtmlElement, attributeVector);
        return attributeVector;
    }

    public void addCHtmlAttribute(CHtmlElement chtmlElement, String attrName) {
        Vector attributeVector = (Vector)this.oCHtmlAttrTable.get(chtmlElement);
        if (attributeVector == null) {
            attributeVector = this.createCHtmlAttributeVector(chtmlElement);
        }
        attributeVector.addElement(attrName);
    }

    public CHtmlElement getCHtmlAttributeElements() {
        CHtmlElementCollection attributeElements = new CHtmlElementCollection();
        Enumeration keys = this.oCHtmlAttrTable.keys();
        while (keys.hasMoreElements()) {
            try {
                CHtmlElement chtmlElement = (CHtmlElement)keys.nextElement();
                attributeElements.addCHtmlElement(chtmlElement);
            }
            catch (CHtmlElementCannotBeAddedException cHtmlElementCannotBeAddedException) {
                // empty catch block
            }
        }
        return attributeElements;
    }

    public Enumeration getCHtmlAttributes(CHtmlElement chtmlElement) throws CHtmlAmlStateKeeperElementNotFoundException {
        Vector attributeVector = (Vector)this.oCHtmlAttrTable.get(chtmlElement);
        if (attributeVector == null) {
            throw new CHtmlAmlStateKeeperElementNotFoundException();
        }
        return attributeVector.elements();
    }

    public void removeAllCHtmlAttributes() {
        this.oCHtmlAttrTable.clear();
    }

    public void removeCHtmlAttributes(CHtmlElement chtmlElement) throws CHtmlAmlStateKeeperElementNotFoundException {
        Vector attributeVector = (Vector)this.oCHtmlAttrTable.get(chtmlElement);
        if (attributeVector == null) {
            throw new CHtmlAmlStateKeeperElementNotFoundException();
        }
        this.oCHtmlAttrTable.remove(chtmlElement);
    }

    public void removeCHtmlAttribute(CHtmlElement chtmlElement, String chtmlAttrName) throws CHtmlAmlStateKeeperElementNotFoundException, CHtmlAmlStateKeeperAttributeNotFoundException {
        Vector attributeVector = (Vector)this.oCHtmlAttrTable.get(chtmlElement);
        if (attributeVector == null) {
            throw new CHtmlAmlStateKeeperElementNotFoundException();
        }
        boolean present = attributeVector.remove(chtmlAttrName);
        if (!present) {
            throw new CHtmlAmlStateKeeperAttributeNotFoundException();
        }
    }

    public void addCHtmlText(CHtmlElement chtmlElement) {
        try {
            this.oCHtmlTextElements.addCHtmlElement(chtmlElement);
        }
        catch (CHtmlElementCannotBeAddedException cHtmlElementCannotBeAddedException) {
            // empty catch block
        }
    }

    public CHtmlElement getCHtmlTextElements() {
        return this.oCHtmlTextElements;
    }

    public void removeAllCHtmlTextElements() {
        this.oCHtmlTextElements.removeAll();
    }

    public void removeCHtmlText(CHtmlElement chtmlElement) throws CHtmlAmlStateKeeperElementNotFoundException {
        try {
            this.oCHtmlTextElements.removeCHtmlElement(chtmlElement);
        }
        catch (CHtmlElementNotFoundException we) {
            throw new CHtmlAmlStateKeeperElementNotFoundException();
        }
    }

    public void setTopStyleElement(XmlElementInterface topStyleElement) {
        this.oTopStyleElement = topStyleElement;
    }

    public XmlElementInterface getTopStyleElement() {
        return this.oTopStyleElement;
    }

    public void setStyleID(StyleIDInterface styleID) {
        this.oStyleID = styleID;
    }

    public StyleIDInterface getStyleID() {
        return this.oStyleID;
    }
}

