/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.chtml.amlhandlets;

import com.aligo.axml.AxmlPage;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.chtml.CHtmlA;
import com.aligo.chtml.exceptions.CHtmlAttributeCannotBeAddedException;
import com.aligo.chtml.exceptions.CHtmlElementCannotBeAddedException;
import com.aligo.chtml.interfaces.CHtmlElement;
import com.aligo.modules.EventDescriptor;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.chtml.errors.CHtmlAmlHandlerError;
import com.aligo.modules.chtml.handlets.CHtmlAmlStylePathHandlet;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlAddElementHandledHandletEvent;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlAddXmlAmlAddAttributeHandletEvent;
import com.aligo.modules.chtml.interfaces.CHtmlEventHookPosition;
import com.aligo.modules.chtml.util.CHtmlAmlElementUtils;
import com.aligo.modules.chtml.util.CHtmlEventDescriptor;
import com.aligo.modules.chtml.util.CHtmlEventHookDescriptor;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.util.chtml.TextUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CHtmlAmlLinkingHandlet
extends CHtmlAmlStylePathHandlet {
    private static final String TYPE = "type";
    private static final String OPTIONS = "options";
    private static final String LABEL = "label";
    private static final String PREVIOUS_PAGE = "Previous Page";
    private static final String SENDREFERER = "sendreferer";
    private static final String TRUE = "true";
    private static final String HREF = "href";
    private static final String NEXT_PAGE = "Next Page";
    private static final String ID = "id";
    private Hashtable oPageIDs = new Hashtable();
    private Hashtable oIDPages = new Hashtable();
    private Hashtable oIDLinks = new Hashtable();
    private CHtmlElement oCHtmlElement;

    public Vector getEvents() {
        Vector<EventDescriptor> events = new Vector<EventDescriptor>();
        CHtmlEventHookDescriptor eventHookDescriptor = new CHtmlEventHookDescriptor("CHtmlAmlAddElementHandledHandletEvent", CHtmlEventHookPosition.POSITION_AFTER);
        events.addElement(eventHookDescriptor);
        CHtmlEventDescriptor eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlAddXmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long chtmlAmlStylePathRelevance() {
        long currentCHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof CHtmlAmlAddElementHandledHandletEvent) {
            CHtmlAmlAddElementHandledHandletEvent addElementHandledEvent = (CHtmlAmlAddElementHandledHandletEvent)this.oCurrentEvent;
            this.oStyleXmlElement = addElementHandledEvent.getXmlElement();
            this.oCurrentAmlPath = addElementHandledEvent.getAmlPath();
            try {
                this.oCHtmlElement = CHtmlAmlElementUtils.getCHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.oStyleXmlElement);
                AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                if (amlElement instanceof AxmlPage && this.oCHtmlElement instanceof CHtmlA) {
                    currentCHtmlAmlStylePathRelevance = 20L;
                }
            }
            catch (HandlerError he) {}
        } else if (this.oCurrentEvent instanceof CHtmlAmlAddXmlAmlAddAttributeHandletEvent) {
            CHtmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (CHtmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            XmlElementInterface styleXmlElement = addAttributeEvent.getXmlElement();
            this.oCurrentAmlPath = addAttributeEvent.getAmlPath();
            try {
                CHtmlElement chtmlElement = CHtmlAmlElementUtils.getCHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, styleXmlElement);
                String chtmlName = addAttributeEvent.getCHtmlName();
                if (chtmlElement instanceof CHtmlA && chtmlName.equals("name")) {
                    currentCHtmlAmlStylePathRelevance = 20L;
                } else if (chtmlElement instanceof CHtmlA && chtmlName.equals(HREF)) {
                    currentCHtmlAmlStylePathRelevance = 20L;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return currentCHtmlAmlStylePathRelevance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleStylePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof CHtmlAmlAddElementHandledHandletEvent) {
            try {
                this.addName(this.oCHtmlElement);
                return;
            }
            catch (Exception ex) {
                if (ex instanceof HandlerError) return;
                throw new CHtmlAmlHandlerError(ex);
            }
        } else {
            if (!(this.oCurrentEvent instanceof CHtmlAmlAddXmlAmlAddAttributeHandletEvent)) return;
            CHtmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (CHtmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            XmlElementInterface styleXmlElement = addAttributeEvent.getXmlElement();
            CHtmlElement chtmlElement = CHtmlAmlElementUtils.getCHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, styleXmlElement);
            String chtmlName = addAttributeEvent.getCHtmlName();
            if (chtmlElement instanceof CHtmlA && chtmlName.equals("name")) {
                String chtmlValue = addAttributeEvent.getCHtmlValue();
                if (chtmlValue == null) return;
                this.setCardId(chtmlElement, chtmlValue);
                String strPath = this.oCurrentAmlPath.toString();
                return;
            } else {
                String chtmlValue;
                if (!(chtmlElement instanceof CHtmlA) || !chtmlName.equals(HREF) || (chtmlValue = addAttributeEvent.getCHtmlValue()) == null) return;
                String url = chtmlValue;
                int refIndex = chtmlValue.indexOf("#");
                if (refIndex != -1) {
                    Vector links;
                    String id = chtmlValue.substring(refIndex + 1);
                    Vector paths = (Vector)this.oIDPages.get(id);
                    if (paths != null && paths.size() > 0) {
                        url = this.getUrl(this.oCurrentAmlPath, paths, id);
                    }
                    if ((links = (Vector)this.oIDLinks.get(id)) == null) {
                        links = new Vector();
                        this.oIDLinks.put(id, links);
                    }
                    Vector<Object> linkDesc = new Vector<Object>();
                    linkDesc.addElement(this.oCurrentAmlPath);
                    linkDesc.addElement(chtmlElement);
                    links.addElement(linkDesc);
                } else {
                    url = TextUtils.transformAttr(HREF, url);
                }
                CHtmlAmlElementUtils.addCHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, chtmlElement, HREF, url);
            }
        }
    }

    public String addName(CHtmlElement chtmlElement) throws CHtmlAttributeCannotBeAddedException, CHtmlElementCannotBeAddedException, HandlerError {
        String name = null;
        if (chtmlElement instanceof CHtmlA) {
            PageAllocatorInterface pageAllocator = CHtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
            pageAllocator.allocateElement();
            name = pageAllocator.getCurrentElementID();
            this.setCardId(chtmlElement, name);
        }
        return name;
    }

    private void setCardId(CHtmlElement chtmlElement, String id) {
        try {
            CHtmlAmlElementUtils.addCHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, chtmlElement, "name", id);
        }
        catch (HandlerError he) {
            // empty catch block
        }
        String strPath = this.oCurrentAmlPath.toString();
        String oldId = (String)this.oPageIDs.get(strPath);
        if (oldId != null) {
            this.oIDPages.remove(oldId);
            PageAllocatorInterface pageAllocator = CHtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
            pageAllocator.changeElement(oldId, id);
        }
        this.oPageIDs.put(strPath, id);
        Vector<AmlPathInterface> pages = (Vector<AmlPathInterface>)this.oIDPages.get(id);
        if (pages == null) {
            pages = new Vector<AmlPathInterface>();
            this.oIDPages.put(id, pages);
        }
        pages.addElement(this.oCurrentAmlPath);
        Vector links = (Vector)this.oIDLinks.get(id);
        if (links != null) {
            int number = links.size();
            int i = 0;
            while (i < number) {
                Vector linkDesc = (Vector)links.elementAt(i);
                AmlPathInterface amlPath = (AmlPathInterface)linkDesc.elementAt(0);
                CHtmlElement linkElement = (CHtmlElement)linkDesc.elementAt(1);
                try {
                    String url = this.getUrl(amlPath, pages, id);
                    CHtmlAmlElementUtils.addCHtmlAttribute(this.oHandlerManager, amlPath, linkElement, HREF, url);
                }
                catch (HandlerError he) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    private String getUrl(AmlPathInterface srcPath, Vector paths, String id) {
        String url = "#" + id;
        int srcRealm = srcPath.getRealm();
        Enumeration keys = paths.elements();
        boolean isSame = false;
        boolean first = true;
        AmlPathInterface firstPath = null;
        int firstRealm = -1;
        while (keys.hasMoreElements() && !isSame) {
            AmlPathInterface destPath = (AmlPathInterface)keys.nextElement();
            int destRealm = destPath.getRealm();
            if (srcRealm == destRealm) {
                isSame = true;
                continue;
            }
            if (first) {
                firstRealm = destRealm;
                firstPath = destPath;
                first = false;
                continue;
            }
            if (destRealm >= firstRealm) continue;
            firstRealm = destRealm;
            firstPath = destPath;
        }
        if (!isSame && firstPath != null) {
            url = this.getUrl(srcPath, firstPath, id);
        }
        return url;
    }

    private String getUrl(AmlPathInterface srcPath, AmlPathInterface destPath, String id) {
        int destRealm;
        String url = "#" + id;
        int srcRealm = srcPath.getRealm();
        if (srcRealm != (destRealm = destPath.getRealm())) {
            PageAllocatorInterface pageAllocator = CHtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
            url = pageAllocator.getElementURL(id);
        }
        return url;
    }
}

