/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.chtml;

import com.aligo.chtml.CHtmlElementCollection;
import com.aligo.chtml.exceptions.CHtmlElementIndexOutOfBoundsException;
import com.aligo.chtml.interfaces.CHtmlElement;
import com.aligo.modules.chtml.CHtmlAmlHandler;
import com.aligo.modules.chtml.events.CHtmlAmlAddCurrentMemoryHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlCacheContentsHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlGetCHtmlChildContainerStateHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlGetCurrentPageIDHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlGetPageAllocatorMemoryHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlGetPresentationElementsHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlGetPreviousPageIDHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlGetRemainingMemoryHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlIsDeckSaneMemoryHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlIsSufficientMemoryHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlRemoveCurrentMemoryHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlResetCurrentMemoryHandlerEvent;
import com.aligo.modules.chtml.util.CHtmlAmlElementUtils;
import com.aligo.modules.chtml.util.CHtmlEventDescriptor;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.profile.interfaces.UAProfile;
import com.aligo.util.PageCache;
import com.aligo.util.URLUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class CHtmlAmlPresentationContainerHandler
extends CHtmlAmlHandler
implements PageAllocatorInterface {
    public static final long HIGH_RELEVANCE = 10L;
    public static final long RESERVE_MEM = 50L;
    private static final String ELEMENT_PREFIX = "agp";
    private static final String ELEMENT_REFERENCE = "#";
    private static final long DEFAULT_HIGHMEM = 1000L;
    private static final String EXISTS = "true";
    protected CHtmlElementCollection oCHtmlDecks = new CHtmlElementCollection();
    protected boolean bIsTransactionEvent;
    private Map oPageURLMap = Collections.synchronizedMap(new HashMap());
    private Map oPageIDMap = Collections.synchronizedMap(new HashMap());
    private Map oElementURLs = Collections.synchronizedMap(new HashMap());
    private Map oElementLinks = Collections.synchronizedMap(new HashMap());
    private int iCurrentElementNumber;
    private String sCurrentElementID;
    private String sPreviousElementID;
    private PageCache oPageCache;
    private String sCacheURL;
    private boolean bNavigatePrevious = false;
    private String sPreviousLabel = "Back";
    private String sNextLabel = "More";
    private long lMemory;
    private int iActiveIndex = 0;
    private int iBaseIndex = 0;
    private Hashtable oPresentationElements = new Hashtable();
    private Hashtable oCurrentMemories = new Hashtable();
    private int iCurrentRealm;

    public void init() {
        UAProfile uaProfile = this.getUAProfile();
        this.lMemory = (long)uaProfile.getPDUSize() - 50L;
        if (this.lMemory <= 0L) {
            this.defaultMemory();
        }
        if (this.oHandlerLogger.debugEnabled()) {
            this.oHandlerLogger.logDebug("lMemory = " + this.lMemory);
        }
        CHtmlAmlElementUtils.addPresentationElement(this.oPresentationElements, (CHtmlElement)this.oCHtmlDecks);
    }

    private void defaultMemory() {
        this.lMemory = 1000L;
    }

    public CHtmlElement getCHtmlDecks() {
        CHtmlElement chtmlElement = null;
        try {
            chtmlElement = this.oCHtmlDecks.chtmlElementAt(0);
        }
        catch (CHtmlElementIndexOutOfBoundsException cHtmlElementIndexOutOfBoundsException) {
            // empty catch block
        }
        if (this.oHandlerLogger.debugEnabled()) {
            this.oHandlerLogger.logDebug("chtmlElement = " + this.oCHtmlDecks.getContents());
        }
        return chtmlElement;
    }

    public void allocatePage() {
        int index = this.iBaseIndex + this.iActiveIndex;
        StringBuffer pageURL = new StringBuffer(this.sCacheURL);
        pageURL.append(index);
        this.oPageURLMap.put(new Integer(index), pageURL.toString());
        ++this.iActiveIndex;
    }

    private int getMIndex() {
        return this.iBaseIndex + this.iActiveIndex;
    }

    public void changeElement(String oldId, String newId) {
        String linkId;
        String url;
        String linkedId = this.getElementLink(oldId);
        if (linkedId != null) {
            this.oElementLinks.put(newId, linkedId);
            this.oElementLinks.remove(oldId);
        }
        if ((url = (String)this.oElementURLs.get(oldId)) != null) {
            url = URLUtils.composeAnchorURL(url, newId).toString();
            this.oElementURLs.put(newId, url);
            this.oElementURLs.remove(oldId);
        }
        if ((linkId = this.getElementIDLinkingTo(oldId)) != null) {
            this.oElementLinks.put(linkId, newId);
        }
        if (this.sCurrentElementID != null && this.sCurrentElementID.equals(oldId)) {
            this.sCurrentElementID = newId;
        }
        if (this.sPreviousElementID != null && this.sPreviousElementID.equals(oldId)) {
            this.sPreviousElementID = newId;
        }
    }

    public void allocateElement() {
        this.sPreviousElementID = this.sCurrentElementID;
        StringBuffer elementID = new StringBuffer(ELEMENT_PREFIX);
        elementID.append(this.iCurrentElementNumber);
        this.sCurrentElementID = elementID.toString();
        StringBuffer url = new StringBuffer(this.sCacheURL);
        url.append(this.getMIndex());
        url = URLUtils.composeAnchorURL(url.toString(), ELEMENT_PREFIX + this.iCurrentElementNumber);
        String currElementURL = url.toString();
        this.oElementURLs.put(this.sCurrentElementID, currElementURL);
        if (this.sPreviousElementID != null) {
            String prevElementURLPrefix;
            String currElementURLPrefix = currElementURL.substring(0, currElementURL.indexOf(this.sCurrentElementID));
            String prevElementURL = this.getElementURL(this.sPreviousElementID);
            if (prevElementURL != null && (prevElementURLPrefix = prevElementURL.substring(0, prevElementURL.indexOf(this.sPreviousElementID))).equals(currElementURLPrefix)) {
                this.oElementLinks.put(this.sPreviousElementID, this.sCurrentElementID);
            }
        }
        ++this.iCurrentElementNumber;
    }

    public String getElementLink(String elementID) {
        return (String)this.oElementLinks.get(elementID);
    }

    private String getElementIDLinkingTo(String elementID) {
        String result = null;
        Iterator keys = this.oElementLinks.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String tmpElementID = (String)this.oElementLinks.get(key);
            if (tmpElementID == null || !tmpElementID.equals(elementID)) continue;
            result = key;
        }
        return result;
    }

    public void deallocateElement(String elementID) {
        String elementLinkFrom = this.getElementIDLinkingTo(elementID);
        String elementLinkTo = (String)this.oElementLinks.get(elementID);
        if (elementLinkFrom != null && elementLinkTo != null) {
            this.oElementLinks.put(elementLinkFrom, elementLinkTo);
            if (this.sPreviousElementID != null && this.sPreviousElementID.equals(elementID) && this.sCurrentElementID.equals(elementLinkTo)) {
                this.sPreviousElementID = elementLinkFrom;
            }
        } else if (elementLinkFrom != null && elementLinkTo == null) {
            if (this.sPreviousElementID != null && this.sPreviousElementID.equals(elementLinkFrom) && this.sCurrentElementID.equals(elementID)) {
                this.sPreviousElementID = this.getElementIDLinkingTo(elementLinkFrom);
                this.sCurrentElementID = elementLinkFrom;
            }
        } else if (elementLinkFrom == null && elementLinkTo != null && this.sPreviousElementID != null && this.sPreviousElementID.equals(elementID) && this.sCurrentElementID.equals(elementLinkTo)) {
            this.sPreviousElementID = null;
            this.sCurrentElementID = elementLinkTo;
        }
        this.oElementLinks.remove(elementID);
        this.oElementURLs.remove(elementID);
    }

    private String createPageURL(int index) {
        StringBuffer pageURL = new StringBuffer(this.sCacheURL);
        pageURL.append(index);
        return pageURL.toString();
    }

    public boolean navigatePrevious() {
        return this.bNavigatePrevious;
    }

    public String getPreviousLabel() {
        return this.sPreviousLabel;
    }

    public void setPreviousLabel(String label) {
        this.sPreviousLabel = label;
    }

    public String getNextLabel() {
        return this.sNextLabel;
    }

    public void setNextLabel(String label) {
        this.sNextLabel = label;
    }

    public void assignPageID(String pageID) {
        int mIndex = this.iBaseIndex + this.iActiveIndex;
        this.oPageIDMap.put(pageID, new Integer(mIndex));
    }

    public String getPageURL(String pageID) {
        return (String)this.oPageURLMap.get((Integer)this.oPageIDMap.get(pageID));
    }

    public String getCurrentPageURL() {
        int mIndex = this.iBaseIndex + this.iActiveIndex;
        return this.createPageURL(mIndex);
    }

    public String getPreviousPageURL() {
        String prevURL = null;
        if (this.iActiveIndex > 0) {
            int mIndex = this.iBaseIndex + this.iActiveIndex - 1;
            prevURL = this.createPageURL(mIndex);
        }
        return prevURL;
    }

    public String getNextPageURL() {
        String prevURL = null;
        if (this.iActiveIndex > 0) {
            int mIndex = this.iBaseIndex + this.iActiveIndex + 1;
            prevURL = this.createPageURL(mIndex);
        }
        return prevURL;
    }

    public String getPreviousElementURL() {
        return this.getElementURL(this.sPreviousElementID);
    }

    public String getElementURL(String elementID) {
        String result = null;
        if (elementID != null && !elementID.equals("")) {
            result = (String)this.oElementURLs.get(elementID);
        }
        return result;
    }

    public String getCurrentElementURL() {
        return this.getElementURL(this.sCurrentElementID);
    }

    public boolean isElementLinkValid(String linkFromElementID, String linkToElementID) {
        String tmpElementID = this.getElementIDLinkingTo(linkToElementID);
        return linkFromElementID.equals(tmpElementID);
    }

    public String getCurrentElementID() {
        return this.sCurrentElementID;
    }

    public String getPreviousElementID() {
        return this.sPreviousElementID;
    }

    public String getCacheURL() {
        return this.sCacheURL;
    }

    public void setCacheURL(String cacheURL) {
        this.sCacheURL = cacheURL;
    }

    public PageCache getPageCache() {
        return this.oPageCache;
    }

    public void setPageCache(PageCache pageCache) {
        this.oPageCache = pageCache;
    }

    private int getCurrentPageID() {
        return this.iActiveIndex + this.iBaseIndex;
    }

    private int getPreviousPageID() {
        int prevId = -1;
        if (this.iActiveIndex > 0) {
            prevId = this.iActiveIndex + this.iBaseIndex - 1;
        }
        return prevId;
    }

    public Vector getEvents() {
        Vector<CHtmlEventDescriptor> events = new Vector<CHtmlEventDescriptor>();
        CHtmlEventDescriptor eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlGetCHtmlChildContainerStateHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlIsSufficientMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlIsDeckSaneMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlGetRemainingMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlCacheContentsHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlGetCurrentPageIDHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlGetPreviousPageIDHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlGetPageAllocatorMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlResetCurrentMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlAddCurrentMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlRemoveCurrentMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlGetPresentationElementsHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long chtmlAmlRelevance() {
        long currentCHtmlAmlRelevance = 0L;
        if (this.oCurrentEvent instanceof CHtmlAmlGetCHtmlChildContainerStateHandlerEvent) {
            CHtmlAmlGetCHtmlChildContainerStateHandlerEvent getCHtmlChildContainerStateHandlerEvent = (CHtmlAmlGetCHtmlChildContainerStateHandlerEvent)this.oCurrentEvent;
            AmlPathInterface amlPath = getCHtmlChildContainerStateHandlerEvent.getAmlPath();
            if (amlPath == null) {
                currentCHtmlAmlRelevance = 10L;
            }
        } else if (this.oCurrentEvent instanceof CHtmlAmlIsSufficientMemoryHandlerEvent) {
            currentCHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof CHtmlAmlIsDeckSaneMemoryHandlerEvent) {
            currentCHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof CHtmlAmlGetRemainingMemoryHandlerEvent) {
            currentCHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof CHtmlAmlCacheContentsHandlerEvent) {
            currentCHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof CHtmlAmlGetCurrentPageIDHandlerEvent) {
            currentCHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof CHtmlAmlGetPreviousPageIDHandlerEvent) {
            currentCHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof CHtmlAmlGetPageAllocatorMemoryHandlerEvent) {
            currentCHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof CHtmlAmlResetCurrentMemoryHandlerEvent) {
            currentCHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof CHtmlAmlAddCurrentMemoryHandlerEvent) {
            currentCHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof CHtmlAmlRemoveCurrentMemoryHandlerEvent) {
            currentCHtmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof CHtmlAmlGetPresentationElementsHandlerEvent) {
            currentCHtmlAmlRelevance = 10L;
        }
        return currentCHtmlAmlRelevance;
    }

    public void handleEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof CHtmlAmlGetCHtmlChildContainerStateHandlerEvent) {
            CHtmlAmlGetCHtmlChildContainerStateHandlerEvent chtmlAmlCHtmlChildContainerStateHandlerEvent = (CHtmlAmlGetCHtmlChildContainerStateHandlerEvent)this.oCurrentEvent;
            chtmlAmlCHtmlChildContainerStateHandlerEvent.setCHtmlElement(this.oCHtmlDecks);
        } else if (this.oCurrentEvent instanceof CHtmlAmlIsSufficientMemoryHandlerEvent) {
            CHtmlAmlIsSufficientMemoryHandlerEvent isSufficientMemoryEvent = (CHtmlAmlIsSufficientMemoryHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = isSufficientMemoryEvent.getAmlPath();
            boolean memorySufficient = this.isMemorySufficient(currentAmlPath);
            isSufficientMemoryEvent.setSufficient(memorySufficient);
        } else if (this.oCurrentEvent instanceof CHtmlAmlIsDeckSaneMemoryHandlerEvent) {
            CHtmlAmlIsDeckSaneMemoryHandlerEvent isDeckSaneEvent = (CHtmlAmlIsDeckSaneMemoryHandlerEvent)this.oCurrentEvent;
            boolean deckSane = this.isDeckSane();
            isDeckSaneEvent.setSane(deckSane);
        } else if (this.oCurrentEvent instanceof CHtmlAmlGetRemainingMemoryHandlerEvent) {
            CHtmlAmlGetRemainingMemoryHandlerEvent remainingMemoryEvent = (CHtmlAmlGetRemainingMemoryHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = remainingMemoryEvent.getAmlPath();
            long remainingMemory = 0L;
            try {
                long bytes = this.getCurrentNumberBytes(currentAmlPath);
                if (this.lMemory > bytes) {
                    remainingMemory = this.lMemory - bytes;
                }
            }
            catch (CHtmlElementIndexOutOfBoundsException ie) {
                // empty catch block
            }
            remainingMemoryEvent.setNumberBytes(remainingMemory);
        } else if (this.oCurrentEvent instanceof CHtmlAmlCacheContentsHandlerEvent) {
            this.allocatePage();
            int i = 0;
            while (i < this.iActiveIndex) {
                int index = this.iBaseIndex + i;
                try {
                    this.oPageCache.putIndexedPage(Integer.toString(index), this.oCHtmlDecks.chtmlElementAt(i).getContents());
                }
                catch (CHtmlElementIndexOutOfBoundsException ie) {
                    // empty catch block
                }
                ++i;
            }
        } else if (this.oCurrentEvent instanceof CHtmlAmlGetCurrentPageIDHandlerEvent) {
            CHtmlAmlGetCurrentPageIDHandlerEvent currentPageIDEvent = (CHtmlAmlGetCurrentPageIDHandlerEvent)this.oCurrentEvent;
            currentPageIDEvent.setID(new Integer(this.getCurrentPageID()).toString());
        } else if (this.oCurrentEvent instanceof CHtmlAmlGetPreviousPageIDHandlerEvent) {
            CHtmlAmlGetPreviousPageIDHandlerEvent previousPageIDEvent = (CHtmlAmlGetPreviousPageIDHandlerEvent)this.oCurrentEvent;
            previousPageIDEvent.setID(new Integer(this.getPreviousPageID()).toString());
        } else if (this.oCurrentEvent instanceof CHtmlAmlGetPageAllocatorMemoryHandlerEvent) {
            CHtmlAmlGetPageAllocatorMemoryHandlerEvent getPageAllocatorEvent = (CHtmlAmlGetPageAllocatorMemoryHandlerEvent)this.oCurrentEvent;
            getPageAllocatorEvent.setPageAllocator(this);
        } else if (this.oCurrentEvent instanceof CHtmlAmlResetCurrentMemoryHandlerEvent) {
            AmlPathInterface currentAmlPath = ((CHtmlAmlResetCurrentMemoryHandlerEvent)this.oCurrentEvent).getAmlPath();
            this.resetCurrentMemory(currentAmlPath);
        } else if (this.oCurrentEvent instanceof CHtmlAmlAddCurrentMemoryHandlerEvent) {
            CHtmlAmlAddCurrentMemoryHandlerEvent addCurrentMemoryEvent = (CHtmlAmlAddCurrentMemoryHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = addCurrentMemoryEvent.getAmlPath();
            long addMemory = addCurrentMemoryEvent.getMemory();
            long currentMemory = this.getCurrentMemory(currentAmlPath);
            this.setCurrentMemory(currentAmlPath, currentMemory += addMemory);
        } else if (this.oCurrentEvent instanceof CHtmlAmlRemoveCurrentMemoryHandlerEvent) {
            CHtmlAmlRemoveCurrentMemoryHandlerEvent removeCurrentMemoryEvent = (CHtmlAmlRemoveCurrentMemoryHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = removeCurrentMemoryEvent.getAmlPath();
            long removeMemory = removeCurrentMemoryEvent.getMemory();
            long currentMemory = this.getCurrentMemory(currentAmlPath);
            this.setCurrentMemory(currentAmlPath, currentMemory -= removeMemory);
        } else if (this.oCurrentEvent instanceof CHtmlAmlGetPresentationElementsHandlerEvent) {
            CHtmlAmlGetPresentationElementsHandlerEvent getPresentationElementsEvent = (CHtmlAmlGetPresentationElementsHandlerEvent)this.oCurrentEvent;
            getPresentationElementsEvent.setCHtmlElements(this.oPresentationElements);
        }
    }

    private boolean isMemorySufficient(AmlPathInterface currentAmlPath) {
        boolean memorySufficient = true;
        try {
            long bytes = this.getCurrentNumberBytes(currentAmlPath);
            if (bytes > this.lMemory) {
                memorySufficient = false;
            }
        }
        catch (CHtmlElementIndexOutOfBoundsException ie) {
            memorySufficient = false;
        }
        return memorySufficient;
    }

    private long getCurrentNumberBytes(AmlPathInterface currentAmlPath) throws CHtmlElementIndexOutOfBoundsException {
        long bytes = this.getCurrentMemory(currentAmlPath);
        return bytes;
    }

    private boolean isElementSane(CHtmlElement chtmlElement) {
        boolean elementSane = true;
        if (chtmlElement == null) {
            elementSane = false;
        } else {
            elementSane = chtmlElement.areCHtmlChildrenSane();
            if (elementSane && (elementSane = chtmlElement.areCHtmlAttributesSane())) {
                int numberChildren = chtmlElement.getNumberElements();
                int i = 0;
                while (i < numberChildren && elementSane) {
                    try {
                        CHtmlElement childCHtmlElement = chtmlElement.chtmlElementAt(i);
                        elementSane = this.isElementSane(childCHtmlElement);
                    }
                    catch (CHtmlElementIndexOutOfBoundsException ie) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }
        return elementSane;
    }

    private boolean isDeckSane() {
        boolean deckSane = true;
        try {
            CHtmlElement chtmlElement = this.oCHtmlDecks.chtmlElementAt(this.iActiveIndex);
            deckSane = this.isElementSane(chtmlElement);
        }
        catch (CHtmlElementIndexOutOfBoundsException ie) {
            deckSane = false;
        }
        return deckSane;
    }

    private long getDefaultMemory() {
        return 0L;
    }

    private void resetCurrentMemory(AmlPathInterface currentAmlPath) {
        this.setCurrentMemory(currentAmlPath, this.getDefaultMemory());
    }

    private long getCurrentMemory(AmlPathInterface currentAmlPath) {
        int realm = currentAmlPath.getRealm();
        Long objMemory = (Long)this.oCurrentMemories.get(new Integer(realm));
        long memory = this.getDefaultMemory();
        if (objMemory != null) {
            memory = objMemory;
        }
        return memory;
    }

    private void setCurrentMemory(AmlPathInterface currentAmlPath, long memory) {
        int realm = currentAmlPath.getRealm();
        this.oCurrentMemories.put(new Integer(realm), new Long(memory));
    }
}

