/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.chtml;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.chtml.CHtmlAmlPathHandler;
import com.aligo.modules.chtml.errors.CHtmlAmlHandlerError;
import com.aligo.modules.chtml.events.CHtmlAmlControlMenuOffsetHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlGetAddChildIndexHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlGetNextChildIndexHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlGetPreviousChildIndexHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlIsAncestorPersistentHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlIsPersistentHandlerEvent;
import com.aligo.modules.chtml.exceptions.CHtmlAmlNextIndexNotFoundPersistException;
import com.aligo.modules.chtml.exceptions.CHtmlAmlPreviousIndexNotFoundPersistException;
import com.aligo.modules.chtml.util.CHtmlAmlElementUtils;
import com.aligo.modules.chtml.util.CHtmlAmlMemoryUtils;
import com.aligo.modules.chtml.util.CHtmlEventDescriptor;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.paths.exceptions.AmlPathIndexOutOfBoundsException;
import com.aligo.modules.paths.interfaces.AmlPathComponentInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CHtmlAmlPersistChildHandler
extends CHtmlAmlPathHandler {
    public static final String PERSIST = "persist";
    public static final String PERSIST_FALSE = "false";
    public static final String HEADER_TRUE = "true";
    private Hashtable oPathIndices = new Hashtable();
    private Hashtable oIsPersistent = new Hashtable();

    public Hashtable getPathIndices(AmlPathInterface amlPath) {
        String strAmlPath = amlPath.toString();
        Hashtable indices = (Hashtable)this.oPathIndices.get(strAmlPath);
        if (indices == null) {
            indices = new Hashtable();
            this.oPathIndices.put(strAmlPath, indices);
        }
        return indices;
    }

    public Vector getEvents() {
        Vector<CHtmlEventDescriptor> events = new Vector<CHtmlEventDescriptor>();
        CHtmlEventDescriptor eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlGetNextChildIndexHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlGetPreviousChildIndexHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlGetAddChildIndexHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlIsAncestorPersistentHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlIsPersistentHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long chtmlAmlPathRelevance() {
        long currentCHtmlAmlPathRelevance = 0L;
        if (this.oCurrentEvent instanceof CHtmlAmlGetNextChildIndexHandlerEvent) {
            CHtmlAmlGetNextChildIndexHandlerEvent getNextChildIndexEvent = (CHtmlAmlGetNextChildIndexHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = getNextChildIndexEvent.getAmlPath();
            AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
            if (parentAmlPath != null) {
                int currentIndex = getNextChildIndexEvent.getCurrentIndex();
                boolean relevant = false;
                relevant = currentIndex == -1 ? true : this.isRelevant(parentAmlPath);
                if (relevant) {
                    currentCHtmlAmlPathRelevance = 30L;
                }
            }
        } else if (this.oCurrentEvent instanceof CHtmlAmlGetPreviousChildIndexHandlerEvent) {
            boolean relevant;
            CHtmlAmlGetPreviousChildIndexHandlerEvent getPreviousChildIndexEvent = (CHtmlAmlGetPreviousChildIndexHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = getPreviousChildIndexEvent.getAmlPath();
            AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
            if (parentAmlPath != null && (relevant = this.isRelevant(parentAmlPath))) {
                currentCHtmlAmlPathRelevance = 30L;
            }
        } else if (this.oCurrentEvent instanceof CHtmlAmlGetAddChildIndexHandlerEvent) {
            CHtmlAmlGetAddChildIndexHandlerEvent getAddChildIndexEvent = (CHtmlAmlGetAddChildIndexHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = getAddChildIndexEvent.getAmlPath();
            AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
            int childIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
            if (parentAmlPath != null && this.isRelevant(parentAmlPath)) {
                try {
                    if (!CHtmlAmlElementUtils.isPersistent(this.oHandlerManager, currentAmlPath)) {
                        currentCHtmlAmlPathRelevance = 30L;
                    }
                }
                catch (Exception ex) {}
            }
        } else if (this.oCurrentEvent instanceof CHtmlAmlIsAncestorPersistentHandlerEvent) {
            currentCHtmlAmlPathRelevance = 20L;
        } else if (this.oCurrentEvent instanceof CHtmlAmlIsPersistentHandlerEvent) {
            currentCHtmlAmlPathRelevance = 20L;
        }
        return currentCHtmlAmlPathRelevance;
    }

    public void handlePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof CHtmlAmlGetNextChildIndexHandlerEvent) {
            CHtmlAmlGetNextChildIndexHandlerEvent getNextChildIndexEvent = (CHtmlAmlGetNextChildIndexHandlerEvent)this.oCurrentEvent;
            int currentIndex = getNextChildIndexEvent.getCurrentIndex();
            AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
            int nextIndex = 0;
            if (currentIndex == -1) {
                this.prepareIndices(parentAmlPath);
            }
            nextIndex = this.getNextChildIndex(parentAmlPath, currentIndex);
            getNextChildIndexEvent.setNextIndex(nextIndex);
        } else if (this.oCurrentEvent instanceof CHtmlAmlGetPreviousChildIndexHandlerEvent) {
            CHtmlAmlGetPreviousChildIndexHandlerEvent getPreviousChildIndexEvent = (CHtmlAmlGetPreviousChildIndexHandlerEvent)this.oCurrentEvent;
            int currentIndex = getPreviousChildIndexEvent.getCurrentIndex();
            AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
            int previousIndex = this.getPreviousChildIndex(parentAmlPath, currentIndex);
            getPreviousChildIndexEvent.setPreviousIndex(previousIndex);
        } else if (this.oCurrentEvent instanceof CHtmlAmlGetAddChildIndexHandlerEvent) {
            CHtmlAmlGetAddChildIndexHandlerEvent getAddChildIndexEvent = (CHtmlAmlGetAddChildIndexHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = this.oCurrentAmlPath;
            AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
            int childIndex = this.getAddChildIndex(currentAmlPath);
            int childSubIndex = getAddChildIndexEvent.getChildIndex();
            if (childSubIndex == -1) {
                childSubIndex = 0;
            }
            CHtmlAmlControlMenuOffsetHandlerEvent controlMenuOffsetEvent = new CHtmlAmlControlMenuOffsetHandlerEvent(currentAmlPath, childIndex);
            this.oHandlerManager.postEventNow(controlMenuOffsetEvent);
            int cmOffsetChildIndex = controlMenuOffsetEvent.getOffsetChildIndex();
            childIndex = cmOffsetChildIndex != -1 ? cmOffsetChildIndex + childSubIndex : (childIndex += childSubIndex);
            getAddChildIndexEvent.setAddChildIndex(childIndex);
        } else if (this.oCurrentEvent instanceof CHtmlAmlIsAncestorPersistentHandlerEvent) {
            CHtmlAmlIsAncestorPersistentHandlerEvent isAncestorPersistentEvent = (CHtmlAmlIsAncestorPersistentHandlerEvent)this.oCurrentEvent;
            AmlPathInterface amlPath = isAncestorPersistentEvent.getAmlPath();
            boolean persistent = this.isAncestorPersistent(amlPath);
            isAncestorPersistentEvent.setPersistent(persistent);
        } else if (this.oCurrentEvent instanceof CHtmlAmlIsPersistentHandlerEvent) {
            CHtmlAmlIsPersistentHandlerEvent isPersistentEvent = (CHtmlAmlIsPersistentHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = isPersistentEvent.getAmlPath();
            boolean persistent = this.isPersistent(currentAmlPath);
            isPersistentEvent.setPersistent(persistent);
        }
    }

    private int getAddChildIndex(AmlPathInterface currentAmlPath) throws HandlerError {
        int addChildIndex = -1;
        int childIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
        AmlPathInterface lastWorkingPath = CHtmlAmlMemoryUtils.getLastWorkingPath(this.oHandlerManager);
        if (lastWorkingPath == null) {
            addChildIndex = childIndex;
        } else {
            int currentNumberElements = currentAmlPath.getNumberAmlPathComponents();
            int numberElements = lastWorkingPath.getNumberAmlPathComponents();
            try {
                boolean memoryCache = false;
                AmlPathInterface amlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
                AmlPathInterface parentLastWorkingPath = AmlPathUtils.getParentPath(this.oHandlerManager, lastWorkingPath);
                if (this.arePathsConcurrent(amlPath, parentLastWorkingPath)) {
                    memoryCache = true;
                }
                if (!memoryCache) {
                    addChildIndex = childIndex;
                } else if (numberElements < currentNumberElements) {
                    addChildIndex = childIndex;
                } else {
                    AmlPathComponentInterface pathComponent = lastWorkingPath.getAmlPathComponentAt(currentNumberElements - 1);
                    int lastChildIndex = pathComponent.getPathIndex();
                    if (childIndex >= lastChildIndex) {
                        addChildIndex = this.getNumberPersistElements(amlPath, lastChildIndex);
                        addChildIndex += childIndex - lastChildIndex;
                    }
                }
            }
            catch (AmlPathIndexOutOfBoundsException ae) {
                // empty catch block
            }
        }
        return addChildIndex;
    }

    private int getNumberPersistElements(AmlPathInterface parentPath, int lastChildIndex) {
        int numberPersistElements = 0;
        if (parentPath != null) {
            try {
                AxmlElement parentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentPath);
                int numberChildren = parentAmlElement.getNumberElements();
                if (lastChildIndex > numberChildren) {
                    lastChildIndex = numberChildren;
                }
                try {
                    int i = 0;
                    while (i < lastChildIndex) {
                        AmlPathInterface childAmlPath = AmlPathUtils.getChildPath(this.oHandlerManager, parentPath, i);
                        if (CHtmlAmlElementUtils.isPersistent(this.oHandlerManager, childAmlPath)) {
                            ++numberPersistElements;
                        }
                        ++i;
                    }
                }
                catch (ArrayIndexOutOfBoundsException ae) {}
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return numberPersistElements;
    }

    private boolean isRelevant(AmlPathInterface amlPath) {
        String strAmlPath;
        Boolean boPersistent;
        boolean relevant = false;
        AmlPathInterface lastWorkingPath = null;
        try {
            lastWorkingPath = CHtmlAmlMemoryUtils.getLastWorkingPath(this.oHandlerManager);
        }
        catch (HandlerError he) {
            // empty catch block
        }
        if (lastWorkingPath != null) {
            relevant = true;
        }
        if (!relevant && (boPersistent = (Boolean)this.oIsPersistent.get(strAmlPath = amlPath.toString())) != null) {
            relevant = boPersistent;
        }
        return relevant;
    }

    private boolean arePathsConcurrent(AmlPathInterface path1, AmlPathInterface path2) {
        boolean concurrent = false;
        if (path1 != null && path2 != null) {
            int path2Elements;
            int path1Elements = path1.getNumberAmlPathComponents();
            if (path1Elements <= (path2Elements = path2.getNumberAmlPathComponents())) {
                try {
                    boolean equal = true;
                    int i = 0;
                    while (i < path1Elements && equal) {
                        AmlPathComponentInterface memoryComponent;
                        int memoryPathIndex;
                        AmlPathComponentInterface component = path1.getAmlPathComponentAt(i);
                        int pathIndex = component.getPathIndex();
                        if (pathIndex != (memoryPathIndex = (memoryComponent = path2.getAmlPathComponentAt(i)).getPathIndex())) {
                            equal = false;
                        }
                        ++i;
                    }
                    if (equal) {
                        concurrent = true;
                    }
                }
                catch (AmlPathIndexOutOfBoundsException ae) {}
            }
        } else if (path1 == null && path2 == null) {
            concurrent = true;
        }
        return concurrent;
    }

    private int getNextTableIndex(AmlPathInterface amlPath, int currentIndex) throws Exception {
        int nextIndex = currentIndex;
        Hashtable indices = this.getPathIndices(amlPath);
        boolean error = false;
        if (indices != null) {
            Integer nextIIndex = (Integer)indices.get(new Integer(currentIndex));
            if (nextIIndex != null) {
                nextIndex = nextIIndex;
            } else {
                error = true;
            }
        } else {
            error = true;
        }
        if (error) {
            throw new CHtmlAmlNextIndexNotFoundPersistException(amlPath, currentIndex);
        }
        return nextIndex;
    }

    private int getPreviousTableIndex(AmlPathInterface amlPath, int currentIndex) throws Exception {
        int previousIndex = currentIndex;
        Hashtable indices = this.getPathIndices(amlPath);
        boolean error = false;
        boolean found = false;
        if (indices != null) {
            Enumeration keys = indices.keys();
            Integer IcurrentIndex = new Integer(currentIndex);
            while (keys.hasMoreElements() && !found) {
                Integer key = (Integer)keys.nextElement();
                Integer value = (Integer)indices.get(key);
                if (value == null || !IcurrentIndex.equals(value)) continue;
                previousIndex = key;
                found = true;
            }
            if (!found) {
                error = true;
            }
        } else {
            error = true;
        }
        if (error) {
            throw new CHtmlAmlPreviousIndexNotFoundPersistException(amlPath, currentIndex);
        }
        return previousIndex;
    }

    private int getNextChildIndex(AmlPathInterface amlPath, int currentIndex) throws HandlerError {
        AmlPathInterface lastWorkingPath = CHtmlAmlMemoryUtils.getLastWorkingPath(this.oHandlerManager);
        return this.getNextChildIndex(amlPath, currentIndex, lastWorkingPath);
    }

    private int getPreviousChildIndex(AmlPathInterface amlPath, int currentIndex) throws HandlerError {
        AmlPathInterface lastWorkingPath = CHtmlAmlMemoryUtils.getLastWorkingPath(this.oHandlerManager);
        return this.getPreviousChildIndex(amlPath, currentIndex, lastWorkingPath);
    }

    private int getNextChildIndex(AmlPathInterface amlPath, int currentIndex, AmlPathInterface lastWorkingPath) throws HandlerError {
        try {
            int nextIndex = this.getNextTableIndex(amlPath, currentIndex);
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath);
            int numberChildren = amlElement.getNumberElements();
            try {
                if (nextIndex < numberChildren) {
                    AmlPathInterface parentLastWorkingPath;
                    AmlPathInterface childAmlPath = AmlPathUtils.getChildPath(this.oHandlerManager, amlPath, nextIndex);
                    boolean persistent = this.isAncestorPersistent(childAmlPath);
                    boolean memoryCache = false;
                    if (lastWorkingPath != null && this.arePathsConcurrent(amlPath, parentLastWorkingPath = AmlPathUtils.getParentPath(this.oHandlerManager, lastWorkingPath))) {
                        memoryCache = true;
                    }
                    if (!persistent && memoryCache) {
                        AmlPathComponentInterface pathComponent;
                        int lastChildIndex;
                        int currentNumberElements = amlPath.getNumberAmlPathComponents() + 1;
                        int numberElements = lastWorkingPath.getNumberAmlPathComponents();
                        if (currentNumberElements != 0 && numberElements >= currentNumberElements && nextIndex < (lastChildIndex = (pathComponent = lastWorkingPath.getAmlPathComponentAt(currentNumberElements - 1)).getPathIndex())) {
                            nextIndex = this.getNextChildIndex(amlPath, nextIndex, lastWorkingPath);
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
                throw new CHtmlAmlHandlerError(ex);
            }
            return nextIndex;
        }
        catch (Exception ex) {
            throw new CHtmlAmlHandlerError(ex);
        }
    }

    private int getPreviousChildIndex(AmlPathInterface amlPath, int currentIndex, AmlPathInterface lastWorkingPath) throws HandlerError {
        try {
            int previousIndex = this.getPreviousTableIndex(amlPath, currentIndex);
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath);
            int numberChildren = amlElement.getNumberElements();
            try {
                if (previousIndex >= 0) {
                    AmlPathInterface parentLastWorkingPath;
                    AmlPathInterface childAmlPath = AmlPathUtils.getChildPath(this.oHandlerManager, amlPath, previousIndex);
                    boolean persistent = this.isAncestorPersistent(childAmlPath);
                    boolean memoryCache = false;
                    if (lastWorkingPath != null && this.arePathsConcurrent(amlPath, parentLastWorkingPath = AmlPathUtils.getParentPath(this.oHandlerManager, lastWorkingPath))) {
                        memoryCache = true;
                    }
                    if (!persistent && memoryCache) {
                        AmlPathComponentInterface pathComponent;
                        int lastChildIndex;
                        int currentNumberElements = amlPath.getNumberAmlPathComponents() + 1;
                        int numberElements = lastWorkingPath.getNumberAmlPathComponents();
                        if (currentNumberElements != 0 && numberElements >= currentNumberElements && previousIndex < (lastChildIndex = (pathComponent = lastWorkingPath.getAmlPathComponentAt(currentNumberElements - 1)).getPathIndex())) {
                            previousIndex = this.getPreviousChildIndex(amlPath, previousIndex, lastWorkingPath);
                        }
                    }
                }
            }
            catch (Exception ex) {
                throw new CHtmlAmlHandlerError(ex);
            }
            return previousIndex;
        }
        catch (Exception ex) {
            throw new CHtmlAmlHandlerError(ex);
        }
    }

    private boolean isAncestorPersistent(AmlPathInterface amlPath) {
        boolean persistent = false;
        AmlPathInterface rPath = amlPath;
        boolean done = false;
        try {
            while (rPath != null && !done) {
                if (CHtmlAmlElementUtils.isPersistent(this.oHandlerManager, rPath)) {
                    persistent = true;
                    done = true;
                }
                rPath = AmlPathUtils.getParentPath(this.oHandlerManager, rPath);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return persistent;
    }

    private boolean isPersistent(AmlPathInterface amlPath) throws HandlerError {
        boolean persistent = false;
        AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath);
        String value = amlElement.getAxmlAttributeValue(PERSIST);
        if (value != null && !value.equals(PERSIST_FALSE)) {
            persistent = true;
        }
        return persistent;
    }

    private void prepareIndices(AmlPathInterface amlPath) {
        try {
            boolean persistent = false;
            Hashtable indices = this.getPathIndices(amlPath);
            String strAmlPath = amlPath.toString();
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath);
            int numberChildren = amlElement.getNumberElements();
            Vector<Integer> persistIndices = new Vector<Integer>();
            Vector<Integer> normalIndices = new Vector<Integer>();
            int i = 0;
            while (i < numberChildren) {
                try {
                    AmlPathInterface childAmlPath = AmlPathUtils.getChildPath(this.oHandlerManager, amlPath, i);
                    if (CHtmlAmlElementUtils.isPersistent(this.oHandlerManager, childAmlPath)) {
                        if (!persistent) {
                            this.oIsPersistent.put(strAmlPath, new Boolean(true));
                            persistent = true;
                        }
                        persistIndices.addElement(new Integer(i));
                    } else {
                        normalIndices.addElement(new Integer(i));
                    }
                }
                catch (ArrayIndexOutOfBoundsException ae) {
                    // empty catch block
                }
                ++i;
            }
            Integer lpin = new Integer(-1);
            int psize = persistIndices.size();
            int i2 = 0;
            while (i2 < psize) {
                Integer pin = (Integer)persistIndices.elementAt(i2);
                indices.put(lpin, pin);
                lpin = pin;
                ++i2;
            }
            int nsize = normalIndices.size();
            int i3 = 0;
            while (i3 < nsize) {
                Integer nin = (Integer)normalIndices.elementAt(i3);
                indices.put(lpin, nin);
                lpin = nin;
                ++i3;
            }
            indices.put(lpin, new Integer(numberChildren));
        }
        catch (Exception ex) {
            this.oHandlerLogger.logError(ex);
        }
    }
}

