/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.aml.handlers;

import com.aligo.axml.AxmlForm;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.EventDescriptor;
import com.aligo.modules.aml.events.AmlIsCacheableEvent;
import com.aligo.modules.aml.events.AmlIsFormChoicePresentEvent;
import com.aligo.modules.aml.handlers.AmlPathHandler;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import java.util.Vector;

public class AmlCacheHandler
extends AmlPathHandler {
    private static final String FALSE = "false";
    private static final String CHOICE = "com.aligo.axml.AxmlChoice";

    public Vector getEvents() {
        Vector<EventDescriptor> events = new Vector<EventDescriptor>();
        EventDescriptor eventDescriptor = new EventDescriptor("AmlIsCacheableEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new EventDescriptor("AmlIsFormChoicePresentEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long amlPathRelevance() {
        long currentWmlAmlPathRelevance = 0L;
        if (this.oEvent instanceof AmlIsCacheableEvent) {
            currentWmlAmlPathRelevance = 20L;
        }
        return currentWmlAmlPathRelevance;
    }

    public void handlePathEventNow() {
        if (this.oEvent instanceof AmlIsCacheableEvent) {
            AmlIsCacheableEvent isCacheableEvent = (AmlIsCacheableEvent)this.oEvent;
            boolean cacheable = this.isCacheable(this.oCurrentAmlPath);
            isCacheableEvent.setCacheable(cacheable);
        } else if (this.oEvent instanceof AmlIsFormChoicePresentEvent) {
            AmlIsFormChoicePresentEvent isFormChoicePresentEvent = (AmlIsFormChoicePresentEvent)this.oEvent;
            boolean present = this.isFormChoicePresent(this.oCurrentAmlPath);
            isFormChoicePresentEvent.setPresent(present);
        }
    }

    private boolean isFormChoicePresent(AmlPathInterface amlPath) {
        AxmlElement amlElement;
        AmlPathInterface choiceParentPath;
        boolean present = false;
        AmlPathInterface choicePath = AmlPathUtils.getAncestorPath(this.oHandlerManager, amlPath, CHOICE);
        if (choicePath != null && (choiceParentPath = AmlPathUtils.getParentPath(this.oHandlerManager, choicePath)) != null && (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, choiceParentPath)) instanceof AxmlForm) {
            present = true;
        }
        return present;
    }

    private boolean isCacheable(AmlPathInterface amlPath) {
        boolean cacheable = true;
        while (amlPath != null && cacheable) {
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath);
            String cacheValue = amlElement.getAxmlAttributeValue("cache");
            if (cacheValue != null && cacheValue.equals(FALSE)) {
                cacheable = false;
            }
            if (this.oHandlerLogger.debugEnabled()) {
                this.oHandlerLogger.logDebug("amlPath " + amlPath + " cacaheble " + cacheable);
            }
            amlPath = AmlPathUtils.getParentPath(this.oHandlerManager, amlPath);
        }
        return cacheable;
    }
}

