/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules;

import com.aligo.modules.exceptions.DepthOutOfBoundsContextStackException;
import com.aligo.modules.exceptions.EmptyContextStackException;
import com.aligo.modules.interfaces.ContextInterface;
import com.aligo.modules.interfaces.ContextStackInterface;
import java.util.EmptyStackException;
import java.util.Stack;

public class ContextStack
implements ContextStackInterface {
    private Stack oStack = new Stack();

    public void push(ContextInterface context) {
        this.oStack.push(context);
    }

    public ContextInterface pop() throws EmptyContextStackException {
        try {
            return (ContextInterface)this.oStack.pop();
        }
        catch (EmptyStackException e) {
            throw new EmptyContextStackException();
        }
    }

    public ContextInterface peekAt(int depth) throws DepthOutOfBoundsContextStackException {
        int numberElements = this.oStack.size();
        int elementIndex = numberElements - depth - 1;
        try {
            return (ContextInterface)this.oStack.elementAt(elementIndex);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new DepthOutOfBoundsContextStackException(depth);
        }
    }

    public ContextInterface peek() {
        return (ContextInterface)this.oStack.peek();
    }

    public int getDepth() {
        return this.oStack.size();
    }

    public void clear() {
        this.oStack.clear();
    }
}

