/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules;

import com.aligo.interfaces.AligoEventInterface;
import com.aligo.modules.interfaces.ContextHandlerInterface;
import com.aligo.modules.interfaces.ContextHandlersInterface;
import com.aligo.modules.interfaces.EventDescriptorInterface;
import com.aligo.modules.interfaces.EventHookDescriptorInterface;
import com.aligo.modules.interfaces.EventHookPosition;
import com.aligo.modules.interfaces.HandlerInterface;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class ContextHandlers
implements ContextHandlersInterface {
    private HashMap oEventHandlers = new HashMap();
    private HashMap oHandlerEvents = new HashMap();
    private ArrayList oUnknownHandlers;
    private HashMap oEventHooks = new HashMap();

    private void addEventHandler(EventDescriptorInterface event, HandlerInterface handler) {
        if (event instanceof EventHookDescriptorInterface) {
            EventHookPosition position;
            ArrayList<HandlerInterface> handlers;
            EventHookDescriptorInterface eventHook = (EventHookDescriptorInterface)event;
            String eventName = eventHook.toString();
            HashMap hooks = (HashMap)this.oEventHooks.get(eventName);
            if (hooks == null) {
                hooks = new HashMap();
                this.oEventHooks.put(eventName, hooks);
            }
            if ((handlers = this.getHandlersByPosition(hooks, position = eventHook.getPosition())) == null) {
                handlers = new ArrayList<HandlerInterface>();
            }
            handlers.add(handler);
            this.setHandlersByPosition(hooks, position, handlers);
        } else {
            ArrayList<HandlerInterface> handlers = (ArrayList<HandlerInterface>)this.oEventHandlers.get(event.toString());
            if (handlers == null) {
                handlers = new ArrayList<HandlerInterface>();
            }
            handlers.add(handler);
            this.oEventHandlers.put(event.toString(), handlers);
            ArrayList<EventDescriptorInterface> events = (ArrayList<EventDescriptorInterface>)this.oHandlerEvents.get(handler);
            if (events == null) {
                events = new ArrayList<EventDescriptorInterface>();
            }
            events.add(event);
            this.oHandlerEvents.put(handler, events);
        }
    }

    private void addUnknownHandler(HandlerInterface handler) {
        if (this.oUnknownHandlers == null) {
            this.oUnknownHandlers = new ArrayList();
        }
        this.oUnknownHandlers.add(handler);
    }

    public void addHandler(HandlerInterface handler) {
        ContextHandlerInterface contextHandler;
        Vector events;
        boolean eventInfoGiven = false;
        if (handler instanceof ContextHandlerInterface && (events = (contextHandler = (ContextHandlerInterface)((Object)handler)).getEvents()) != null) {
            int numberEvents = events.size();
            int i = 0;
            while (i < numberEvents) {
                EventDescriptorInterface objEvent = (EventDescriptorInterface)events.elementAt(i);
                if (objEvent instanceof EventDescriptorInterface) {
                    EventDescriptorInterface event = objEvent;
                    this.addEventHandler(event, handler);
                    if (!eventInfoGiven) {
                        eventInfoGiven = true;
                    }
                }
                ++i;
            }
        }
        if (!eventInfoGiven) {
            this.addUnknownHandler(handler);
        }
    }

    public void removeHandler(HandlerInterface handler) {
        ArrayList events = (ArrayList)this.oHandlerEvents.get(handler);
        if (events != null) {
            int numberEvents = events.size();
            int i = 0;
            while (i < numberEvents) {
                EventDescriptorInterface event = (EventDescriptorInterface)events.get(i);
                ArrayList handlers = (ArrayList)this.oEventHandlers.get(event.toString());
                if (handlers != null) {
                    ((AbstractCollection)handlers).remove(handler);
                }
                if (handlers.size() == 0) {
                    this.oEventHandlers.remove(event);
                }
                ++i;
            }
            this.oHandlerEvents.remove(handler);
        }
    }

    public void removeAllHandlers() {
        this.oEventHandlers.clear();
        this.oHandlerEvents.clear();
        this.oUnknownHandlers.clear();
    }

    public ArrayList getHandlers(AligoEventInterface event, EventHookPosition position) {
        ArrayList handlers = null;
        String eventName = event.getEventName();
        HashMap hooks = (HashMap)this.oEventHooks.get(eventName);
        if (hooks != null) {
            handlers = this.getHandlersByPosition(hooks, position);
        }
        return handlers;
    }

    public ArrayList getHandlers(AligoEventInterface event) {
        ArrayList handlers = null;
        if (event != null) {
            handlers = (ArrayList)this.oEventHandlers.get(event.getEventName());
            if (this.oUnknownHandlers != null) {
                if (handlers == null) {
                    handlers = this.oUnknownHandlers;
                } else {
                    ArrayList allHandlers = new ArrayList();
                    allHandlers.addAll(handlers);
                    allHandlers.addAll(this.oUnknownHandlers);
                    handlers = allHandlers;
                }
            }
        }
        if (handlers == null) {
            handlers = new ArrayList();
        }
        return handlers;
    }

    private ArrayList getHandlersByPosition(HashMap hooks, EventHookPosition position) {
        return (ArrayList)hooks.get(new Integer(position.getPosition()));
    }

    private void setHandlersByPosition(HashMap hooks, EventHookPosition position, ArrayList handlers) {
        hooks.put(new Integer(position.getPosition()), handlers);
    }
}

