/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.ihtml;

import com.aligo.ihtml.IHtmlAttributes;
import com.aligo.ihtml.IHtmlContainer;
import com.aligo.ihtml.IHtmlElementCollection;
import com.aligo.ihtml.exceptions.IHtmlAttributeCannotBeAddedException;
import com.aligo.ihtml.exceptions.IHtmlElementCannotBeAddedException;
import com.aligo.ihtml.exceptions.IHtmlElementCloneFailedException;
import com.aligo.ihtml.exceptions.IHtmlElementIndexOutOfBoundsException;
import com.aligo.ihtml.exceptions.IHtmlElementNotFoundException;
import com.aligo.ihtml.exceptions.IHtmlTextCannotBeResetException;
import com.aligo.ihtml.exceptions.IHtmlTextCannotBeSetException;
import com.aligo.ihtml.exceptions.IHtmlTextNotSetException;
import com.aligo.ihtml.interfaces.IHtmlAttributeInterface;
import com.aligo.ihtml.interfaces.IHtmlContainerInterface;
import com.aligo.ihtml.interfaces.IHtmlElement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class IHtmlBaseElement
implements IHtmlElement {
    public static final String AMPERSAND = "&";
    public static final String CLOSEBRACE = ")";
    public static final String COLON = ":";
    public static final String COMMA = ",";
    public static final String DASH = "-";
    public static final String DOLLAR = "$";
    public static final String EQUALS = "=";
    public static final String FORWARDSLASH = "/";
    public static final String GREATERTHAN = ">";
    public static final String HASH = "#";
    public static final String LESSERTHAN = "<";
    public static final String NEWLINE = "\n";
    public static final String OPENBRACE = "(";
    public static final String QUESTION = "?";
    public static final String QUOTE = "\"";
    public static final String SEMICOLON = ";";
    public static final String SPACE = " ";
    public static final String UNDERSCORE = "_";
    public static final String ONCE = "";
    public static final String ZERO_OR_ONE = "?";
    public static final String ZERO_OR_MORE = "*";
    public static final String ONE_OR_MORE = "+";
    public static final String IHTML_BOOLEAN = "boolean";
    public static final String IHTML_CDATA = "cdata";
    public static final String IHTML_EMPH = "emph";
    public static final String IHTML_FLOW = "flow";
    public static final String IHTML_HREF = "href";
    public static final String IHTML_ID = "id";
    public static final String IHTML_INLINE = "inline";
    public static final String IHTML_LAYOUT = "layout";
    public static final String IHTML_LENGTH = "length";
    public static final String IHTML_NUMBER = "number";
    public static final String IHTML_PASSWORD = "password";
    public static final String IHTML_PCDATA = "pcdata";
    public static final String IHTML_TEXT = "text";
    public static final String IHTML_TOKEN = "nmtoken";
    public static final String IHTML_VDATA = "vdata";
    public static final String[] SIHtmlDataTypes = new String[]{"boolean", "cdata", "emph", "flow", "href", "id", "inline", "layout", "length", "number", "password", "pcdata", "text", "nmtoken", "vdata"};
    public static final String IHTML_IHTML = "IHtml";
    public static final int LAST_ELEMENT_ID = -1;
    protected static boolean bContainerClass = false;
    protected boolean bContentsWithTag = false;
    private String SName = this.getName();
    private String sContents = null;
    protected IHtmlElementCollection elements = new IHtmlElementCollection();
    private Hashtable oChildrenRules = this.getChildrenRules();
    protected IHtmlAttributeInterface oAttributes = new IHtmlAttributes();
    private Hashtable oAttributeRules;
    private String[] requiredAttributes = this.getRequiredAttributes();
    protected String sText;
    private IHtmlElement oIHtmlParentElement;

    public IHtmlBaseElement() {
        this.oAttributeRules = this.getAttributeRules();
    }

    public String getName() {
        return "IHtmlBaseElement";
    }

    public String getXmlID() {
        return IHTML_IHTML;
    }

    protected void addNCIHtmlElement(IHtmlElement ihtmlElement, int index) throws IHtmlElementCannotBeAddedException {
        if (index == -1) {
            this.elements.addIHtmlElement(ihtmlElement);
        } else {
            this.elements.addIHtmlElementAt(ihtmlElement, index);
        }
        ihtmlElement.setIHtmlParentElement(this);
    }

    public void addIHtmlElementAt(IHtmlElement ihtmlElement, int index) throws IHtmlElementCannotBeAddedException {
        int numberElements = this.elements.getNumberElements();
        boolean done = false;
        boolean exception = false;
        String className = ihtmlElement.getName();
        if (this instanceof IHtmlContainerInterface || ihtmlElement instanceof IHtmlContainerInterface) {
            this.addNCIHtmlElement(ihtmlElement, index);
            IHtmlContainerInterface checkValidElement = null;
            if (this instanceof IHtmlContainerInterface) {
                checkValidElement = (IHtmlContainerInterface)((Object)this);
            } else if (ihtmlElement instanceof IHtmlContainerInterface) {
                checkValidElement = (IHtmlContainerInterface)((Object)ihtmlElement);
            }
            done = checkValidElement.isAddValid();
            if (!done) {
                try {
                    this.removeIHtmlElement(ihtmlElement);
                }
                catch (IHtmlElementNotFoundException je) {
                    // empty catch block
                }
                throw new IHtmlElementCannotBeAddedException();
            }
        } else {
            try {
                Enumeration keys = this.oChildrenRules.keys();
                while (!done && keys.hasMoreElements()) {
                    String sChild;
                    IHtmlElement containedElement;
                    int i;
                    Object child = keys.nextElement();
                    String childValue = (String)this.oChildrenRules.get(child);
                    if (child instanceof Vector) {
                        Vector vChild = (Vector)child;
                        if (!vChild.contains(className)) continue;
                        done = true;
                        if (!childValue.equals(ONCE)) continue;
                        int numberChild = vChild.size();
                        i = 0;
                        while (i < numberElements && !exception) {
                            containedElement = this.elements.ihtmlElementAt(i);
                            int j = 0;
                            while (j < numberChild && !exception) {
                                String childName = (String)vChild.elementAt(j);
                                if (containedElement.getName().equals(childName)) {
                                    exception = true;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (!(child instanceof String) || !(sChild = (String)child).equals(className)) continue;
                    done = true;
                    if (!childValue.equals(ONCE)) continue;
                    i = 0;
                    while (i < numberElements && !exception) {
                        containedElement = this.elements.ihtmlElementAt(i);
                        if (containedElement.getName().equals(sChild)) {
                            exception = true;
                        }
                        ++i;
                    }
                }
            }
            catch (IHtmlElementIndexOutOfBoundsException we) {
                // empty catch block
            }
            if (!done || exception) {
                throw new IHtmlElementCannotBeAddedException();
            }
            this.addNCIHtmlElement(ihtmlElement, index);
        }
    }

    public void addIHtmlElement(IHtmlElement ihtmlElement) throws IHtmlElementCannotBeAddedException {
        this.addIHtmlElementAt(ihtmlElement, -1);
    }

    public boolean hasElements() {
        boolean flag = false;
        if (this.elements.getNumberElements() > 0) {
            flag = true;
        }
        return flag;
    }

    public int getNumberElements() {
        return this.elements.getNumberElements();
    }

    public IHtmlElement ihtmlElementAt(int index) throws IHtmlElementIndexOutOfBoundsException {
        return this.elements.ihtmlElementAt(index);
    }

    public int ihtmlElementIndex(IHtmlElement ihtmlElement) throws IHtmlElementNotFoundException {
        return this.elements.ihtmlElementIndex(ihtmlElement);
    }

    public void removeIHtmlElement(int index) throws IHtmlElementIndexOutOfBoundsException {
        IHtmlElement ihtmlElement = this.ihtmlElementAt(index);
        try {
            this.removeIHtmlElement(ihtmlElement);
        }
        catch (IHtmlElementNotFoundException we) {
            throw new IHtmlElementIndexOutOfBoundsException(index);
        }
    }

    public void removeIHtmlElement(IHtmlElement ihtmlElement) throws IHtmlElementNotFoundException {
        this.elements.removeIHtmlElement(ihtmlElement);
        ihtmlElement.setIHtmlParentElement(null);
    }

    public void removeAll() {
        int numberElements = this.getNumberElements();
        int i = 0;
        while (i < numberElements) {
            try {
                IHtmlElement ihtmlElement = this.ihtmlElementAt(i);
                ihtmlElement.setIHtmlParentElement(null);
            }
            catch (IHtmlElementIndexOutOfBoundsException iHtmlElementIndexOutOfBoundsException) {
                // empty catch block
            }
            ++i;
        }
        this.elements.removeAll();
    }

    public Hashtable getChildrenRules() {
        return null;
    }

    public boolean areIHtmlChildrenSane() {
        int numberElements = this.elements.getNumberElements();
        boolean done = false;
        boolean sane = true;
        try {
            Enumeration keys = this.oChildrenRules.keys();
            while (sane && keys.hasMoreElements()) {
                int j;
                IHtmlElement containedElement;
                IHtmlElement childElement;
                int i;
                Object child = keys.nextElement();
                String childValue = (String)this.oChildrenRules.get(child);
                if (child instanceof Vector) {
                    Vector vChild = (Vector)child;
                    if (!childValue.equals(ONCE) && !childValue.equals(ONE_OR_MORE)) continue;
                    int numberChild = vChild.size();
                    done = false;
                    i = 0;
                    while (i < numberElements && !done) {
                        childElement = this.elements.ihtmlElementAt(i);
                        Vector vContainer = this.getNonContainerElements(childElement);
                        int numberContainer = vContainer.size();
                        int k = 0;
                        while (k < numberContainer) {
                            containedElement = (IHtmlElement)vContainer.elementAt(k);
                            j = 0;
                            while (j < numberChild && !done) {
                                String childName = (String)vChild.elementAt(j);
                                if (containedElement.getName().equals(childName)) {
                                    done = true;
                                }
                                ++j;
                            }
                            ++k;
                        }
                        ++i;
                    }
                    if (done) continue;
                    sane = false;
                    continue;
                }
                if (!(child instanceof String)) continue;
                String sChild = (String)child;
                if (!childValue.equals(ONCE) && !childValue.equals(ONE_OR_MORE)) continue;
                done = false;
                i = 0;
                while (i < numberElements && !done) {
                    childElement = this.elements.ihtmlElementAt(i);
                    Vector vContainer = this.getNonContainerElements(childElement);
                    int numberContainer = vContainer.size();
                    j = 0;
                    while (j < numberContainer) {
                        containedElement = (IHtmlElement)vContainer.elementAt(j);
                        if (containedElement.getName().equals(sChild)) {
                            done = true;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (done) continue;
                sane = false;
            }
        }
        catch (IHtmlElementIndexOutOfBoundsException we) {
            // empty catch block
        }
        return sane;
    }

    public void addIHtmlAttribute(String name, String value) throws IHtmlAttributeCannotBeAddedException {
        boolean exception = false;
        boolean flag = false;
        Object attributeValues = null;
        attributeValues = this.oAttributeRules.get(name);
        if (attributeValues != null) {
            if (attributeValues instanceof Vector) {
                Vector vAttributeValues = attributeValues;
                int numberValues = vAttributeValues.size();
                int i = 0;
                while (i < numberValues && !flag) {
                    String strAttributeValue = (String)vAttributeValues.elementAt(i);
                    if (strAttributeValue.equals(value)) {
                        flag = true;
                    }
                    ++i;
                }
                if (!flag) {
                    exception = true;
                }
            } else if (attributeValues instanceof String) {
                // empty if block
            }
        } else {
            exception = true;
        }
        if (exception) {
            throw new IHtmlAttributeCannotBeAddedException();
        }
        this.oAttributes.addAttribute(name, value);
    }

    public String getIHtmlAttributeValue(String name) {
        return this.oAttributes.getValue(name);
    }

    public String changeIHtmlAttribute(String name, String value) {
        String oldAttributeValue = this.oAttributes.change(name, value);
        return oldAttributeValue;
    }

    public void removeIHtmlAttribute(String name) {
        String value = this.getIHtmlAttributeValue(name);
        this.oAttributes.remove(name);
    }

    public Hashtable getAttributeRules() {
        return null;
    }

    public String[] getRequiredAttributes() {
        return null;
    }

    public boolean areIHtmlAttributesSane() {
        boolean sane = true;
        String value = null;
        if (this.requiredAttributes != null) {
            int i = 0;
            while (i < this.requiredAttributes.length && sane) {
                value = this.oAttributes.getValue(this.requiredAttributes[i]);
                if (value == null) {
                    sane = false;
                }
                ++i;
            }
        }
        return sane;
    }

    public int getNumberOfLines() {
        return this.elements.getNumberOfLines();
    }

    public String getStartTag() {
        return ONCE;
    }

    public String getEndTag() {
        return this.getStartTag();
    }

    public String getHead() {
        String startTag = this.getStartTag();
        String head = ONCE;
        if (!startTag.equals(ONCE)) {
            head = LESSERTHAN + startTag + this.oAttributes.getContents();
            head = head + ">\n";
        }
        return head;
    }

    public String getTail() {
        String endTag = this.getEndTag();
        String tail = ONCE;
        if (!endTag.equals(ONCE)) {
            tail = "</" + endTag + GREATERTHAN + NEWLINE;
        }
        return tail;
    }

    public String getBody() {
        String body = ONCE;
        String text = null;
        try {
            text = this.getText();
            if (text != null) {
                body = text;
            }
        }
        catch (IHtmlTextNotSetException we) {
            body = this.elements.getContents();
        }
        return body;
    }

    public String getContents() {
        String contents = ONCE;
        if (this.sContents == null) {
            String body = this.getBody();
            contents = this.getHead() + body + this.getTail();
        } else {
            contents = this.bContentsWithTag ? this.getHead() + this.sContents + this.getTail() : this.sContents;
        }
        return contents;
    }

    public void setContents(String contents) {
        this.sContents = contents;
        this.bContentsWithTag = false;
    }

    public void setContentsWithTag(String contents) {
        this.setContents(contents);
        this.bContentsWithTag = true;
    }

    public void setText(String text) throws IHtmlTextCannotBeSetException {
        throw new IHtmlTextCannotBeSetException();
    }

    public String getText() throws IHtmlTextNotSetException {
        throw new IHtmlTextNotSetException();
    }

    public void resetText() throws IHtmlTextCannotBeResetException {
        throw new IHtmlTextCannotBeResetException();
    }

    public void setIHtmlParentElement(IHtmlElement ihtmlParentElement) {
        this.oIHtmlParentElement = ihtmlParentElement;
    }

    public IHtmlElement getIHtmlParentElement() {
        return this.oIHtmlParentElement;
    }

    public IHtmlElement cloneIHtmlElement() throws IHtmlElementCloneFailedException {
        IHtmlElement cIHtmlElement = null;
        try {
            cIHtmlElement = (IHtmlElement)this.getClass().newInstance();
            Enumeration keys = this.oAttributes.keys();
            while (keys.hasMoreElements()) {
                String name = (String)keys.nextElement();
                String value = this.oAttributes.getValue(name);
                cIHtmlElement.addIHtmlAttribute(name, value);
            }
            try {
                String text = this.getText();
                cIHtmlElement.setText(text);
            }
            catch (IHtmlTextNotSetException je) {
                // empty catch block
            }
            int numberElements = this.getNumberElements();
            int i = 0;
            while (i < numberElements) {
                IHtmlElement childIHtmlElement = this.ihtmlElementAt(i);
                IHtmlElement cChildIHtmlElement = childIHtmlElement.cloneIHtmlElement();
                cIHtmlElement.addIHtmlElement(cChildIHtmlElement);
                ++i;
            }
        }
        catch (IHtmlElementCloneFailedException je) {
            throw je;
        }
        catch (Exception ex) {
            throw new IHtmlElementCloneFailedException(ex.getMessage());
        }
        return cIHtmlElement;
    }

    public static String[] getIHtmlDataTypes() {
        return SIHtmlDataTypes;
    }

    public static boolean isCoreDataType(String dataType) {
        boolean found = false;
        int i = 0;
        while (i < SIHtmlDataTypes.length && !found) {
            if (dataType.equals(SIHtmlDataTypes[i])) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    public String getPCDataTag() {
        return IHTML_PCDATA;
    }

    private Vector getNonContainerElements(IHtmlElement ihtmlElement) {
        Vector nonContainerElements = new Vector();
        this.getNonContainerElements(ihtmlElement, nonContainerElements);
        return nonContainerElements;
    }

    private void getNonContainerElements(IHtmlElement ihtmlElement, Vector nonContainerElements) {
        if (ihtmlElement != null) {
            if (ihtmlElement instanceof IHtmlContainer) {
                int numberChildren = ihtmlElement.getNumberElements();
                int i = 0;
                while (i < numberChildren) {
                    try {
                        IHtmlElement childIHtmlElement = ihtmlElement.ihtmlElementAt(i);
                        this.getNonContainerElements(childIHtmlElement, nonContainerElements);
                    }
                    catch (IHtmlElementIndexOutOfBoundsException he) {
                        // empty catch block
                    }
                    ++i;
                }
            } else {
                nonContainerElements.addElement(ihtmlElement);
            }
        }
    }
}

