/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.hdml;

import com.aligo.hdml.exceptions.HdmlAttributeCannotBeAddedException;
import com.aligo.hdml.exceptions.HdmlElementCannotBeAddedException;
import com.aligo.hdml.exceptions.HdmlElementIndexOutOfBoundsException;
import com.aligo.hdml.exceptions.HdmlElementNotFoundException;
import com.aligo.hdml.exceptions.HdmlTextCannotBeResetException;
import com.aligo.hdml.exceptions.HdmlTextCannotBeSetException;
import com.aligo.hdml.exceptions.HdmlTextNotSetException;
import com.aligo.hdml.interfaces.HdmlElement;
import java.util.Hashtable;
import java.util.Vector;

public class HdmlElementCollection
implements HdmlElement {
    Vector elements = new Vector();

    public String getName() {
        return "HdmlElementCollection";
    }

    public String getXmlID() {
        return "";
    }

    public void addHdmlElementAt(HdmlElement element, int index) throws HdmlElementCannotBeAddedException {
        this.elements.insertElementAt(element, index);
    }

    public void addHdmlElement(HdmlElement element) throws HdmlElementCannotBeAddedException {
        this.elements.addElement(element);
    }

    public boolean hasElements() {
        boolean flag = false;
        if (this.getNumberElements() > 0) {
            flag = true;
        }
        return flag;
    }

    public int getNumberElements() {
        return this.elements.size();
    }

    public HdmlElement hdmlElementAt(int loc) throws HdmlElementIndexOutOfBoundsException {
        try {
            return (HdmlElement)this.elements.elementAt(loc);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new HdmlElementIndexOutOfBoundsException(loc);
        }
    }

    public int hdmlElementIndex(HdmlElement hdmlElement) throws HdmlElementNotFoundException {
        int index = this.elements.indexOf(hdmlElement);
        if (index == -1) {
            throw new HdmlElementNotFoundException();
        }
        return this.elements.indexOf(hdmlElement);
    }

    public void removeHdmlElement(int index) throws HdmlElementIndexOutOfBoundsException {
        try {
            this.elements.remove(index);
        }
        catch (Exception ex) {
            throw new HdmlElementIndexOutOfBoundsException(index);
        }
    }

    public void removeHdmlElement(HdmlElement hdmlElement) throws HdmlElementNotFoundException {
        boolean present = this.elements.remove(hdmlElement);
        if (!present) {
            throw new HdmlElementNotFoundException();
        }
    }

    public void removeAll() {
        this.elements.removeAllElements();
    }

    public Hashtable getChildrenRules() {
        return null;
    }

    public boolean areHdmlChildrenSane() {
        return true;
    }

    public void addHdmlAttribute(String name, String value) throws HdmlAttributeCannotBeAddedException {
        throw new HdmlAttributeCannotBeAddedException();
    }

    public String getHdmlAttributeValue(String name) {
        return null;
    }

    public String changeHdmlAttribute(String name, String value) {
        return null;
    }

    public void removeHdmlAttribute(String name) {
    }

    public Hashtable getAttributeRules() {
        return null;
    }

    public String[] getRequiredAttributes() {
        return null;
    }

    public boolean areHdmlAttributesSane() {
        return true;
    }

    public int getNumberOfLines() {
        int count = 0;
        HdmlElement element = null;
        int i = 0;
        while (i < this.elements.size()) {
            try {
                element = this.hdmlElementAt(i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            count += element.getNumberOfLines();
            ++i;
        }
        return count;
    }

    public String getStartTag() {
        return "";
    }

    public String getEndTag() {
        return "";
    }

    public String getHead() {
        return "";
    }

    public String getTail() {
        return "";
    }

    public String getBody() {
        return "";
    }

    public String getContents() {
        String contents = "";
        HdmlElement element = null;
        int i = 0;
        while (i < this.elements.size()) {
            try {
                element = this.hdmlElementAt(i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            contents = contents + element.getContents();
            ++i;
        }
        return contents;
    }

    public void setContents(String contents) {
    }

    public void setContentsWithTag(String contents) {
    }

    public void setText(String text) throws HdmlTextCannotBeSetException {
        throw new HdmlTextCannotBeSetException();
    }

    public String getText() throws HdmlTextNotSetException {
        throw new HdmlTextNotSetException();
    }

    public void resetText() throws HdmlTextCannotBeResetException {
        throw new HdmlTextCannotBeResetException();
    }

    public void setHdmlParentElement(HdmlElement hdmlParentElement) {
    }

    public HdmlElement getHdmlParentElement() {
        return null;
    }
}

