/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.config;

import com.aligo.parsing.XMLException;
import com.aligo.parsing.XMLHDOM;
import com.aligo.parsing.XMLParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;

public class SystemConfig {
    private Hashtable globals = null;
    private XMLHDOM hdom;
    private String configFileName = "../config/aligo.xml";
    private Reader configFile;

    public void setConfigFileName(String cfn) {
        this.configFileName = cfn;
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public void init(String cfn) throws IOException, XMLException {
        if (cfn != null) {
            this.configFileName = cfn;
        }
        this.init();
    }

    public void init(Reader cfn) throws IOException, XMLException {
        if (cfn != null) {
            this.configFile = cfn;
        }
        this.globals = new Hashtable();
        char[] buffer = new char[4096];
        int i = 0;
        StringBuffer xmlData = new StringBuffer();
        while ((i = this.configFile.read(buffer)) > 0) {
            xmlData.append(buffer, 0, i);
        }
        this.hdom = new XMLParser().parse(xmlData.toString());
    }

    public void init() throws IOException, XMLException {
        System.out.println("in SystemConfig.init()");
        this.globals = new Hashtable();
        File fl = new File(this.configFileName);
        FileReader fr = new FileReader(fl);
        char[] data = new char[(int)fl.length()];
        fr.read(data, 0, (int)fl.length());
        fr.close();
        this.hdom = new XMLParser().parse(data);
        System.out.println("done with SystemConfig.init()");
    }

    public Enumeration elements(String path) {
        return this.hdom.elements(path);
    }

    public int count(String path) {
        return this.hdom.count(path);
    }

    public String resolve(String path) {
        String ret = this.hdom.resolve(path);
        return ret;
    }

    public String resolve(String path, String defaultValue) {
        return this.hdom.resolve(path, defaultValue);
    }

    public String resolveEx(String path) {
        if (this.hdom != null) {
            String ret = this.hdom.resolveEx(path);
            return ret;
        }
        return "";
    }

    public void put(Object at, Object val) {
        if (this.globals != null) {
            this.globals.put(at, val);
        }
    }

    public Object get(Object at) {
        if (this.globals != null) {
            return this.globals.get(at);
        }
        return null;
    }

    public Enumeration getElements(String path) {
        return this.hdom.children(path);
    }

    public int getCount(String path) {
        return this.hdom.count(path);
    }
}

