/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.aml.base;

import com.aligo.aml.base.AmlAttributes;
import com.aligo.aml.base.AmlElementCollection;
import com.aligo.aml.base.AmlExtensionCollection;
import com.aligo.aml.base.interfaces.AmlAttributeInterface;
import com.aligo.aml.base.interfaces.AmlCheckBoxElementInterface;
import com.aligo.aml.base.interfaces.AmlChoiceElementInterface;
import com.aligo.aml.base.interfaces.AmlDocumentElementInterface;
import com.aligo.aml.base.interfaces.AmlElement;
import com.aligo.aml.base.interfaces.AmlExtensionInterface;
import com.aligo.aml.base.interfaces.AmlFormElementInterface;
import com.aligo.aml.base.interfaces.AmlInputElementInterface;
import com.aligo.aml.base.interfaces.AmlTextAreaElementInterface;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.exceptions.AttributeCannotBeAddedException;
import com.aligo.exceptions.ElementCannotBeAddedException;
import com.aligo.exceptions.ElementNotFoundException;
import com.aligo.util.aml.TextUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AmlBaseElement
implements AmlElement {
    public static final String AMPERSAND = "&amp;";
    public static final String CLOSEBRACE = ")";
    public static final String COLON = ":";
    public static final String DASH = "-";
    public static final String DOLLAR = "$";
    public static final String EQUALS = "=";
    public static final String FORWARDSLASH = "/";
    public static final String GREATERTHAN = ">";
    public static final String HASH = "#";
    public static final String LESSERTHAN = "<";
    public static final String NEWLINE = "\n";
    public static final String OPENBRACE = "(";
    public static final String QUESTION = "?";
    public static final String QUOTE = "\"";
    public static final String SPACE = " ";
    public static final String ANY = "*";
    public static final String ONCE = "";
    public static final String ZERO_OR_ONE = "?";
    public static final String ZERO_OR_MORE = "*";
    public static final String ONE_OR_MORE = "+";
    public static final String AXML_BOOLEAN = "boolean";
    public static final String AXML_CDATA = "cdata";
    public static final String AXML_EMPH = "emph";
    public static final String AXML_FLOW = "flow";
    public static final String AXML_HREF = "href";
    public static final String AXML_ID = "id";
    public static final String AXML_INLINE = "inline";
    public static final String AXML_LAYOUT = "layout";
    public static final String AXML_LENGTH = "length";
    public static final String AXML_NUMBER = "number";
    public static final String AXML_PASSWORD = "password";
    public static final String AXML_PCDATA = "pcdata";
    public static final String AXML_TEXT = "text";
    public static final String AXML_TOKEN = "nmtoken";
    public static final String AXML_VDATA = "vdata";
    public static final String[] SAmlDataTypes = new String[]{"boolean", "cdata", "emph", "flow", "href", "id", "inline", "layout", "length", "number", "password", "pcdata", "text", "nmtoken", "vdata"};
    public static final String amlHeader = "<?xml version=\"1.0\"?>\r\n<!DOCTYPE AmlDocument SYSTEM \"aml.dtd\">\r\n";
    public static final int LAST_ELEMENT_INDEX = -1;
    private String sName = this.getName();
    protected AmlElementCollection elements = new AmlElementCollection();
    protected AmlExtensionCollection extensions_ = new AmlExtensionCollection();
    private Hashtable oChildrenRules = this.getChildrenRules();
    protected AmlAttributeInterface oAttributes = new AmlAttributes();
    private Hashtable oAttributeRules;
    private String[] requiredAttributes = this.getRequiredAttributes();
    protected String sText;
    private AmlElement oAmlParentElement;

    public AmlBaseElement() {
        this.oAttributeRules = this.getAttributeRules();
    }

    public String getName() {
        return "AmlBaseElement";
    }

    public void addAmlElement(AmlElement amlElement) throws ElementCannotBeAddedException {
        this.addAmlElementAt(amlElement, -1);
    }

    public void addAmlElementAt(AmlElement amlElement, int index) throws ElementCannotBeAddedException {
        int numberElements = this.elements.getNumberElements();
        boolean done = false;
        boolean exception = false;
        String className = amlElement.getName();
        Enumeration keys = this.oChildrenRules.keys();
        while (!done && keys.hasMoreElements()) {
            String sChild;
            AmlElement containedElement;
            int i;
            Object child = keys.nextElement();
            String childValue = (String)this.oChildrenRules.get(child);
            if (child instanceof Vector) {
                Vector vChild = (Vector)child;
                if (!vChild.contains(className)) continue;
                done = true;
                if (!childValue.equals(ONCE)) continue;
                int numberChild = vChild.size();
                i = 0;
                while (i < numberElements && !exception) {
                    containedElement = this.elements.amlElementAt(i);
                    int j = 0;
                    while (j < numberChild && !exception) {
                        String childName = (String)vChild.elementAt(j);
                        if (containedElement.getName().equals(childName)) {
                            exception = true;
                        }
                        ++j;
                    }
                    ++i;
                }
                continue;
            }
            if (!(child instanceof String) || !(sChild = (String)child).equals(className) && !sChild.equals("*")) continue;
            done = true;
            if (!childValue.equals(ONCE)) continue;
            i = 0;
            while (i < numberElements && !exception) {
                containedElement = this.elements.amlElementAt(i);
                if (containedElement.getName().equals(sChild)) {
                    exception = true;
                }
                ++i;
            }
        }
        if (!done || exception) {
            throw new ElementCannotBeAddedException();
        }
        if (index == -1) {
            this.elements.addAmlElement(amlElement);
        } else {
            this.elements.addAmlElementAt(amlElement, index);
        }
        amlElement.setAmlParentElement(this);
    }

    public boolean hasElements() {
        boolean flag = false;
        if (this.elements.getNumberElements() > 0) {
            flag = true;
        }
        return flag;
    }

    public int getNumberElements() {
        return this.elements.getNumberElements();
    }

    public AmlElement amlElementAt(int index) throws ArrayIndexOutOfBoundsException {
        return this.elements.amlElementAt(index);
    }

    public int amlElementIndex(AmlElement amlElement) throws ElementNotFoundException {
        return this.elements.amlElementIndex(amlElement);
    }

    public void removeAmlElement(int index) {
        AmlElement amlElement = this.amlElementAt(index);
        this.removeAmlElement(amlElement);
    }

    public void removeAmlElement(AmlElement amlElement) {
        amlElement.setAmlParentElement(null);
        this.elements.removeAmlElement(amlElement);
    }

    public void removeAll() {
        this.elements.removeAll();
    }

    public Hashtable getChildrenRules() {
        return null;
    }

    public boolean areAmlChildrenSane() {
        int numberElements = this.elements.getNumberElements();
        boolean done = false;
        boolean sane = true;
        AmlElement containedElement = null;
        Enumeration keys = this.oChildrenRules.keys();
        while (keys.hasMoreElements()) {
            int i;
            Object child = keys.nextElement();
            String childValue = (String)this.oChildrenRules.get(child);
            if (child instanceof Vector) {
                Vector vChild = (Vector)child;
                if (!childValue.equals(ONCE) && !childValue.equals(ONE_OR_MORE)) continue;
                int numberChild = vChild.size();
                done = false;
                i = 0;
                while (i < numberElements && !done) {
                    containedElement = this.elements.amlElementAt(i);
                    int j = 0;
                    while (j < numberChild && !done) {
                        String childName = (String)vChild.elementAt(j);
                        if (containedElement.getName().equals(childName)) {
                            done = true;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (done || !sane) continue;
                sane = false;
                continue;
            }
            if (!(child instanceof String)) continue;
            String sChild = (String)child;
            if (!childValue.equals(ONCE) && !childValue.equals(ONE_OR_MORE)) continue;
            done = false;
            i = 0;
            while (i < numberElements && !done) {
                containedElement = this.elements.amlElementAt(i);
                if (containedElement.getName().equals(sChild)) {
                    done = true;
                }
                ++i;
            }
            if (done) continue;
            sane = false;
        }
        return sane;
    }

    public void addAmlAttribute(String name, String value) throws AttributeCannotBeAddedException {
        boolean exception = false;
        boolean flag = false;
        Object attributeValues = null;
        attributeValues = this.oAttributeRules.get(name);
        if (attributeValues != null) {
            if (attributeValues instanceof Vector) {
                Vector vAttributeValues = attributeValues;
                int numberValues = vAttributeValues.size();
                int i = 0;
                while (i < numberValues && !flag) {
                    String strAttributeValue = (String)vAttributeValues.elementAt(i);
                    if (strAttributeValue.equals(value)) {
                        flag = true;
                    }
                    ++i;
                }
                if (!flag) {
                    exception = true;
                }
            } else if (attributeValues instanceof String) {
                // empty if block
            }
        } else {
            exception = true;
        }
        if (exception) {
            throw new AttributeCannotBeAddedException();
        }
        if (value != null) {
            this.oAttributes.addAttribute(name, value);
        }
    }

    public String getAmlAttributeValue(String name) {
        return this.oAttributes.getValue(name);
    }

    public boolean doesAmlAttributeExists(String name) {
        String attrValue = null;
        attrValue = this.oAttributes.getValue(name);
        return attrValue != null;
    }

    public AmlAttributeInterface getAmlAttributes() {
        return this.oAttributes;
    }

    public void removeAmlAttribute(String name) {
        this.oAttributes.remove(name);
    }

    public Hashtable getAttributeRules() {
        return null;
    }

    public String[] getRequiredAttributes() {
        return null;
    }

    public boolean areAmlAttributesSane() {
        boolean sane = true;
        String value = null;
        if (this.requiredAttributes != null) {
            int i = 0;
            while (i < this.requiredAttributes.length) {
                value = this.oAttributes.getValue(this.requiredAttributes[i]);
                if (value == null && sane) {
                    sane = false;
                }
                ++i;
            }
        }
        return sane;
    }

    public int getNumberOfLines() {
        return this.elements.getNumberOfLines();
    }

    public String getStartTag() {
        return ONCE;
    }

    public String getEndTag() {
        return this.getStartTag();
    }

    public String getHead() {
        String startTag = this.getStartTag();
        String head = ONCE;
        if (!startTag.equals(ONCE)) {
            head = LESSERTHAN + startTag + this.oAttributes.getContents();
            head = head + GREATERTHAN;
        }
        return head;
    }

    public String getTail() {
        String endTag = this.getEndTag();
        String tail = ONCE;
        if (!endTag.equals(ONCE)) {
            tail = "</" + endTag + GREATERTHAN + NEWLINE;
        }
        return tail;
    }

    public String getContents() {
        String body = null;
        String contents = ONCE;
        if (this instanceof AmlDocumentElementInterface) {
            contents = amlHeader;
        }
        body = this.sText == null ? this.elements.getContents() : TextUtils.transformText(this.sText) + this.elements.getContents();
        if (this instanceof AmlFormElementInterface) {
            body = body + this.formUrlHack();
        }
        return contents + this.getHead() + body + this.getTail();
    }

    public String getXmlContents() {
        String body = null;
        body = this.sText == null ? this.elements.getContents() : TextUtils.transformText(this.sText) + this.elements.getContents();
        return this.getHead() + body + this.getTail();
    }

    public void setContents(String contents) {
    }

    public void setText(String text) throws AttributeCannotBeAddedException {
        throw new AttributeCannotBeAddedException();
    }

    public String getText() {
        return this.sText;
    }

    public void setAmlParentElement(AmlElement amlParentElement) {
        this.oAmlParentElement = amlParentElement;
    }

    public AmlElement getAmlParentElement() {
        return this.oAmlParentElement;
    }

    public static String[] getAmlDataTypes() {
        return SAmlDataTypes;
    }

    public static boolean isCoreDataType(String dataType) {
        boolean found = false;
        int i = 0;
        while (i < SAmlDataTypes.length && !found) {
            if (dataType.equals(SAmlDataTypes[i])) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    public String getPCDataTag() {
        return AXML_PCDATA;
    }

    public void addExtension(AmlExtensionInterface extension) {
        this.extensions_.addExtension(extension);
    }

    private String formUrlHack() {
        StringBuffer retVal = new StringBuffer("<formParams>");
        int elementCount = this.elements.getNumberElements();
        String delim = "?";
        int i = 0;
        while (i < elementCount) {
            AmlElement nextAml = this.amlElementAt(i);
            if (nextAml instanceof AmlInputElementInterface || nextAml instanceof AmlTextAreaElementInterface || nextAml instanceof AmlCheckBoxElementInterface || nextAml instanceof AmlChoiceElementInterface) {
                retVal.append("<formParam>");
                retVal.append(nextAml.getAmlAttributeValue("name"));
                retVal.append("=$(");
                retVal.append(nextAml.getAmlAttributeValue("name"));
                retVal.append(CLOSEBRACE);
                retVal.append("</formParam>");
            }
            ++i;
        }
        retVal.append("</formParams>");
        return retVal.toString();
    }

    public AxmlElement getAxmlElement() {
        return null;
    }
}

