/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.aml;

import com.aligo.aml.AmlContainer;
import com.aligo.aml.AmlControlMenu;
import com.aligo.aml.AmlGridBagLayout;
import com.aligo.aml.AmlPage;
import com.aligo.aml.AmlStyle;
import com.aligo.aml.AmlText;
import com.aligo.aml.base.AmlDocumentElement;
import com.aligo.axml.AxmlDocument;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.exceptions.AligoException;
import com.aligo.exceptions.AttributeCannotBeAddedException;
import com.aligo.exceptions.ElementCannotBeAddedException;

public class AmlDocument
extends AmlDocumentElement {
    private static final String DBC_PATH = "/Aligo/Messages/aml/AmlDocument/";
    private AxmlDocument axmlDocument_ = new AxmlDocument();

    public AmlDocument(AligoException aaE, String returnUrl) {
        try {
            AmlPage ePage = new AmlPage("eid", "");
            AmlControlMenu eLink = new AmlControlMenu();
            eLink.setText("Back");
            eLink.setURL(returnUrl);
            ePage.addAmlControlMenu(eLink);
            ePage.addAmlText(new AmlText(aaE.getMessage()));
            this.setTitle("Error");
            this.addAmlPage(ePage);
        }
        catch (AligoException aligoException) {
            // empty catch block
        }
    }

    public AmlDocument() {
    }

    public AmlDocument(AmlPage amlPage) throws ElementCannotBeAddedException {
        this.addAmlPage(amlPage);
    }

    public void addAmlPage(AmlPage amlpage) throws ElementCannotBeAddedException {
        this.axmlDocument_.addAxmlElement(amlpage.getAxmlElement());
    }

    public void addAmlContainer(AmlContainer amlContainer) throws ElementCannotBeAddedException {
        this.axmlDocument_.addAxmlElement(amlContainer.getAxmlElement());
    }

    public void addAmlStyle(AmlStyle amlStyle) throws ElementCannotBeAddedException {
        this.axmlDocument_.addExtension(amlStyle.getExtensionObject());
    }

    public void addAmlGridBagLayout(AmlGridBagLayout amlGridBagLayout) throws ElementCannotBeAddedException {
        this.axmlDocument_.addExtension(amlGridBagLayout.getExtensionObject());
    }

    public void setTitle(String title) throws AttributeCannotBeAddedException {
        this.axmlDocument_.addAxmlAttribute("title", title);
    }

    public void setEncoding(String encoding) throws AttributeCannotBeAddedException {
        this.axmlDocument_.addAxmlAttribute("encoding", encoding);
    }

    public void setTitleColor(String titlecolor) throws AttributeCannotBeAddedException {
        this.axmlDocument_.addAxmlAttribute("titlecolor", titlecolor);
    }

    public void setTextSize(String textsize) throws AttributeCannotBeAddedException {
        if (textsize.equals("big") || textsize.equals("small")) {
            this.axmlDocument_.addAxmlAttribute("textsize", textsize);
        } else {
            this.axmlDocument_.addAxmlAttribute("textsize", "normal");
        }
    }

    public void setItalics(boolean flag) throws AttributeCannotBeAddedException {
        this.axmlDocument_.addAxmlAttribute("italics", new Boolean(flag).toString());
    }

    public void setBold(boolean flag) throws AttributeCannotBeAddedException {
        this.axmlDocument_.addAxmlAttribute("bold", new Boolean(flag).toString());
    }

    public void setUnderline(boolean flag) throws AttributeCannotBeAddedException {
        this.axmlDocument_.addAxmlAttribute("underline", new Boolean(flag).toString());
    }

    public void setHalign(String halign) throws AttributeCannotBeAddedException {
        if (halign.equals("right") || halign.equals("left")) {
            this.axmlDocument_.addAxmlAttribute("halign", halign);
        } else {
            this.axmlDocument_.addAxmlAttribute("halign", "center");
        }
    }

    public void setFont(String font) throws AttributeCannotBeAddedException {
        this.axmlDocument_.addAxmlAttribute("font", font);
    }

    public void setBlink(boolean flag) throws AttributeCannotBeAddedException {
        this.axmlDocument_.addAxmlAttribute("blink", new Boolean(flag).toString());
    }

    public void setMarquee(boolean flag) throws AttributeCannotBeAddedException {
        this.axmlDocument_.addAxmlAttribute("marquee", new Boolean(flag).toString());
    }

    public void setAudioText(String audio_text) throws AttributeCannotBeAddedException {
        this.axmlDocument_.addAxmlAttribute("audio_text", audio_text);
    }

    public void setAudioTextUrl(String audio_text_url) throws AttributeCannotBeAddedException {
        this.axmlDocument_.addAxmlAttribute("audio_text_src", audio_text_url);
    }

    public void setBGColor(String bgcolor) throws AttributeCannotBeAddedException {
        this.axmlDocument_.addAxmlAttribute("bgcolor", bgcolor);
    }

    public void setTextColor(String textcolor) throws AttributeCannotBeAddedException {
        this.axmlDocument_.addAxmlAttribute("textcolor", textcolor);
    }

    public void setLinkColor(String linkcolor) throws AttributeCannotBeAddedException {
        this.axmlDocument_.addAxmlAttribute("linkcolor", linkcolor);
    }

    public void setPreviousLabel(String previousLabel) throws AttributeCannotBeAddedException {
        this.axmlDocument_.addAxmlAttribute("prev_label", previousLabel);
    }

    public void setNextLabel(String nextLabel) throws AttributeCannotBeAddedException {
        this.axmlDocument_.addAxmlAttribute("next_label", nextLabel);
    }

    public void setRefresh(String refresh) throws AttributeCannotBeAddedException {
        this.axmlDocument_.addAxmlAttribute("refresh", refresh);
    }

    public void setRefreshTimeout(int timeout) throws AttributeCannotBeAddedException {
        String strTimeout = String.valueOf(timeout);
        this.setRefreshTimeout(strTimeout);
    }

    public void setRefreshTimeout(String timeout) throws AttributeCannotBeAddedException {
        this.axmlDocument_.addAxmlAttribute("refresh_timeout", timeout);
    }

    public void setMarkupHeaders(String headers) throws AttributeCannotBeAddedException {
        this.axmlDocument_.addAxmlAttribute("markup_headers", headers);
    }

    public String getContents() {
        return super.getContents();
    }

    public AxmlElement getAxmlElement() {
        return this.axmlDocument_;
    }

    public String getName() {
        return "AmlDocument";
    }
}

