/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.services.responsebuffer;

import com.aligo.engine.Content;
import com.aligo.portal.wireless.services.rendering.CacheManager;
import com.aligo.portal.wireless.services.rendering.CacheManagerFactory;
import com.aligo.portal.wireless.services.rendering.Logger;
import com.aligo.portal.wireless.services.rendering.RenderingEngine;
import com.aligo.portal.wireless.services.rendering.RenderingEngineFactory;
import com.aligo.portal.wireless.services.rendering.RenderingException;
import com.iplanet.am.util.AMClientDetector;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.session.util.SessionUtils;
import com.sun.portal.wireless.services.responsebuffer.ResponseBufferEntry;
import com.sun.portal.wireless.services.responsebuffer.ResponseBufferService;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResponseBufferServlet
extends HttpServlet {
    private static Debug debug = Debug.getInstance((String)"MAPResponseBufferService");
    private AMClientDetector client_detector = null;
    private ResponseBufferService _service = null;
    private CacheManagerFactory cache_manager_factory = null;
    private SSOTokenManager sso_token_manager = null;
    private RenderingEngineFactory rendering_engine_factory = null;
    private static final String POST_METHOD = "post";
    private static final String GET_METHOD = "get";
    private static final String REDIRECT_PREFIX = "<AmlDocument title=\"Redirect\"><AmlPage><AmlLink text=\"New Location\" url=\"";
    private static final String REDIRECT_SUFFIX = "\"/></AmlPage></AmlDocument>";

    public void init() throws ServletException {
        this.client_detector = new AMClientDetector();
        this._service = ResponseBufferService.getInstance();
        this.cache_manager_factory = CacheManagerFactory.getInstance();
        this.rendering_engine_factory = RenderingEngineFactory.getInstance();
        try {
            this.sso_token_manager = SSOTokenManager.getInstance();
        }
        catch (SSOException se) {
            debug.error("init(): Unable to get the SSOTokenManager, failed with message " + se.getMessage());
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String client_charset;
        Client client;
        SSOToken sso_token;
        String session_id;
        String servlet_method;
        block27: {
            servlet_method = this.getServletMethodName(request);
            session_id = null;
            sso_token = null;
            client = null;
            client_charset = null;
            if (this.sso_token_manager != null) {
                try {
                    sso_token = this.sso_token_manager.createSSOToken(request);
                }
                catch (SSOException se) {
                    if (debug.messageEnabled()) {
                        debug.message(servlet_method + ": Unable to get the SSO token, failed with message " + se.getMessage());
                    }
                    if ((session_id = SessionUtils.getSessionId((HttpServletRequest)request)) == null) {
                        if (debug.messageEnabled()) {
                            debug.message(servlet_method + ": Unable to get the session id");
                        }
                    }
                    if (!debug.messageEnabled()) break block27;
                    debug.message(session_id + ": " + servlet_method + ": Using the session id instead of token");
                }
            }
        }
        if (sso_token == null && session_id == null) {
            try {
                client = this.getClient(null, request, "");
            }
            catch (SSOException se) {
                // empty catch block
            }
            this.redirectWithBody(this._service.getLoginURL(), request, response, client, sso_token, "");
            return;
        }
        String token_string = null;
        token_string = sso_token != null ? sso_token.getTokenID().toString() : session_id;
        try {
            client = this.getClient(sso_token, request, token_string);
            client_charset = sso_token.getProperty("CharSet");
        }
        catch (SSOException se) {
            debug.error(token_string + ": " + servlet_method + ": Unable to get the client type from SSO token, failed with message " + se.getMessage());
            try {
                client = this.getClient(null, request, token_string);
            }
            catch (SSOException sse) {
                // empty catch block
            }
            this.redirectWithBody(this._service.getLoginURL(), request, response, client, sso_token, token_string);
        }
        Integer entry_number = this.getEntryNumberFromRequest(request);
        if (entry_number == null) {
            debug.error(token_string + ": " + servlet_method + ": Unable to get the response buffer entry number from the request");
            this.redirectWithBody(this._service.getDesktopURL(), request, response, client, sso_token, token_string);
            return;
        }
        ResponseBufferEntry entry = null;
        entry = sso_token != null ? this._service.getEntry(sso_token, entry_number) : this._service.getEntry(session_id, entry_number);
        String request_url = null;
        if (entry == null) {
            request_url = sso_token != null ? this._service.getRequestURL(sso_token, entry_number) : this._service.getRequestURL(session_id, entry_number);
            if (debug.warningEnabled()) {
                debug.warning(token_string + ": " + servlet_method + ": Unable to get the entry corresponding to " + entry_number + " generated by " + request_url);
            }
            this.redirectAppropriately(request_url, request, response, client, sso_token, token_string);
        } else {
            request_url = entry.getRequestURL();
            Logger logger = new Logger(token_string + ": Entry " + entry_number);
            Content content = this.getContent(request, entry, token_string, logger);
            if (content == null) {
                debug.error(token_string + ": " + servlet_method + ": Unable to get the cached Content for entry corresponding to " + entry_number + " generated by " + request_url);
                this.redirectAppropriately(request_url, request, response, client, sso_token, token_string);
            } else {
                String redirect_url;
                String content_type = content.getHeader("Content-type");
                if (content_type == null) {
                    if (debug.warningEnabled()) {
                        debug.warning(token_string + ": " + servlet_method + ": Unable to get the content type from Content for entry corresponding to " + entry_number + " generated by " + request_url);
                    }
                    if ((content_type = this.getContentTypeFromClient(client, sso_token, token_string)) != null && content_type.indexOf(";") == -1) {
                        content_type = content_type + "; charset=" + client_charset;
                    }
                }
                if ((redirect_url = content.getRedirectURL()) != null) {
                    if (debug.messageEnabled()) {
                        debug.message(token_string + ": " + servlet_method + ": Content for entry corresponding to " + entry_number + " generated by " + request_url + " is a redirect to " + redirect_url);
                    }
                    this.redirectWithBodyAndContentType(redirect_url, request, response, client, content_type, token_string, sso_token);
                    return;
                }
                if (content_type == null) {
                    debug.error(token_string + ": " + servlet_method + ": Unable to get the content type for entry corresponding to " + entry_number + " generated by " + request_url);
                    this.redirectAppropriately(entry.getRequestURL(), request, response, client, sso_token, token_string);
                } else {
                    response.setContentType(content_type);
                    String body = content.getContents();
                    if (debug.messageEnabled()) {
                        debug.message(token_string + ": " + servlet_method + ": Sending out content type |" + content_type + "| with content |" + body + "|");
                    }
                    PrintWriter out = response.getWriter();
                    out.print(body);
                }
            }
        }
    }

    private Integer getEntryNumberFromRequest(HttpServletRequest request) {
        String entry_number_string = request.getParameter("e");
        if (entry_number_string == null) {
            return null;
        }
        Integer entry_number = null;
        try {
            entry_number = Integer.valueOf(entry_number_string, 36);
        }
        catch (NumberFormatException ne) {
            entry_number = null;
        }
        return entry_number;
    }

    private Content getContent(HttpServletRequest request, ResponseBufferEntry entry, String token_string, Logger logger) {
        CacheManager manager = this.cache_manager_factory.getCacheManager(entry, logger);
        Content content = null;
        try {
            content = manager.getContent(request);
        }
        catch (Exception e) {
            debug.error(token_string + ": getContent(): Unable to get content for entry " + entry.getEntryNumber() + ", fails with " + e.getMessage());
        }
        return content;
    }

    private void redirectAppropriately(String url, HttpServletRequest request, HttpServletResponse response, Client client, SSOToken sso_token, String token_string) throws IOException {
        String redirect_url = url != null ? url : this._service.getDesktopURL();
        this.redirectWithBody(redirect_url, request, response, client, sso_token, token_string);
    }

    private String getContentTypeFromClient(Client client, SSOToken sso_token, String token_string) {
        String content_type = null;
        if (client != null && (content_type = client.getProperty("contentType")) != null) {
            String charset;
            String locale_string = null;
            if (sso_token != null) {
                try {
                    locale_string = sso_token.getProperty("Locale");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((charset = client.getCharset(Locale.getLocale(locale_string))) != null) {
                StringBuffer buffer = new StringBuffer(content_type);
                buffer.append("; charset=");
                buffer.append(charset);
                content_type = buffer.toString();
            }
        }
        if (debug.messageEnabled()) {
            debug.message(token_string + ": getContentTypeFromClient(): content type is " + (content_type != null ? content_type : ""));
        }
        return content_type;
    }

    private Client getClient(SSOToken sso_token, HttpServletRequest request, String token_string) throws SSOException {
        String client_type = null;
        if (sso_token != null) {
            client_type = sso_token.getProperty("clientType");
        }
        if (client_type == null) {
            client_type = this.client_detector.getClientType(request);
        }
        Client client = null;
        if (client_type != null) {
            try {
                client = Client.getInstance((String)client_type);
            }
            catch (ClientException ce) {
                // empty catch block
            }
        }
        if (client == null) {
            client = Client.getDefaultInstance();
        }
        client_type = client != null ? client.getClientType() : "";
        if (debug.messageEnabled()) {
            debug.message(token_string + ": getClient() " + ": Got clientType of " + client_type + " from SSO token");
        }
        return client;
    }

    private String getServletMethodName(HttpServletRequest request) {
        String http_method = request.getMethod().trim().toLowerCase();
        String servlet_method = null;
        servlet_method = GET_METHOD.equals(http_method) ? "doGet()" : (POST_METHOD.equals(http_method) ? "doPost()" : http_method);
        return servlet_method;
    }

    private String getDefaultAMLRedirectBody(String url) {
        if (url == null) {
            return null;
        }
        String encoded_url = URLEncoder.encode(url);
        StringBuffer aml_markup_for_body = new StringBuffer(512);
        aml_markup_for_body.append(REDIRECT_PREFIX);
        aml_markup_for_body.append(encoded_url);
        aml_markup_for_body.append(REDIRECT_SUFFIX);
        return aml_markup_for_body.toString();
    }

    private String getAMLRedirectBody(String url, SSOToken sso_token) {
        ResourceBundle bundle = null;
        String aml_markup_from_props = null;
        String aml_markup_for_body = null;
        String locale_str = null;
        if (url == null) {
            return null;
        }
        String encoded_url = URLEncoder.encode(url);
        try {
            if (sso_token != null) {
                locale_str = sso_token.getProperty("Locale");
            }
            bundle = locale_str != null ? ResourceBundle.getBundle("ResponseBuffer", Locale.getLocale((String)locale_str)) : ResourceBundle.getBundle("ResponseBuffer", Locale.getDefaultLocale());
            aml_markup_from_props = bundle.getString("redirectPage");
        }
        catch (SSOException sse) {
            if (debug.messageEnabled()) {
                debug.message("ResponseBufferServlet.getAMLRedirectBody(): ", (Throwable)sse);
            }
            return this.getDefaultAMLRedirectBody(url);
        }
        catch (MissingResourceException mre) {
            if (debug.messageEnabled()) {
                debug.message("ResponseBufferServlet.getAMLRedirectBody(): ", (Throwable)mre);
            }
            return this.getDefaultAMLRedirectBody(url);
        }
        if (debug.messageEnabled()) {
            debug.message("ResponseBufferServlet.getAMLRedirectBody(): Redirect page from properties file = " + aml_markup_from_props);
        }
        if (aml_markup_from_props != null) {
            int start = aml_markup_from_props.indexOf("[REDIRECT_URL]");
            if (start != -1) {
                int end = start + 14;
                StringBuffer errBuf = new StringBuffer(aml_markup_from_props);
                aml_markup_for_body = errBuf.replace(start, end, encoded_url).toString();
            } else {
                aml_markup_for_body = aml_markup_from_props;
            }
            if (debug.messageEnabled()) {
                debug.message("ResponseBufferServlet.getAMLRedirectBody(): Redirect Page with url = " + aml_markup_for_body);
            }
        } else {
            aml_markup_for_body = this.getDefaultAMLRedirectBody(url);
        }
        return aml_markup_for_body;
    }

    private String getNativeRedirectBody(String url, Client client, String token_string, SSOToken sso_token) {
        if (client == null) {
            return null;
        }
        String native_markup_for_body = null;
        String aml_markup_for_body = this.getAMLRedirectBody(url, sso_token);
        if (aml_markup_for_body != null) {
            if (debug.messageEnabled()) {
                debug.message(token_string + ": getNativeRedirectBody(): AML body for redirect is " + aml_markup_for_body);
            }
            String log_name = "ResponseBufferServlet:getNativeRedirectBody:" + token_string;
            RenderingEngine engine = this.rendering_engine_factory.getEngine(null, log_name);
            try {
                Content content = engine.renderContent(aml_markup_for_body, client, false, false);
                if (content != null) {
                    native_markup_for_body = content.getContents();
                    if (debug.messageEnabled()) {
                        debug.message(token_string + ": getNativeRedirectBody(): Native body for redirect is " + native_markup_for_body);
                    }
                } else if (debug.messageEnabled()) {
                    debug.message(token_string + ": getNativeRedirectBody(): Native body for redirect is null");
                }
            }
            catch (RenderingException re) {
                if (debug.messageEnabled()) {
                    debug.message(token_string + ": getNativeRedirectBody(): Rendering exception", (Throwable)re);
                }
                native_markup_for_body = null;
            }
        }
        return native_markup_for_body;
    }

    private void sendRedirect(String url, HttpServletResponse response, String body, String content_type, String token_string) throws IOException {
        if (debug.messageEnabled()) {
            debug.message(token_string + ": sendRedirect(): Sending a redirect to " + url);
        }
        if (body != null) {
            if (content_type != null) {
                response.setContentType(content_type);
            }
            response.setStatus(302);
            response.setHeader("Location", url);
            PrintWriter out = response.getWriter();
            out.print(body);
            response.flushBuffer();
        } else {
            response.sendRedirect(url);
        }
    }

    private void redirectWithBody(String url, HttpServletRequest request, HttpServletResponse response, Client client, SSOToken sso_token, String token_string) throws IOException {
        String content_type = this.getContentTypeFromClient(client, sso_token, token_string);
        this.redirectWithBodyAndContentType(url, request, response, client, content_type, token_string, sso_token);
    }

    private void redirectWithBodyAndContentType(String url, HttpServletRequest request, HttpServletResponse response, Client client, String content_type, String token_string, SSOToken sso_token) throws IOException {
        String absolute_url = ResponseBufferServlet.getAbsoluteURL(url, request, client, token_string);
        String native_markup_for_body = this.getNativeRedirectBody(absolute_url, client, token_string, sso_token);
        this.sendRedirect(absolute_url, response, native_markup_for_body, content_type, token_string);
    }

    private static String getAbsoluteURL(String url, HttpServletRequest request, Client client, String token_string) {
        String absolute_url = null;
        try {
            absolute_url = ResponseBufferService.getAbsoluteURL(url, request, client);
        }
        catch (Exception e) {
            debug.message(token_string + ": getAbsoluteURL(): Failed to convert into absolute url " + url);
            absolute_url = url;
        }
        return absolute_url;
    }
}

