/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.services.filter;

import com.iplanet.am.util.Debug;
import com.sun.portal.wireless.services.filter.MAPController;
import com.sun.portal.wireless.services.filter.MAPOutputStream;
import com.sun.portal.wireless.services.filter.MAPWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class MAPHttpResponse
extends HttpServletResponseWrapper {
    private static Debug debug = MAPController.debug;
    private static final String CONTENT_TYPE = "content-type";
    private MAPOutputStream outputStream = null;
    private MAPWriter mapWriter = null;
    private HttpServletResponse response = null;
    public static final String DEFAULT_CONTENT_CHARSET = "ISO-8859-1";
    private String MAPRespContentType = null;
    private boolean isAML = false;

    public MAPHttpResponse(HttpServletResponse res) {
        super(res);
        this.response = res;
    }

    public boolean isContentAML() {
        return this.isAML;
    }

    public void setContentAML(boolean flag) {
        this.isAML = flag;
    }

    public void flushBuffer() throws IOException {
        if (!this.isContentAML()) {
            this.response.flushBuffer();
        }
    }

    public void setContentType(String ct) {
        if (ct.indexOf("text/aml") != -1) {
            this.setContentAML(true);
        }
        this.MAPRespContentType = ct;
        this.response.setContentType(ct);
    }

    public void setHeader(String name, String value) {
        if (name != null && name.equalsIgnoreCase(CONTENT_TYPE)) {
            this.setContentType(value);
        } else {
            this.response.setHeader(name, value);
        }
    }

    public String getContentType() {
        return this.MAPRespContentType;
    }

    public boolean usingStream() {
        return this.outputStream != null;
    }

    public boolean usingWriter() {
        return this.mapWriter != null;
    }

    public PrintWriter getWriter() throws IOException, UnsupportedEncodingException {
        if (debug.messageEnabled()) {
            debug.message("MAPHttpResponse: getWriter(): " + this.isAML);
        }
        if (!this.isContentAML()) {
            return this.response.getWriter();
        }
        if (this.usingStream()) {
            String msg = "getOutputStream() has already been called for this response";
            throw new IllegalStateException(msg);
        }
        if (!this.usingWriter()) {
            this.createWriter();
        }
        return this.mapWriter.getPrintWriter();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (debug.messageEnabled()) {
            debug.message("MAPHttpResponse: getOutputStream(): " + this.isAML);
        }
        if (!this.isContentAML()) {
            return this.response.getOutputStream();
        }
        if (this.usingWriter()) {
            String msg = "getWriter() has already been called for this response";
            throw new IllegalStateException(msg);
        }
        if (!this.usingStream()) {
            this.createStream();
        }
        return this.outputStream;
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() throws IllegalStateException {
        this.response.reset();
        this.resetBuffer();
    }

    public void resetBuffer() throws IllegalStateException {
        if (this.usingStream()) {
            this.outputStream.reset();
        } else if (this.usingWriter()) {
            this.mapWriter.reset();
        }
    }

    private void createWriter() throws UnsupportedEncodingException {
        if (this.mapWriter == null) {
            this.mapWriter = new MAPWriter();
        }
    }

    private void createStream() {
        if (this.outputStream == null) {
            this.outputStream = new MAPOutputStream();
        }
    }

    byte[] getByteArray() {
        byte[] arr = null;
        if (this.usingStream()) {
            arr = this.outputStream.getBufferedData();
        } else if (this.usingWriter()) {
            String s = this.mapWriter.getBufferedData();
            String charset = this.getCharEnc();
            try {
                arr = s.getBytes(charset);
            }
            catch (UnsupportedEncodingException uee) {
                debug.error("MAPHttpResponse: Error", (Throwable)uee);
                arr = null;
            }
        }
        return arr;
    }

    String getBufferAsString() {
        String ret = null;
        if (this.usingWriter()) {
            ret = this.mapWriter.getBufferedData();
        } else if (this.usingStream()) {
            byte[] arr = this.outputStream.getBufferedData();
            String charset = this.getCharEnc();
            if (arr != null) {
                try {
                    ret = new String(arr, charset);
                }
                catch (UnsupportedEncodingException uee) {
                    debug.error("MAPController: Error", (Throwable)uee);
                    ret = null;
                }
            }
        }
        return ret;
    }

    String getCharEnc() {
        String enc = this.response.getCharacterEncoding();
        if (enc == null) {
            enc = DEFAULT_CONTENT_CHARSET;
            if (debug.messageEnabled()) {
                debug.message("MAPHttpResponse:charset = Default");
            }
        }
        return enc;
    }
}

