/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.services.filter;

import com.aligo.engine.Content;
import com.aligo.portal.wireless.services.rendering.RenderingEngine;
import com.aligo.portal.wireless.services.rendering.RenderingEngineFactory;
import com.aligo.portal.wireless.services.rendering.RenderingException;
import com.iplanet.am.util.AMClientDetector;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.services.cdm.ClientsManager;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.ISLocaleContext;
import com.sun.portal.wireless.services.filter.MAPHttpResponse;
import com.sun.portal.wireless.services.responsebuffer.ResponseBufferEntry;
import com.sun.portal.wireless.services.responsebuffer.ResponseBufferService;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MAPController
implements Filter {
    public static Debug debug = Debug.getInstance((String)"MAPFilterConfig");
    private RenderingEngineFactory engineFactory = null;
    private RenderingEngine engine = null;
    private ServletContext context = null;
    private AMClientDetector cd = null;
    private static final String RESPONSE = "MAPResponseObject";
    private static final String AML_PATH = "/aml/";
    public static final String AML_CONTENT_TYPE = "text/aml";

    public void init(FilterConfig config) throws ServletException {
        this.context = config.getServletContext();
        this.cd = new AMClientDetector();
        this.engineFactory = RenderingEngineFactory.getInstance();
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        MAPHttpResponse resp;
        HttpServletRequest hReq = (HttpServletRequest)request;
        String uri = hReq.getRequestURI();
        if (debug.messageEnabled()) {
            debug.message("MAPController: Filter URI: " + uri);
        }
        if ((resp = (MAPHttpResponse)((Object)hReq.getAttribute(RESPONSE))) != null) {
            this.checkForAML(uri, resp);
            try {
                chain.doFilter((ServletRequest)hReq, (ServletResponse)resp);
            }
            catch (ServletException se) {
                String msg = " Error: (uri=" + uri + "): ";
                this.context.log(msg, (Throwable)se);
                throw se;
            }
            return;
        }
        if (debug.messageEnabled()) {
            debug.message("--------\nMAPController: New request: " + request);
        }
        MAPHttpResponse mapResponse = new MAPHttpResponse((HttpServletResponse)response);
        hReq.setAttribute(RESPONSE, (Object)mapResponse);
        this.checkForAML(uri, mapResponse);
        try {
            chain.doFilter((ServletRequest)hReq, (ServletResponse)mapResponse);
        }
        catch (ServletException se) {
            String msg = " Error: (uri=" + uri + "): ";
            this.context.log(msg, (Throwable)se);
            throw se;
        }
        catch (RuntimeException re) {
            this.doTransform(hReq, response, mapResponse);
            String msg = " Error: (uri=" + uri + "): ";
            this.context.log(msg, (Throwable)re);
            if (debug.messageEnabled()) {
                debug.message("MAPController: (handled_rtexcptn) transform(): " + uri + " : ", (Throwable)re);
                debug.message("-------------------------");
            }
            throw re;
        }
        this.doTransform(hReq, response, mapResponse);
        if (debug.messageEnabled()) {
            debug.message("MAPController: (normal) transform(): " + uri + "\n-------------------------");
        }
    }

    private void doTransform(HttpServletRequest request, ServletResponse response, MAPHttpResponse mapResponse) throws IOException, ServletException {
        String clientType = this.cd.getClientType(request);
        Client client = null;
        try {
            client = ClientsManager.getInstance((String)clientType);
        }
        catch (ClientException ce) {
            debug.error("Could not getClientInstance(): ", (Throwable)ce);
            client = ClientsManager.getDefaultInstance();
        }
        if (mapResponse.usingStream() || mapResponse.usingWriter()) {
            String buffer = null;
            buffer = this.getAMLContent(mapResponse);
            if (buffer != null) {
                String trxfd = this.transform(request, mapResponse, buffer, client);
                PrintWriter out = response.getWriter();
                out.print(trxfd);
                out.flush();
            } else {
                byte[] arr = mapResponse.getByteArray();
                debug.message("MAPController: Stream Size = " + arr.length);
                ServletOutputStream out = response.getOutputStream();
                out.write(arr, 0, arr.length);
                out.flush();
            }
            response.flushBuffer();
        } else if (debug.messageEnabled()) {
            debug.message("MAPController: nothing to transform(): ");
        }
    }

    private void checkForAML(String uri, MAPHttpResponse mResp) {
        if (mResp != null) {
            return;
        }
        if (mResp.isContentAML()) {
            return;
        }
        if (uri != null && uri.indexOf(AML_PATH) != -1) {
            mResp.setContentAML(true);
        }
    }

    private String getAMLContent(MAPHttpResponse mapResp) {
        String buffer = mapResp.getBufferAsString();
        return buffer;
    }

    private String transform(HttpServletRequest request, MAPHttpResponse mapResp, String input, Client client) {
        String output = null;
        if (debug.messageEnabled()) {
            debug.message("AMLInput: " + input);
        }
        SSOToken sso_token = null;
        try {
            sso_token = SSOTokenManager.getInstance().createSSOToken(request);
        }
        catch (SSOException ssoe) {
            // empty catch block
        }
        ResponseBufferService service = ResponseBufferService.getInstance();
        ResponseBufferEntry entry = null;
        Object session_id = null;
        if (sso_token != null) {
            try {
                entry = service.createEntry(sso_token, request.getRequestURL().toString(), request);
            }
            catch (SSOException ssoe) {
                // empty catch block
            }
        }
        StringBuffer logName = new StringBuffer("MAPController: ");
        logName.append(request.getRequestURI());
        if (request.getQueryString() != null) {
            logName.append("?");
            logName.append(request.getQueryString());
        }
        RenderingEngine engine = this.engineFactory.getEngine(entry, new String(logName));
        Content content = null;
        try {
            content = engine.renderContent(input, client, entry != null, false);
            if (content != null) {
                output = content.getContents();
            } else {
                debug.error("MAPController: Rendering engine returned null Content");
                output = this.fetchErrorPage(input, client, sso_token, request, mapResp, engine, service);
            }
        }
        catch (RenderingException rex) {
            debug.error("MAPController.transform(): ", (Throwable)rex);
            output = this.fetchErrorPage(input, client, sso_token, request, mapResp, engine, service);
        }
        String cType = mapResp.getContentType();
        if (cType == null || cType.indexOf(AML_CONTENT_TYPE) != -1) {
            String content_type = null;
            content_type = content != null ? content.getHeader("Content-type") : client.getProperty("contentType") + " ; charset=" + mapResp.getCharEnc();
            mapResp.setContentType(content_type);
        }
        if (debug.messageEnabled()) {
            debug.message("Markup : " + output);
        }
        return output;
    }

    private String fetchErrorPage(String input, Client client, SSOToken ssoToken, HttpServletRequest request, MAPHttpResponse mapResp, RenderingEngine engine, ResponseBufferService service) {
        String errPg = null;
        String errStr = null;
        String desktopURL = null;
        ResourceBundle bundle = null;
        java.util.Locale locale = null;
        try {
            if (ssoToken != null) {
                locale = Locale.getLocale((String)ssoToken.getProperty("Locale"));
            }
        }
        catch (SSOException se) {
            // empty catch block
        }
        if (locale == null) {
            ISLocaleContext lcontext = new ISLocaleContext();
            lcontext.setLocale(request);
            locale = lcontext.getLocale();
        }
        try {
            bundle = ResourceBundle.getBundle("RenderingError", locale);
            errStr = bundle.getString("defaultError");
        }
        catch (MissingResourceException mre) {
            if (debug.messageEnabled()) {
                debug.message("MAPController.fetchErrorPage(): ", (Throwable)mre);
            }
            return "";
        }
        if (debug.messageEnabled()) {
            debug.message("MAPController.fetchErrorPage(): Error page from properties file = " + errStr);
        }
        try {
            if (ssoToken != null) {
                desktopURL = ssoToken.encodeURL(service.getDesktopURL());
            }
        }
        catch (SSOException ss) {
            desktopURL = service.getDesktopURL();
        }
        if (debug.messageEnabled()) {
            debug.message("MAPController.fetchErrorPage(): desktop url = " + desktopURL);
        }
        if (errStr != null) {
            int start = errStr.indexOf("[PORTALHM]");
            if (start != -1) {
                int end = start + 10;
                StringBuffer errBuf = new StringBuffer(errStr);
                errPg = errBuf.replace(start, end, desktopURL).toString();
            } else {
                errPg = errStr;
            }
            if (debug.messageEnabled()) {
                debug.message("MAPController.fetchErrorPage(): Error Page to render = " + errPg);
            }
        }
        try {
            Content content = engine.renderContent(errPg, client, false, false);
            if (content != null) {
                if (debug.messageEnabled()) {
                    debug.message("MAPController.fetchErrorPage(): xformed content: " + content.getContents());
                }
                return content.getContents();
            }
            if (debug.messageEnabled()) {
                debug.message("MAPController.fetchErrorPage(): xformed content is null");
            }
            return "";
        }
        catch (RenderingException re) {
            if (debug.messageEnabled()) {
                debug.message("MAPController.fetchErrorPage(): Unrecoverable Rendering Exception", (Throwable)re);
            }
            return "";
        }
    }
}

