/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.mail;

import com.sun.portal.wireless.taglibs.base.Util;
import com.sun.portal.wireless.taglibs.mail.AttachmentBean;
import com.sun.portal.wireless.taglibs.mail.LineBean;
import com.sun.portal.wireless.taglibs.mail.TTSStrings;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class MsgBean {
    private Message msg = null;
    private String msgBody = null;
    private Vector msgAttachments;
    private boolean decoded = true;
    private boolean unrolled = false;
    private String charset = null;
    private String from = null;
    private String lastName = null;
    private String firstName = null;
    private Session mailSession = null;
    private LineBean[] lines = null;
    private TimeZone timezone = null;
    private String textEncoding = "Q";
    private static final String nullString = "";

    public MsgBean(Session mailSession, String charset, String from, TimeZone tz) {
        this.msg = new MimeMessage(mailSession);
        this.msgAttachments = new Vector();
        this.mailSession = mailSession;
        this.charset = charset;
        this.from = from;
        this.timezone = tz;
        this.unrolled = true;
    }

    public MsgBean(Message msg, String from, TimeZone tz) {
        this.msg = msg;
        this.msgAttachments = new Vector();
        this.from = from;
        this.timezone = tz;
        this.unrolled = false;
    }

    public LineBean[] toLines() {
        if (this.lines == null) {
            Vector<LineBean> v = new Vector<LineBean>();
            String str = this.getText();
            int idx1 = 0;
            int idx2 = 0;
            if (str == null) {
                str = " ";
            }
            idx2 = str.indexOf(10, idx1);
            while (idx2 > 0) {
                v.addElement(new LineBean(str.substring(idx1, idx2)));
                idx1 = idx2 + 1;
                idx2 = str.indexOf(10, idx1);
            }
            if (v.isEmpty()) {
                v.addElement(new LineBean(str));
            }
            LineBean[] lb = new LineBean[v.size()];
            this.lines = v.toArray(lb);
        }
        return this.lines;
    }

    private String getWhiteSpace(String line, int index) {
        int startIndex = index;
        int lineLength = line.length();
        if (index >= lineLength) {
            return nullString;
        }
        char c = line.charAt(index);
        while (c == ' ' || c == '\t') {
            if (++index >= lineLength) break;
            c = line.charAt(index);
        }
        if (index == startIndex) {
            return nullString;
        }
        return line.substring(startIndex, index);
    }

    private String getWord(String line, int index) {
        int lineLength = line.length();
        if (index >= lineLength) {
            return nullString;
        }
        int blankIndex = line.indexOf(32, index);
        if (blankIndex == -1) {
            return line.substring(index, lineLength);
        }
        return line.substring(index, blankIndex);
    }

    private String removeSelf(String addrList) throws MessagingException {
        if (addrList != null) {
            InternetAddress[] addr = InternetAddress.parse((String)addrList, (boolean)false);
            InternetAddress ifrom = new InternetAddress(this.from);
            String fromAddr = ifrom.getAddress();
            Vector<InternetAddress> vec = new Vector<InternetAddress>();
            int i = 0;
            while (i < addr.length) {
                if (!addr[i].getAddress().equalsIgnoreCase(fromAddr)) {
                    vec.addElement(addr[i]);
                }
                ++i;
            }
            if (vec.size() == 0) {
                return null;
            }
            if (vec.size() == addr.length) {
                return this.toCommaDelimitedAddressList(addr);
            }
            InternetAddress[] raddr = new InternetAddress[vec.size()];
            int i2 = 0;
            while (i2 < vec.size()) {
                raddr[i2] = (InternetAddress)vec.elementAt(i2);
                ++i2;
            }
            return this.toCommaDelimitedAddressList(raddr);
        }
        return null;
    }

    private String toCommaDelimitedAddressList(InternetAddress[] addr) {
        if (addr != null) {
            if (addr.length > 1) {
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < addr.length) {
                    sb.append(", ");
                    sb.append(addr[i].getAddress());
                    ++i;
                }
                sb.setCharAt(0, ' ');
                return sb.toString().trim();
            }
            return addr[0].getAddress();
        }
        return null;
    }

    private void reflowLine(String line, int lineLength, Vector v) {
        StringBuffer newLine = new StringBuffer(lineLength);
        int newLineLength = 0;
        int newLineRemaining = lineLength;
        int index = 0;
        String whiteSpace = this.getWhiteSpace(line, index);
        int whiteSpaceLength = whiteSpace.length();
        String word = this.getWord(line, index += whiteSpaceLength);
        int wordLength = word.length();
        index += wordLength;
        while (wordLength != 0) {
            if (whiteSpaceLength > newLineRemaining) {
                whiteSpace = whiteSpace.substring(newLineRemaining);
                whiteSpaceLength = whiteSpace.length();
                v.addElement(new LineBean(newLine.toString()));
                newLine.setLength(0);
                newLineLength = 0;
                newLineRemaining = lineLength;
                continue;
            }
            if (whiteSpaceLength > 0) {
                newLine.append(whiteSpace);
                newLineLength += whiteSpaceLength;
                newLineRemaining -= whiteSpaceLength;
                whiteSpaceLength = 0;
            }
            if (newLineRemaining == lineLength && wordLength > newLineRemaining) {
                newLine.append(word.substring(0, newLineRemaining));
                v.addElement(new LineBean(newLine.toString()));
                word = word.substring(newLineRemaining);
                wordLength = word.length();
                newLine.setLength(0);
                newLineLength = 0;
                newLineRemaining = lineLength;
                continue;
            }
            if (wordLength > newLineRemaining) {
                v.addElement(new LineBean(newLine.toString()));
                newLine.setLength(0);
                newLineLength = 0;
                newLineRemaining = lineLength;
                continue;
            }
            newLine.append(word);
            newLineLength += wordLength;
            newLineRemaining -= wordLength;
            whiteSpace = this.getWhiteSpace(line, index);
            whiteSpaceLength = whiteSpace.length();
            word = this.getWord(line, index += whiteSpaceLength);
            wordLength = word.length();
            index += wordLength;
        }
        if (newLine.length() != 0) {
            v.addElement(new LineBean(newLine.toString()));
        }
    }

    public LineBean[] toLines(int lineLength) {
        if (this.lines == null) {
            Vector v = new Vector();
            String str = this.getText();
            int idx1 = 0;
            int idx2 = 0;
            if (str == null) {
                str = " ";
            }
            idx2 = str.indexOf(10, idx1);
            while (idx2 > 0) {
                this.reflowLine(str.substring(idx1, idx2), lineLength, v);
                idx1 = idx2 + 1;
                idx2 = str.indexOf(10, idx1);
            }
            if (v.isEmpty()) {
                this.reflowLine(str, lineLength, v);
            }
            LineBean[] lb = new LineBean[v.size()];
            this.lines = v.toArray(lb);
        }
        return this.lines;
    }

    public String getFrom() throws MessagingException {
        block3: {
            String[] s = this.msg.getHeader("from");
            try {
                if (s != null) {
                    return MimeUtility.decodeText((String)s[0]);
                }
            }
            catch (UnsupportedEncodingException ex) {
                Util.logWarning((String)"Exception caught in MsgBean while decoding 'From' header", (Throwable)ex);
                if (s == null) break block3;
                return s[0];
            }
        }
        return null;
    }

    public void setFrom(String fromAddr) throws MessagingException {
        this.from = fromAddr;
    }

    public void setAnswered(String answerState) throws MessagingException {
        boolean ansState = false;
        if (answerState != null && !answerState.equals(nullString)) {
            ansState = Boolean.getBoolean(answerState);
        }
        this.msg.setFlag(Flags.Flag.ANSWERED, ansState);
    }

    public void setAnswered(boolean answerState) throws MessagingException {
        this.msg.setFlag(Flags.Flag.ANSWERED, answerState);
    }

    public boolean isAnswered() throws MessagingException {
        return this.msg.isSet(Flags.Flag.ANSWERED);
    }

    public String getFromAddress() throws MessagingException {
        InternetAddress[] addr = (InternetAddress[])this.msg.getFrom();
        if (addr != null) {
            if (addr.length > 1) {
                return this.toCommaDelimitedAddressList(addr);
            }
            return addr[0].getAddress();
        }
        return null;
    }

    public String getFromPersonal() throws MessagingException {
        InternetAddress[] addr = (InternetAddress[])this.msg.getFrom();
        if (addr != null) {
            if (addr.length > 1) {
                return this.toCommaDelimitedAddressList(addr);
            }
            return addr[0].getPersonal();
        }
        return null;
    }

    public String getReplyTo() throws MessagingException {
        block3: {
            String[] s = this.msg.getHeader("reply-to");
            try {
                if (s != null) {
                    return MimeUtility.decodeText((String)s[0]);
                }
            }
            catch (UnsupportedEncodingException ex) {
                Util.logWarning((String)"Exception caught in MsgBean while decoding 'Reply-To' header", (Throwable)ex);
                if (s == null) break block3;
                return s[0];
            }
        }
        return this.getFrom();
    }

    public void setReplyTo(String replyTo) throws MessagingException {
        InternetAddress[] replyToAddresses = InternetAddress.parse((String)replyTo, (boolean)false);
        this.msg.setReplyTo((Address[])replyToAddresses);
    }

    public String getReplyToAddress() throws MessagingException {
        InternetAddress[] addr = (InternetAddress[])this.msg.getReplyTo();
        if (addr != null) {
            if (addr.length > 1) {
                return this.toCommaDelimitedAddressList(addr);
            }
            return addr[0].getAddress();
        }
        return this.getFromAddress();
    }

    public String getReplyToPersonal() throws MessagingException {
        InternetAddress[] addr = (InternetAddress[])this.msg.getReplyTo();
        if (addr != null) {
            if (addr.length > 1) {
                return this.toCommaDelimitedAddressList(addr);
            }
            return addr[0].getPersonal();
        }
        return this.getFromPersonal();
    }

    public String getLn() {
        if (this.lastName == null) {
            this.parsePersonal();
        }
        return this.lastName;
    }

    public String getFn() {
        if (this.firstName == null) {
            this.parsePersonal();
        }
        return this.firstName;
    }

    public String getTo() throws MessagingException {
        block3: {
            String[] s = this.msg.getHeader("to");
            try {
                if (s != null) {
                    return MimeUtility.decodeText((String)s[0]);
                }
            }
            catch (UnsupportedEncodingException ex) {
                Util.logWarning((String)"Exception caught in MsgBean while decoding 'To' header", (Throwable)ex);
                if (s == null) break block3;
                return s[0];
            }
        }
        return null;
    }

    public String getToAddress() throws MessagingException {
        String[] s = this.msg.getHeader("to");
        if (s != null) {
            InternetAddress[] addr = InternetAddress.parse((String)s[0], (boolean)false);
            return this.toCommaDelimitedAddressList(addr);
        }
        return null;
    }

    public String getToAddressReply() throws MessagingException {
        return this.removeSelf(this.getToAddress());
    }

    public void setTo(String to) throws MessagingException {
        InternetAddress[] toAddresses = InternetAddress.parse((String)to, (boolean)false);
        try {
            int i = 0;
            while (i < toAddresses.length) {
                String tmp = toAddresses[i].getPersonal();
                toAddresses[i].setPersonal(tmp, this.charset);
                ++i;
            }
        }
        catch (UnsupportedEncodingException ex) {
            Util.logWarning((String)"Exception caught in MsgBean while encoding 'To' header", (Throwable)ex);
        }
        this.msg.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
    }

    public String getCc() throws MessagingException {
        block3: {
            String[] s = this.msg.getHeader("cc");
            try {
                if (s != null) {
                    return MimeUtility.decodeText((String)s[0]);
                }
            }
            catch (UnsupportedEncodingException ex) {
                Util.logWarning((String)"Exception caught in MsgBean while decoding 'Cc' header", (Throwable)ex);
                if (s == null) break block3;
                return s[0];
            }
        }
        return null;
    }

    public String getCcAddress() throws MessagingException {
        String[] s = this.msg.getHeader("Cc");
        if (s != null) {
            InternetAddress[] addr = InternetAddress.parse((String)s[0], (boolean)false);
            return this.toCommaDelimitedAddressList(addr);
        }
        return null;
    }

    public String getCcAddressReply() throws MessagingException {
        return this.removeSelf(this.getCcAddress());
    }

    public void setCc(String cc) throws MessagingException {
        InternetAddress[] ccAddresses = InternetAddress.parse((String)cc, (boolean)false);
        try {
            int i = 0;
            while (i < ccAddresses.length) {
                String tmp = ccAddresses[i].getPersonal();
                ccAddresses[i].setPersonal(tmp, this.charset);
                ++i;
            }
        }
        catch (UnsupportedEncodingException ex) {
            Util.logWarning((String)"Exception caught in MsgBean while encoding 'Cc' header", (Throwable)ex);
        }
        this.msg.setRecipients(Message.RecipientType.CC, (Address[])ccAddresses);
    }

    public void setBcc(String bcc) throws MessagingException {
        InternetAddress[] bccAddresses = InternetAddress.parse((String)bcc, (boolean)false);
        try {
            int i = 0;
            while (i < bccAddresses.length) {
                String tmp = bccAddresses[i].getPersonal();
                bccAddresses[i].setPersonal(tmp, this.charset);
                ++i;
            }
        }
        catch (UnsupportedEncodingException ex) {
            Util.logWarning((String)"Exception caught in MsgBean while encoding 'Bcc' header", (Throwable)ex);
        }
        this.msg.setRecipients(Message.RecipientType.BCC, (Address[])bccAddresses);
    }

    public String getSubject() throws MessagingException {
        String s = this.msg.getSubject();
        return s != null ? s : nullString;
    }

    public void setSubject(String subject) throws MessagingException {
        try {
            this.msg.setSubject(MimeUtility.encodeText((String)subject, (String)this.charset, (String)this.textEncoding));
        }
        catch (UnsupportedEncodingException ex) {
            this.msg.setSubject(subject);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getDate() throws MessagingException {
        Date date = this.msg.getReceivedDate();
        if (date != null) {
            if (this.timezone != null) {
                DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
                dateFormat.setTimeZone(this.timezone);
                try {
                    void e;
                    String newDate = dateFormat.format(date);
                    return e;
                }
                catch (Exception e) {
                    Util.logWarning((String)("MsgBean.getDate(): parsing exception:" + e));
                    return date.toString();
                }
            }
            return date.toString();
        }
        return nullString;
    }

    public int getMsgid() {
        return this.msg.getMessageNumber();
    }

    public void setText(String body) {
        this.msgBody = body;
    }

    public Vector getIndentText(String quoteString) {
        String text = this.getText();
        TTSStrings tl = new TTSStrings();
        return tl.formatString(text, quoteString);
    }

    public String getText() {
        if (!this.unrolled && this.msg != null) {
            try {
                this.decodeMsg();
                this.unrolled = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.msgBody != null) {
            return this.msgBody;
        }
        return nullString;
    }

    public String getReplyText(String prefix) {
        StringBuffer sb = new StringBuffer();
        Vector<LineBean> v = new Vector<LineBean>();
        String str = this.getText();
        int idx1 = 0;
        int idx2 = 0;
        if (str == null) {
            str = " ";
        }
        idx2 = str.indexOf(10, idx1);
        while (idx2 > 0) {
            v.addElement(new LineBean(str.substring(idx1, idx2)));
            idx1 = idx2 + 1;
            idx2 = str.indexOf(10, idx1);
        }
        if (v.isEmpty()) {
            v.addElement(new LineBean(str));
        }
        int i = 0;
        while (i < v.size()) {
            sb.append(prefix);
            sb.append(((LineBean)v.elementAt(i)).toString());
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public Message getObject() {
        return this.msg;
    }

    public boolean isHasattachments() throws MessagingException {
        return this.msg.isMimeType("multipart/*");
    }

    public boolean isSeen() throws MessagingException {
        return this.msg.isSet(Flags.Flag.SEEN);
    }

    public boolean isRecent() throws MessagingException {
        return this.msg.isSet(Flags.Flag.RECENT);
    }

    public boolean isDeleted() throws MessagingException {
        return this.msg.isSet(Flags.Flag.DELETED);
    }

    public int getAttachmentCount() {
        if (!this.unrolled) {
            this.decodeMsg();
            this.unrolled = true;
        }
        return this.msgAttachments.size();
    }

    public Vector getAttachments() {
        if (!this.unrolled) {
            this.decodeMsg();
            this.unrolled = true;
        }
        return this.msgAttachments;
    }

    public void setAttachments(Vector attachments) {
        this.msgAttachments = attachments;
    }

    public String getTextEncoding() {
        return this.textEncoding;
    }

    public void setTextEncoding(String enc) {
        if (enc == null || enc.length() != 1) {
            return;
        }
        char c = enc.charAt(0);
        if (c == 'Q' || c == 'q' || c == 'b' || c == 'B') {
            this.textEncoding = enc;
        } else {
            Util.logError((String)("MsgBean: IllegalArgument for encoding " + enc + "\n possible values are Q and B"));
        }
    }

    public void addAttachment(AttachmentBean p) {
        this.msgAttachments.addElement(p);
    }

    public void delete() throws MessagingException {
        this.msg.setFlag(Flags.Flag.DELETED, true);
    }

    public void send() throws MessagingException {
        if (!this.msgAttachments.isEmpty()) {
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart mbp = new MimeBodyPart();
            mbp.setContent((Object)this.msgBody, "text/plain; charset=" + this.charset);
            mp.addBodyPart((BodyPart)mbp);
            int size = this.msgAttachments.size();
            int i = 0;
            while (i < size) {
                AttachmentBean attach = (AttachmentBean)this.msgAttachments.elementAt(i);
                mp.addBodyPart((BodyPart)attach.partObj());
                ++i;
            }
            this.msg.setContent((Multipart)mp);
        } else {
            this.msg.setContent((Object)this.msgBody, "text/plain; charset=" + this.charset);
        }
        try {
            InternetAddress ifrom = new InternetAddress(this.from);
            this.msg.setFrom((Address)ifrom);
        }
        catch (Exception e) {
            // empty catch block
        }
        Transport t = this.mailSession.getTransport();
        Transport.send((Message)this.msg);
    }

    /*
     * Unable to fully structure code
     */
    private void decodeMsg() {
        block5: {
            try {
                fp = new FetchProfile();
                fp.add(FetchProfile.Item.ENVELOPE);
                m = new Message[]{this.msg};
                this.msg.getFolder().fetch(m, fp);
                try {
                    this.splitMsgIntoParts((Part)this.msg);
                    break block5;
                }
                catch (Exception e) {
                    Util.logWarning((String)"Exception caught while trying to parse message");
                    Util.logWarning((String)"Returning content unparsed", (Throwable)e);
                    buffer = new byte[2048];
                    is = this.msg.getInputStream();
                    str = new StringBuffer();
                    ** while ((i = is.read((byte[])buffer)) != -1)
                }
lbl-1000:
                // 1 sources

                {
                    str.append(new String(buffer, 0, (int)var6_8));
                    continue;
                }
lbl19:
                // 1 sources

                this.msgBody = str.toString();
                this.decoded = false;
            }
            catch (Exception e) {
                Util.logError((String)"Unknown error in MsgBean:decodeMsg", (Throwable)e);
            }
        }
    }

    private void splitMsgIntoParts(Part p) throws Exception {
        ContentType type = new ContentType(p.getContentType());
        if (type.match("multipart/*")) {
            Multipart mp = (Multipart)p.getContent();
            int i = 0;
            while (i < mp.getCount()) {
                this.splitMsgIntoParts((Part)mp.getBodyPart(i));
                ++i;
            }
        } else if (type.match("text/*") && this.msgBody == null) {
            Object o = p.getContent();
            if (o instanceof String) {
                this.msgBody = ((String)o).trim() + "\n";
            } else {
                this.msgAttachments.addElement(new AttachmentBean(p));
            }
        } else {
            this.msgAttachments.addElement(new AttachmentBean(p));
        }
    }

    private void parsePersonal() {
        this.lastName = nullString;
        this.firstName = nullString;
        String name = null;
        try {
            name = this.getReplyToPersonal();
            if (name == null) {
                name = this.getFromPersonal();
            }
        }
        catch (MessagingException me) {
            Util.logWarning((String)"Error getting Personal info from ReplyTo or From header");
        }
        if (name != null) {
            int i = 0;
            i = name.indexOf(" ");
            if (i < 0 || i > name.length()) {
                int j = 0;
                j = name.indexOf(",");
                if (j < 0 || j > name.length()) {
                    this.lastName = name;
                } else {
                    this.lastName = name.substring(0, j);
                    this.firstName = name.substring(j + 1, name.length());
                }
            } else {
                int k = 0;
                k = name.indexOf(",");
                if (k < 0 || k > name.length()) {
                    this.firstName = name.substring(0, i);
                    this.lastName = name.substring(i, name.length()).trim();
                } else {
                    this.lastName = name.substring(0, k);
                    this.firstName = name.substring(k + 1, name.length()).trim();
                }
            }
        }
    }
}

